/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec2(-10l, -12l) >> uvec2(13u, 26u)) => i64vec2(-1l, -1l)
 * (i64vec2(-10l, -12l) >> uvec2(2u, 26u)) => i64vec2(-3l, -1l)
 * (i64vec2(-42l, 48l) >> uvec2(13u, 26u)) => i64vec2(-1l, 0l)
 * (i64vec2(-42l, 48l) >> uvec2(2u, 26u)) => i64vec2(-11l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec2(-10l, -12l) >> uvec2(13u, 26u)), i64vec2(-1l, -1l))) ? 1 : -1] array0;
  float[all(equal((i64vec2(-10l, -12l) >> uvec2(2u, 26u)), i64vec2(-3l, -1l))) ? 1 : -1] array1;
  float[all(equal((i64vec2(-42l, 48l) >> uvec2(13u, 26u)), i64vec2(-1l, 0l))) ? 1 : -1] array2;
  float[all(equal((i64vec2(-42l, 48l) >> uvec2(2u, 26u)), i64vec2(-11l, 0l))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
