/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class UnknownImplementationSnapshot
extends ImplementationSnapshot {
    private final UnknownReason unknownReason;

    public UnknownImplementationSnapshot(String typeName, UnknownReason unknownReason) {
        super(typeName);
        this.unknownReason = unknownReason;
    }

    public void appendToHasher(Hasher hasher) {
        throw new UnsupportedOperationException("Cannot hash an unknown implementation " + this);
    }

    @Override
    protected boolean isSameSnapshot(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnknownImplementationSnapshot that = (UnknownImplementationSnapshot)o;
        return this.classIdentifier.equals(that.classIdentifier) && this.unknownReason.equals((Object)that.unknownReason);
    }

    @Override
    public HashCode getClassLoaderHash() {
        return null;
    }

    public UnknownReason getUnknownReason() {
        return this.unknownReason;
    }

    public String getProblemDescription() {
        return String.format(this.unknownReason.descriptionTemplate, this.classIdentifier);
    }

    public String getReasonDescription() {
        return this.unknownReason.reason;
    }

    public String getSolutionDescription() {
        return this.unknownReason.solution;
    }

    public boolean equals(Object o) {
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.classIdentifier, this.unknownReason});
    }

    public String toString() {
        return this.classIdentifier + "@<" + this.unknownReason.name() + ">";
    }

    public static enum UnknownReason {
        UNKNOWN_CLASSLOADER("was loaded with an unknown classloader (class '%s').", "Gradle cannot track the implementation for classes loaded with an unknown classloader.", "Load your class by using one of Gradle's built-in ways."),
        UNTRACKED_LAMBDA("was implemented by the Java lambda '%s'.", "Using Java lambdas is not supported as task inputs.", "Use an (anonymous inner) class instead.");

        private final String descriptionTemplate;
        private final String reason;
        private final String solution;

        private UnknownReason(String descriptionTemplate, String reason, String solution) {
            this.descriptionTemplate = descriptionTemplate;
            this.reason = reason;
            this.solution = solution;
        }
    }
}

