/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.i18n;

import de.escape.quincunx.gimmicks.Utility;
import de.escape.quincunx.i18n.ResourceBundleCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class I18n {
    static boolean DEBUG;
    protected static Hashtable resourceBundles;
    protected static Vector appResourceBases;
    protected static Locale defaultLocale;

    public static void addAppResourceBase(String base) {
        appResourceBases.addElement(base);
        resourceBundles.clear();
    }

    public static void setDefaultLocale(Locale l) {
        if (l == null) {
            l = Locale.getDefault();
        }
        defaultLocale = l;
    }

    private static final ResourceBundle getBundle(Locale l) throws MissingResourceException {
        ResourceBundle res;
        if (l == null) {
            l = defaultLocale;
        }
        if ((res = (ResourceBundle)resourceBundles.get(l)) == null) {
            if (appResourceBases.size() == 0) {
                throw new MissingResourceException("No application specific resource base defined", "<unknown>", "");
            }
            ResourceBundleCollection collect = new ResourceBundleCollection();
            Enumeration e = appResourceBases.elements();
            while (e.hasMoreElements()) {
                collect.addResourceBundle(ResourceBundle.getBundle((String)e.nextElement(), l));
            }
            resourceBundles.put(l, collect);
            return collect;
        }
        return res;
    }

    public static String getString(String tag) throws MissingResourceException {
        return I18n.getBundle(null).getString(tag);
    }

    public static String getString(String tag, Locale l) throws MissingResourceException {
        return I18n.getBundle(l).getString(tag);
    }

    public static String format(String tag, String[] args, Locale l) throws MissingResourceException {
        return Utility.compileString(tag, args, I18n.getBundle(l));
    }

    public static String format(String tag, String arg, Locale l) throws MissingResourceException {
        return Utility.compileString(tag, new String[]{arg}, I18n.getBundle(l));
    }

    public static String format(String tag, String[] args) throws MissingResourceException {
        return Utility.compileString(tag, args, I18n.getBundle(null));
    }

    public static String format(String tag, String arg) throws MissingResourceException {
        return Utility.compileString(tag, new String[]{arg}, I18n.getBundle(null));
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    static {
        resourceBundles = new Hashtable(89);
        appResourceBases = new Vector(1);
        defaultLocale = Locale.getDefault();
        I18n.addAppResourceBase("de.escape.quincunx.i18n.BasicResourceBundle");
    }
}

