/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.configuration;

import de.focus_shift.jollyday.core.ManagerParameter;
import de.focus_shift.jollyday.core.configuration.ClasspathConfigurationProvider;
import de.focus_shift.jollyday.core.configuration.ConfigurationProvider;
import de.focus_shift.jollyday.core.configuration.URLConfigurationProvider;
import de.focus_shift.jollyday.core.util.ClassLoadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProviderManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationProviderManager.class);
    private ConfigurationProvider classpathConfigurationProvider = new ClasspathConfigurationProvider();
    private ConfigurationProvider urlConfigurationProvider = new URLConfigurationProvider();

    public void mergeConfigurationProperties(ManagerParameter parameter) {
        this.addInternalConfigurationProviderProperties(parameter);
        this.addCustomConfigurationProviderProperties(parameter);
    }

    private void addInternalConfigurationProviderProperties(ManagerParameter parameter) {
        parameter.mergeProperties(this.urlConfigurationProvider.getProperties());
        parameter.mergeProperties(this.classpathConfigurationProvider.getProperties());
    }

    private void addCustomConfigurationProviderProperties(ManagerParameter parameter) {
        String providersStrList = System.getProperty("de.focus_shift.jollyday.config.providers");
        if (providersStrList != null) {
            String[] providersClassNames;
            for (String providerClassName : providersClassNames = providersStrList.split(",")) {
                if (providerClassName == null || providerClassName.isEmpty()) continue;
                try {
                    Class<?> providerClass = Class.forName(providerClassName.trim(), true, ClassLoadingUtil.getClassloader());
                    ConfigurationProvider configurationProvider = (ConfigurationProvider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    parameter.mergeProperties(configurationProvider.getProperties());
                }
                catch (Exception e) {
                    LOG.warn("Cannot load configuration from provider class '{}'. {} ({}).", new Object[]{providerClassName, e.getClass().getSimpleName(), e.getMessage()});
                }
            }
        }
    }
}

