/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ops4j.pax.web.service.spi.servlet.OsgiScopedServletContext;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiInitializedServlet
implements Servlet {
    private final Servlet servlet;
    private final OsgiScopedServletContext servletContext;
    private final boolean whiteboardTCCL;

    public OsgiInitializedServlet(Servlet servlet, OsgiScopedServletContext servletSpecificContext, boolean whiteboardTCCL) {
        this.servlet = servlet;
        this.servletContext = servletSpecificContext;
        this.whiteboardTCCL = whiteboardTCCL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(final ServletConfig config) throws ServletException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            BundleWiring wiring;
            ClassLoader newCl = null;
            if (this.servletContext != null && (newCl = this.servletContext.getClassLoader()) == null && this.servletContext.getBundle() != null && (wiring = (BundleWiring)this.servletContext.getBundle().adapt(BundleWiring.class)) != null) {
                newCl = wiring.getClassLoader();
            }
            if (newCl != null) {
                Thread.currentThread().setContextClassLoader(newCl);
            }
            this.servlet.init(new ServletConfig(){

                public String getServletName() {
                    return config.getServletName();
                }

                public ServletContext getServletContext() {
                    return OsgiInitializedServlet.this.servletContext;
                }

                public String getInitParameter(String name) {
                    return config.getInitParameter(name);
                }

                public Enumeration<String> getInitParameterNames() {
                    return config.getInitParameterNames();
                }
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public ServletConfig getServletConfig() {
        return this.servlet.getServletConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (!this.whiteboardTCCL) {
            this.servlet.service(req, res);
        } else {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(req.getServletContext().getClassLoader());
                this.servlet.service(req, res);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public String getServletInfo() {
        return this.servlet.getServletInfo();
    }

    public void destroy() {
        this.servlet.destroy();
    }

    public Servlet getDelegate() {
        return this.servlet;
    }
}

