/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.io.DirRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class DirFile
extends File
implements StorageFile {
    private RandomAccessFile lockFileOpen;
    private FileChannel lockFileChannel;
    private FileLock dbLock;

    DirFile(String path) {
        super(path);
    }

    DirFile(String directoryName, String fileName) {
        super(directoryName, fileName);
    }

    DirFile(DirFile directoryName, String fileName) {
        super(directoryName, fileName);
    }

    @Override
    public StorageFile getParentDir() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return new DirFile(parent);
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        boolean exists = this.exists();
        FileOutputStream result = new FileOutputStream(this, append);
        if (!exists) {
            try {
                this.limitAccessToOwner();
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (IOException ioe) {
                FileNotFoundException e = new FileNotFoundException();
                e.initCause(ioe);
                throw e;
            }
        }
        return result;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this);
    }

    @Override
    public synchronized int getExclusiveFileLock() throws StandardException {
        int status;
        block14: {
            boolean validExclusiveLock = false;
            try {
                if (this.createNewFile()) {
                    validExclusiveLock = true;
                } else if (this.length() > 0L) {
                    validExclusiveLock = true;
                }
                if (validExclusiveLock) {
                    int retries = 120;
                    while (true) {
                        this.lockFileOpen = new RandomAccessFile(this, "rw");
                        this.limitAccessToOwner();
                        this.lockFileChannel = this.lockFileOpen.getChannel();
                        try {
                            this.dbLock = this.lockFileChannel.tryLock();
                            if (this.dbLock == null) {
                                this.lockFileChannel.close();
                                this.lockFileChannel = null;
                                this.lockFileOpen.close();
                                this.lockFileOpen = null;
                                status = 2;
                            } else {
                                this.lockFileOpen.writeInt(1);
                                this.lockFileChannel.force(true);
                                status = 1;
                            }
                            break block14;
                        }
                        catch (AsynchronousCloseException e) {
                            InterruptStatus.setInterrupted();
                            this.lockFileOpen.close();
                            if (retries-- > 0) continue;
                            throw e;
                        }
                        break;
                    }
                }
                status = 0;
            }
            catch (IOException ioe) {
                this.releaseExclusiveFileLock();
                status = 0;
                SanityManager.THROWASSERT((String)("Unable to Acquire Exclusive Lock on " + this.getPath()), (Throwable)ioe);
            }
            catch (OverlappingFileLockException ofle) {
                try {
                    this.lockFileChannel.close();
                    this.lockFileOpen.close();
                }
                catch (IOException e) {
                    SanityManager.THROWASSERT((String)("Error closing file channel " + this.getPath()), (Throwable)e);
                }
                this.lockFileChannel = null;
                this.lockFileOpen = null;
                status = 2;
            }
        }
        return status;
    }

    @Override
    public synchronized void releaseExclusiveFileLock() {
        try {
            if (this.dbLock != null) {
                this.dbLock.release();
                this.dbLock = null;
            }
            if (this.lockFileChannel != null) {
                this.lockFileChannel.close();
                this.lockFileChannel = null;
            }
            if (this.lockFileOpen != null) {
                this.lockFileOpen.close();
                this.lockFileOpen = null;
            }
            if (this.exists()) {
                this.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        return new DirRandomAccessFile(this, mode);
    }

    @Override
    public boolean renameTo(StorageFile newName) {
        boolean rename_status = super.renameTo((File)((Object)newName));
        for (int retry_count = 1; !rename_status && retry_count <= 5; ++retry_count) {
            try {
                Thread.sleep(1000 * retry_count);
            }
            catch (InterruptedException ie) {
                InterruptStatus.setInterrupted();
            }
            rename_status = super.renameTo((File)((Object)newName));
        }
        return rename_status;
    }

    @Override
    public boolean deleteAll() {
        if (!this.exists()) {
            return false;
        }
        String[] childList = super.list();
        if (childList != null) {
            String parentName = this.getPath();
            for (int i = 0; i < childList.length; ++i) {
                DirFile child;
                if (childList[i].equals(".") || childList[i].equals("..") || (child = new DirFile(parentName, childList[i])).deleteAll()) continue;
                return false;
            }
        }
        return this.delete();
    }

    @Override
    public void limitAccessToOwner() throws IOException {
        FileUtil.limitAccessToOwner(this);
    }
}

