/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import twitter4j.APIResourceBase;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.JSONObject;
import twitter4j.Logger;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.StringUtil;
import twitter4j.TwitterException;
import twitter4j.UploadedMediaImpl;
import twitter4j.v1.IDs;
import twitter4j.v1.OEmbed;
import twitter4j.v1.OEmbedRequest;
import twitter4j.v1.ResponseList;
import twitter4j.v1.Status;
import twitter4j.v1.StatusUpdate;
import twitter4j.v1.TweetsResources;
import twitter4j.v1.UploadedMedia;

class TweetsResourcesImpl
extends APIResourceBase
implements TweetsResources {
    private static final Logger logger = Logger.getLogger();
    private static final String CHUNKED_INIT = "INIT";
    private static final String CHUNKED_APPEND = "APPEND";
    private static final String CHUNKED_FINALIZE = "FINALIZE";
    private static final String CHUNKED_STATUS = "STATUS";
    private static final int MB = 0x100000;
    private static final int MAX_VIDEO_SIZE = 0x20000000;
    private static final int CHUNK_SIZE = 0x200000;
    private final String uploadBaseURL;

    TweetsResourcesImpl(HttpClient http, ObjectFactory factory, String restBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners, String uploadBaseURL) {
        super(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
        this.uploadBaseURL = uploadBaseURL;
    }

    @Override
    public ResponseList<Status> getRetweets(long statusId) throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/retweets/" + statusId + ".json?count=100"));
    }

    @Override
    public IDs getRetweeterIds(long statusId, long cursor) throws TwitterException {
        return this.getRetweeterIds(statusId, 100, cursor);
    }

    @Override
    public IDs getRetweeterIds(long statusId, int count, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.restBaseURL + "statuses/retweeters/ids.json?id=" + statusId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public Status showStatus(long id) throws TwitterException {
        return this.factory.createStatus(this.get(this.restBaseURL + "statuses/show/" + id + ".json", includeMyRetweet));
    }

    @Override
    public Status destroyStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.restBaseURL + "statuses/destroy/" + statusId + ".json"));
    }

    @Override
    public Status updateStatus(String status) throws TwitterException {
        return this.factory.createStatus(this.post(this.restBaseURL + "statuses/update.json", new HttpParameter("status", status)));
    }

    @Override
    public Status updateStatus(StatusUpdate status) throws TwitterException {
        boolean isForUpdateWithMedia = status.mediaFile != null || status.mediaName != null;
        String url = this.restBaseURL + (isForUpdateWithMedia ? "statuses/update_with_media.json" : "statuses/update.json");
        return this.factory.createStatus(this.post(url, TweetsResourcesImpl.asHttpParameterArray(status)));
    }

    static HttpParameter[] asHttpParameterArray(StatusUpdate statusUpdate) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        TweetsResourcesImpl.appendParameter("status", statusUpdate.status, params);
        if (-1L != statusUpdate.inReplyToStatusId) {
            TweetsResourcesImpl.appendParameter("in_reply_to_status_id", statusUpdate.inReplyToStatusId, params);
        }
        if (statusUpdate.location != null) {
            TweetsResourcesImpl.appendParameter("lat", statusUpdate.location.latitude, params);
            TweetsResourcesImpl.appendParameter("long", statusUpdate.location.longitude, params);
        }
        TweetsResourcesImpl.appendParameter("place_id", statusUpdate.placeId, params);
        if (!statusUpdate.displayCoordinates) {
            TweetsResourcesImpl.appendParameter("display_coordinates", "false", params);
        }
        if (null != statusUpdate.mediaFile) {
            params.add(new HttpParameter("media[]", statusUpdate.mediaFile));
            params.add(new HttpParameter("possibly_sensitive", statusUpdate.possiblySensitive));
        } else if (statusUpdate.mediaName != null && statusUpdate.mediaBody != null) {
            params.add(new HttpParameter("media[]", statusUpdate.mediaName, statusUpdate.mediaBody));
            params.add(new HttpParameter("possibly_sensitive", statusUpdate.possiblySensitive));
        } else if (statusUpdate.mediaIds != null && statusUpdate.mediaIds.length >= 1) {
            params.add(new HttpParameter("media_ids", StringUtil.join(statusUpdate.mediaIds)));
        }
        if (statusUpdate.autoPopulateReplyMetadata) {
            TweetsResourcesImpl.appendParameter("auto_populate_reply_metadata", "true", params);
        }
        TweetsResourcesImpl.appendParameter("attachment_url", statusUpdate.attachmentUrl, params);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private static void appendParameter(String name, String value, List<HttpParameter> params) {
        if (value != null) {
            params.add(new HttpParameter(name, value));
        }
    }

    private static void appendParameter(String name, double value, List<HttpParameter> params) {
        params.add(new HttpParameter(name, String.valueOf(value)));
    }

    private static void appendParameter(String name, long value, List<HttpParameter> params) {
        params.add(new HttpParameter(name, String.valueOf(value)));
    }

    @Override
    public Status retweetStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.restBaseURL + "statuses/retweet/" + statusId + ".json"));
    }

    @Override
    public Status unRetweetStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.restBaseURL + "statuses/unretweet/" + statusId + ".json"));
    }

    @Override
    public OEmbed getOEmbed(OEmbedRequest req) throws TwitterException {
        return this.factory.createOEmbed(this.get(this.restBaseURL + "statuses/oembed.json", this.asHttpParameterArray(req)));
    }

    HttpParameter[] asHttpParameterArray(OEmbedRequest request) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(12);
        HttpParameter.appendParameter("id", request.statusId, params);
        HttpParameter.appendParameter("url", request.url, params);
        HttpParameter.appendParameter("maxwidth", request.maxWidth, params);
        params.add(new HttpParameter("hide_media", request.hideMedia));
        params.add(new HttpParameter("hide_thread", request.hideThread));
        params.add(new HttpParameter("omit_script", request.omitScript));
        params.add(new HttpParameter("align", request.align.name().toLowerCase()));
        if (request.related.length > 0) {
            HttpParameter.appendParameter("related", StringUtil.join(request.related), params);
        }
        HttpParameter.appendParameter("lang", request.lang, params);
        if (request.widgetType != OEmbedRequest.WidgetType.NONE) {
            params.add(new HttpParameter("widget_type", request.widgetType.name().toLowerCase()));
            params.add(new HttpParameter("hide_tweet", request.hideTweet));
        }
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    @Override
    public ResponseList<Status> lookup(long ... ids) throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/lookup.json?id=" + StringUtil.join(ids)));
    }

    @Override
    public UploadedMedia uploadMedia(File image) throws TwitterException {
        this.checkFileValidity(image);
        return new UploadedMediaImpl(this.post(this.uploadBaseURL + "media/upload.json", new HttpParameter("media", image)).asJSONObject());
    }

    @Override
    public UploadedMedia uploadMedia(String fileName, InputStream image) throws TwitterException {
        return new UploadedMediaImpl(this.post(this.uploadBaseURL + "media/upload.json", new HttpParameter("media", fileName, image)).asJSONObject());
    }

    @Override
    public UploadedMedia uploadMediaChunked(String fileName, InputStream media) throws TwitterException {
        byte[] dataBytes;
        try {
            int n;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(262144);
            byte[] buffer = new byte[32768];
            while ((n = media.read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
            dataBytes = baos.toByteArray();
            if (dataBytes.length > 0x20000000) {
                throw new TwitterException(String.format(Locale.US, "video file can't be longer than: %d MBytes", 512));
            }
        }
        catch (IOException ioe) {
            throw new TwitterException("Failed to download the file.", ioe);
        }
        try {
            int bytesRead;
            UploadedMedia uploadedMedia = this.uploadMediaChunkedInit(dataBytes.length);
            ByteArrayInputStream dataInputStream = new ByteArrayInputStream(dataBytes);
            byte[] segmentData = new byte[0x200000];
            int segmentIndex = 0;
            int totalRead = 0;
            while ((bytesRead = dataInputStream.read(segmentData)) > 0) {
                logger.debug("Chunked appened, segment index:" + segmentIndex + " bytes:" + (totalRead += bytesRead) + "/" + dataBytes.length);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(segmentData, 0, bytesRead);
                this.uploadMediaChunkedAppend(fileName, byteArrayInputStream, segmentIndex, uploadedMedia.getMediaId());
                segmentData = new byte[0x200000];
                ++segmentIndex;
            }
            return this.uploadMediaChunkedFinalize(uploadedMedia.getMediaId());
        }
        catch (Exception e) {
            throw new TwitterException(e);
        }
    }

    private UploadedMedia uploadMediaChunkedInit(long size) throws TwitterException {
        return new UploadedMediaImpl(this.post(this.uploadBaseURL + "media/upload.json", new HttpParameter("command", CHUNKED_INIT), new HttpParameter("media_type", "video/mp4"), new HttpParameter("media_category", "tweet_video"), new HttpParameter("total_bytes", size)).asJSONObject());
    }

    private void uploadMediaChunkedAppend(String fileName, InputStream media, int segmentIndex, long mediaId) throws TwitterException {
        this.post(this.uploadBaseURL + "media/upload.json", new HttpParameter("command", CHUNKED_APPEND), new HttpParameter("media_id", mediaId), new HttpParameter("segment_index", segmentIndex), new HttpParameter("media", fileName, media));
    }

    private UploadedMedia uploadMediaChunkedFinalize(long mediaId) throws TwitterException {
        int tries = 0;
        int maxTries = 20;
        int lastProgressPercent = 0;
        int currentProgressPercent = 0;
        UploadedMedia uploadedMedia = this.uploadMediaChunkedFinalize0(mediaId);
        while (tries < maxTries) {
            if (lastProgressPercent == currentProgressPercent) {
                ++tries;
            }
            lastProgressPercent = currentProgressPercent;
            String state = uploadedMedia.getProcessingState();
            if (state.equals("failed")) {
                throw new TwitterException("Failed to finalize the chuncked upload.");
            }
            if (state.equals("pending") || state.equals("in_progress")) {
                currentProgressPercent = uploadedMedia.getProgressPercent();
                int waitSec = Math.max(uploadedMedia.getProcessingCheckAfterSecs(), 1);
                logger.debug("Chunked finalize, wait for:" + waitSec + " sec");
                try {
                    Thread.sleep((long)waitSec * 1000L);
                }
                catch (InterruptedException e) {
                    throw new TwitterException("Failed to finalize the chuncked upload.", e);
                }
            }
            if (state.equals("succeeded")) {
                return uploadedMedia;
            }
            uploadedMedia = this.uploadMediaChunkedStatus(mediaId);
        }
        throw new TwitterException("Failed to finalize the chuncked upload, progress has stopped, tried " + tries + 1 + " times.");
    }

    private UploadedMedia uploadMediaChunkedFinalize0(long mediaId) throws TwitterException {
        JSONObject json = this.post(this.uploadBaseURL + "media/upload.json", new HttpParameter("command", CHUNKED_FINALIZE), new HttpParameter("media_id", mediaId)).asJSONObject();
        logger.debug("Finalize response:" + json);
        return new UploadedMediaImpl(json);
    }

    private UploadedMedia uploadMediaChunkedStatus(long mediaId) throws TwitterException {
        JSONObject json = this.get(this.uploadBaseURL + "media/upload.json", new HttpParameter("command", CHUNKED_STATUS), new HttpParameter("media_id", mediaId)).asJSONObject();
        logger.debug("Status response:" + json);
        return new UploadedMediaImpl(json);
    }
}

