/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.tunnel.pool.ExcluderBase;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.util.ArraySet;

class ClientPeerSelector
extends TunnelPeerSelector {
    public ClientPeerSelector(RouterContext context) {
        super(context);
    }

    @Override
    public List<Hash> selectPeers(TunnelPoolSettings settings) {
        ArrayList<Hash> rv;
        int length = this.getLength(settings);
        if (length < 0) {
            return null;
        }
        if (length == 0 && settings.getLength() + settings.getLengthVariance() > 0) {
            return null;
        }
        boolean isInbound = settings.isInbound();
        if (length > 0) {
            MaskedIPSet ipSet;
            boolean v6Only = this.isIPv6Only();
            boolean ntcpDisabled = this.isNTCPDisabled();
            boolean ssuDisabled = this.isSSUDisabled();
            boolean checkClosestHop = v6Only || ntcpDisabled || ssuDisabled;
            boolean hidden = this.ctx.router().isHidden() || this.ctx.router().getRouterInfo().getAddressCount() <= 0 || !this.ctx.commSystem().haveInboundCapacity(95);
            boolean hiddenInbound = hidden && isInbound;
            boolean hiddenOutbound = hidden && !isInbound;
            int ipRestriction = this.ctx.getBooleanProperty("i2np.allowLocal") || length <= 1 ? 0 : settings.getIPRestriction();
            MaskedIPSet maskedIPSet = ipSet = ipRestriction > 0 ? new MaskedIPSet(16) : null;
            if (this.shouldSelectExplicit(settings)) {
                return this.selectExplicit(settings, length);
            }
            Set<Hash> exclude = this.getExclude(isInbound, false);
            ArraySet<Hash> matches = new ArraySet<Hash>(length);
            if (length == 1) {
                if (checkClosestHop) {
                    exclude = this.getClosestHopExclude(isInbound, exclude);
                }
                exclude = isInbound ? new IBGWExcluder(exclude) : new OBEPExcluder(exclude);
                if (hiddenInbound) {
                    this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, exclude, matches);
                }
                if (matches.isEmpty()) {
                    if (hiddenInbound) {
                        if (this.log.shouldWarn()) {
                            this.log.warn("CPS SANFP hidden closest IB no active peers found, returning null");
                        }
                        return null;
                    }
                    this.ctx.profileOrganizer().selectFastPeers(length, exclude, matches);
                }
                matches.remove(this.ctx.routerHash());
                rv = new ArrayList<Hash>(matches);
            } else {
                Set<Hash> lastHopExclude;
                rv = new ArrayList(length + 1);
                SessionKey randomKey = settings.getRandomKey();
                if (isInbound) {
                    lastHopExclude = checkClosestHop && !hidden ? this.getClosestHopExclude(true, exclude) : exclude;
                    if (this.log.shouldInfo()) {
                        this.log.info("CPS SFP closest IB " + lastHopExclude);
                    }
                } else {
                    lastHopExclude = new OBEPExcluder(exclude);
                    if (this.log.shouldInfo()) {
                        this.log.info("CPS SFP OBEP " + lastHopExclude);
                    }
                }
                if (hiddenInbound) {
                    if (this.log.shouldInfo()) {
                        this.log.info("CPS SANFP hidden closest IB " + lastHopExclude);
                    }
                    this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, lastHopExclude, matches, ipRestriction, ipSet);
                    if (matches.isEmpty()) {
                        if (this.log.shouldWarn()) {
                            this.log.warn("CPS SANFP hidden closest IB no active peers found, returning null");
                        }
                        return null;
                    }
                } else if (hiddenOutbound) {
                    boolean pickFurthest;
                    TunnelManagerFacade tmf = this.ctx.tunnelManager();
                    TunnelPool tp = tmf.getInboundPool(settings.getDestination());
                    if (tp != null) {
                        pickFurthest = true;
                        TunnelPoolSettings tps = tp.getSettings();
                        int len = tps.getLength();
                        if (len > 0 && tps.getLengthOverride() != 0 && len + tps.getLengthVariance() > 0) {
                            List<TunnelInfo> tunnels = tp.listTunnels();
                            if (!tunnels.isEmpty()) {
                                for (TunnelInfo ti : tp.listTunnels()) {
                                    if (ti.getLength() <= 1) continue;
                                    pickFurthest = false;
                                    break;
                                }
                            } else {
                                tp = tmf.getInboundExploratoryPool();
                                tps = tp.getSettings();
                                len = tps.getLength();
                                if (len > 0 && tps.getLengthOverride() != 0 && len + tps.getLengthVariance() > 0 && !(tunnels = tp.listTunnels()).isEmpty()) {
                                    for (TunnelInfo ti : tp.listTunnels()) {
                                        if (ti.getLength() <= 1) continue;
                                        pickFurthest = false;
                                        break;
                                    }
                                }
                            }
                        }
                    } else {
                        pickFurthest = false;
                    }
                    if (pickFurthest) {
                        if (this.log.shouldInfo()) {
                            this.log.info("CPS SANFP OBEP " + lastHopExclude);
                        }
                        this.ctx.profileOrganizer().selectActiveNotFailingPeers(1, lastHopExclude, matches, ipRestriction, ipSet);
                        if (matches.isEmpty()) {
                            if (this.log.shouldWarn()) {
                                this.log.warn("CPS SANFP hidden OBEP no active peers found, returning null");
                            }
                            return null;
                        }
                        this.ctx.commSystem().exemptIncoming(matches.get(0));
                    } else {
                        this.ctx.profileOrganizer().selectFastPeers(1, lastHopExclude, matches, randomKey, length == 2 ? ProfileOrganizer.Slice.SLICE_0_1 : ProfileOrganizer.Slice.SLICE_0, ipRestriction, ipSet);
                    }
                } else {
                    this.ctx.profileOrganizer().selectFastPeers(1, lastHopExclude, matches, randomKey, length == 2 ? ProfileOrganizer.Slice.SLICE_0_1 : ProfileOrganizer.Slice.SLICE_0, ipRestriction, ipSet);
                }
                matches.remove(this.ctx.routerHash());
                exclude.addAll(matches);
                rv.addAll(matches);
                matches.clear();
                if (length > 2) {
                    if (this.log.shouldInfo()) {
                        this.log.info("CPS SFP middle " + exclude);
                    }
                    this.ctx.profileOrganizer().selectFastPeers(length - 2, exclude, matches, randomKey, ProfileOrganizer.Slice.SLICE_2_3, ipRestriction, ipSet);
                    matches.remove(this.ctx.routerHash());
                    if (matches.size() > 1) {
                        ArrayList<Hash> ordered = new ArrayList<Hash>(matches);
                        this.orderPeers(ordered, randomKey);
                        rv.addAll(ordered);
                    } else {
                        rv.addAll(matches);
                    }
                    exclude.addAll(matches);
                    matches.clear();
                }
                if (isInbound) {
                    exclude = new IBGWExcluder(exclude);
                    if (this.log.shouldInfo()) {
                        this.log.info("CPS SFP IBGW " + exclude);
                    }
                } else {
                    if (checkClosestHop) {
                        exclude = this.getClosestHopExclude(false, exclude);
                    }
                    if (this.log.shouldInfo()) {
                        this.log.info("CPS SFP closest OB " + exclude);
                    }
                }
                this.ctx.profileOrganizer().selectFastPeers(1, exclude, matches, randomKey, length == 2 ? ProfileOrganizer.Slice.SLICE_2_3 : ProfileOrganizer.Slice.SLICE_1, ipRestriction, ipSet);
                matches.remove(this.ctx.routerHash());
                rv.addAll(matches);
            }
            if (this.log.shouldInfo()) {
                this.log.info("CPS " + length + (isInbound ? " IB " : " OB ") + "final: " + exclude);
            }
            if (rv.size() < length) {
                if (this.log.shouldWarn()) {
                    this.log.warn("CPS requested " + length + " got " + rv.size());
                }
                int min = settings.getLength();
                int skew = settings.getLengthVariance();
                if (skew < 0) {
                    min += skew;
                }
                if (rv.size() < min) {
                    return null;
                }
            }
        } else {
            rv = new ArrayList<Hash>(1);
        }
        if (isInbound) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        if (rv.size() > 1 && !this.checkTunnel(isInbound, false, rv)) {
            rv = null;
        }
        if (isInbound && rv != null && rv.size() > 1) {
            this.ctx.commSystem().exemptIncoming((Hash)rv.get(1));
        }
        return rv;
    }

    private class OBEPExcluder
    extends ExcluderBase {
        public OBEPExcluder(Set<Hash> set) {
            super(set);
        }

        @Override
        public boolean contains(Object o) {
            boolean rv;
            if (this.s.contains(o)) {
                return true;
            }
            Hash h = (Hash)o;
            boolean bl = rv = !ClientPeerSelector.this.allowAsOBEP(h);
            if (rv) {
                this.s.add(h);
                if (ClientPeerSelector.this.log.shouldDebug()) {
                    ClientPeerSelector.this.log.debug("CPS OBEP exclude " + h.toBase64());
                }
            }
            return rv;
        }
    }

    private class IBGWExcluder
    extends ExcluderBase {
        public IBGWExcluder(Set<Hash> set) {
            super(set);
        }

        @Override
        public boolean contains(Object o) {
            boolean rv;
            if (this.s.contains(o)) {
                return true;
            }
            Hash h = (Hash)o;
            boolean bl = rv = !ClientPeerSelector.this.allowAsIBGW(h);
            if (rv) {
                this.s.add(h);
                if (ClientPeerSelector.this.log.shouldDebug()) {
                    ClientPeerSelector.this.log.debug("CPS IBGW exclude " + h.toBase64());
                }
            }
            return rv;
        }
    }
}

