/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;

public class DefaultResolvedComponentResult
implements ResolvedComponentResultInternal {
    private final ModuleVersionIdentifier moduleVersion;
    private ImmutableSet<DependencyResult> dependencies = ImmutableSet.of();
    private Set<ResolvedDependencyResult> dependents = new LinkedHashSet<ResolvedDependencyResult>();
    private final ComponentSelectionReason selectionReason;
    private final ComponentIdentifier componentId;
    private final ImmutableList<ResolvedVariantResult> selectedVariants;
    private final Map<Long, ResolvedVariantResult> selectedVariantsById;
    private final ImmutableList<ResolvedVariantResult> allVariants;
    private final String repositoryName;
    private ImmutableSetMultimap<ResolvedVariantResult, DependencyResult> variantDependencies = ImmutableSetMultimap.of();

    public DefaultResolvedComponentResult(ModuleVersionIdentifier moduleVersion, ComponentSelectionReason selectionReason, ComponentIdentifier componentId, ImmutableMap<Long, ResolvedVariantResult> selectedVariants, ImmutableList<ResolvedVariantResult> allVariants, @Nullable String repositoryName) {
        this.moduleVersion = moduleVersion;
        this.selectionReason = selectionReason;
        this.componentId = componentId;
        this.selectedVariantsById = selectedVariants;
        this.selectedVariants = ImmutableList.copyOf((Collection)selectedVariants.values());
        this.allVariants = allVariants.isEmpty() ? this.selectedVariants : allVariants;
        this.repositoryName = repositoryName;
    }

    public ComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    @Deprecated
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    @Nullable
    public String getRepositoryId() {
        return this.repositoryName;
    }

    public Set<DependencyResult> getDependencies() {
        return this.dependencies;
    }

    public Set<ResolvedDependencyResult> getDependents() {
        return Collections.unmodifiableSet(this.dependents);
    }

    public void addDependencies(ImmutableSet<DependencyResult> dependencies) {
        this.dependencies = this.dependencies.isEmpty() ? dependencies : ImmutableSet.builder().addAll(this.dependencies).addAll(dependencies).build();
    }

    public DefaultResolvedComponentResult addDependent(ResolvedDependencyResult dependent) {
        this.dependents.add(dependent);
        return this;
    }

    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    @Nullable
    public ModuleVersionIdentifier getModuleVersion() {
        return this.moduleVersion;
    }

    public String toString() {
        return this.getId().getDisplayName();
    }

    public List<ResolvedVariantResult> getVariants() {
        return this.selectedVariants;
    }

    @Override
    public List<ResolvedVariantResult> getAvailableVariants() {
        return this.allVariants;
    }

    public List<DependencyResult> getDependenciesForVariant(ResolvedVariantResult variant) {
        if (!this.selectedVariants.contains((Object)variant)) {
            this.reportInvalidVariant(variant);
        }
        return ImmutableList.copyOf((Collection)this.variantDependencies.get((Object)variant));
    }

    private void reportInvalidVariant(ResolvedVariantResult variant) {
        Optional<ResolvedVariantResult> sameName = this.selectedVariants.stream().filter(v -> v.getDisplayName().equals(variant.getDisplayName())).findFirst();
        String moreInfo = sameName.isPresent() ? "A variant with the same name exists but is not the same instance." : "There's no resolved variant with the same name.";
        throw new InvalidUserCodeException("Variant '" + variant.getDisplayName() + "' doesn't belong to resolved component '" + this + "'. " + moreInfo + " Most likely you are using a variant from another component to get the dependencies of this component.");
    }

    @Override
    @Nullable
    public ResolvedVariantResult getVariant(long id) {
        return this.selectedVariantsById.get(id);
    }

    public void addVariantDependencies(ImmutableSetMultimap<ResolvedVariantResult, DependencyResult> variantDependencies) {
        this.variantDependencies = this.variantDependencies.isEmpty() ? variantDependencies : ImmutableSetMultimap.builder().putAll(this.variantDependencies).putAll(variantDependencies).build();
    }

    public static void eachElement(ResolvedComponentResult start, Action<? super ResolvedComponentResult> moduleAction, Action<? super DependencyResult> dependencyAction, Set<ResolvedComponentResult> visited) {
        if (!visited.add(start)) {
            return;
        }
        moduleAction.execute((Object)start);
        for (DependencyResult d : start.getDependencies()) {
            dependencyAction.execute((Object)d);
            if (!(d instanceof ResolvedDependencyResult)) continue;
            DefaultResolvedComponentResult.eachElement(((ResolvedDependencyResult)d).getSelected(), moduleAction, dependencyAction, visited);
        }
    }

    public void complete() {
        this.dependents = ImmutableSet.copyOf(this.dependents);
    }
}

