/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;

public class DefaultBuildOperationAncestryTracker
implements BuildOperationListener,
BuildOperationAncestryTracker {
    private final Map<OperationIdentifier, OperationIdentifier> parents = new ConcurrentHashMap<OperationIdentifier, OperationIdentifier>();

    @Override
    public Optional<OperationIdentifier> findClosestMatchingAncestor(@Nullable OperationIdentifier id, Predicate<? super OperationIdentifier> predicate) {
        if (id == null) {
            return Optional.empty();
        }
        if (predicate.test(id)) {
            return Optional.of(id);
        }
        return this.findClosestMatchingAncestor(this.parents.get(id), predicate);
    }

    @Override
    public <T> Optional<T> findClosestExistingAncestor(@Nullable OperationIdentifier id, Function<? super OperationIdentifier, T> lookupFunction) {
        if (id == null) {
            return Optional.empty();
        }
        T value = lookupFunction.apply(id);
        if (value != null) {
            return Optional.of(value);
        }
        return this.findClosestExistingAncestor(this.parents.get(id), lookupFunction);
    }

    @Override
    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (buildOperation.getParentId() != null) {
            this.parents.put(buildOperation.getId(), buildOperation.getParentId());
        }
    }

    @Override
    public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        this.parents.remove(buildOperation.getId());
    }
}

