/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.util.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class MockPseudoRandom
extends Random {
    int pos = 0;
    private List<Integer> setNumberList;
    private boolean cycleNumbers;
    private Random random;
    private final float scale = 4.656613E-10f;

    public MockPseudoRandom() {
        this(new ArrayList<Integer>(), false);
    }

    public MockPseudoRandom(List<Integer> setNumbers, boolean toCycle) {
        this.setNumberList = setNumbers;
        this.cycleNumbers = toCycle;
        this.random = null;
    }

    public void setNextNumbers(List<Integer> setNumbers, boolean toCycle) {
        this.pos = 0;
        this.setNumberList = setNumbers;
        this.cycleNumbers = toCycle;
    }

    private int getNext() {
        if (this.pos < this.setNumberList.size()) {
            int number = this.setNumberList.get(this.pos);
            ++this.pos;
            return number;
        }
        if (this.cycleNumbers && !this.setNumberList.isEmpty()) {
            int number = this.setNumberList.get(0);
            this.pos = 1;
            return number;
        }
        if (this.random == null) {
            this.random = new Random(0L);
        }
        return -1;
    }

    @Override
    public int nextInt(int n) {
        int number = this.getNext();
        if (number < 0 || number >= n) {
            System.err.println("MockPseudoRandom out of range: " + number);
            return this.random.nextInt(n);
        }
        return number;
    }

    @Override
    public float nextFloat() {
        int number = this.getNext();
        return number < 0 ? this.random.nextFloat() : (float)number * 4.656613E-10f;
    }

    @Override
    public double nextDouble() {
        int number = this.getNext();
        return number < 0 ? this.random.nextDouble() : (double)((float)number * 4.656613E-10f);
    }
}

