/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class AnimateMoveMessage
extends ObjectMessage {
    public static final String TAG = "animateMove";
    private static final String NEW_TILE_TAG = "newTile";
    private static final String OLD_TILE_TAG = "oldTile";
    private static final String UNIT_TAG = "unit";

    public AnimateMoveMessage(Unit unit, Tile oldTile, Tile newTile, boolean appears) {
        super(TAG, UNIT_TAG, unit.getId(), NEW_TILE_TAG, newTile.getId(), OLD_TILE_TAG, oldTile.getId());
        if (appears) {
            this.appendChild(unit.isOnCarrier() ? unit.getCarrier() : unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimateMoveMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, NEW_TILE_TAG, OLD_TILE_TAG, UNIT_TAG);
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        Unit unit = null;
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if (UNIT_TAG.equals(tag)) {
                    if (unit == null) {
                        unit = xr.readFreeColObject(game, Unit.class);
                    } else {
                        this.expected(TAG, tag);
                    }
                } else {
                    this.expected(UNIT_TAG, tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChild(unit);
    }

    private Unit getUnit(Game game) {
        String uid = this.getStringAttribute(UNIT_TAG);
        Unit unit = game.getFreeColGameObject(uid, Unit.class);
        if (unit == null) {
            unit = this.getChild(0, Unit.class);
            if (unit == null) {
                logger.warning("Move animation missing unit: " + uid);
            } else {
                unit.intern();
                if (!unit.getId().equals(uid) && (unit = unit.getCarriedUnitById(uid)) == null) {
                    logger.warning("Move animation missing carried unit: " + uid);
                }
            }
        }
        return unit;
    }

    private Tile getNewTile(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(NEW_TILE_TAG), Tile.class);
    }

    private Tile getOldTile(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(OLD_TILE_TAG), Tile.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.ANIMATION;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player player = freeColClient.getMyPlayer();
        Tile oldTile = this.getOldTile(game);
        Tile newTile = this.getNewTile(game);
        Unit unit = this.getUnit(game);
        if (unit == null) {
            return;
        }
        if (oldTile == null) {
            logger.warning("Animation for: " + player.getId() + " missing old Tile.");
            return;
        }
        if (newTile == null) {
            logger.warning("Animation for: " + player.getId() + " missing new Tile.");
            return;
        }
        this.igc(freeColClient).animateMoveHandler(unit, oldTile, newTile);
        this.clientGeneric(freeColClient);
    }
}

