/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.util.CollectionUtils;

public class ScopeContainer {
    private static final Stream<Scope> noStream = Stream.empty();
    private static final List<Scope> noList = Collections.emptyList();
    private static final Comparator<Scope> scopeComparator = new Comparator<Scope>(){

        @Override
        public int compare(Scope s1, Scope s2) {
            return Long.compare(s1.hashCode(), s2.hashCode());
        }
    };
    private List<Scope> scopes = null;

    public final boolean isEmpty() {
        return this.scopes == null || this.scopes.isEmpty();
    }

    public final List<Scope> getList() {
        return this.isEmpty() ? noList : this.scopes;
    }

    public final Stream<Scope> get() {
        return this.isEmpty() ? noStream : this.scopes.stream();
    }

    public final void set(List<Scope> scopes) {
        if (this.scopes == null || scopes == null) {
            this.scopes = scopes;
        } else {
            this.clear();
            this.addAll(scopes);
        }
    }

    public final void clear() {
        if (this.scopes != null) {
            this.scopes.clear();
        }
    }

    public final void add(Scope scope) {
        if (scope == null) {
            return;
        }
        if (this.scopes == null) {
            this.scopes = new ArrayList<Scope>();
        }
        this.scopes.add(scope);
    }

    public final void addAll(Collection<Scope> c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        if (this.scopes == null) {
            this.scopes = new ArrayList<Scope>();
        }
        this.scopes.addAll(c);
    }

    public final void addAll(ScopeContainer other) {
        if (other != null) {
            this.addAll(other.scopes);
        }
    }

    public final void remove(Scope scope) {
        if (this.scopes != null) {
            this.scopes.remove(scope);
        }
    }

    public final void sort(Comparator<Scope> comp) {
        if (this.scopes != null) {
            this.scopes.sort(comp);
        }
    }

    public boolean appliesTo(FreeColObject object) {
        return this.isEmpty() || CollectionUtils.any(this.scopes, s -> s.appliesTo(object));
    }

    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.scopes == null) {
            return;
        }
        this.sort(scopeComparator);
        for (Scope scope : this.scopes) {
            scope.toXML(xw);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ScopeContainer) {
            ScopeContainer sc = (ScopeContainer)o;
            if (this.isEmpty() != sc.isEmpty()) {
                return false;
            }
            if (this.isEmpty()) {
                return true;
            }
            ArrayList<Scope> sl1 = new ArrayList<Scope>(this.scopes);
            ArrayList<Scope> sl2 = new ArrayList<Scope>(sc.scopes);
            sl1.sort(scopeComparator);
            sl2.sort(scopeComparator);
            while (!sl1.isEmpty()) {
                Scope s2;
                if (sl2.isEmpty()) {
                    return false;
                }
                Scope s1 = (Scope)sl1.remove(0);
                if (s1.equals(s2 = (Scope)sl2.remove(0))) continue;
                return false;
            }
            return sl2.isEmpty();
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        for (Scope s : this.getList()) {
            hash += 37 * s.hashCode();
        }
        return hash;
    }

    public static boolean isScopeContainerEmpty(ScopeContainer sc) {
        return sc == null || sc.isEmpty();
    }

    public static List<Scope> getScopeList(ScopeContainer sc) {
        return sc == null ? noList : sc.getList();
    }

    public static Stream<Scope> getScopes(ScopeContainer sc) {
        return sc == null ? noStream : sc.get();
    }

    public static ScopeContainer addScope(ScopeContainer sc, Scope scope) {
        if (sc == null) {
            sc = new ScopeContainer();
        }
        sc.add(scope);
        return sc;
    }

    public static void removeScope(ScopeContainer sc, Scope scope) {
        if (sc != null) {
            sc.remove(scope);
        }
    }

    public static ScopeContainer setScopes(ScopeContainer sc, Collection<Scope> c) {
        if (sc == null) {
            if (c == null || c.isEmpty()) {
                return null;
            }
            sc = new ScopeContainer();
        } else {
            sc.clear();
        }
        sc.addAll(c);
        return sc;
    }

    public static void clearScopes(ScopeContainer sc) {
        if (sc != null) {
            sc.clear();
        }
    }

    public static boolean equalScopes(ScopeContainer sc1, ScopeContainer sc2) {
        return sc1 == null ? sc2 == null : (sc2 == null ? false : sc1.equals(sc2));
    }

    public static boolean scopeContainerAppliesTo(ScopeContainer sc, FreeColObject fco) {
        return sc == null || sc.appliesTo(fco);
    }

    public static void scopeContainerToXML(ScopeContainer sc, FreeColXMLWriter xw) throws XMLStreamException {
        if (sc != null) {
            sc.toXML(xw);
        }
    }
}

