/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.callback;

import java.awt.EventQueue;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.OverrideMessageProxyListener;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.callback.CallbackImplementor;
import org.zaproxy.zap.extension.callback.CallbackParam;
import org.zaproxy.zap.extension.callback.OptionsCallbackPanel;
import org.zaproxy.zap.extension.callback.ui.CallbackPanel;
import org.zaproxy.zap.extension.callback.ui.CallbackRequest;
import org.zaproxy.zap.extension.help.ExtensionHelp;

@Deprecated
public class ExtensionCallback
extends ExtensionAdaptor
implements OptionsChangedListener,
SessionChangedListener {
    private static final String TEST_PREFIX = "ZapTest";
    private static final String NAME = "ExtensionCallback";
    private ProxyServer proxyServer;
    private CallbackParam callbackParam;
    private OptionsCallbackPanel optionsCallbackPanel;
    private Map<String, CallbackImplementor> callbacks = new HashMap<String, CallbackImplementor>();
    private int actualPort;
    private String currentConfigLocalAddress;
    private int currentConfigPort;
    private static final Logger LOGGER = LogManager.getLogger(ExtensionCallback.class);
    private CallbackPanel callbackPanel;

    public ExtensionCallback() {
        this.proxyServer = new ProxyServer("ZAP-CallbackServer");
        this.proxyServer.addOverrideMessageProxyListener(new CallbackProxyListener());
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("callback.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getCallbackParam());
        extensionHook.addOptionsChangedListener(this);
        extensionHook.addSessionListener(this);
        if (this.hasView()) {
            extensionHook.getHookView().addStatusPanel(this.getCallbackPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsCallbackPanel());
            ExtensionHelp.enableHelpKey(this.getCallbackPanel(), "ui.tabs.callbacks");
        }
    }

    @Override
    public void optionsLoaded() {
        this.proxyServer.setConnectionParam(this.getModel().getOptionsParam().getConnectionParam());
        this.currentConfigLocalAddress = this.getCallbackParam().getLocalAddress();
        this.currentConfigPort = this.getCallbackParam().getPort();
    }

    @Override
    public void postInit() {
        this.restartServer(this.getCallbackParam().getPort());
    }

    private void restartServer(int port) {
        this.actualPort = this.proxyServer.startServer(this.getCallbackParam().getLocalAddress(), port, true);
        LOGGER.info("Started callback server on " + this.getCallbackParam().getLocalAddress() + ":" + this.actualPort);
    }

    public String getCallbackAddress() {
        String addr = this.getCallbackParam().getRemoteAddress();
        boolean ipv6 = addr.contains(":");
        String hostname = ipv6 ? "[" + addr + "]" : addr;
        boolean isSecure = this.getCallbackParam().isSecure();
        String scheme = isSecure ? "https" : "http";
        return scheme + "://" + hostname + ":" + this.actualPort + "/";
    }

    private CallbackPanel getCallbackPanel() {
        if (this.callbackPanel == null) {
            this.callbackPanel = new CallbackPanel(this);
        }
        return this.callbackPanel;
    }

    public String getTestUrl() {
        return this.getCallbackAddress() + TEST_PREFIX;
    }

    protected int getPort() {
        return this.actualPort;
    }

    public void registerCallbackImplementor(CallbackImplementor impl) {
        for (String prefix : impl.getCallbackPrefixes()) {
            LOGGER.debug("Registering callback prefix: " + prefix);
            if (this.callbacks.containsKey(prefix)) {
                LOGGER.error("Duplicate callback prefix: " + prefix);
            }
            this.callbacks.put("/" + prefix, impl);
        }
    }

    public void removeCallbackImplementor(CallbackImplementor impl) {
        for (String shortcut : impl.getCallbackPrefixes()) {
            String key = "/" + shortcut;
            if (!this.callbacks.containsKey(key)) continue;
            LOGGER.debug("Removing registered callback prefix: " + shortcut);
            this.callbacks.remove(key);
        }
    }

    private CallbackParam getCallbackParam() {
        if (this.callbackParam == null) {
            this.callbackParam = new CallbackParam();
        }
        return this.callbackParam;
    }

    private OptionsCallbackPanel getOptionsCallbackPanel() {
        if (this.optionsCallbackPanel == null) {
            this.optionsCallbackPanel = new OptionsCallbackPanel(this);
        }
        return this.optionsCallbackPanel;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("callback.desc");
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        if (!this.currentConfigLocalAddress.equals(this.getCallbackParam().getLocalAddress()) || this.currentConfigPort != this.getCallbackParam().getPort()) {
            int port = this.actualPort;
            if (this.currentConfigPort != this.getCallbackParam().getPort()) {
                port = this.getCallbackParam().getPort();
            }
            this.restartServer(port);
            this.currentConfigLocalAddress = this.getCallbackParam().getLocalAddress();
            this.currentConfigPort = this.getCallbackParam().getPort();
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        this.invokeIfRequiredAndViewIsInitialised(new Runnable(){

            @Override
            public void run() {
                ExtensionCallback.this.sessionChangedEventHandler(session);
            }
        });
    }

    private void sessionChangedEventHandler(Session session) {
        this.getCallbackPanel().clearCallbackRequests();
        this.addCallbacksFromDatabaseIntoCallbackPanel(session);
    }

    private void addCallbacksFromDatabaseIntoCallbackPanel(Session session) {
        if (session == null) {
            return;
        }
        try {
            List<Integer> historyIds = this.getModel().getDb().getTableHistory().getHistoryIdsOfHistType(session.getSessionId(), 21);
            for (int historyId : historyIds) {
                HistoryReference historyReference = new HistoryReference(historyId);
                CallbackRequest request = CallbackRequest.create(historyReference);
                this.getCallbackPanel().addCallbackRequest(request);
            }
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteCallbacks() {
        this.deleteCallbacksFromDatabase();
        this.invokeIfRequiredAndViewIsInitialised(new Runnable(){

            @Override
            public void run() {
                ExtensionCallback.this.getCallbackPanel().clearCallbackRequests();
            }
        });
    }

    private void deleteCallbacksFromDatabase() {
        try {
            this.getModel().getDb().getTableHistory().deleteHistoryType(this.getModel().getSession().getSessionId(), 21);
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void invokeIfRequiredAndViewIsInitialised(Runnable runnable) {
        if (this.hasView()) {
            if (!EventQueue.isDispatchThread()) {
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                return;
            }
            runnable.run();
        }
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    private void callbackReceived(final String handler, final HttpMessage httpMessage) {
        this.invokeIfRequiredAndViewIsInitialised(new Runnable(){

            @Override
            public void run() {
                ExtensionCallback.this.callbackReceivedHandler(handler, httpMessage);
            }
        });
    }

    private void callbackReceivedHandler(String handler, HttpMessage httpMessage) {
        try {
            CallbackRequest request = CallbackRequest.create(handler, httpMessage);
            this.getCallbackPanel().addCallbackRequest(request);
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.warn("Failed to persist received callback:", (Throwable)e);
        }
    }

    private class CallbackProxyListener
    implements OverrideMessageProxyListener {
        private CallbackProxyListener() {
        }

        @Override
        public int getArrangeableListenerOrder() {
            return 0;
        }

        @Override
        public boolean onHttpRequestSend(HttpMessage msg) {
            try {
                msg.setTimeSentMillis(new Date().getTime());
                String url = msg.getRequestHeader().getURI().toString();
                String path = msg.getRequestHeader().getURI().getPath();
                LOGGER.debug("Callback received for URL : " + url + " path : " + path + " from " + msg.getRequestHeader().getSenderAddress());
                msg.setResponseHeader("HTTP/1.1 200");
                if (path.startsWith("/ZapTest")) {
                    String str = Constant.messages.getString("callback.test.msg", url, msg.getRequestHeader().getSenderAddress().toString());
                    if (ExtensionCallback.this.hasView()) {
                        ExtensionCallback.this.getView().getOutputPanel().appendAsync(str + "\n");
                    }
                    LOGGER.info(str);
                    ExtensionCallback.this.callbackReceived(Constant.messages.getString("callback.handler.test.name"), msg);
                    return true;
                }
                if (path.startsWith("/favicon.ico")) {
                    return true;
                }
                for (Map.Entry callback : ExtensionCallback.this.callbacks.entrySet()) {
                    if (!path.startsWith((String)callback.getKey())) continue;
                    CallbackImplementor implementor = (CallbackImplementor)callback.getValue();
                    implementor.handleCallBack(msg.cloneAll());
                    ExtensionCallback.this.callbackReceived(implementor.getClass().getSimpleName(), msg);
                    return true;
                }
                ExtensionCallback.this.callbackReceived(Constant.messages.getString("callback.handler.none.name"), msg);
                LOGGER.error("No callback handler for URL : " + url + " from " + msg.getRequestHeader().getSenderAddress());
            }
            catch (URIException | HttpMalformedHeaderException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }

        @Override
        public boolean onHttpResponseReceived(HttpMessage msg) {
            return true;
        }
    }
}

