/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.FixedSizeItemsBlock;

class IntegerColumn
extends AbstractColumn {
    IntegerColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 40;
    }

    @Override
    protected int readData(byte[] byArray, int n) {
        FixedSizeItemsBlock fixedSizeItemsBlock = new FixedSizeItemsBlock().read(byArray, n);
        n = fixedSizeItemsBlock.getOffset();
        byte[][] byArray2 = fixedSizeItemsBlock.getData();
        this.m_data = new Integer[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            this.m_data[i] = FastTrackUtility.getInt(byArray2[i], 0);
        }
        return n;
    }

    @Override
    protected void dumpData(PrintWriter printWriter) {
        printWriter.println("  [Data");
        for (Object object : this.m_data) {
            printWriter.println("    " + object);
        }
        printWriter.println("  ]");
    }
}

