/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.RowStoreAVLHybrid;

public class RowStoreAVLHybridExtended
extends RowStoreAVLHybrid {
    Session session;
    boolean resettingAccessor = false;

    public RowStoreAVLHybridExtended(Session session, TableBase tableBase, boolean bl) {
        super(session, tableBase, bl);
        this.session = session;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        if (!this.resettingAccessor && this.table.getIndexCount() != this.indexList.length) {
            this.resetAccessorKeys(session, this.table.getIndexList());
        }
        return super.getNewCachedObject(session, object, bl);
    }

    @Override
    public synchronized void add(Session session, CachedObject cachedObject, boolean bl) {
        super.add(session, cachedObject, bl);
        if (bl) {
            RowAction.addInsertAction(session, this.table, this, (Row)cachedObject);
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
        int n = 0;
        while (nodeAVL != null) {
            ++n;
            nodeAVL = nodeAVL.nNext;
        }
        if (this.isCached && row.isMemory() || n != this.indexList.length) {
            row = (Row)this.getNewCachedObject(session, row.getData(), true);
        }
        super.indexRow(session, row);
    }

    @Override
    public void delete(Session session, Row row) {
        NodeAVL nodeAVL = ((RowAVL)row).getNode(0);
        int n = 0;
        while (nodeAVL != null) {
            ++n;
            nodeAVL = nodeAVL.nNext;
        }
        if (this.isCached && row.isMemory() || n != this.indexList.length) {
            row = ((Table)this.table).getDeleteRowFromLog(session, row.getData());
        }
        if (row != null) {
            super.delete(session, row);
        }
    }

    @Override
    public synchronized double searchCost(Session session, Index index, int n, int n2) {
        if (this.table.getIndexCount() != this.indexList.length) {
            this.resetAccessorKeys(session, this.table.getIndexList());
        }
        return super.searchCost(session, index, n, n2);
    }

    @Override
    public CachedObject getAccessor(Index index) {
        if (!this.resettingAccessor && index.getPosition() > 0 && this.table.getIndexCount() != this.indexList.length) {
            this.resetAccessorKeys(this.session, this.table.getIndexList());
        }
        return super.getAccessor(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resetAccessorKeys(Session session, Index[] indexArray) {
        this.resettingAccessor = true;
        try {
            if (this.indexList.length == 0 || this.accessorList[0] == null) {
                this.indexList = indexArray;
                this.accessorList = new CachedObject[this.indexList.length];
                return;
            }
            if (this.isCached) {
                this.resetAccessorKeysCached(indexArray);
            } else {
                super.resetAccessorKeys(session, indexArray);
            }
        }
        finally {
            this.resettingAccessor = false;
        }
    }

    private void resetAccessorKeysCached(Index[] indexArray) {
        RowStoreAVLHybridExtended rowStoreAVLHybridExtended = new RowStoreAVLHybridExtended(this.session, this.table, true);
        rowStoreAVLHybridExtended.changeToDiskTable(this.session);
        rowStoreAVLHybridExtended.indexList = this.indexList;
        rowStoreAVLHybridExtended.accessorList = this.accessorList;
        rowStoreAVLHybridExtended.elementCount.set(this.elementCount.get());
        this.indexList = indexArray;
        this.accessorList = new CachedObject[this.indexList.length];
        this.elementCount.set(0L);
        RowIterator rowIterator = rowStoreAVLHybridExtended.rowIterator();
        while (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            Row row2 = (Row)this.getNewCachedObject(this.session, row.getData(), false);
            this.indexRow(this.session, row2);
        }
    }
}

