/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.chooser;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.EsniDnsKeyRecordVersion;
import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.HeartbeatMode;
import de.rub.nds.tlsattacker.core.constants.MaxFragmentLength;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.constants.TokenBindingVersion;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.SNIEntry;
import de.rub.nds.tlsattacker.core.record.layer.RecordLayerType;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import java.math.BigInteger;
import java.util.List;
import org.bouncycastle.util.Arrays;

public class DefaultChooser
extends Chooser {
    DefaultChooser(TlsContext context, Config config) {
        super(context, config);
    }

    @Override
    public CertificateType getSelectedClientCertificateType() {
        if (this.context.getSelectedClientCertificateType() != null) {
            return this.context.getSelectedClientCertificateType();
        }
        return this.config.getDefaultSelectedClientCertificateType();
    }

    @Override
    public CertificateType getSelectedServerCertificateType() {
        if (this.context.getSelectedServerCertificateType() != null) {
            return this.context.getSelectedServerCertificateType();
        }
        return this.config.getDefaultSelectedServerCertificateType();
    }

    @Override
    public List<ECPointFormat> getClientSupportedPointFormats() {
        if (this.context.getClientPointFormatsList() != null) {
            return this.context.getClientPointFormatsList();
        }
        return this.config.getDefaultClientSupportedPointFormats();
    }

    @Override
    public SignatureAndHashAlgorithm getSelectedSigHashAlgorithm() {
        if (this.context.getSelectedSignatureAndHashAlgorithm() != null) {
            return this.context.getSelectedSignatureAndHashAlgorithm();
        }
        return this.config.getDefaultSelectedSignatureAndHashAlgorithm();
    }

    @Override
    public List<NamedGroup> getClientSupportedNamedGroups() {
        if (this.context.getClientNamedGroupsList() != null) {
            return this.context.getClientNamedGroupsList();
        }
        return this.config.getDefaultClientNamedGroups();
    }

    @Override
    public List<NamedGroup> getServerSupportedNamedGroups() {
        if (this.context.getServerNamedGroupsList() != null) {
            return this.context.getServerNamedGroupsList();
        }
        return this.config.getDefaultServerNamedGroups();
    }

    @Override
    public List<ECPointFormat> getServerSupportedPointFormats() {
        if (this.context.getServerPointFormatsList() != null) {
            return this.context.getServerPointFormatsList();
        }
        return this.config.getDefaultServerSupportedPointFormats();
    }

    @Override
    public List<SignatureAndHashAlgorithm> getClientSupportedSignatureAndHashAlgorithms() {
        if (this.context.getClientSupportedSignatureAndHashAlgorithms() != null) {
            return this.context.getClientSupportedSignatureAndHashAlgorithms();
        }
        return this.config.getDefaultClientSupportedSignatureAndHashAlgorithms();
    }

    @Override
    public List<SNIEntry> getClientSNIEntryList() {
        if (this.context.getClientSNIEntryList() != null) {
            return this.context.getClientSNIEntryList();
        }
        return this.config.getDefaultClientSNIEntryList();
    }

    @Override
    public ProtocolVersion getLastRecordVersion() {
        if (this.context.getLastRecordVersion() != null) {
            return this.context.getLastRecordVersion();
        }
        return this.config.getDefaultLastRecordProtocolVersion();
    }

    @Override
    public byte[] getDistinguishedNames() {
        if (this.context.getDistinguishedNames() != null) {
            return this.copy(this.context.getDistinguishedNames());
        }
        return this.config.getDistinguishedNames();
    }

    @Override
    public List<ClientCertificateType> getClientCertificateTypes() {
        if (this.context.getClientCertificateTypes() != null) {
            return this.context.getClientCertificateTypes();
        }
        return this.config.getClientCertificateTypes();
    }

    @Override
    public MaxFragmentLength getMaxFragmentLength() {
        if (this.context.getMaxFragmentLength() != null) {
            return this.context.getMaxFragmentLength();
        }
        return this.config.getDefaultMaxFragmentLength();
    }

    @Override
    public HeartbeatMode getHeartbeatMode() {
        if (this.context.getHeartbeatMode() != null) {
            return this.context.getHeartbeatMode();
        }
        return this.config.getDefaultHeartbeatMode();
    }

    @Override
    public boolean isUseExtendedMasterSecret() {
        return this.context.isUseExtendedMasterSecret();
    }

    @Override
    public List<CompressionMethod> getClientSupportedCompressions() {
        if (this.context.getClientSupportedCompressions() != null) {
            return this.context.getClientSupportedCompressions();
        }
        return this.config.getDefaultClientSupportedCompressionMethods();
    }

    @Override
    public List<CipherSuite> getClientSupportedCiphersuites() {
        if (this.context.getClientSupportedCiphersuites() != null) {
            return this.context.getClientSupportedCiphersuites();
        }
        return this.config.getDefaultClientSupportedCiphersuites();
    }

    @Override
    public List<SignatureAndHashAlgorithm> getServerSupportedSignatureAndHashAlgorithms() {
        if (this.context.getServerSupportedSignatureAndHashAlgorithms() != null) {
            return this.context.getServerSupportedSignatureAndHashAlgorithms();
        }
        return this.config.getDefaultServerSupportedSignatureAndHashAlgorithms();
    }

    @Override
    public ProtocolVersion getSelectedProtocolVersion() {
        if (this.context.getSelectedProtocolVersion() != null) {
            return this.context.getSelectedProtocolVersion();
        }
        return this.config.getDefaultSelectedProtocolVersion();
    }

    @Override
    public ProtocolVersion getHighestClientProtocolVersion() {
        if (this.context.getHighestClientProtocolVersion() != null) {
            return this.context.getHighestClientProtocolVersion();
        }
        return this.config.getDefaultHighestClientProtocolVersion();
    }

    @Override
    public ConnectionEndType getTalkingConnectionEnd() {
        return this.context.getTalkingConnectionEndType();
    }

    @Override
    public byte[] getMasterSecret() {
        if (this.context.getMasterSecret() != null) {
            return this.copy(this.context.getMasterSecret());
        }
        return this.config.getDefaultMasterSecret();
    }

    @Override
    public CipherSuite getSelectedCipherSuite() {
        if (this.context.getSelectedCipherSuite() != null) {
            return this.context.getSelectedCipherSuite();
        }
        return this.config.getDefaultSelectedCipherSuite();
    }

    @Override
    public SSL2CipherSuite getSSL2CipherSuite() {
        if (this.context.getSSL2CipherSuite() != null) {
            return this.context.getSSL2CipherSuite();
        }
        return this.config.getDefaultSSL2CipherSuite();
    }

    @Override
    public byte[] getPreMasterSecret() {
        if (this.context.getPreMasterSecret() != null) {
            return this.copy(this.context.getPreMasterSecret());
        }
        return this.config.getDefaultPreMasterSecret();
    }

    @Override
    public byte[] getClientRandom() {
        if (this.context.getClientRandom() != null) {
            return this.copy(this.context.getClientRandom());
        }
        return this.config.getDefaultClientRandom();
    }

    @Override
    public byte[] getClientExtendedRandom() {
        if (this.context.getClientExtendedRandom() != null) {
            return this.copy(this.context.getClientExtendedRandom());
        }
        return this.config.getDefaultClientExtendedRandom();
    }

    @Override
    public byte[] getServerExtendedRandom() {
        if (this.context.getServerExtendedRandom() != null) {
            return this.copy(this.context.getServerExtendedRandom());
        }
        return this.config.getDefaultServerExtendedRandom();
    }

    @Override
    public byte[] getServerRandom() {
        if (this.context.getServerRandom() != null) {
            return this.copy(this.context.getServerRandom());
        }
        return this.config.getDefaultServerRandom();
    }

    @Override
    public CompressionMethod getSelectedCompressionMethod() {
        if (this.context.getSelectedCompressionMethod() != null) {
            return this.context.getSelectedCompressionMethod();
        }
        return this.config.getDefaultSelectedCompressionMethod();
    }

    @Override
    public byte[] getClientSessionId() {
        if (this.context.getClientSessionId() != null) {
            return this.copy(this.context.getClientSessionId());
        }
        return this.config.getDefaultClientSessionId();
    }

    @Override
    public byte[] getServerSessionId() {
        if (this.context.getServerSessionId() != null) {
            return this.copy(this.context.getServerSessionId());
        }
        return this.config.getDefaultServerSessionId();
    }

    @Override
    public byte[] getDtlsCookie() {
        if (this.context.getDtlsCookie() != null) {
            return this.copy(this.context.getDtlsCookie());
        }
        return this.config.getDtlsDefaultCookie();
    }

    @Override
    public TransportHandler getTransportHandler() {
        return this.context.getTransportHandler();
    }

    @Override
    public PRFAlgorithm getPRFAlgorithm() {
        if (this.context.getPrfAlgorithm() != null) {
            return this.context.getPrfAlgorithm();
        }
        return this.config.getDefaultPRFAlgorithm();
    }

    @Override
    public byte[] getSessionTicketTLS() {
        if (this.context.getSessionTicketTLS() != null) {
            return this.copy(this.context.getSessionTicketTLS());
        }
        return this.config.getTlsSessionTicket();
    }

    @Override
    public byte[] getSignedCertificateTimestamp() {
        if (this.context.getSignedCertificateTimestamp() != null) {
            return this.copy(this.context.getSignedCertificateTimestamp());
        }
        return this.config.getDefaultSignedCertificateTimestamp();
    }

    @Override
    public TokenBindingVersion getTokenBindingVersion() {
        if (this.context.getTokenBindingVersion() != null) {
            return this.context.getTokenBindingVersion();
        }
        return this.config.getDefaultTokenBindingVersion();
    }

    @Override
    public List<TokenBindingKeyParameters> getTokenBindingKeyParameters() {
        if (this.context.getTokenBindingKeyParameters() != null) {
            return this.context.getTokenBindingKeyParameters();
        }
        return this.config.getDefaultTokenBindingKeyParameters();
    }

    @Override
    public BigInteger getServerDhModulus() {
        if (this.context.getServerDhModulus() != null) {
            return this.context.getServerDhModulus();
        }
        return this.config.getDefaultServerDhModulus();
    }

    @Override
    public BigInteger getServerDhGenerator() {
        if (this.context.getServerDhGenerator() != null) {
            return this.context.getServerDhGenerator();
        }
        return this.config.getDefaultServerDhGenerator();
    }

    @Override
    public BigInteger getClientDhModulus() {
        if (this.context.getClientDhModulus() != null) {
            return this.context.getClientDhModulus();
        }
        return this.config.getDefaultClientDhModulus();
    }

    @Override
    public BigInteger getClientDhGenerator() {
        if (this.context.getClientDhGenerator() != null) {
            return this.context.getClientDhGenerator();
        }
        return this.config.getDefaultClientDhGenerator();
    }

    @Override
    public BigInteger getDhServerPrivateKey() {
        if (this.context.getServerDhPrivateKey() != null) {
            return this.context.getServerDhPrivateKey();
        }
        return this.config.getDefaultServerDhPrivateKey();
    }

    @Override
    public BigInteger getSRPModulus() {
        if (this.context.getSRPModulus() != null) {
            return this.context.getSRPModulus();
        }
        return this.config.getDefaultSRPModulus();
    }

    @Override
    public byte[] getPSKIdentity() {
        if (this.context.getPSKIdentity() != null) {
            return this.copy(this.context.getPSKIdentity());
        }
        return this.config.getDefaultPSKIdentity();
    }

    @Override
    public byte[] getPSKIdentityHint() {
        if (this.context.getPSKIdentityHint() != null) {
            return this.copy(this.context.getPSKIdentityHint());
        }
        return this.config.getDefaultPSKIdentityHint();
    }

    @Override
    public BigInteger getPSKModulus() {
        if (this.context.getPSKModulus() != null) {
            return this.context.getPSKModulus();
        }
        return this.config.getDefaultPSKModulus();
    }

    @Override
    public BigInteger getPSKServerPrivateKey() {
        if (this.context.getServerPSKPrivateKey() != null) {
            return this.context.getServerPSKPrivateKey();
        }
        return this.config.getDefaultPSKServerPrivateKey();
    }

    @Override
    public BigInteger getPSKServerPublicKey() {
        if (this.context.getServerPSKPublicKey() != null) {
            return this.context.getServerPSKPublicKey();
        }
        return this.config.getDefaultPSKServerPublicKey();
    }

    @Override
    public BigInteger getPSKGenerator() {
        if (this.context.getPSKGenerator() != null) {
            return this.context.getPSKGenerator();
        }
        return this.config.getDefaultPSKGenerator();
    }

    @Override
    public BigInteger getSRPGenerator() {
        if (this.context.getSRPGenerator() != null) {
            return this.context.getSRPGenerator();
        }
        return this.config.getDefaultSRPGenerator();
    }

    @Override
    public BigInteger getSRPServerPrivateKey() {
        if (this.context.getServerSRPPrivateKey() != null) {
            return this.context.getServerSRPPrivateKey();
        }
        return this.config.getDefaultSRPServerPrivateKey();
    }

    @Override
    public BigInteger getSRPServerPublicKey() {
        if (this.context.getServerSRPPublicKey() != null) {
            return this.context.getServerSRPPublicKey();
        }
        return this.config.getDefaultSRPServerPublicKey();
    }

    @Override
    public BigInteger getSRPClientPrivateKey() {
        if (this.context.getClientSRPPrivateKey() != null) {
            return this.context.getClientSRPPrivateKey();
        }
        return this.config.getDefaultSRPClientPrivateKey();
    }

    @Override
    public BigInteger getSRPClientPublicKey() {
        if (this.context.getClientSRPPublicKey() != null) {
            return this.context.getClientSRPPublicKey();
        }
        return this.config.getDefaultSRPClientPublicKey();
    }

    @Override
    public byte[] getSRPPassword() {
        if (this.context.getSRPPassword() != null) {
            return this.copy(this.context.getSRPPassword());
        }
        return this.config.getDefaultSRPPassword();
    }

    @Override
    public byte[] getSRPIdentity() {
        if (this.context.getSRPIdentity() != null) {
            return this.copy(this.context.getSRPIdentity());
        }
        return this.config.getDefaultSRPIdentity();
    }

    @Override
    public byte[] getSRPServerSalt() {
        if (this.context.getSRPServerSalt() != null) {
            return this.copy(this.context.getSRPServerSalt());
        }
        return this.config.getDefaultSRPServerSalt();
    }

    @Override
    public BigInteger getDhClientPrivateKey() {
        if (this.context.getClientDhPrivateKey() != null) {
            return this.context.getClientDhPrivateKey();
        }
        return this.config.getDefaultClientDhPrivateKey();
    }

    @Override
    public BigInteger getDhServerPublicKey() {
        if (this.context.getServerDhPublicKey() != null) {
            return this.context.getServerDhPublicKey();
        }
        return this.config.getDefaultServerDhPublicKey();
    }

    @Override
    public BigInteger getDhClientPublicKey() {
        if (this.context.getClientDhPublicKey() != null) {
            return this.context.getClientDhPublicKey();
        }
        return this.config.getDefaultClientDhPublicKey();
    }

    @Override
    public BigInteger getServerEcPrivateKey() {
        if (this.context.getServerEcPrivateKey() != null) {
            return this.context.getServerEcPrivateKey();
        }
        return this.config.getDefaultServerEcPrivateKey();
    }

    @Override
    public GOSTCurve getSelectedGostCurve() {
        if (this.context.getSelectedGostCurve() != null) {
            return this.context.getSelectedGostCurve();
        }
        return this.config.getDefaultSelectedGostCurve();
    }

    @Override
    public BigInteger getClientEcPrivateKey() {
        if (this.context.getClientEcPrivateKey() != null) {
            return this.context.getClientEcPrivateKey();
        }
        return this.config.getDefaultClientEcPrivateKey();
    }

    @Override
    public NamedGroup getSelectedNamedGroup() {
        if (this.context.getSelectedGroup() != null) {
            return this.context.getSelectedGroup();
        }
        return this.config.getDefaultSelectedNamedGroup();
    }

    @Override
    public NamedGroup getEcCertificateCurve() {
        if (this.context.getSelectedGroup() != null) {
            return this.context.getEcCertificateCurve();
        }
        return this.config.getDefaultEcCertificateCurve();
    }

    @Override
    public Point getClientEcPublicKey() {
        if (this.context.getClientEcPublicKey() != null) {
            return this.context.getClientEcPublicKey();
        }
        return this.config.getDefaultClientEcPublicKey();
    }

    @Override
    public Point getServerEcPublicKey() {
        if (this.context.getServerEcPublicKey() != null) {
            return this.context.getServerEcPublicKey();
        }
        return this.config.getDefaultServerEcPublicKey();
    }

    @Override
    public EllipticCurveType getEcCurveType() {
        return EllipticCurveType.NAMED_CURVE;
    }

    @Override
    public BigInteger getServerRsaModulus() {
        if (this.context.getServerRsaModulus() != null) {
            return this.context.getServerRsaModulus();
        }
        return this.config.getDefaultServerRSAModulus();
    }

    @Override
    public BigInteger getClientRsaModulus() {
        if (this.context.getClientRsaModulus() != null) {
            return this.context.getClientRsaModulus();
        }
        return this.config.getDefaultClientRSAModulus();
    }

    @Override
    public BigInteger getServerRSAPublicKey() {
        if (this.context.getServerRSAPublicKey() != null) {
            return this.context.getServerRSAPublicKey();
        }
        return this.config.getDefaultServerRSAPublicKey();
    }

    @Override
    public BigInteger getClientRSAPublicKey() {
        if (this.context.getClientRSAPublicKey() != null) {
            return this.context.getClientRSAPublicKey();
        }
        return this.config.getDefaultClientRSAPublicKey();
    }

    @Override
    public byte[] getCertificateRequestContext() {
        if (this.context.getCertificateRequestContext() != null) {
            return this.copy(this.context.getCertificateRequestContext());
        }
        return this.config.getDefaultCertificateRequestContext();
    }

    @Override
    public byte[] getServerHandshakeTrafficSecret() {
        if (this.context.getServerHandshakeTrafficSecret() != null) {
            return this.copy(this.context.getServerHandshakeTrafficSecret());
        }
        return this.config.getDefaultServerHandshakeTrafficSecret();
    }

    @Override
    public byte[] getClientHandshakeTrafficSecret() {
        if (this.context.getClientHandshakeTrafficSecret() != null) {
            return this.copy(this.context.getClientHandshakeTrafficSecret());
        }
        return this.config.getDefaultClientHandshakeTrafficSecret();
    }

    @Override
    public byte[] getClientApplicationTrafficSecret() {
        if (this.context.getClientApplicationTrafficSecret() != null) {
            return this.copy(this.context.getClientApplicationTrafficSecret());
        }
        return this.config.getDefaultClientApplicationTrafficSecret();
    }

    @Override
    public byte[] getServerApplicationTrafficSecret() {
        if (this.context.getServerApplicationTrafficSecret() != null) {
            return this.copy(this.context.getServerApplicationTrafficSecret());
        }
        return this.config.getDefaultServerApplicationTrafficSecret();
    }

    @Override
    public RecordLayerType getRecordLayerType() {
        if (this.context.getRecordLayerType() != null) {
            return this.context.getRecordLayerType();
        }
        return this.config.getRecordLayerType();
    }

    @Override
    public BigInteger getClientRSAPrivateKey() {
        if (this.context.getClientRSAPrivateKey() != null) {
            return this.context.getClientRSAPrivateKey();
        }
        return this.config.getDefaultClientRSAPrivateKey();
    }

    @Override
    public BigInteger getServerRSAPrivateKey() {
        if (this.context.getServerRSAPrivateKey() != null) {
            return this.context.getServerRSAPrivateKey();
        }
        return this.config.getDefaultServerRSAPrivateKey();
    }

    @Override
    public Connection getConnection() {
        return this.context.getConnection();
    }

    @Override
    public ConnectionEndType getMyConnectionPeer() {
        return this.getConnection().getLocalConnectionEndType() == ConnectionEndType.CLIENT ? ConnectionEndType.SERVER : ConnectionEndType.CLIENT;
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        if (this.context.getHighestProtocolVersion() != null) {
            return this.context.getHighestProtocolVersion();
        }
        return this.config.getHighestProtocolVersion();
    }

    @Override
    public boolean isClientAuthentication() {
        if (this.context.isClientAuthentication() != null) {
            return this.context.isClientAuthentication();
        }
        return this.config.isClientAuthentication();
    }

    @Override
    public byte[] getLastHandledApplicationMessageData() {
        if (this.context.getLastHandledApplicationMessageData() != null) {
            return this.copy(this.context.getLastHandledApplicationMessageData());
        }
        return this.config.getDefaultApplicationMessageData().getBytes();
    }

    @Override
    public byte[] getPsk() {
        if (this.context.getPsk() != null) {
            return this.copy(this.context.getPsk());
        }
        return this.config.getPsk();
    }

    @Override
    public String getHttpsCookieValue() {
        String cookieVal = this.context.getHttpsCookieValue();
        if (cookieVal != null && !cookieVal.isEmpty()) {
            return cookieVal;
        }
        return this.config.getDefaultHttpsCookieValue();
    }

    @Override
    public String getHttpsCookieName() {
        String cookieName = this.context.getHttpsCookieName();
        if (cookieName != null && !cookieName.isEmpty()) {
            return cookieName;
        }
        return this.config.getDefaultHttpsCookieName();
    }

    @Override
    public List<PskSet> getPskSets() {
        if (this.context.getPskSets() != null) {
            return this.context.getPskSets();
        }
        return this.config.getDefaultPskSets();
    }

    @Override
    public CipherSuite getEarlyDataCipherSuite() {
        if (this.context.getEarlyDataCipherSuite() != null) {
            return this.context.getEarlyDataCipherSuite();
        }
        return this.config.getEarlyDataCipherSuite();
    }

    @Override
    public byte[] getClientEarlyTrafficSecret() {
        if (this.context.getClientEarlyTrafficSecret() != null) {
            return this.copy(this.context.getClientEarlyTrafficSecret());
        }
        return this.config.getClientEarlyTrafficSecret();
    }

    @Override
    public byte[] getEarlySecret() {
        if (this.context.getEarlySecret() != null) {
            return this.copy(this.context.getEarlySecret());
        }
        return this.config.getEarlySecret();
    }

    @Override
    public byte[] getEarlyDataPsk() {
        if (this.context.getEarlyDataPsk() != null) {
            return this.copy(this.context.getEarlyDataPsk());
        }
        return this.config.getEarlyDataPsk();
    }

    @Override
    public ConnectionEndType getConnectionEndType() {
        return this.getConnection().getLocalConnectionEndType();
    }

    @Override
    public List<KeyShareStoreEntry> getClientKeyShares() {
        if (this.context.getClientKeyShareStoreEntryList() != null) {
            return this.context.getClientKeyShareStoreEntryList();
        }
        return this.config.getDefaultClientKeyShareEntries();
    }

    @Override
    public KeyShareStoreEntry getServerKeyShare() {
        if (this.context.getServerKeyShareStoreEntry() != null) {
            return this.context.getServerKeyShareStoreEntry();
        }
        return this.config.getDefaultServerKeyShareEntry();
    }

    @Override
    public BigInteger getDsaClientPrivateKey() {
        if (this.context.getClientDsaPrivateKey() != null) {
            return this.context.getClientDsaPrivateKey();
        }
        return this.config.getDefaultClientDsaPrivateKey();
    }

    @Override
    public BigInteger getDsaClientPublicKey() {
        if (this.context.getClientDsaPublicKey() != null) {
            return this.context.getClientDsaPublicKey();
        }
        return this.config.getDefaultClientDsaPublicKey();
    }

    @Override
    public BigInteger getDsaClientPrimeP() {
        if (this.context.getClientDsaPrimeP() != null) {
            return this.context.getClientDsaPrimeP();
        }
        return this.config.getDefaultClientDsaPrimeP();
    }

    @Override
    public BigInteger getDsaClientPrimeQ() {
        if (this.context.getClientDsaPrimeQ() != null) {
            return this.context.getClientDsaPrimeQ();
        }
        return this.config.getDefaultClientDsaPrimeQ();
    }

    @Override
    public BigInteger getDsaClientGenerator() {
        if (this.context.getClientDsaGenerator() != null) {
            return this.context.getClientDsaGenerator();
        }
        return this.config.getDefaultClientDsaGenerator();
    }

    @Override
    public BigInteger getDsaServerPrivateKey() {
        if (this.context.getServerDsaPrivateKey() != null) {
            return this.context.getServerDsaPrivateKey();
        }
        return this.config.getDefaultServerDsaPrivateKey();
    }

    @Override
    public BigInteger getDsaServerPublicKey() {
        if (this.context.getServerDsaPublicKey() != null) {
            return this.context.getServerDsaPublicKey();
        }
        return this.config.getDefaultServerDsaPublicKey();
    }

    @Override
    public BigInteger getDsaServerPrimeP() {
        if (this.context.getServerDsaPrimeP() != null) {
            return this.context.getServerDsaPrimeP();
        }
        return this.config.getDefaultServerDsaPrimeP();
    }

    @Override
    public BigInteger getDsaServerPrimeQ() {
        if (this.context.getServerDsaPrimeQ() != null) {
            return this.context.getServerDsaPrimeQ();
        }
        return this.config.getDefaultServerDsaPrimeQ();
    }

    @Override
    public BigInteger getDsaServerGenerator() {
        if (this.context.getServerDsaGenerator() != null) {
            return this.context.getServerDsaGenerator();
        }
        return this.config.getDefaultServerDsaGenerator();
    }

    @Override
    public byte[] getHandshakeSecret() {
        if (this.context.getHandshakeSecret() != null) {
            return this.copy(this.context.getHandshakeSecret());
        }
        return this.config.getDefaultHandshakeSecret();
    }

    private byte[] copy(byte[] array) {
        return Arrays.copyOf((byte[])array, (int)array.length);
    }

    @Override
    public String getClientPWDUsername() {
        if (this.context.getClientPWDUsername() != null) {
            return this.context.getClientPWDUsername();
        }
        return this.config.getDefaultClientPWDUsername();
    }

    @Override
    public byte[] getServerPWDSalt() {
        return this.context.getServerPWDSalt();
    }

    @Override
    public String getPWDPassword() {
        return this.config.getDefaultPWDPassword();
    }

    @Override
    public byte[] getEsniClientNonce() {
        if (this.context.getEsniClientNonce() != null) {
            return this.context.getEsniClientNonce();
        }
        return this.config.getDefaultEsniClientNonce();
    }

    @Override
    public byte[] getEsniServerNonce() {
        if (this.context.getEsniServerNonce() != null) {
            return this.context.getEsniServerNonce();
        }
        return this.config.getDefaultEsniServerNonce();
    }

    @Override
    public byte[] getEsniRecordBytes() {
        if (this.context.getEsniRecordBytes() != null) {
            return this.context.getEsniRecordBytes();
        }
        return this.config.getDefaultEsniRecordBytes();
    }

    @Override
    public EsniDnsKeyRecordVersion getEsniRecordVersion() {
        if (this.context.getEsniRecordVersion() != null) {
            return this.context.getEsniRecordVersion();
        }
        return this.config.getDefaultEsniRecordVersion();
    }

    @Override
    public byte[] getEsniRecordChecksum() {
        if (this.context.getEsniRecordChecksum() != null) {
            return this.context.getEsniRecordChecksum();
        }
        return this.config.getDefaultEsniRecordChecksum();
    }

    @Override
    public List<KeyShareStoreEntry> getEsniServerKeyShareEntries() {
        if (this.context.getEsniServerKeyShareEntries() != null && this.context.getEsniServerKeyShareEntries().size() > 0) {
            return this.context.getEsniServerKeyShareEntries();
        }
        return this.config.getDefaultEsniServerKeyShareEntries();
    }

    @Override
    public List<CipherSuite> getEsniServerCiphersuites() {
        if (this.context.getEsniServerCiphersuites() != null) {
            return this.context.getEsniServerCiphersuites();
        }
        return this.config.getDefaultEsniServerCiphersuites();
    }

    @Override
    public Integer getEsniPaddedLength() {
        if (this.context.getEsniPaddedLength() != null) {
            return this.context.getEsniPaddedLength();
        }
        return this.config.getDefaultEsniPaddedLength();
    }

    @Override
    public Long getEsniNotBefore() {
        if (this.context.getEsniKeysNotBefore() != null) {
            return this.context.getEsniKeysNotBefore();
        }
        return this.config.getDefaultEsniNotBefore();
    }

    @Override
    public Long getEsniNotAfter() {
        if (this.context.getEsniNotAfter() != null) {
            return this.context.getEsniNotAfter();
        }
        return this.config.getDefaultEsniNotAfter();
    }
}

