/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.core.PApplet;
import processing.mode.android.AndroidMode;
import processing.mode.android.BadSDKException;

class AndroidSDK {
    private final File folder;
    private final File tools;
    private final File platformTools;
    private final File androidTool;
    private static final String ANDROID_SDK_PRIMARY = "Is the Android SDK installed?";
    private static final String ANDROID_SDK_SECONDARY = "The Android SDK does not appear to be installed, <br>because the ANDROID_SDK variable is not set. <br>If it is installed, click \u201cYes\u201d to select the <br>location of the SDK, or \u201cNo\u201d to visit the SDK<br>download site at http://developer.android.com/sdk.";
    private static final String SELECT_ANDROID_SDK_FOLDER = "Choose the location of the Android SDK";
    private static final String NOT_ANDROID_SDK = "The selected folder does not appear to contain an Android SDK,\nor the SDK needs to be updated to the latest version.";
    private static final String ANDROID_SDK_URL = "http://developer.android.com/sdk/";
    private static final String ADB_DAEMON_MSG_1 = "daemon not running";
    private static final String ADB_DAEMON_MSG_2 = "daemon started successfully";

    public AndroidSDK(File folder) throws BadSDKException, IOException {
        this.folder = folder;
        if (!folder.exists()) {
            throw new BadSDKException(folder + " does not exist");
        }
        this.tools = new File(folder, "tools");
        if (!this.tools.exists()) {
            throw new BadSDKException("There is no tools folder in " + folder);
        }
        this.platformTools = new File(folder, "platform-tools");
        if (!this.platformTools.exists()) {
            throw new BadSDKException("There is no platform-tools folder in " + folder);
        }
        this.androidTool = AndroidSDK.findAndroidTool(this.tools);
        Platform p = Base.getPlatform();
        String path = p.getenv("PATH");
        p.setenv("ANDROID_SDK", folder.getCanonicalPath());
        path = this.platformTools.getCanonicalPath() + File.pathSeparator + this.tools.getCanonicalPath() + File.pathSeparator + path;
        String javaHomeProp = System.getProperty("java.home");
        File javaHome = new File(javaHomeProp).getCanonicalFile();
        p.setenv("JAVA_HOME", javaHome.getCanonicalPath());
        path = new File(javaHome, "bin").getCanonicalPath() + File.pathSeparator + path;
        p.setenv("PATH", path);
        this.checkDebugCertificate();
    }

    protected void checkDebugCertificate() {
        File dotAndroidFolder = new File(System.getProperty("user.home"), ".android");
        File keystoreFile = new File(dotAndroidFolder, "debug.keystore");
        if (keystoreFile.exists()) {
            ProcessHelper ph = new ProcessHelper("keytool", "-list", "-v", "-storepass", "android", "-keystore", keystoreFile.getAbsolutePath());
            try {
                ProcessResult result = ph.execute();
                if (result.succeeded()) {
                    String[] lines;
                    for (String line : lines = PApplet.split((String)result.getStdout(), (char)'\n')) {
                        String[] m = PApplet.match((String)line, (String)"Valid from: .* until: (.*)");
                        if (m == null) continue;
                        String timestamp = m[1];
                        SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
                        try {
                            Date date = df.parse(timestamp);
                            long expireMillis = date.getTime();
                            if (expireMillis >= System.currentTimeMillis()) continue;
                            System.out.println("Removing expired debug.keystore file.");
                            String hidingName = "debug.keystore." + AndroidMode.getDateStamp(expireMillis);
                            File hidingFile = new File(keystoreFile.getParent(), hidingName);
                            if (keystoreFile.renameTo(hidingFile)) continue;
                            System.err.println("Could not remove the expired debug.keystore file.");
                            System.err.println("Please remove the file " + keystoreFile.getAbsolutePath());
                        }
                        catch (ParseException pe) {
                            System.err.println("The date \u201c" + timestamp + "\u201d could not be parsed.");
                            System.err.println("Please report this as a bug so we can fix it.");
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public File getAndroidTool() {
        return this.androidTool;
    }

    public String getAndroidToolPath() {
        return this.androidTool.getAbsolutePath();
    }

    public File getSdkFolder() {
        return this.folder;
    }

    public File getPlatformToolsFolder() {
        return this.platformTools;
    }

    private static File findAndroidTool(File tools) throws BadSDKException {
        if (new File(tools, "android.exe").exists()) {
            return new File(tools, "android.exe");
        }
        if (new File(tools, "android.bat").exists()) {
            return new File(tools, "android.bat");
        }
        if (new File(tools, "android").exists()) {
            return new File(tools, "android");
        }
        throw new BadSDKException("Cannot find the android tool in " + tools);
    }

    public static AndroidSDK load() throws BadSDKException, IOException {
        String sdkPrefsPath;
        Platform platform = Base.getPlatform();
        String sdkEnvPath = platform.getenv("ANDROID_SDK");
        if (sdkEnvPath != null) {
            try {
                AndroidSDK androidSDK = new AndroidSDK(new File(sdkEnvPath));
                Preferences.set("android.sdk.path", sdkEnvPath);
                return androidSDK;
            }
            catch (BadSDKException drop) {
                // empty catch block
            }
        }
        if ((sdkPrefsPath = Preferences.get("android.sdk.path")) != null) {
            try {
                AndroidSDK androidSDK = new AndroidSDK(new File(sdkPrefsPath));
                Preferences.set("android.sdk.path", sdkPrefsPath);
                return androidSDK;
            }
            catch (BadSDKException wellThatsThat) {
                Preferences.unset("android.sdk.path");
            }
        }
        return null;
    }

    public static AndroidSDK locate(Frame window) throws BadSDKException, IOException {
        int result = Base.showYesNoQuestion(window, "Android SDK", ANDROID_SDK_PRIMARY, ANDROID_SDK_SECONDARY);
        if (result == 2) {
            throw new BadSDKException("User canceled attempt to find SDK.");
        }
        if (result == 1) {
            Base.openURL(ANDROID_SDK_URL);
            throw new BadSDKException("No SDK installed.");
        }
        while (true) {
            File folder;
            if ((folder = Base.selectFolder(SELECT_ANDROID_SDK_FOLDER, null, window)) == null) {
                throw new BadSDKException("User canceled attempt to find SDK.");
            }
            try {
                AndroidSDK androidSDK = new AndroidSDK(folder);
                Preferences.set("android.sdk.path", folder.getAbsolutePath());
                return androidSDK;
            }
            catch (BadSDKException nope) {
                JOptionPane.showMessageDialog(window, NOT_ANDROID_SDK);
                continue;
            }
            break;
        }
    }

    public static ProcessResult runADB(String ... cmd) throws InterruptedException, IOException {
        ProcessResult adbResult;
        String out;
        String[] adbCmd = !cmd[0].equals("adb") ? PApplet.splice((String[])cmd, (String)"adb", (int)0) : cmd;
        if (Base.DEBUG) {
            PApplet.println((Object)adbCmd);
        }
        if ((out = (adbResult = new ProcessHelper(adbCmd).execute()).getStdout()).contains(ADB_DAEMON_MSG_1) && out.contains(ADB_DAEMON_MSG_2)) {
            StringBuilder sb = new StringBuilder();
            for (String line : out.split("\n")) {
                if (out.contains(ADB_DAEMON_MSG_1) || out.contains(ADB_DAEMON_MSG_2)) continue;
                sb.append(line).append("\n");
            }
            return new ProcessResult(adbResult.getCmd(), adbResult.getResult(), sb.toString(), adbResult.getStderr(), adbResult.getTime());
        }
        return adbResult;
    }
}

