/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DateAndFlags;
import net.i2p.data.Destination;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionId;

public class SendMessageExpiresMessage
extends SendMessageMessage {
    public static final int MESSAGE_TYPE = 36;
    private final DateAndFlags _daf;

    public SendMessageExpiresMessage() {
        this._daf = new DateAndFlags();
    }

    @Deprecated
    public SendMessageExpiresMessage(DateAndFlags options) {
        this._daf = options;
    }

    public SendMessageExpiresMessage(SessionId sessID, Destination dest, Payload payload, long nonce) {
        super(sessID, dest, payload, nonce);
        this._daf = new DateAndFlags();
    }

    public SendMessageExpiresMessage(SessionId sessID, Destination dest, Payload payload, long nonce, DateAndFlags options) {
        super(sessID, dest, payload, nonce);
        this._daf = options;
    }

    public Date getExpiration() {
        return this._daf.getDate();
    }

    public long getExpirationTime() {
        return this._daf.getTime();
    }

    public void setExpiration(Date d) {
        this._daf.setDate(d);
    }

    public void setExpiration(long d) {
        this._daf.setDate(d);
    }

    public int getFlags() {
        return this._daf.getFlags();
    }

    public void setFlags(int f) {
        this._daf.setFlags(f);
    }

    @Override
    public synchronized void readMessage(InputStream in, int length, int type) throws I2CPMessageException, IOException {
        super.readMessage(in, length, type);
        try {
            this._daf.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    public synchronized void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        if (this._sessionId == null) {
            throw new I2CPMessageException("No session ID");
        }
        if (this._destination == null) {
            throw new I2CPMessageException("No dest");
        }
        if (this._payload == null) {
            throw new I2CPMessageException("No payload");
        }
        if (this._nonce < 0L) {
            throw new I2CPMessageException("No nonce");
        }
        int len = 2 + this._destination.size() + this._payload.getSize() + 4 + 4 + 8;
        try {
            DataHelper.writeLong(out, 4, len);
            out.write(36);
            this._sessionId.writeBytes(out);
            this._destination.writeBytes(out);
            this._payload.writeBytes(out);
            DataHelper.writeLong(out, 4, this._nonce);
            this._daf.writeBytes(out);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing the msg", dfe);
        }
    }

    @Override
    public int getType() {
        return 36;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[SendMessageExpiresMessage: ");
        buf.append("\n\tSessionId: ").append(this._sessionId);
        buf.append("\n\tNonce: ").append(this._nonce);
        buf.append("\n\tDestination: ").append(this._destination);
        buf.append("\n\tExpiration: ").append(this.getExpiration());
        buf.append("\n\tPayload: ").append(this._payload);
        buf.append("]");
        return buf.toString();
    }
}

