/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GalleonCLICommand;
import org.jboss.galleon.cli.GalleonCommandExecutionContext;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.LatestVersionNotAvailableException;

public abstract class PmSessionCommand
implements Command<PmCommandInvocation>,
GalleonCLICommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(PmCommandInvocation session) throws CommandException {
        GalleonCommandExecutionContext ctx = null;
        try {
            Object version;
            session.getPmSession().commandStart(session);
            if (this.getCommandClassName(session.getPmSession()) != null) {
                ctx = this.getGalleonContext(session.getPmSession());
                if (ctx == null) {
                    version = this.getCoreVersion(session.getPmSession());
                    ctx = session.getPmSession().getGalleonContext((String)version);
                }
                ctx.execute(this, session);
            } else {
                this.runCommand(session);
            }
            version = CommandResult.SUCCESS;
            return version;
        }
        catch (Throwable t) {
            PmSessionCommand.handleException(ctx, session, t);
            CommandResult commandResult = CommandResult.FAILURE;
            return commandResult;
        }
        finally {
            session.getPmSession().commandEnd(session);
        }
    }

    public static void handleException(PmCommandInvocation session, Throwable t) throws CommandException {
        PmSessionCommand.handleException(null, session, t);
    }

    public static void handleException(GalleonCommandExecutionContext ctx, PmCommandInvocation session, Throwable t) throws CommandException {
        if (session.getPmSession().isExceptionRethrown()) {
            throw new CommandException(t);
        }
        PmSessionCommand.printException(ctx, session.getPmSession(), t);
    }

    static void printException(GalleonCommandExecutionContext ctx, PmSession session, Throwable t) {
        if (t instanceof RuntimeException) {
            CliLogging.exception(t);
            t.printStackTrace(session.getErr());
        }
        t = PmSessionCommand.handleCommandExecutionException(ctx, t);
        CliLogging.error(t.getMessage());
        session.print("Error: ");
        PmSessionCommand.println(session, t);
        t = t.getCause();
        int offset = 1;
        while (t != null) {
            for (int i = 0; i < offset; ++i) {
                session.print(" ");
            }
            session.print("* ");
            PmSessionCommand.println(session, t);
            t = t.getCause();
            ++offset;
        }
    }

    private static Throwable handleCommandExecutionException(GalleonCommandExecutionContext ctx, Throwable t) {
        CommandExecutionException cex;
        if (t instanceof CommandExecutionException && (cex = (CommandExecutionException)t).getPmSession() != null && cex.getCause() instanceof LatestVersionNotAvailableException) {
            LatestVersionNotAvailableException cause = (LatestVersionNotAvailableException)cex.getCause();
            FeaturePackLocation fpl = ctx.getExposedLocation(null, cause.getLocation());
            t = new LatestVersionNotAvailableException(fpl);
        }
        return t;
    }

    private static void println(PmSession session, Throwable t) {
        if (t.getLocalizedMessage() == null) {
            session.println(t.getClass().getName());
        } else {
            session.println(t.getLocalizedMessage());
        }
    }

    protected String getCoreVersion(PmSession session) throws ProvisioningException {
        return null;
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return null;
    }

    public GalleonCommandExecutionContext getGalleonContext(PmSession session) throws CommandException {
        return null;
    }

    protected abstract void runCommand(PmCommandInvocation var1) throws CommandExecutionException;

    public CommandDomain getDomain() {
        return null;
    }
}

