/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateIterator
implements Iterator<int[]> {
    private final int[] dimensions;
    private final boolean littleEndian;
    private final int[] current;
    private boolean hasNext;

    public CoordinateIterator(int[] dimensions) {
        this(dimensions, false);
    }

    public CoordinateIterator(int[] dimensions, boolean littleEndian) {
        this.dimensions = dimensions;
        this.littleEndian = littleEndian;
        this.current = new int[dimensions.length];
        this.hasNext = true;
        for (int dimension : dimensions) {
            if (dimension > 0) continue;
            this.hasNext = false;
            break;
        }
    }

    public static Iterable<int[]> iterate(final int[] dimensions) {
        return new Iterable<int[]>(){

            @Override
            public Iterator<int[]> iterator() {
                return new CoordinateIterator(dimensions, true);
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int[] next() {
        int[] result = (int[])this.current.clone();
        this.moveToNext();
        return result;
    }

    private void moveToNext() {
        if (this.littleEndian) {
            for (int offset = 0; offset < this.dimensions.length; ++offset) {
                int n = offset;
                this.current[n] = this.current[n] + 1;
                int k = this.current[n];
                if (k < this.dimensions[offset]) {
                    return;
                }
                this.current[offset] = 0;
            }
        } else {
            for (int offset = this.dimensions.length - 1; offset >= 0; --offset) {
                int n = offset;
                this.current[n] = this.current[n] + 1;
                int k = this.current[n];
                if (k < this.dimensions[offset]) {
                    return;
                }
                this.current[offset] = 0;
            }
        }
        this.hasNext = false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

