/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.clients.consumer.internals.CachedSupplier;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.OffsetAndTimestampInternal;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.ShareConsumeRequestManager;
import org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.AllTopicsMetadataEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.AssignmentChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.AsyncCommitEvent;
import org.apache.kafka.clients.consumer.internals.events.CommitOnCloseEvent;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.EventProcessor;
import org.apache.kafka.clients.consumer.internals.events.FetchCommittedOffsetsEvent;
import org.apache.kafka.clients.consumer.internals.events.ListOffsetsEvent;
import org.apache.kafka.clients.consumer.internals.events.NewTopicsMetadataUpdateRequestEvent;
import org.apache.kafka.clients.consumer.internals.events.PollEvent;
import org.apache.kafka.clients.consumer.internals.events.ResetPositionsEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgeAsyncEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgeOnCloseEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgeSyncEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareFetchEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareSubscriptionChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareUnsubscribeEvent;
import org.apache.kafka.clients.consumer.internals.events.SubscriptionChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.SyncCommitEvent;
import org.apache.kafka.clients.consumer.internals.events.TopicMetadataEvent;
import org.apache.kafka.clients.consumer.internals.events.UnsubscribeEvent;
import org.apache.kafka.clients.consumer.internals.events.ValidatePositionsEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ApplicationEventProcessor
implements EventProcessor<ApplicationEvent> {
    private final Logger log;
    private final ConsumerMetadata metadata;
    private final SubscriptionState subscriptions;
    private final RequestManagers requestManagers;

    public ApplicationEventProcessor(LogContext logContext, RequestManagers requestManagers, ConsumerMetadata metadata, SubscriptionState subscriptions) {
        this.log = logContext.logger(ApplicationEventProcessor.class);
        this.requestManagers = requestManagers;
        this.metadata = metadata;
        this.subscriptions = subscriptions;
    }

    @Override
    public void process(ApplicationEvent event) {
        switch (event.type()) {
            case COMMIT_ASYNC: {
                this.process((AsyncCommitEvent)event);
                return;
            }
            case COMMIT_SYNC: {
                this.process((SyncCommitEvent)event);
                return;
            }
            case POLL: {
                this.process((PollEvent)event);
                return;
            }
            case FETCH_COMMITTED_OFFSETS: {
                this.process((FetchCommittedOffsetsEvent)event);
                return;
            }
            case NEW_TOPICS_METADATA_UPDATE: {
                this.process((NewTopicsMetadataUpdateRequestEvent)event);
                return;
            }
            case ASSIGNMENT_CHANGE: {
                this.process((AssignmentChangeEvent)event);
                return;
            }
            case TOPIC_METADATA: {
                this.process((TopicMetadataEvent)event);
                return;
            }
            case ALL_TOPICS_METADATA: {
                this.process((AllTopicsMetadataEvent)event);
                return;
            }
            case LIST_OFFSETS: {
                this.process((ListOffsetsEvent)event);
                return;
            }
            case RESET_POSITIONS: {
                this.process((ResetPositionsEvent)event);
                return;
            }
            case VALIDATE_POSITIONS: {
                this.process((ValidatePositionsEvent)event);
                return;
            }
            case SUBSCRIPTION_CHANGE: {
                this.process((SubscriptionChangeEvent)event);
                return;
            }
            case UNSUBSCRIBE: {
                this.process((UnsubscribeEvent)event);
                return;
            }
            case CONSUMER_REBALANCE_LISTENER_CALLBACK_COMPLETED: {
                this.process((ConsumerRebalanceListenerCallbackCompletedEvent)event);
                return;
            }
            case COMMIT_ON_CLOSE: {
                this.process((CommitOnCloseEvent)event);
                return;
            }
            case SHARE_FETCH: {
                this.process((ShareFetchEvent)event);
                return;
            }
            case SHARE_ACKNOWLEDGE_SYNC: {
                this.process((ShareAcknowledgeSyncEvent)event);
                return;
            }
            case SHARE_ACKNOWLEDGE_ASYNC: {
                this.process((ShareAcknowledgeAsyncEvent)event);
                return;
            }
            case SHARE_SUBSCRIPTION_CHANGE: {
                this.process((ShareSubscriptionChangeEvent)event);
                return;
            }
            case SHARE_UNSUBSCRIBE: {
                this.process((ShareUnsubscribeEvent)event);
                return;
            }
            case SHARE_ACKNOWLEDGE_ON_CLOSE: {
                this.process((ShareAcknowledgeOnCloseEvent)event);
                return;
            }
        }
        this.log.warn("Application event type {} was not expected", (Object)event.type());
    }

    @Override
    private void process(PollEvent event) {
        if (this.requestManagers.commitRequestManager.isPresent()) {
            this.requestManagers.commitRequestManager.ifPresent(m -> m.updateAutoCommitTimer(event.pollTimeMs()));
            this.requestManagers.heartbeatRequestManager.ifPresent(hrm -> hrm.resetPollTimer(event.pollTimeMs()));
        } else {
            this.requestManagers.shareHeartbeatRequestManager.ifPresent(hrm -> hrm.resetPollTimer(event.pollTimeMs()));
        }
    }

    @Override
    private void process(AsyncCommitEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        CompletableFuture<Void> future = manager.commitAsync(event.offsets());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(SyncCommitEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        CompletableFuture<Void> future = manager.commitSync(event.offsets(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(FetchCommittedOffsetsEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            event.future().completeExceptionally(new KafkaException("Unable to fetch committed offset because the CommittedRequestManager is not available. Check if group.id was set correctly"));
            return;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        CompletableFuture<Map<TopicPartition, OffsetAndMetadata>> future = manager.fetchOffsets(event.partitions(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(NewTopicsMetadataUpdateRequestEvent ignored) {
        this.metadata.requestUpdateForNewTopics();
    }

    @Override
    private void process(AssignmentChangeEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return;
        }
        CommitRequestManager manager = this.requestManagers.commitRequestManager.get();
        manager.updateAutoCommitTimer(event.currentTimeMs());
        manager.maybeAutoCommitAsync();
    }

    @Override
    private void process(ListOffsetsEvent event) {
        CompletableFuture<Map<TopicPartition, OffsetAndTimestampInternal>> future = this.requestManagers.offsetsRequestManager.fetchOffsets(event.timestampsToSearch(), event.requireTimestamps());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(SubscriptionChangeEvent ignored) {
        if (!this.requestManagers.heartbeatRequestManager.isPresent()) {
            this.log.warn("Group membership manager not present when processing a subscribe event");
            return;
        }
        MembershipManager membershipManager = this.requestManagers.heartbeatRequestManager.get().membershipManager();
        membershipManager.onSubscriptionUpdated();
    }

    @Override
    private void process(UnsubscribeEvent event) {
        if (this.requestManagers.heartbeatRequestManager.isPresent()) {
            MembershipManager membershipManager = this.requestManagers.heartbeatRequestManager.get().membershipManager();
            CompletableFuture<Void> future = membershipManager.leaveGroup();
            future.whenComplete(this.complete(event.future()));
        } else {
            this.subscriptions.unsubscribe();
            event.future().complete(null);
        }
    }

    @Override
    private void process(ResetPositionsEvent event) {
        CompletableFuture<Void> future = this.requestManagers.offsetsRequestManager.resetPositionsIfNeeded();
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(ValidatePositionsEvent event) {
        CompletableFuture<Void> future = this.requestManagers.offsetsRequestManager.validatePositionsIfNeeded();
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(TopicMetadataEvent event) {
        CompletableFuture<Map<String, List<PartitionInfo>>> future = this.requestManagers.topicMetadataRequestManager.requestTopicMetadata(event.topic(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(AllTopicsMetadataEvent event) {
        CompletableFuture<Map<String, List<PartitionInfo>>> future = this.requestManagers.topicMetadataRequestManager.requestAllTopicsMetadata(event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(ConsumerRebalanceListenerCallbackCompletedEvent event) {
        if (!this.requestManagers.heartbeatRequestManager.isPresent()) {
            this.log.warn("An internal error occurred; the group membership manager was not present, so the notification of the {} callback execution could not be sent", (Object)event.methodName());
            return;
        }
        MembershipManager manager = this.requestManagers.heartbeatRequestManager.get().membershipManager();
        manager.consumerRebalanceListenerCallbackCompleted(event);
    }

    @Override
    private void process(CommitOnCloseEvent event) {
        if (!this.requestManagers.commitRequestManager.isPresent()) {
            return;
        }
        this.log.debug("Signal CommitRequestManager closing");
        this.requestManagers.commitRequestManager.get().signalClose();
    }

    @Override
    private void process(ShareFetchEvent event) {
        this.requestManagers.shareConsumeRequestManager.ifPresent(scrm -> scrm.fetch(event.acknowledgementsMap()));
    }

    @Override
    private void process(ShareAcknowledgeSyncEvent event) {
        if (!this.requestManagers.shareConsumeRequestManager.isPresent()) {
            return;
        }
        ShareConsumeRequestManager manager = this.requestManagers.shareConsumeRequestManager.get();
        CompletableFuture<Map<TopicIdPartition, Acknowledgements>> future = manager.commitSync(event.acknowledgementsMap(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(ShareAcknowledgeAsyncEvent event) {
        if (!this.requestManagers.shareConsumeRequestManager.isPresent()) {
            return;
        }
        ShareConsumeRequestManager manager = this.requestManagers.shareConsumeRequestManager.get();
        manager.commitAsync(event.acknowledgementsMap());
    }

    @Override
    private void process(ShareSubscriptionChangeEvent ignored) {
        if (!this.requestManagers.shareHeartbeatRequestManager.isPresent()) {
            this.log.warn("Group membership manager not present when processing a subscribe event");
            return;
        }
        ShareMembershipManager membershipManager = this.requestManagers.shareHeartbeatRequestManager.get().membershipManager();
        membershipManager.onSubscriptionUpdated();
    }

    @Override
    private void process(ShareUnsubscribeEvent event) {
        if (!this.requestManagers.shareHeartbeatRequestManager.isPresent()) {
            KafkaException error = new KafkaException("Group membership manager not present when processing an unsubscribe event");
            event.future().completeExceptionally(error);
            return;
        }
        ShareMembershipManager membershipManager = this.requestManagers.shareHeartbeatRequestManager.get().membershipManager();
        CompletableFuture<Void> future = membershipManager.leaveGroup();
        future.whenComplete(this.complete(event.future()));
    }

    @Override
    private void process(ShareAcknowledgeOnCloseEvent event) {
        if (!this.requestManagers.shareConsumeRequestManager.isPresent()) {
            KafkaException error = new KafkaException("Group membership manager not present when processing an acknowledge-on-close event");
            event.future().completeExceptionally(error);
            return;
        }
        ShareConsumeRequestManager manager = this.requestManagers.shareConsumeRequestManager.get();
        CompletableFuture<Void> future = manager.acknowledgeOnClose(event.acknowledgementsMap(), event.deadlineMs());
        future.whenComplete(this.complete(event.future()));
    }

    private <T> BiConsumer<? super T, ? super Throwable> complete(CompletableFuture<T> b) {
        return (value, exception) -> {
            if (exception != null) {
                b.completeExceptionally((Throwable)exception);
            } else {
                b.complete(value);
            }
        };
    }

    public static Supplier<ApplicationEventProcessor> supplier(final LogContext logContext, final ConsumerMetadata metadata, final SubscriptionState subscriptions, final Supplier<RequestManagers> requestManagersSupplier) {
        return new CachedSupplier<ApplicationEventProcessor>(){

            @Override
            protected ApplicationEventProcessor create() {
                RequestManagers requestManagers = (RequestManagers)requestManagersSupplier.get();
                return new ApplicationEventProcessor(logContext, requestManagers, metadata, subscriptions);
            }
        };
    }
}

