/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.ec;

import de.rub.nds.tlsattacker.attacks.ec.ICEPoint;
import de.rub.nds.tlsattacker.attacks.ec.ICEPointCopmparator;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ICEPointReader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ICEPoint> readPoints(NamedGroup group) {
        EllipticCurve curve = CurveFactory.getCurve(group);
        String namedCurveLow = group.name().toLowerCase();
        String fileName = "points_" + namedCurveLow + ".txt";
        BufferedReader br = new BufferedReader(new InputStreamReader(ICEPointReader.class.getClassLoader().getResourceAsStream(fileName)));
        String[] points = new LinkedList();
        try {
            Object nums;
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                nums = line.split("\\s+,\\s+");
                int n = Integer.parseInt(nums[0]);
                BigInteger x = new BigInteger((String)nums[1], 16);
                BigInteger y = new BigInteger((String)nums[2], 16);
                points.add(new ICEPoint(x, y, curve, n));
            }
            Collections.sort(points, new ICEPointCopmparator());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using the following curves and points");
                for (ICEPoint iCEPoint : points) {
                    LOGGER.debug(iCEPoint.getOrder() + " , " + iCEPoint.getX().getData().toString(16) + " , " + iCEPoint.getY().getData().toString(16));
                }
            }
            nums = points;
            return nums;
        }
        catch (IOException | NumberFormatException ex) {
            throw new ConfigurationException(ex.getLocalizedMessage(), ex);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close stream", (Throwable)ex);
            }
        }
    }

    private ICEPointReader() {
    }
}

