/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.Reader;
import processing.xml.StdXMLReader;

class CDATAReader
extends Reader {
    private StdXMLReader reader;
    private char savedChar;
    private boolean atEndOfData;

    CDATAReader(StdXMLReader stdXMLReader) {
        this.reader = stdXMLReader;
        this.savedChar = '\u0000';
        this.atEndOfData = false;
    }

    protected void finalize() throws Throwable {
        this.reader = null;
        super.finalize();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.atEndOfData) {
            return -1;
        }
        if (n + n2 > cArray.length) {
            n2 = cArray.length - n;
        }
        while (n3 < n2) {
            char c = this.savedChar;
            if (c == '\u0000') {
                c = this.reader.read();
            } else {
                this.savedChar = '\u0000';
            }
            if (c == ']') {
                char c2 = this.reader.read();
                if (c2 == ']') {
                    char c3 = this.reader.read();
                    if (c3 == '>') {
                        this.atEndOfData = true;
                        break;
                    }
                    this.savedChar = c2;
                    this.reader.unread(c3);
                } else {
                    this.reader.unread(c2);
                }
            }
            cArray[n3] = c;
            ++n3;
        }
        if (n3 == 0) {
            n3 = -1;
        }
        return n3;
    }

    public void close() throws IOException {
        while (!this.atEndOfData) {
            char c = this.savedChar;
            if (c == '\u0000') {
                c = this.reader.read();
            } else {
                this.savedChar = '\u0000';
            }
            if (c != ']') continue;
            char c2 = this.reader.read();
            if (c2 == ']') {
                char c3 = this.reader.read();
                if (c3 == '>') break;
                this.savedChar = c2;
                this.reader.unread(c3);
                continue;
            }
            this.reader.unread(c2);
        }
        this.atEndOfData = true;
    }
}

