/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct TrackedDevicePose_t")
public class TrackedDevicePose
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MDEVICETOABSOLUTETRACKING;
    public static final int VVELOCITY;
    public static final int VANGULARVELOCITY;
    public static final int ETRACKINGRESULT;
    public static final int BPOSEISVALID;
    public static final int BDEVICEISCONNECTED;

    public TrackedDevicePose(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), TrackedDevicePose.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdMatrix34_t")
    public HmdMatrix34 mDeviceToAbsoluteTracking() {
        return TrackedDevicePose.nmDeviceToAbsoluteTracking(this.address());
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vVelocity() {
        return TrackedDevicePose.nvVelocity(this.address());
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vAngularVelocity() {
        return TrackedDevicePose.nvAngularVelocity(this.address());
    }

    @NativeType(value="ETrackingResult")
    public int eTrackingResult() {
        return TrackedDevicePose.neTrackingResult(this.address());
    }

    @NativeType(value="bool")
    public boolean bPoseIsValid() {
        return TrackedDevicePose.nbPoseIsValid(this.address());
    }

    @NativeType(value="bool")
    public boolean bDeviceIsConnected() {
        return TrackedDevicePose.nbDeviceIsConnected(this.address());
    }

    public TrackedDevicePose mDeviceToAbsoluteTracking(@NativeType(value="HmdMatrix34_t") HmdMatrix34 value) {
        TrackedDevicePose.nmDeviceToAbsoluteTracking(this.address(), value);
        return this;
    }

    public TrackedDevicePose mDeviceToAbsoluteTracking(Consumer<HmdMatrix34> consumer) {
        consumer.accept(this.mDeviceToAbsoluteTracking());
        return this;
    }

    public TrackedDevicePose vVelocity(@NativeType(value="HmdVector3_t") HmdVector3 value) {
        TrackedDevicePose.nvVelocity(this.address(), value);
        return this;
    }

    public TrackedDevicePose vVelocity(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vVelocity());
        return this;
    }

    public TrackedDevicePose vAngularVelocity(@NativeType(value="HmdVector3_t") HmdVector3 value) {
        TrackedDevicePose.nvAngularVelocity(this.address(), value);
        return this;
    }

    public TrackedDevicePose vAngularVelocity(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vAngularVelocity());
        return this;
    }

    public TrackedDevicePose eTrackingResult(@NativeType(value="ETrackingResult") int value) {
        TrackedDevicePose.neTrackingResult(this.address(), value);
        return this;
    }

    public TrackedDevicePose bPoseIsValid(@NativeType(value="bool") boolean value) {
        TrackedDevicePose.nbPoseIsValid(this.address(), value);
        return this;
    }

    public TrackedDevicePose bDeviceIsConnected(@NativeType(value="bool") boolean value) {
        TrackedDevicePose.nbDeviceIsConnected(this.address(), value);
        return this;
    }

    public TrackedDevicePose set(HmdMatrix34 mDeviceToAbsoluteTracking, HmdVector3 vVelocity, HmdVector3 vAngularVelocity, int eTrackingResult, boolean bPoseIsValid, boolean bDeviceIsConnected) {
        this.mDeviceToAbsoluteTracking(mDeviceToAbsoluteTracking);
        this.vVelocity(vVelocity);
        this.vAngularVelocity(vAngularVelocity);
        this.eTrackingResult(eTrackingResult);
        this.bPoseIsValid(bPoseIsValid);
        this.bDeviceIsConnected(bDeviceIsConnected);
        return this;
    }

    public TrackedDevicePose set(TrackedDevicePose src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static TrackedDevicePose malloc() {
        return (TrackedDevicePose)TrackedDevicePose.wrap(TrackedDevicePose.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static TrackedDevicePose calloc() {
        return (TrackedDevicePose)TrackedDevicePose.wrap(TrackedDevicePose.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static TrackedDevicePose create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (TrackedDevicePose)TrackedDevicePose.wrap(TrackedDevicePose.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static TrackedDevicePose create(long address) {
        return (TrackedDevicePose)TrackedDevicePose.wrap(TrackedDevicePose.class, (long)address);
    }

    @Nullable
    public static TrackedDevicePose createSafe(long address) {
        return address == 0L ? null : (TrackedDevicePose)TrackedDevicePose.wrap(TrackedDevicePose.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)TrackedDevicePose.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)TrackedDevicePose.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)TrackedDevicePose.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = TrackedDevicePose.__create((int)capacity, (int)SIZEOF);
        return (Buffer)TrackedDevicePose.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)TrackedDevicePose.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)TrackedDevicePose.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static TrackedDevicePose mallocStack() {
        return TrackedDevicePose.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static TrackedDevicePose callocStack() {
        return TrackedDevicePose.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static TrackedDevicePose mallocStack(MemoryStack stack) {
        return TrackedDevicePose.malloc(stack);
    }

    @Deprecated
    public static TrackedDevicePose callocStack(MemoryStack stack) {
        return TrackedDevicePose.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return TrackedDevicePose.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return TrackedDevicePose.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return TrackedDevicePose.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return TrackedDevicePose.calloc(capacity, stack);
    }

    public static TrackedDevicePose malloc(MemoryStack stack) {
        return (TrackedDevicePose)TrackedDevicePose.wrap(TrackedDevicePose.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static TrackedDevicePose calloc(MemoryStack stack) {
        return (TrackedDevicePose)TrackedDevicePose.wrap(TrackedDevicePose.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)TrackedDevicePose.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)TrackedDevicePose.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static HmdMatrix34 nmDeviceToAbsoluteTracking(long struct) {
        return HmdMatrix34.create(struct + (long)MDEVICETOABSOLUTETRACKING);
    }

    public static HmdVector3 nvVelocity(long struct) {
        return HmdVector3.create(struct + (long)VVELOCITY);
    }

    public static HmdVector3 nvAngularVelocity(long struct) {
        return HmdVector3.create(struct + (long)VANGULARVELOCITY);
    }

    public static int neTrackingResult(long struct) {
        return UNSAFE.getInt(null, struct + (long)ETRACKINGRESULT);
    }

    public static boolean nbPoseIsValid(long struct) {
        return UNSAFE.getByte(null, struct + (long)BPOSEISVALID) != 0;
    }

    public static boolean nbDeviceIsConnected(long struct) {
        return UNSAFE.getByte(null, struct + (long)BDEVICEISCONNECTED) != 0;
    }

    public static void nmDeviceToAbsoluteTracking(long struct, HmdMatrix34 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MDEVICETOABSOLUTETRACKING), (long)HmdMatrix34.SIZEOF);
    }

    public static void nvVelocity(long struct, HmdVector3 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VVELOCITY), (long)HmdVector3.SIZEOF);
    }

    public static void nvAngularVelocity(long struct, HmdVector3 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VANGULARVELOCITY), (long)HmdVector3.SIZEOF);
    }

    public static void neTrackingResult(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ETRACKINGRESULT, value);
    }

    public static void nbPoseIsValid(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)BPOSEISVALID, value ? (byte)1 : 0);
    }

    public static void nbDeviceIsConnected(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)BDEVICEISCONNECTED, value ? (byte)1 : 0);
    }

    static {
        Struct.Layout layout = TrackedDevicePose.__struct((Struct.Member[])new Struct.Member[]{TrackedDevicePose.__member((int)HmdMatrix34.SIZEOF, (int)HmdMatrix34.ALIGNOF), TrackedDevicePose.__member((int)HmdVector3.SIZEOF, (int)HmdVector3.ALIGNOF), TrackedDevicePose.__member((int)HmdVector3.SIZEOF, (int)HmdVector3.ALIGNOF), TrackedDevicePose.__member((int)4), TrackedDevicePose.__member((int)1), TrackedDevicePose.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MDEVICETOABSOLUTETRACKING = layout.offsetof(0);
        VVELOCITY = layout.offsetof(1);
        VANGULARVELOCITY = layout.offsetof(2);
        ETRACKINGRESULT = layout.offsetof(3);
        BPOSEISVALID = layout.offsetof(4);
        BDEVICEISCONNECTED = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<TrackedDevicePose, Buffer>
    implements NativeResource {
        private static final TrackedDevicePose ELEMENT_FACTORY = TrackedDevicePose.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected TrackedDevicePose getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HmdMatrix34_t")
        public HmdMatrix34 mDeviceToAbsoluteTracking() {
            return TrackedDevicePose.nmDeviceToAbsoluteTracking(this.address());
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vVelocity() {
            return TrackedDevicePose.nvVelocity(this.address());
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vAngularVelocity() {
            return TrackedDevicePose.nvAngularVelocity(this.address());
        }

        @NativeType(value="ETrackingResult")
        public int eTrackingResult() {
            return TrackedDevicePose.neTrackingResult(this.address());
        }

        @NativeType(value="bool")
        public boolean bPoseIsValid() {
            return TrackedDevicePose.nbPoseIsValid(this.address());
        }

        @NativeType(value="bool")
        public boolean bDeviceIsConnected() {
            return TrackedDevicePose.nbDeviceIsConnected(this.address());
        }

        public Buffer mDeviceToAbsoluteTracking(@NativeType(value="HmdMatrix34_t") HmdMatrix34 value) {
            TrackedDevicePose.nmDeviceToAbsoluteTracking(this.address(), value);
            return this;
        }

        public Buffer mDeviceToAbsoluteTracking(Consumer<HmdMatrix34> consumer) {
            consumer.accept(this.mDeviceToAbsoluteTracking());
            return this;
        }

        public Buffer vVelocity(@NativeType(value="HmdVector3_t") HmdVector3 value) {
            TrackedDevicePose.nvVelocity(this.address(), value);
            return this;
        }

        public Buffer vVelocity(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vVelocity());
            return this;
        }

        public Buffer vAngularVelocity(@NativeType(value="HmdVector3_t") HmdVector3 value) {
            TrackedDevicePose.nvAngularVelocity(this.address(), value);
            return this;
        }

        public Buffer vAngularVelocity(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vAngularVelocity());
            return this;
        }

        public Buffer eTrackingResult(@NativeType(value="ETrackingResult") int value) {
            TrackedDevicePose.neTrackingResult(this.address(), value);
            return this;
        }

        public Buffer bPoseIsValid(@NativeType(value="bool") boolean value) {
            TrackedDevicePose.nbPoseIsValid(this.address(), value);
            return this;
        }

        public Buffer bDeviceIsConnected(@NativeType(value="bool") boolean value) {
            TrackedDevicePose.nbDeviceIsConnected(this.address(), value);
            return this;
        }
    }
}

