/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrKeyboardTrackingDescriptionFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRACKEDKEYBOARDID;
    public static final int SIZE;
    public static final int FLAGS;
    public static final int NAME;

    public XrKeyboardTrackingDescriptionFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrKeyboardTrackingDescriptionFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long trackedKeyboardId() {
        return XrKeyboardTrackingDescriptionFB.ntrackedKeyboardId(this.address());
    }

    public XrVector3f size() {
        return XrKeyboardTrackingDescriptionFB.nsize(this.address());
    }

    @NativeType(value="XrKeyboardTrackingFlagsFB")
    public long flags() {
        return XrKeyboardTrackingDescriptionFB.nflags(this.address());
    }

    @NativeType(value="char[XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB]")
    public ByteBuffer name() {
        return XrKeyboardTrackingDescriptionFB.nname(this.address());
    }

    @NativeType(value="char[XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB]")
    public String nameString() {
        return XrKeyboardTrackingDescriptionFB.nnameString(this.address());
    }

    public static XrKeyboardTrackingDescriptionFB malloc() {
        return (XrKeyboardTrackingDescriptionFB)XrKeyboardTrackingDescriptionFB.wrap(XrKeyboardTrackingDescriptionFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrKeyboardTrackingDescriptionFB calloc() {
        return (XrKeyboardTrackingDescriptionFB)XrKeyboardTrackingDescriptionFB.wrap(XrKeyboardTrackingDescriptionFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrKeyboardTrackingDescriptionFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrKeyboardTrackingDescriptionFB)XrKeyboardTrackingDescriptionFB.wrap(XrKeyboardTrackingDescriptionFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrKeyboardTrackingDescriptionFB create(long address) {
        return (XrKeyboardTrackingDescriptionFB)XrKeyboardTrackingDescriptionFB.wrap(XrKeyboardTrackingDescriptionFB.class, (long)address);
    }

    @Nullable
    public static XrKeyboardTrackingDescriptionFB createSafe(long address) {
        return address == 0L ? null : (XrKeyboardTrackingDescriptionFB)XrKeyboardTrackingDescriptionFB.wrap(XrKeyboardTrackingDescriptionFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrKeyboardTrackingDescriptionFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrKeyboardTrackingDescriptionFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrKeyboardTrackingDescriptionFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrKeyboardTrackingDescriptionFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrKeyboardTrackingDescriptionFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrKeyboardTrackingDescriptionFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrKeyboardTrackingDescriptionFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrKeyboardTrackingDescriptionFB malloc(MemoryStack stack) {
        return (XrKeyboardTrackingDescriptionFB)XrKeyboardTrackingDescriptionFB.wrap(XrKeyboardTrackingDescriptionFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrKeyboardTrackingDescriptionFB calloc(MemoryStack stack) {
        return (XrKeyboardTrackingDescriptionFB)XrKeyboardTrackingDescriptionFB.wrap(XrKeyboardTrackingDescriptionFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrKeyboardTrackingDescriptionFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrKeyboardTrackingDescriptionFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ntrackedKeyboardId(long struct) {
        return UNSAFE.getLong(null, struct + (long)TRACKEDKEYBOARDID);
    }

    public static XrVector3f nsize(long struct) {
        return XrVector3f.create(struct + (long)SIZE);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)128);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = XrKeyboardTrackingDescriptionFB.__struct((Struct.Member[])new Struct.Member[]{XrKeyboardTrackingDescriptionFB.__member((int)8), XrKeyboardTrackingDescriptionFB.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF), XrKeyboardTrackingDescriptionFB.__member((int)8), XrKeyboardTrackingDescriptionFB.__array((int)1, (int)128)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRACKEDKEYBOARDID = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        NAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrKeyboardTrackingDescriptionFB, Buffer>
    implements NativeResource {
        private static final XrKeyboardTrackingDescriptionFB ELEMENT_FACTORY = XrKeyboardTrackingDescriptionFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrKeyboardTrackingDescriptionFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint64_t")
        public long trackedKeyboardId() {
            return XrKeyboardTrackingDescriptionFB.ntrackedKeyboardId(this.address());
        }

        public XrVector3f size() {
            return XrKeyboardTrackingDescriptionFB.nsize(this.address());
        }

        @NativeType(value="XrKeyboardTrackingFlagsFB")
        public long flags() {
            return XrKeyboardTrackingDescriptionFB.nflags(this.address());
        }

        @NativeType(value="char[XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB]")
        public ByteBuffer name() {
            return XrKeyboardTrackingDescriptionFB.nname(this.address());
        }

        @NativeType(value="char[XR_MAX_KEYBOARD_TRACKING_NAME_SIZE_FB]")
        public String nameString() {
            return XrKeyboardTrackingDescriptionFB.nnameString(this.address());
        }
    }
}

