/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.z.IntHashSet;

public final class AnyType
implements ComplexType {
    private static AnyType theInstance = new AnyType();

    private AnyType() {
    }

    public static AnyType getInstance() {
        return theInstance;
    }

    public String getName() {
        return "anyType";
    }

    public String getEQName() {
        return "Q{http://www.w3.org/2001/XMLSchema}anyType";
    }

    public String getTargetNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    public int getVariety() {
        return 3;
    }

    public int getValidationStatus() {
        return 3;
    }

    public int getRedefinitionLevel() {
        return 0;
    }

    public SchemaType getBaseType() {
        return null;
    }

    public SchemaType getKnownBaseType() throws IllegalStateException {
        return null;
    }

    public int getDerivationMethod() {
        return 0;
    }

    public boolean allowsDerivation(int derivation) {
        return true;
    }

    public int getFinalProhibitions() {
        return 0;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isComplexType() {
        return true;
    }

    public boolean isAnonymousType() {
        return false;
    }

    public boolean isSimpleType() {
        return false;
    }

    public boolean isAtomicType() {
        return false;
    }

    public boolean isIdType() {
        return false;
    }

    public boolean isIdRefType() {
        return false;
    }

    public int getBlock() {
        return 0;
    }

    public boolean isComplexContent() {
        return true;
    }

    public boolean isSimpleContent() {
        return false;
    }

    public boolean isAllContent() {
        return false;
    }

    public SimpleType getSimpleContentType() {
        return null;
    }

    public boolean isRestricted() {
        return false;
    }

    public boolean isEmptyContent() {
        return false;
    }

    public boolean isEmptiable() {
        return true;
    }

    public boolean isMixedContent() {
        return true;
    }

    public int getFingerprint() {
        return 572;
    }

    public int getNameCode() {
        return 572;
    }

    public String getDescription() {
        return "xs:anyType";
    }

    public String getDisplayName() {
        return "xs:anyType";
    }

    public String getSystemId() {
        return null;
    }

    public boolean isSameType(SchemaType other) {
        return other instanceof AnyType;
    }

    public void analyzeContentExpression(Expression expression, int kind, StaticContext env) {
    }

    public AtomicSequence atomize(NodeInfo node) {
        return new UntypedAtomicValue(node.getStringValue());
    }

    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
        if (!(type instanceof AnyType)) {
            throw new SchemaException("Cannot derive xs:anyType from another type");
        }
    }

    public SchemaType getElementParticleType(int fingerprint, boolean considerExtensions) {
        return this;
    }

    public int getElementParticleCardinality(int fingerprint, boolean considerExtensions) {
        return 57344;
    }

    public SimpleType getAttributeUseType(int fingerprint) {
        return AnySimpleType.getInstance();
    }

    public int getAttributeUseCardinality(int fingerprint) throws SchemaException {
        return 24576;
    }

    public boolean allowsAttributes() {
        return true;
    }

    public void gatherAllPermittedChildren(IntHashSet children, boolean ignoreWildcards) throws SchemaException {
        children.add(-1);
    }

    public void gatherAllPermittedDescendants(IntHashSet descendants) throws SchemaException {
        descendants.add(-1);
    }

    public SchemaType getDescendantElementType(int fingerprint) throws SchemaException {
        return this;
    }

    public int getDescendantElementCardinality(int fingerprint) throws SchemaException {
        return 57344;
    }

    public boolean containsElementWildcard() {
        return true;
    }

    public boolean hasAssertions() {
        return false;
    }
}

