/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyDefinitionSet {
    StructuredQName keyName;
    int keySetNumber;
    List<KeyDefinition> keyDefinitions;
    String collationName;
    boolean backwardsCompatible;
    boolean rangeKey;
    boolean reusable = true;

    public KeyDefinitionSet(StructuredQName keyName, int keySetNumber) {
        this.keyName = keyName;
        this.keySetNumber = keySetNumber;
        this.keyDefinitions = new ArrayList<KeyDefinition>(3);
    }

    public void addKeyDefinition(KeyDefinition keyDef) throws XPathException {
        if (this.keyDefinitions.isEmpty()) {
            this.collationName = keyDef.getCollationName();
        } else {
            if (this.collationName == null && keyDef.getCollationName() != null || this.collationName != null && !this.collationName.equals(keyDef.getCollationName())) {
                XPathException err = new XPathException("All keys with the same name must use the same collation");
                err.setErrorCode("XTSE1220");
                throw err;
            }
            List<KeyDefinition> v = this.getKeyDefinitions();
            for (KeyDefinition other : v) {
                if (!keyDef.getMatch().equals(other.getMatch()) || !keyDef.getBody().equals(other.getBody())) continue;
                return;
            }
        }
        if (keyDef.isBackwardsCompatible()) {
            this.backwardsCompatible = true;
        }
        if (keyDef.isRangeKey()) {
            this.rangeKey = true;
        }
        this.keyDefinitions.add(keyDef);
    }

    public StructuredQName getKeyName() {
        return this.keyName;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public int getKeySetNumber() {
        return this.keySetNumber;
    }

    public List<KeyDefinition> getKeyDefinitions() {
        return this.keyDefinitions;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public boolean isRangeKey() {
        return this.rangeKey;
    }

    public void setReusable(boolean reusable) {
        this.reusable = reusable;
    }

    public boolean isReusable() {
        return this.reusable;
    }
}

