/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.cli;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.sonatype.maven.polyglot.TeslaModelTranslator;

public class TeslaTranslatorCli {
    private final DefaultPlexusContainer container;
    private final TeslaModelTranslator translator;

    public TeslaTranslatorCli(ClassWorld classWorld) throws Exception {
        if (classWorld == null) {
            classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(classWorld).setName("translator");
        this.container = new DefaultPlexusContainer(cc);
        this.translator = (TeslaModelTranslator)this.container.lookup(TeslaModelTranslator.class);
    }

    public TeslaTranslatorCli() throws Exception {
        this(null);
    }

    public int run(String[] args) throws Exception {
        if (args == null || args.length != 2) {
            System.out.println("usage: translate <input-file> <output-file>");
            return -1;
        }
        File input = new File(args[0]).getCanonicalFile();
        File output = new File(args[1]).getCanonicalFile();
        System.out.println("Translating " + input + " -> " + output);
        this.translate(input, output);
        return 0;
    }

    public void translate(File input, File output) throws IOException {
        assert (input != null);
        assert (output != null);
        this.translate(input.toURI().toURL(), output.toURI().toURL());
    }

    public void translate(URL input, URL output) throws IOException {
        assert (input != null);
        assert (output != null);
        this.translator.translate(input, output);
    }

    public static void main(String[] args) throws Exception {
        int result = TeslaTranslatorCli.main(args, null);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) throws Exception {
        assert (classWorld != null);
        return new TeslaTranslatorCli(classWorld).run(args);
    }
}

