/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.TreeMap;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.StyledDescriber;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public class NoMatchingConfigurationSelectionException
extends StyledException {
    public NoMatchingConfigurationSelectionException(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, GraphSelectionCandidates candidates) {
        super(NoMatchingConfigurationSelectionException.generateMessage(new StyledDescriber(describer), fromConfigurationAttributes, attributeMatcher, targetComponent, candidates));
    }

    private static String generateMessage(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, GraphSelectionCandidates candidates) {
        boolean variantAware = candidates.isUseVariants();
        TreeMap<String, VariantGraphResolveMetadata> variants = new TreeMap<String, VariantGraphResolveMetadata>();
        if (variantAware) {
            for (VariantGraphResolveState variantGraphResolveState : candidates.getVariants()) {
                variants.put(variantGraphResolveState.getName(), variantGraphResolveState.getMetadata());
            }
        } else {
            for (ConfigurationGraphResolveMetadata configurationGraphResolveMetadata : candidates.getCandidateConfigurations()) {
                variants.put(configurationGraphResolveMetadata.getName(), configurationGraphResolveMetadata);
            }
        }
        TreeFormatter formatter = new TreeFormatter();
        String string = NoMatchingConfigurationSelectionException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName());
        if (fromConfigurationAttributes.isEmpty()) {
            formatter.node("Unable to find a matching " + (variantAware ? "variant" : "configuration") + " of " + string);
        } else {
            formatter.node("No matching " + (variantAware ? "variant" : "configuration") + " of " + string + " was found. The consumer was configured to find " + describer.describeAttributeSet(fromConfigurationAttributes.asMap()) + " but:");
        }
        formatter.startChildren();
        if (variants.isEmpty()) {
            formatter.node("None of the " + (variantAware ? "variants" : "consumable configurations") + " have attributes.");
        } else {
            for (VariantGraphResolveMetadata variant : variants.values()) {
                AmbiguousConfigurationSelectionException.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, variant, variantAware, false, describer);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

