/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.util.regex.Pattern;

public interface JvmVendor {
    public String getRawVendor();

    public KnownJvmVendor getKnownVendor();

    public String getDisplayName();

    public static JvmVendor fromString(final String vendor) {
        return new JvmVendor(){

            @Override
            public String getRawVendor() {
                return vendor;
            }

            @Override
            public KnownJvmVendor getKnownVendor() {
                return KnownJvmVendor.parse(vendor);
            }

            @Override
            public String getDisplayName() {
                KnownJvmVendor knownVendor = this.getKnownVendor();
                if (knownVendor != KnownJvmVendor.UNKNOWN) {
                    return knownVendor.getDisplayName();
                }
                return this.getRawVendor();
            }
        };
    }

    public static enum KnownJvmVendor {
        ADOPTIUM("adoptium", "temurin|adoptium|eclipse foundation", "Eclipse Temurin"),
        ADOPTOPENJDK("adoptopenjdk", "AdoptOpenJDK"),
        AMAZON("amazon", "Amazon Corretto"),
        APPLE("apple", "Apple"),
        AZUL("azul systems", "Azul Zulu"),
        BELLSOFT("bellsoft", "BellSoft Liberica"),
        GRAAL_VM("graalvm community", "GraalVM Community"),
        HEWLETT_PACKARD("hewlett-packard", "HP-UX"),
        IBM("ibm", "ibm|international business machines corporation", "IBM"),
        MICROSOFT("microsoft", "Microsoft"),
        ORACLE("oracle", "Oracle"),
        SAP("sap se", "SAP SapMachine"),
        UNKNOWN("gradle", "Unknown Vendor");

        private final String indicatorString;
        private final Pattern indicatorPattern;
        private final String displayName;

        private KnownJvmVendor(String indicatorString, String displayName) {
            this.indicatorString = indicatorString;
            this.indicatorPattern = Pattern.compile(indicatorString, 2);
            this.displayName = displayName;
        }

        private KnownJvmVendor(String indicatorString, String pattern, String displayName) {
            this.indicatorString = indicatorString;
            this.indicatorPattern = Pattern.compile(pattern, 2);
            this.displayName = displayName;
        }

        private String getDisplayName() {
            return this.displayName;
        }

        static KnownJvmVendor parse(String rawVendor) {
            if (rawVendor == null) {
                return UNKNOWN;
            }
            for (KnownJvmVendor jvmVendor : KnownJvmVendor.values()) {
                if (jvmVendor.indicatorString.equals(rawVendor)) {
                    return jvmVendor;
                }
                if (!jvmVendor.indicatorPattern.matcher(rawVendor).find()) continue;
                return jvmVendor;
            }
            return UNKNOWN;
        }

        public JvmVendor asJvmVendor() {
            return JvmVendor.fromString(this.indicatorString);
        }
    }
}

