/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class SetBuildQueueMessage
extends AttributeMessage {
    public static final String TAG = "setBuildQueue";
    private static final String COLONY_TAG = "colony";

    public SetBuildQueueMessage(Colony colony, List<BuildableType> queue) {
        super(TAG, COLONY_TAG, colony.getId());
        this.setArrayAttributes(CollectionUtils.transform(queue, CollectionUtils.alwaysTrue(), FreeColObject::getId));
    }

    public SetBuildQueueMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, SetBuildQueueMessage.getAttributeMap(xr));
        xr.closeTag(TAG);
    }

    private static Map<String, String> getAttributeMap(FreeColXMLReader xr) {
        Map<String, String> ret = xr.getArrayAttributeMap();
        ret.put(COLONY_TAG, xr.getAttribute(COLONY_TAG, null));
        return ret;
    }

    private Colony getColony(Player player) {
        return player.getOurFreeColGameObject(this.getStringAttribute(COLONY_TAG), Colony.class);
    }

    private List<BuildableType> getQueue(Specification spec) {
        return CollectionUtils.transform(this.getArrayAttributes(), CollectionUtils.alwaysTrue(), id -> spec.getBuildableType((String)id), CollectionUtils.toListNoNulls());
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        List<BuildableType> buildQueue;
        Colony colony;
        ServerGame game = freeColServer.getGame();
        Specification spec = game.getSpecification();
        try {
            colony = this.getColony(serverPlayer);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            buildQueue = this.getQueue(spec);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        return this.igc(freeColServer).setBuildQueue(serverPlayer, colony, buildQueue);
    }
}

