/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.io.Reader;
import java.io.StringReader;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.DBCacheEntry;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.ConnectionPoolUtil;
import org.pentaho.di.core.database.DataSourceProviderFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.Messages;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.database.map.DatabaseConnectionMap;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseBatchException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements VariableSpace {
    public static final String LOG_STATUS_START = "start";
    public static final String LOG_STATUS_END = "end";
    public static final String LOG_STATUS_STOP = "stop";
    private DatabaseMeta databaseMeta;
    private int rowlimit;
    private int commitsize;
    private Connection connection;
    private Statement sel_stmt;
    private PreparedStatement pstmt;
    private PreparedStatement prepStatementLookup;
    private PreparedStatement prepStatementUpdate;
    private PreparedStatement prepStatementInsert;
    private PreparedStatement pstmt_seq;
    private CallableStatement cstmt;
    private DatabaseMetaData dbmd;
    private RowMetaInterface rowMeta;
    private int written;
    private LogWriter log;
    private int opened;
    private int copy;
    private String connectionGroup;
    private String partitionId;
    private VariableSpace variables = new Variables();

    public Database(DatabaseMeta inf) {
        this.log = LogWriter.getInstance();
        this.databaseMeta = inf;
        this.shareVariablesWith(inf);
        this.pstmt = null;
        this.rowMeta = null;
        this.dbmd = null;
        this.rowlimit = 0;
        this.written = 0;
        if (this.log.isDetailed()) {
            this.log.logDetailed(this.toString(), "New database connection defined", new Object[0]);
        }
    }

    public boolean equals(Object obj) {
        Database other = (Database)obj;
        return other.databaseMeta.equals(other.databaseMeta);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setQueryLimit(int rows) {
        this.rowlimit = rows;
    }

    public PreparedStatement getPrepStatementInsert() {
        return this.prepStatementInsert;
    }

    public PreparedStatement getPrepStatementLookup() {
        return this.prepStatementLookup;
    }

    public PreparedStatement getPrepStatementUpdate() {
        return this.prepStatementUpdate;
    }

    public void connect() throws KettleDatabaseException {
        this.connect(null);
    }

    public void connect(String partitionId) throws KettleDatabaseException {
        this.connect(null, partitionId);
    }

    public synchronized void connect(String group, String partitionId) throws KettleDatabaseException {
        if (!Const.isEmpty((String)group)) {
            this.connectionGroup = group;
            this.partitionId = partitionId;
            DatabaseConnectionMap map = DatabaseConnectionMap.getInstance();
            Database lookup = map.getDatabase(group, partitionId, this);
            if (lookup == null) {
                this.normalConnect(partitionId);
                ++this.opened;
                this.copy = this.opened;
                map.storeDatabase(group, partitionId, this);
            } else {
                this.connection = lookup.getConnection();
                lookup.setOpened(lookup.getOpened() + 1);
                this.copy = lookup.getOpened();
            }
        } else {
            this.normalConnect(partitionId);
        }
    }

    public void normalConnect(String partitionId) throws KettleDatabaseException {
        block9: {
            if (this.databaseMeta == null) {
                throw new KettleDatabaseException("No valid database connection defined!");
            }
            try {
                String sql;
                if (this.databaseMeta.isUsingConnectionPool() && this.databaseMeta.getAccessType() != 4) {
                    try {
                        this.connection = ConnectionPoolUtil.getConnection(this.databaseMeta, partitionId);
                        break block9;
                    }
                    catch (Exception e) {
                        throw new KettleDatabaseException("Error occured while trying to connect to the database", (Throwable)e);
                    }
                }
                this.connectUsingClass(this.databaseMeta.getDriverClass(), partitionId);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "Connected to database.", new Object[0]);
                }
                if (!Const.isEmpty((String)(sql = this.environmentSubstitute(this.databaseMeta.getConnectSQL()))) && !Const.onlySpaces((String)sql)) {
                    this.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), "Executed connect time SQL statements:" + Const.CR + sql, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Error occured while trying to connect to the database", (Throwable)e);
            }
        }
    }

    private void initWithNamedDataSource(String dataSourceName) throws KettleDatabaseException {
        this.connection = null;
        DataSource dataSource = DataSourceProviderFactory.getDataSourceProviderInterface().getNamedDataSource(dataSourceName);
        if (dataSource != null) {
            try {
                this.connection = dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Invalid JNDI connection " + dataSourceName + " : " + e.getMessage());
            }
            if (this.connection == null) {
                throw new KettleDatabaseException("Invalid JNDI connection " + dataSourceName);
            }
        } else {
            throw new KettleDatabaseException("Invalid JNDI connection " + dataSourceName);
        }
    }

    private void connectUsingClass(String classname, String partitionId) throws KettleDatabaseException {
        if (this.databaseMeta.getAccessType() == 4) {
            this.initWithNamedDataSource(this.environmentSubstitute(this.databaseMeta.getDatabaseName()));
            return;
        }
        try {
            Class.forName(classname);
        }
        catch (NoClassDefFoundError e) {
            throw new KettleDatabaseException("Exception while loading class", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new KettleDatabaseException("Exception while loading class", (Throwable)e);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Exception while loading class", (Throwable)e);
        }
        try {
            String password;
            String username;
            PartitionDatabaseMeta partition;
            String url = this.databaseMeta.isPartitioned() && !Const.isEmpty((String)partitionId) ? this.environmentSubstitute(this.databaseMeta.getURL(partitionId)) : this.environmentSubstitute(this.databaseMeta.getURL());
            String clusterUsername = null;
            String clusterPassword = null;
            if (this.databaseMeta.isPartitioned() && !Const.isEmpty((String)partitionId) && (partition = this.databaseMeta.getPartitionMeta(partitionId)) != null) {
                clusterUsername = partition.getUsername();
                clusterPassword = Encr.decryptPasswordOptionallyEncrypted((String)partition.getPassword());
            }
            if (!Const.isEmpty(clusterUsername)) {
                username = clusterUsername;
                password = clusterPassword;
            } else {
                username = this.environmentSubstitute(this.databaseMeta.getUsername());
                password = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.databaseMeta.getPassword()));
            }
            if (this.databaseMeta.supportsOptionsInURL()) {
                this.connection = !Const.isEmpty((String)username) || !Const.isEmpty((String)password) ? DriverManager.getConnection(url, Const.NVL((String)username, (String)" "), Const.NVL((String)password, (String)"")) : DriverManager.getConnection(url);
            } else {
                Properties properties = this.databaseMeta.getConnectionProperties();
                if (!Const.isEmpty((String)username)) {
                    properties.put("user", username);
                }
                if (!Const.isEmpty((String)password)) {
                    properties.put("password", password);
                }
                this.connection = DriverManager.getConnection(url, properties);
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error connecting to database: (using class " + classname + ")", (Throwable)e);
        }
        catch (Throwable e) {
            throw new KettleDatabaseException("Error connecting to database: (using class " + classname + ")", e);
        }
    }

    public synchronized void disconnect() {
        try {
            if (this.connection == null) {
                return;
            }
            if (this.connection.isClosed()) {
                return;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.prepStatementLookup != null) {
                this.prepStatementLookup.close();
                this.prepStatementLookup = null;
            }
            if (this.prepStatementInsert != null) {
                this.prepStatementInsert.close();
                this.prepStatementInsert = null;
            }
            if (this.prepStatementUpdate != null) {
                this.prepStatementUpdate.close();
                this.prepStatementUpdate = null;
            }
            if (this.pstmt_seq != null) {
                this.pstmt_seq.close();
                this.pstmt_seq = null;
            }
            if (!Const.isEmpty((String)this.connectionGroup)) {
                return;
            }
            if (!this.isAutoCommit()) {
                this.commit();
            }
            this.closeConnectionOnly();
        }
        catch (SQLException ex) {
            this.log.logError(this.toString(), "Error disconnecting from database:" + Const.CR + ex.getMessage(), new Object[0]);
            this.log.logError(this.toString(), Const.getStackTracker((Throwable)ex), new Object[0]);
        }
        catch (KettleDatabaseException dbe) {
            this.log.logError(this.toString(), "Error disconnecting from database:" + Const.CR + dbe.getMessage(), new Object[0]);
            this.log.logError(this.toString(), Const.getStackTracker((Throwable)dbe), new Object[0]);
        }
    }

    public synchronized void closeConnectionOnly() throws KettleDatabaseException {
        try {
            if (this.connection != null) {
                this.connection.close();
                if (!this.databaseMeta.isUsingConnectionPool()) {
                    this.connection = null;
                }
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Connection to database closed!", new Object[0]);
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error disconnecting from database '" + this.toString() + "'", (Throwable)e);
        }
    }

    public void cancelQuery() throws KettleDatabaseException {
        this.cancelStatement(this.pstmt);
        this.cancelStatement(this.sel_stmt);
    }

    public void cancelStatement(Statement statement) throws KettleDatabaseException {
        try {
            if (statement != null) {
                statement.cancel();
            }
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), "Statement canceled!", new Object[0]);
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error cancelling statement", (Throwable)ex);
        }
    }

    public void setCommit(int commsize) {
        this.commitsize = commsize;
        String onOff = this.commitsize <= 0 ? "on" : "off";
        try {
            this.connection.setAutoCommit(this.commitsize <= 0);
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Auto commit " + onOff, new Object[0]);
            }
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "Can't turn auto commit " + onOff, new Object[0]);
        }
    }

    public void setAutoCommit(boolean useAutoCommit) throws KettleDatabaseException {
        try {
            this.connection.setAutoCommit(useAutoCommit);
        }
        catch (SQLException e) {
            if (useAutoCommit) {
                throw new KettleDatabaseException(Messages.getString("Database.Exception.UnableToEnableAutoCommit", this.toString()));
            }
            throw new KettleDatabaseException(Messages.getString("Database.Exception.UnableToDisableAutoCommit", this.toString()));
        }
    }

    public void commit() throws KettleDatabaseException {
        this.commit(false);
    }

    public void commit(boolean force) throws KettleDatabaseException {
        block7: {
            try {
                if (!Const.isEmpty((String)this.connectionGroup) && !force) {
                    return;
                }
                if (this.getDatabaseMetaData().supportsTransactions()) {
                    if (this.log.isDebug()) {
                        this.log.logDebug(this.toString(), "Commit on database connection [" + this.toString() + "]", new Object[0]);
                    }
                    this.connection.commit();
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), "No commit possible on database connection [" + this.toString() + "]", new Object[0]);
                }
            }
            catch (Exception e) {
                if (!this.databaseMeta.supportsEmptyTransactions()) break block7;
                throw new KettleDatabaseException("Error comitting connection", (Throwable)e);
            }
        }
    }

    public void rollback() throws KettleDatabaseException {
        this.rollback(false);
    }

    public void rollback(boolean force) throws KettleDatabaseException {
        try {
            if (!Const.isEmpty((String)this.connectionGroup) && !force) {
                return;
            }
            if (this.getDatabaseMetaData().supportsTransactions()) {
                if (this.connection != null) {
                    if (this.log.isDebug()) {
                        this.log.logDebug(this.toString(), "Rollback on database connection [" + this.toString() + "]", new Object[0]);
                    }
                    this.connection.rollback();
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "No rollback possible on database connection [" + this.toString() + "]", new Object[0]);
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error performing rollback on connection", (Throwable)e);
        }
    }

    public void prepareInsert(RowMetaInterface rowMeta, String tableName) throws KettleDatabaseException {
        this.prepareInsert(rowMeta, null, tableName);
    }

    public void prepareInsert(RowMetaInterface rowMeta, String schemaName, String tableName) throws KettleDatabaseException {
        if (rowMeta.size() == 0) {
            throw new KettleDatabaseException("No fields in row, can't insert!");
        }
        String ins = this.getInsertStatement(schemaName, tableName, rowMeta);
        if (this.log.isDetailed()) {
            this.log.logDetailed(this.toString(), "Preparing statement: " + Const.CR + ins, new Object[0]);
        }
        this.prepStatementInsert = this.prepareSQL(ins);
    }

    public PreparedStatement prepareSQL(String sql) throws KettleDatabaseException {
        return this.prepareSQL(sql, false);
    }

    public PreparedStatement prepareSQL(String sql, boolean returnKeys) throws KettleDatabaseException {
        try {
            if (returnKeys) {
                return this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1);
            }
            return this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't prepare statement:" + Const.CR + sql, (Throwable)ex);
        }
    }

    public void closeLookup() throws KettleDatabaseException {
        this.closePreparedStatement(this.pstmt);
        this.pstmt = null;
    }

    public void closePreparedStatement(PreparedStatement ps) throws KettleDatabaseException {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing prepared statement", (Throwable)e);
            }
        }
    }

    public void closeInsert() throws KettleDatabaseException {
        if (this.prepStatementInsert != null) {
            try {
                this.prepStatementInsert.close();
                this.prepStatementInsert = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing insert prepared statement.", (Throwable)e);
            }
        }
    }

    public void closeUpdate() throws KettleDatabaseException {
        if (this.prepStatementUpdate != null) {
            try {
                this.prepStatementUpdate.close();
                this.prepStatementUpdate = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing update prepared statement.", (Throwable)e);
            }
        }
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.pstmt);
    }

    public void setValues(RowMetaAndData row) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData());
    }

    public void setValuesInsert(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementInsert);
    }

    public void setValuesInsert(RowMetaAndData row) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData(), this.prepStatementInsert);
    }

    public void setValuesUpdate(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementUpdate);
    }

    public void setValuesLookup(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementLookup);
    }

    public void setProcValues(RowMetaInterface rowMeta, Object[] data, int[] argnrs, String[] argdir, boolean result) throws KettleDatabaseException {
        int pos = result ? 2 : 1;
        for (int i = 0; i < argnrs.length; ++i) {
            if (argdir[i].equalsIgnoreCase("IN") || argdir[i].equalsIgnoreCase("INOUT")) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(argnrs[i]);
                Object value = data[argnrs[i]];
                this.setValue(this.cstmt, valueMeta, value, pos);
                ++pos;
                continue;
            }
            ++pos;
        }
    }

    public void setValue(PreparedStatement ps, ValueMetaInterface v, Object object, int pos) throws KettleDatabaseException {
        String debug = "";
        try {
            switch (v.getType()) {
                case 1: {
                    if (!v.isNull(object)) {
                        debug = "Number, not null, getting number from value";
                        double num = v.getNumber(object);
                        if (this.databaseMeta.supportsFloatRoundingOnUpdate() && v.getPrecision() >= 0) {
                            debug = "Number, rounding to precision [" + v.getPrecision() + "]";
                            num = Const.round((double)num, (int)v.getPrecision());
                        }
                        debug = "Number, setting [" + num + "] on position #" + pos + " of the prepared statement";
                        ps.setDouble(pos, num);
                        break;
                    }
                    ps.setNull(pos, 8);
                    break;
                }
                case 5: {
                    debug = "Integer";
                    if (!v.isNull(object)) {
                        if (this.databaseMeta.supportsSetLong()) {
                            ps.setLong(pos, v.getInteger(object));
                            break;
                        }
                        double d = v.getNumber(object);
                        if (this.databaseMeta.supportsFloatRoundingOnUpdate() && v.getPrecision() >= 0) {
                            ps.setDouble(pos, d);
                            break;
                        }
                        ps.setDouble(pos, Const.round((double)d, (int)v.getPrecision()));
                        break;
                    }
                    ps.setNull(pos, 4);
                    break;
                }
                case 2: {
                    debug = "String";
                    if (v.getLength() < 9999999) {
                        if (!v.isNull(object)) {
                            ps.setString(pos, v.getString(object));
                            break;
                        }
                        ps.setNull(pos, 12);
                        break;
                    }
                    if (!v.isNull(object)) {
                        String string = v.getString(object);
                        int maxlen = this.databaseMeta.getMaxTextFieldLength();
                        int len = string.length();
                        int begin = len - maxlen;
                        if (begin < 0) {
                            begin = 0;
                        }
                        String logging = string.substring(begin);
                        if (this.databaseMeta.supportsSetCharacterStream()) {
                            StringReader sr = new StringReader(logging);
                            ps.setCharacterStream(pos, (Reader)sr, logging.length());
                            break;
                        }
                        ps.setString(pos, logging);
                        break;
                    }
                    ps.setNull(pos, 12);
                    break;
                }
                case 3: {
                    debug = "Date";
                    if (!v.isNull(object)) {
                        long dat = v.getInteger(object);
                        if (v.getPrecision() == 1 || !this.databaseMeta.supportsTimeStampToDateConversion()) {
                            Date ddate = new Date(dat);
                            ps.setDate(pos, ddate);
                            break;
                        }
                        Timestamp sdate = new Timestamp(dat);
                        ps.setTimestamp(pos, sdate);
                        break;
                    }
                    if (v.getPrecision() == 1 || !this.databaseMeta.supportsTimeStampToDateConversion()) {
                        ps.setNull(pos, 91);
                        break;
                    }
                    ps.setNull(pos, 93);
                    break;
                }
                case 4: {
                    debug = "Boolean";
                    if (this.databaseMeta.supportsBooleanDataType()) {
                        if (!v.isNull(object)) {
                            ps.setBoolean(pos, v.getBoolean(object));
                            break;
                        }
                        ps.setNull(pos, 16);
                        break;
                    }
                    if (!v.isNull(object)) {
                        ps.setString(pos, v.getBoolean(object) != false ? "Y" : "N");
                        break;
                    }
                    ps.setNull(pos, 1);
                    break;
                }
                case 6: {
                    debug = "BigNumber";
                    if (!v.isNull(object)) {
                        ps.setBigDecimal(pos, v.getBigNumber(object));
                        break;
                    }
                    ps.setNull(pos, 3);
                    break;
                }
                case 8: {
                    debug = "Binary";
                    if (!v.isNull(object)) {
                        ps.setBytes(pos, v.getBinary(object));
                        break;
                    }
                    ps.setNull(pos, -2);
                    break;
                }
                default: {
                    debug = "default";
                    ps.setNull(pos, 12);
                }
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error setting value #" + pos + " [" + v.toString() + "] on prepared statement (" + debug + ")" + Const.CR + ex.toString(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Error setting value #" + pos + " [" + (v == null ? "NULL" : v.toString()) + "] on prepared statement (" + debug + ")" + Const.CR + e.toString(), (Throwable)e);
        }
    }

    public void setValues(RowMetaAndData row, PreparedStatement ps) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData(), ps);
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data, PreparedStatement ps) throws KettleDatabaseException {
        for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface v = rowMeta.getValueMeta(i);
            Object object = data[i];
            try {
                this.setValue(ps, v, object, i + 1);
                continue;
            }
            catch (KettleDatabaseException e) {
                throw new KettleDatabaseException("offending row : " + rowMeta, (Throwable)e);
            }
        }
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data, PreparedStatement ps, int ignoreThisValueIndex) throws KettleDatabaseException {
        int index = 0;
        for (int i = 0; i < rowMeta.size(); ++i) {
            if (i == ignoreThisValueIndex) continue;
            ValueMetaInterface v = rowMeta.getValueMeta(i);
            Object object = data[i];
            try {
                this.setValue(ps, v, object, index + 1);
                ++index;
                continue;
            }
            catch (KettleDatabaseException e) {
                throw new KettleDatabaseException("offending row : " + rowMeta, (Throwable)e);
            }
        }
    }

    public RowMetaAndData getGeneratedKeys(PreparedStatement ps) throws KettleDatabaseException {
        ResultSet keys = null;
        try {
            keys = ps.getGeneratedKeys();
            ResultSetMetaData resultSetMetaData = keys.getMetaData();
            RowMetaInterface rowMeta = this.getRowInfo(resultSetMetaData, false, false);
            RowMetaAndData rowMetaAndData = new RowMetaAndData(rowMeta, this.getRow(keys, resultSetMetaData, rowMeta));
            return rowMetaAndData;
        }
        catch (Exception ex) {
            throw new KettleDatabaseException("Unable to retrieve key(s) from auto-increment field(s)", (Throwable)ex);
        }
        finally {
            if (keys != null) {
                try {
                    keys.close();
                }
                catch (SQLException e) {
                    throw new KettleDatabaseException("Unable to close resultset of auto-generated keys", (Throwable)e);
                }
            }
        }
    }

    public Long getNextSequenceValue(String sequenceName, String keyfield) throws KettleDatabaseException {
        return this.getNextSequenceValue(null, sequenceName, keyfield);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextSequenceValue(String schemaName, String sequenceName, String keyfield) throws KettleDatabaseException {
        Long retval = null;
        String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
        try {
            if (this.pstmt_seq == null) {
                this.pstmt_seq = this.connection.prepareStatement(this.databaseMeta.getSeqNextvalSQL(this.databaseMeta.stripCR(schemaSequence)));
            }
            ResultSet rs = null;
            try {
                rs = this.pstmt_seq.executeQuery();
                if (rs.next()) {
                    retval = rs.getLong(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to get next value for sequence : " + schemaSequence, (Throwable)ex);
        }
        return retval;
    }

    public void insertRow(String tableName, RowMetaInterface fields, Object[] data) throws KettleDatabaseException {
        this.prepareInsert(fields, tableName);
        this.setValuesInsert(fields, data);
        this.insertRow();
        this.closeInsert();
    }

    public String getInsertStatement(String tableName, RowMetaInterface fields) {
        return this.getInsertStatement(null, tableName, fields);
    }

    public String getInsertStatement(String schemaName, String tableName, RowMetaInterface fields) {
        int i;
        StringBuffer ins = new StringBuffer(128);
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        ins.append("INSERT INTO ").append(schemaTable).append(" (");
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins.append(", ");
            }
            String name = fields.getValueMeta(i).getName();
            ins.append(this.databaseMeta.quoteField(name));
        }
        ins.append(") VALUES (");
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins.append(", ");
            }
            ins.append(" ?");
        }
        ins.append(')');
        return ins.toString();
    }

    public void insertRow() throws KettleDatabaseException {
        this.insertRow(this.prepStatementInsert);
    }

    public void insertRow(boolean batch) throws KettleDatabaseException {
        this.insertRow(this.prepStatementInsert, batch);
    }

    public void updateRow() throws KettleDatabaseException {
        this.insertRow(this.prepStatementUpdate);
    }

    public void insertRow(PreparedStatement ps) throws KettleDatabaseException {
        this.insertRow(ps, false);
    }

    public boolean insertRow(PreparedStatement ps, boolean batch) throws KettleDatabaseException {
        return this.insertRow(ps, false, true);
    }

    public boolean insertRow(PreparedStatement ps, boolean batch, boolean handleCommit) throws KettleDatabaseException {
        String debug = "insertRow start";
        boolean rowsAreSafe = false;
        try {
            boolean useBatchInsert;
            boolean bl = useBatchInsert = batch && this.getDatabaseMetaData().supportsBatchUpdates() && this.databaseMeta.supportsBatchUpdates() && Const.isEmpty((String)this.connectionGroup);
            if (!this.isAutoCommit()) {
                if (useBatchInsert) {
                    debug = "insertRow add batch";
                    ps.addBatch();
                } else {
                    debug = "insertRow exec update";
                    ps.executeUpdate();
                }
            } else {
                ps.executeUpdate();
            }
            ++this.written;
            if (handleCommit && !this.isAutoCommit() && this.written % this.commitsize == 0) {
                if (useBatchInsert) {
                    debug = "insertRow executeBatch commit";
                    ps.executeBatch();
                    this.commit();
                    ps.clearBatch();
                } else {
                    debug = "insertRow normal commit";
                    this.commit();
                }
                rowsAreSafe = true;
            }
            return rowsAreSafe;
        }
        catch (BatchUpdateException ex) {
            KettleDatabaseBatchException kdbe = new KettleDatabaseBatchException("Error updating batch", (Throwable)ex);
            kdbe.setUpdateCounts(ex.getUpdateCounts());
            ArrayList<BatchUpdateException> exceptions = new ArrayList<BatchUpdateException>();
            SQLException nextException = ex;
            do {
                exceptions.add((BatchUpdateException)nextException);
            } while ((nextException = nextException.getNextException()) != null);
            kdbe.setExceptionsList(exceptions);
            throw kdbe;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error inserting/updating row", (Throwable)ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error inserting/updating row in part [" + debug + "]", (Throwable)e);
        }
    }

    public void clearInsertBatch() throws KettleDatabaseException {
        this.clearBatch(this.prepStatementInsert);
    }

    public void clearBatch(PreparedStatement preparedStatement) throws KettleDatabaseException {
        try {
            preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to clear batch for prepared statement", (Throwable)e);
        }
    }

    public void insertFinished(boolean batch) throws KettleDatabaseException {
        this.insertFinished(this.prepStatementInsert, batch);
        this.prepStatementInsert = null;
    }

    public void emptyAndCommit(PreparedStatement ps, boolean batch, int batchCounter) throws KettleDatabaseException {
        try {
            if (ps != null) {
                if (!this.isAutoCommit()) {
                    if (batch && this.getDatabaseMetaData().supportsBatchUpdates() && batchCounter > 0) {
                        ps.executeBatch();
                        this.commit();
                    } else {
                        this.commit();
                    }
                }
                ps.close();
            }
        }
        catch (BatchUpdateException ex) {
            KettleDatabaseBatchException kdbe = new KettleDatabaseBatchException("Error updating batch", (Throwable)ex);
            kdbe.setUpdateCounts(ex.getUpdateCounts());
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            SQLException oldException = null;
            for (SQLException nextException = ex.getNextException(); nextException != null && oldException != nextException; nextException = nextException.getNextException()) {
                exceptions.add(nextException);
                oldException = nextException;
            }
            kdbe.setExceptionsList(exceptions);
            throw kdbe;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to empty ps and commit connection.", (Throwable)ex);
        }
    }

    public void insertFinished(PreparedStatement ps, boolean batch) throws KettleDatabaseException {
        try {
            if (ps != null) {
                if (!this.isAutoCommit()) {
                    if (batch && this.getDatabaseMetaData().supportsBatchUpdates()) {
                        ps.executeBatch();
                        this.commit();
                    } else {
                        this.commit();
                    }
                }
                ps.close();
            }
        }
        catch (BatchUpdateException ex) {
            KettleDatabaseBatchException kdbe = new KettleDatabaseBatchException("Error updating batch", (Throwable)ex);
            kdbe.setUpdateCounts(ex.getUpdateCounts());
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            SQLException oldException = null;
            for (SQLException nextException = ex.getNextException(); nextException != null && oldException != nextException; nextException = nextException.getNextException()) {
                exceptions.add(nextException);
                oldException = nextException;
            }
            kdbe.setExceptionsList(exceptions);
            throw kdbe;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to commit connection after having inserted rows.", (Throwable)ex);
        }
    }

    public Result execStatement(String sql) throws KettleDatabaseException {
        return this.execStatement(sql, null, null);
    }

    public Result execStatement(String sql, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        Result result = new Result();
        try {
            int count;
            boolean resultSet;
            if (params != null) {
                PreparedStatement prep_stmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                this.setValues(params, data, prep_stmt);
                resultSet = prep_stmt.execute();
                count = prep_stmt.getUpdateCount();
                prep_stmt.close();
            } else {
                String sqlStripped = this.databaseMeta.stripCR(sql);
                Statement stmt = this.connection.createStatement();
                resultSet = stmt.execute(sqlStripped);
                count = stmt.getUpdateCount();
                stmt.close();
            }
            if (!resultSet && count > 0) {
                if (sql.toUpperCase().startsWith("INSERT")) {
                    result.setNrLinesOutput((long)count);
                }
                if (sql.toUpperCase().startsWith("UPDATE")) {
                    result.setNrLinesUpdated((long)count);
                }
                if (sql.toUpperCase().startsWith("DELETE")) {
                    result.setNrLinesDeleted((long)count);
                }
            }
            if (sql.toUpperCase().startsWith("ALTER TABLE") || sql.toUpperCase().startsWith("DROP TABLE") || sql.toUpperCase().startsWith("CREATE TABLE")) {
                DBCache.getInstance().clear(this.databaseMeta.getName());
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't execute SQL: " + sql + Const.CR, (Throwable)ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error executing SQL: " + Const.CR, (Throwable)e);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Result execStatements(String script) throws KettleDatabaseException {
        result = new Result();
        all = script;
        from = 0;
        to = 0;
        length = all.length();
        nrstats = 0;
        while (to < length) {
            c = all.charAt(to);
            if (c == 34) {
                c = 32;
                while (to < length && c != 34) {
                    c = all.charAt(++to);
                }
            } else if (c == 39) {
                c = 32;
                while (to < length && c != 39) {
                    c = all.charAt(++to);
                }
            } else if (all.substring(to).startsWith("--")) {
                while (to < length && c != 10 && c != 13) {
                    c = all.charAt(++to);
                }
            }
            if (c == 59 || to >= length - 1) {
                if (to >= length - 1) {
                    ++to;
                }
                if ((stat = to <= length ? all.substring(from, to) : all.substring(from)).length() > 0 && stat.charAt(stat.length() - 1) == ';') {
                    stat = stat.substring(0, stat.length() - 1);
                }
                if (!Const.onlySpaces((String)stat)) {
                    sql = Const.trim((String)stat);
                    if (sql.toUpperCase().startsWith("SELECT")) {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "launch SELECT statement: " + Const.CR + sql, new Object[0]);
                        }
                        ++nrstats;
                        rs = null;
                        try {
                            rs = this.openQuery(sql);
                            if (rs != null) {
                                row = this.getRow(rs);
                                while (row != null) {
                                    result.setNrLinesRead(result.getNrLinesRead() + 1L);
                                    if (this.log.isDetailed()) {
                                        this.log.logDetailed(this.toString(), this.rowMeta.getString(row), new Object[0]);
                                    }
                                    row = this.getRow(rs);
                                }
                            }
                            if (!this.log.isDebug()) ** GOTO lbl68
                            this.log.logDebug(this.toString(), "Error executing query: " + Const.CR + sql, new Object[0]);
                        }
                        catch (KettleValueException e) {
                            throw new KettleDatabaseException((Throwable)e);
                        }
                        finally {
                            block31: {
                                try {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                }
                                catch (SQLException ex) {
                                    if (!this.log.isDebug()) break block31;
                                    this.log.logDebug(this.toString(), "Error closing query: " + Const.CR + sql, new Object[0]);
                                }
                            }
                        }
                    } else {
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), "launch DDL statement: " + Const.CR + sql, new Object[0]);
                        }
                        ++nrstats;
                        res = this.execStatement(sql);
                        result.add(res);
                    }
                }
lbl68:
                // 6 sources

                from = ++to;
                continue;
            }
            ++to;
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(this.toString(), nrstats + " statement" + (nrstats == 1 ? "" : "s") + " executed", new Object[0]);
        }
        return result;
    }

    public ResultSet openQuery(String sql) throws KettleDatabaseException {
        return this.openQuery(sql, null, null);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        return this.openQuery(sql, params, data, 1000);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data, int fetch_mode) throws KettleDatabaseException {
        return this.openQuery(sql, params, data, fetch_mode, false);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data, int fetch_mode, boolean lazyConversion) throws KettleDatabaseException {
        ResultSet res;
        String debug = "Start";
        try {
            if (params != null) {
                debug = "P create prepared statement (con==null? " + (this.connection == null) + ")";
                this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);
                debug = "P Set values";
                this.setValues(params, data);
                if (this.canWeSetFetchSize(this.pstmt)) {
                    int fs;
                    debug = "P Set fetchsize";
                    int n = fs = 5000 <= this.pstmt.getMaxRows() ? this.pstmt.getMaxRows() : 5000;
                    if (this.databaseMeta.getDatabaseType() == 1 && this.databaseMeta.isStreamingResults()) {
                        this.pstmt.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        this.pstmt.setFetchSize(fs);
                    }
                    debug = "P Set fetch direction";
                    this.pstmt.setFetchDirection(fetch_mode);
                }
                debug = "P Set max rows";
                if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                    this.pstmt.setMaxRows(this.rowlimit);
                }
                debug = "exec query";
                res = this.pstmt.executeQuery();
            } else {
                debug = "create statement";
                this.sel_stmt = this.connection.createStatement();
                if (this.canWeSetFetchSize(this.sel_stmt)) {
                    int fs;
                    debug = "Set fetchsize";
                    int n = fs = 5000 <= this.sel_stmt.getMaxRows() ? this.sel_stmt.getMaxRows() : 5000;
                    if (this.databaseMeta.getDatabaseType() == 1 && this.databaseMeta.isStreamingResults()) {
                        this.sel_stmt.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        this.sel_stmt.setFetchSize(fs);
                    }
                    debug = "Set fetch direction";
                    this.sel_stmt.setFetchDirection(fetch_mode);
                }
                debug = "Set max rows";
                if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                    this.sel_stmt.setMaxRows(this.rowlimit);
                }
                debug = "exec query";
                res = this.sel_stmt.executeQuery(this.databaseMeta.stripCR(sql));
            }
            debug = "openQuery : get rowinfo";
            this.rowMeta = this.getRowInfo(res.getMetaData(), this.databaseMeta.getDatabaseType() == 1, lazyConversion);
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("An error occurred executing SQL: " + Const.CR + sql, (Throwable)ex);
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "ERROR executing query: " + e.toString(), new Object[0]);
            this.log.logError(this.toString(), "ERROR in part: " + debug, new Object[0]);
            throw new KettleDatabaseException("An error occurred executing SQL in part [" + debug + "]:" + Const.CR + sql, (Throwable)e);
        }
        return res;
    }

    private boolean canWeSetFetchSize(Statement statement) throws SQLException {
        return this.databaseMeta.isFetchSizeSupported() && (statement.getMaxRows() > 0 || this.databaseMeta.getDatabaseType() == 7 || this.databaseMeta.getDatabaseType() == 1 && this.databaseMeta.isStreamingResults());
    }

    public ResultSet openQuery(PreparedStatement ps, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        ResultSet res;
        String debug = "Start";
        try {
            debug = "OQ Set values";
            this.setValues(params, data, ps);
            if (this.canWeSetFetchSize(ps)) {
                int fs;
                debug = "OQ Set fetchsize";
                int n = fs = 5000 <= ps.getMaxRows() ? ps.getMaxRows() : 5000;
                if (this.databaseMeta.getDatabaseType() == 1 && this.databaseMeta.isStreamingResults()) {
                    ps.setFetchSize(Integer.MIN_VALUE);
                } else {
                    ps.setFetchSize(fs);
                }
                debug = "OQ Set fetch direction";
                ps.setFetchDirection(1000);
            }
            debug = "OQ Set max rows";
            if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                ps.setMaxRows(this.rowlimit);
            }
            debug = "OQ exec query";
            res = ps.executeQuery();
            debug = "OQ getRowInfo()";
            this.rowMeta = this.getRowInfo(res.getMetaData(), this.databaseMeta.getDatabaseType() == 1, false);
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("ERROR executing query in part[" + debug + "]", (Throwable)ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("ERROR executing query in part[" + debug + "]", (Throwable)e);
        }
        return res;
    }

    public RowMetaInterface getTableFields(String tablename) throws KettleDatabaseException {
        return this.getQueryFields(this.databaseMeta.getSQLQueryFields(tablename), false);
    }

    public RowMetaInterface getQueryFields(String sql, boolean param) throws KettleDatabaseException {
        return this.getQueryFields(sql, param, null, null);
    }

    public boolean checkTableExists(String tablename) throws KettleDatabaseException {
        try {
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), "Checking if table [" + tablename + "] exists!", new Object[0]);
            }
            String sql = this.databaseMeta.getSQLTableExists(tablename);
            try {
                this.getOneRow(sql);
                return true;
            }
            catch (KettleDatabaseException e) {
                return false;
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to check if table [" + tablename + "] exists on connection [" + this.databaseMeta.getName() + "]", (Throwable)e);
        }
    }

    public boolean checkColumnExists(String columnname, String tablename) throws KettleDatabaseException {
        try {
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), "Checking if column [" + columnname + "] exists in table [" + tablename + "] !", new Object[0]);
            }
            String sql = this.databaseMeta.getSQLColumnExists(columnname, tablename);
            try {
                this.getOneRow(sql);
                return true;
            }
            catch (KettleDatabaseException e) {
                return false;
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to check if column [" + columnname + "] exists in table [" + tablename + "] on connection [" + this.databaseMeta.getName() + "]", (Throwable)e);
        }
    }

    public boolean checkSequenceExists(String sequenceName) throws KettleDatabaseException {
        return this.checkSequenceExists(null, sequenceName);
    }

    public boolean checkSequenceExists(String schemaName, String sequenceName) throws KettleDatabaseException {
        boolean retval = false;
        if (!this.databaseMeta.supportsSequences()) {
            return retval;
        }
        String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
        try {
            String sql = this.databaseMeta.getSQLSequenceExists(schemaSequence);
            ResultSet res = this.openQuery(sql);
            if (res != null) {
                Object[] row = this.getRow(res);
                if (row != null) {
                    retval = true;
                }
                this.closeQuery(res);
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error checking whether or not sequence [" + schemaSequence + "] exists", (Throwable)e);
        }
        return retval;
    }

    public boolean checkIndexExists(String tableName, String[] idx_fields) throws KettleDatabaseException {
        return this.checkIndexExists(null, tableName, idx_fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIndexExists(String schemaName, String tableName, String[] idx_fields) throws KettleDatabaseException {
        String tablename = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        if (!this.checkTableExists(tablename)) {
            return false;
        }
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), "CheckIndexExists() tablename = " + tablename + " type = " + this.databaseMeta.getDatabaseTypeDesc(), new Object[0]);
        }
        boolean[] exists = new boolean[idx_fields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            switch (this.databaseMeta.getDatabaseType()) {
                case 5: {
                    int idx;
                    String column;
                    CharSequence sql = new StringBuffer(128);
                    ((StringBuffer)sql).append("select i.name table_name, c.name column_name ");
                    ((StringBuffer)sql).append("from     sysindexes i, sysindexkeys k, syscolumns c ");
                    ((StringBuffer)sql).append("where    i.name = '" + tablename + "' ");
                    ((StringBuffer)sql).append("AND      i.id = k.id ");
                    ((StringBuffer)sql).append("AND      i.id = c.id ");
                    ((StringBuffer)sql).append("AND      k.colid = c.colid ");
                    ResultSet res = null;
                    try {
                        res = this.openQuery(((StringBuffer)sql).toString());
                        if (res == null) {
                            boolean row = false;
                            return row;
                        }
                        Object[] row = this.getRow(res);
                        while (row != null) {
                            column = this.rowMeta.getString(row, "column_name", "");
                            idx = Const.indexOfString((String)column, (String[])idx_fields);
                            if (idx >= 0) {
                                exists[idx] = true;
                            }
                            row = this.getRow(res);
                        }
                        break;
                    }
                    finally {
                        if (res != null) {
                            this.closeQuery(res);
                        }
                    }
                }
                case 2: {
                    int idx;
                    String column;
                    CharSequence sql = "SELECT * FROM USER_IND_COLUMNS WHERE TABLE_NAME = '" + tableName + "'";
                    ResultSet res = null;
                    try {
                        res = this.openQuery((String)sql);
                        if (res == null) {
                            boolean row = false;
                            return row;
                        }
                        Object[] row = this.getRow(res);
                        while (row != null) {
                            column = this.rowMeta.getString(row, "COLUMN_NAME", "");
                            idx = Const.indexOfString((String)column, (String[])idx_fields);
                            if (idx >= 0) {
                                exists[idx] = true;
                            }
                            row = this.getRow(res);
                        }
                        break;
                    }
                    finally {
                        if (res != null) {
                            this.closeQuery(res);
                        }
                    }
                }
                case 4: {
                    String column;
                    ResultSet indexList = null;
                    try {
                        indexList = this.getDatabaseMetaData().getIndexInfo(null, null, tablename, false, true);
                        while (indexList.next()) {
                            column = indexList.getString("COLUMN_NAME");
                            int idx = Const.indexOfString((String)column, (String[])idx_fields);
                            if (idx < 0) continue;
                            exists[idx] = true;
                        }
                        break;
                    }
                    finally {
                        if (indexList != null) {
                            indexList.close();
                        }
                    }
                }
                default: {
                    String column;
                    ResultSet indexList = null;
                    try {
                        indexList = this.getDatabaseMetaData().getIndexInfo(null, null, tablename, false, true);
                        while (indexList.next()) {
                            column = indexList.getString("COLUMN_NAME");
                            int idx = Const.indexOfString((String)column, (String[])idx_fields);
                            if (idx < 0) continue;
                            exists[idx] = true;
                        }
                        break;
                    }
                    finally {
                        if (indexList != null) {
                            indexList.close();
                        }
                    }
                }
            }
            boolean all = true;
            int i = 0;
            while (i < exists.length) {
                if (!all) return all;
                if (!exists[i]) {
                    all = false;
                }
                ++i;
            }
            return all;
        }
        catch (Exception e) {
            this.log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
            throw new KettleDatabaseException("Unable to determine if indexes exists on table [" + tablename + "]", (Throwable)e);
        }
    }

    public String getCreateIndexStatement(String tablename, String indexname, String[] idx_fields, boolean tk, boolean unique, boolean bitmap, boolean semi_colon) {
        return this.getCreateIndexStatement(null, tablename, indexname, idx_fields, tk, unique, bitmap, semi_colon);
    }

    public String getCreateIndexStatement(String schemaname, String tablename, String indexname, String[] idx_fields, boolean tk, boolean unique, boolean bitmap, boolean semi_colon) {
        String cr_index = "";
        cr_index = cr_index + "CREATE ";
        if (unique || tk && this.databaseMeta.getDatabaseType() == 10) {
            cr_index = cr_index + "UNIQUE ";
        }
        if (bitmap && this.databaseMeta.supportsBitmapIndex()) {
            cr_index = cr_index + "BITMAP ";
        }
        cr_index = cr_index + "INDEX " + this.databaseMeta.quoteField(indexname) + Const.CR + " ";
        cr_index = cr_index + "ON ";
        cr_index = cr_index + tablename;
        cr_index = cr_index + Const.CR + "( " + Const.CR;
        for (int i = 0; i < idx_fields.length; ++i) {
            cr_index = i > 0 ? cr_index + ", " : cr_index + "  ";
            cr_index = cr_index + this.databaseMeta.quoteField(idx_fields[i]) + Const.CR;
        }
        cr_index = cr_index + ")" + Const.CR;
        if (this.databaseMeta.getDatabaseType() == 2 && this.databaseMeta.getIndexTablespace() != null && this.databaseMeta.getIndexTablespace().length() > 0) {
            cr_index = cr_index + "TABLESPACE " + this.databaseMeta.quoteField(this.databaseMeta.getIndexTablespace());
        }
        if (semi_colon) {
            cr_index = cr_index + ";" + Const.CR;
        }
        return cr_index;
    }

    public String getCreateSequenceStatement(String sequence, long start_at, long increment_by, long max_value, boolean semi_colon) {
        return this.getCreateSequenceStatement(null, sequence, Long.toString(start_at), Long.toString(increment_by), Long.toString(max_value), semi_colon);
    }

    public String getCreateSequenceStatement(String sequence, String start_at, String increment_by, String max_value, boolean semi_colon) {
        return this.getCreateSequenceStatement(null, sequence, start_at, increment_by, max_value, semi_colon);
    }

    public String getCreateSequenceStatement(String schemaName, String sequence, long start_at, long increment_by, long max_value, boolean semi_colon) {
        return this.getCreateSequenceStatement(schemaName, sequence, Long.toString(start_at), Long.toString(increment_by), Long.toString(max_value), semi_colon);
    }

    public String getCreateSequenceStatement(String schemaName, String sequenceName, String start_at, String increment_by, String max_value, boolean semi_colon) {
        String cr_seq = "";
        if (Const.isEmpty((String)sequenceName)) {
            return cr_seq;
        }
        if (this.databaseMeta.supportsSequences()) {
            String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
            cr_seq = cr_seq + "CREATE SEQUENCE " + schemaSequence + " " + Const.CR;
            cr_seq = cr_seq + "START WITH " + start_at + " " + Const.CR;
            cr_seq = cr_seq + "INCREMENT BY " + increment_by + " " + Const.CR;
            if (max_value != null) {
                cr_seq = (this.databaseMeta.getDatabaseType() == 6 || this.databaseMeta.getDatabaseType() == 3) && max_value.trim().equals("-1") ? cr_seq + "NOMAXVALUE" + Const.CR : cr_seq + "MAXVALUE " + max_value + Const.CR;
            }
            if (semi_colon) {
                cr_seq = cr_seq + ";" + Const.CR;
            }
        }
        return cr_seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMetaInterface getQueryFields(String sql, boolean param, RowMetaInterface inform, Object[] data) throws KettleDatabaseException {
        RowMetaInterface fields;
        DBCache dbcache = DBCache.getInstance();
        DBCacheEntry entry = null;
        if (dbcache != null && (fields = dbcache.get(entry = new DBCacheEntry(this.databaseMeta.getName(), sql))) != null) {
            return fields;
        }
        if (this.connection == null) {
            return null;
        }
        if (this.databaseMeta.getDatabaseType() == 2 || this.databaseMeta.getDatabaseType() == 23 || this.databaseMeta.getDatabaseType() == 16) {
            fields = this.getQueryFieldsFallback(sql, param, inform, data);
        } else {
            Statement preparedStatement = null;
            try {
                preparedStatement = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);
                ResultSetMetaData rsmd = preparedStatement.getMetaData();
                fields = this.getRowInfo(rsmd, false, false);
            }
            catch (Exception e) {
                fields = this.getQueryFieldsFallback(sql, param, inform, data);
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException e) {
                        throw new KettleDatabaseException("Unable to close prepared statement after determining SQL layout", (Throwable)e);
                    }
                }
            }
        }
        if (dbcache != null && entry != null && fields != null) {
            dbcache.put(entry, fields);
        }
        return fields;
    }

    private RowMetaInterface getQueryFieldsFallback(String sql, boolean param, RowMetaInterface inform, Object[] data) throws KettleDatabaseException {
        RowMetaInterface fields;
        try {
            if (inform == null && this.databaseMeta.getDatabaseType() != 5) {
                this.sel_stmt = this.connection.createStatement(1003, 1007);
                if (this.databaseMeta.isFetchSizeSupported() && this.sel_stmt.getMaxRows() >= 1) {
                    if (this.databaseMeta.getDatabaseType() == 1) {
                        this.sel_stmt.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        this.sel_stmt.setFetchSize(1);
                    }
                }
                if (this.databaseMeta.supportsSetMaxRows()) {
                    this.sel_stmt.setMaxRows(1);
                }
                ResultSet r = this.sel_stmt.executeQuery(this.databaseMeta.stripCR(sql));
                fields = this.getRowInfo(r.getMetaData(), false, false);
                r.close();
                this.sel_stmt.close();
                this.sel_stmt = null;
            } else {
                PreparedStatement ps = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                if (param) {
                    RowMetaInterface par = inform;
                    if (par == null || par.isEmpty()) {
                        par = this.getParameterMetaData(ps);
                    }
                    if (par == null || par.isEmpty()) {
                        par = this.getParameterMetaData(sql, inform, data);
                    }
                    this.setValues(par, data, ps);
                }
                ResultSet r = ps.executeQuery();
                fields = this.getRowInfo(ps.getMetaData(), false, false);
                r.close();
                ps.close();
            }
        }
        catch (Exception ex) {
            throw new KettleDatabaseException("Couldn't get field info from [" + sql + "]" + Const.CR, (Throwable)ex);
        }
        return fields;
    }

    public void closeQuery(ResultSet res) throws KettleDatabaseException {
        try {
            if (res != null) {
                res.close();
            }
            if (this.sel_stmt != null) {
                this.sel_stmt.close();
                this.sel_stmt = null;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't close query: resultset or prepared statements", (Throwable)ex);
        }
    }

    private RowMetaInterface getRowInfo(ResultSetMetaData rm, boolean ignoreLength, boolean lazyConversion) throws KettleDatabaseException {
        if (rm == null) {
            return null;
        }
        this.rowMeta = new RowMeta();
        try {
            int fieldNr = 1;
            int nrcols = rm.getColumnCount();
            for (int i = 1; i <= nrcols; ++i) {
                String name = new String(rm.getColumnName(i));
                if (Const.isEmpty((String)name) || Const.onlySpaces((String)name)) {
                    name = "Field" + fieldNr;
                    ++fieldNr;
                }
                ValueMetaInterface v = this.getValueFromSQLType(name, rm, i, ignoreLength, lazyConversion);
                this.rowMeta.addValueMeta(v);
            }
            return this.rowMeta;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error getting row information from database: ", (Throwable)ex);
        }
    }

    private ValueMetaInterface getValueFromSQLType(String name, ResultSetMetaData rm, int index, boolean ignoreLength, boolean lazyConversion) throws SQLException {
        int length = -1;
        int precision = -1;
        int valtype = 0;
        boolean isClob = false;
        int type = rm.getColumnType(index);
        boolean signed = rm.isSigned(index);
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                valtype = 2;
                if (ignoreLength) break;
                length = rm.getColumnDisplaySize(index);
                break;
            }
            case 2005: {
                valtype = 2;
                length = 9999999;
                isClob = true;
                break;
            }
            case -5: {
                if (signed) {
                    valtype = 5;
                    precision = 0;
                    length = 15;
                    break;
                }
                valtype = 6;
                precision = 0;
                length = 16;
                break;
            }
            case 4: {
                valtype = 5;
                precision = 0;
                length = 9;
                break;
            }
            case 5: {
                valtype = 5;
                precision = 0;
                length = 4;
                break;
            }
            case -6: {
                valtype = 5;
                precision = 0;
                length = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                valtype = 1;
                length = rm.getPrecision(index);
                precision = rm.getScale(index);
                if (length >= 126) {
                    length = -1;
                }
                if (precision >= 126) {
                    precision = -1;
                }
                if (type == 8 || type == 6 || type == 7) {
                    if (precision == 0) {
                        precision = -1;
                    }
                    if (this.databaseMeta.getDatabaseType() == 7 && type == 8 && precision == 16 && length == 16) {
                        precision = -1;
                        length = -1;
                    }
                    if (this.databaseMeta.getDatabaseType() == 1 && precision >= length) {
                        precision = -1;
                        length = -1;
                    }
                } else if (precision == 0 && length < 18 && length > 0) {
                    valtype = 5;
                }
                if (length > 18 || precision > 18) {
                    valtype = 6;
                }
                if (this.databaseMeta.getDatabaseType() != 2) break;
                if (precision == 0 && length == 38) {
                    valtype = 5;
                }
                if (precision > 0 || length > 0) break;
                valtype = 6;
                length = -1;
                precision = -1;
                break;
            }
            case 91: {
                if (this.databaseMeta.getDatabaseType() == 21) {
                    precision = 1;
                }
            }
            case 92: 
            case 93: {
                String property;
                valtype = 3;
                if (this.databaseMeta.getDatabaseType() != 1 || (property = this.databaseMeta.getConnectionProperties().getProperty("yearIsDateType")) == null || !property.equalsIgnoreCase("false") || !rm.getColumnTypeName(index).equalsIgnoreCase("YEAR")) break;
                valtype = 5;
                precision = 0;
                length = 4;
                break;
            }
            case -7: 
            case 16: {
                valtype = 4;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                valtype = 8;
                if (this.databaseMeta.getDatabaseType() == 6 && 2 * rm.getPrecision(index) == rm.getColumnDisplaySize(index)) {
                    length = rm.getPrecision(index);
                } else if (this.databaseMeta.getDatabaseType() == 2 && (type == -3 || type == -4)) {
                    valtype = 2;
                    length = rm.getColumnDisplaySize(index);
                } else {
                    length = -1;
                }
                precision = -1;
                break;
            }
            default: {
                valtype = 2;
                precision = rm.getScale(index);
            }
        }
        String comments = rm.getColumnLabel(index);
        int originalColumnType = rm.getColumnType(index);
        String originalColumnTypeName = rm.getColumnTypeName(index);
        int originalPrecision = -1;
        if (!ignoreLength) {
            rm.getPrecision(index);
        }
        int originalScale = rm.getScale(index);
        boolean originalSigned = rm.isSigned(index);
        ValueMeta v = new ValueMeta(name, valtype);
        v.setLength(length);
        v.setPrecision(precision);
        v.setComments(comments);
        v.setLargeTextField(isClob);
        v.setOriginalColumnType(originalColumnType);
        v.setOriginalColumnTypeName(originalColumnTypeName);
        v.setOriginalPrecision(originalPrecision);
        v.setOriginalScale(originalScale);
        v.setOriginalSigned(originalSigned);
        if (lazyConversion && valtype == 2) {
            v.setStorageType(1);
            ValueMetaInterface storageMetaData = v.clone();
            storageMetaData.setType(2);
            storageMetaData.setStorageType(0);
            v.setStorageMetadata(storageMetaData);
        }
        return v;
    }

    public boolean absolute(ResultSet rs, int position) throws KettleDatabaseException {
        try {
            return rs.absolute(position);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to position " + position, (Throwable)e);
        }
    }

    public boolean relative(ResultSet rs, int rows) throws KettleDatabaseException {
        try {
            return rs.relative(rows);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move the resultset forward " + rows + " rows", (Throwable)e);
        }
    }

    public void afterLast(ResultSet rs) throws KettleDatabaseException {
        try {
            rs.afterLast();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to after the last position", (Throwable)e);
        }
    }

    public void first(ResultSet rs) throws KettleDatabaseException {
        try {
            rs.first();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to the first position", (Throwable)e);
        }
    }

    public Object[] getRow(ResultSet rs) throws KettleDatabaseException {
        return this.getRow(rs, false);
    }

    public Object[] getRow(ResultSet rs, boolean lazyConversion) throws KettleDatabaseException {
        if (this.rowMeta == null) {
            ResultSetMetaData rsmd = null;
            try {
                rsmd = rs.getMetaData();
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Unable to retrieve metadata from resultset", (Throwable)e);
            }
            this.rowMeta = this.getRowInfo(rsmd, false, lazyConversion);
        }
        return this.getRow(rs, null, this.rowMeta);
    }

    public Object[] getRow(ResultSet rs, ResultSetMetaData dummy, RowMetaInterface rowInfo) throws KettleDatabaseException {
        try {
            int nrcols = rowInfo.size();
            Object[] data = RowDataUtil.allocateRowData((int)nrcols);
            if (rs.next()) {
                for (int i = 0; i < nrcols; ++i) {
                    ValueMetaInterface val = rowInfo.getValueMeta(i);
                    switch (val.getType()) {
                        case 4: {
                            data[i] = rs.getBoolean(i + 1);
                            break;
                        }
                        case 1: {
                            data[i] = new Double(rs.getDouble(i + 1));
                            break;
                        }
                        case 6: {
                            data[i] = rs.getBigDecimal(i + 1);
                            break;
                        }
                        case 5: {
                            data[i] = rs.getLong(i + 1);
                            break;
                        }
                        case 2: {
                            if (val.isStorageBinaryString()) {
                                data[i] = rs.getBytes(i + 1);
                                break;
                            }
                            data[i] = rs.getString(i + 1);
                            break;
                        }
                        case 8: {
                            if (this.databaseMeta.supportsGetBlob()) {
                                Blob blob = rs.getBlob(i + 1);
                                if (blob != null) {
                                    data[i] = blob.getBytes(1L, (int)blob.length());
                                    break;
                                }
                                data[i] = null;
                                break;
                            }
                            data[i] = rs.getBytes(i + 1);
                            break;
                        }
                        case 3: {
                            if (this.databaseMeta.getDatabaseType() == 35 && val.getOriginalColumnType() == 92) {
                                data[i] = rs.getTime(i + 1);
                                break;
                            }
                            if (val.getPrecision() != 1 && this.databaseMeta.supportsTimeStampToDateConversion()) {
                                data[i] = rs.getTimestamp(i + 1);
                                break;
                            }
                            data[i] = rs.getDate(i + 1);
                            break;
                        }
                    }
                    if (!rs.wasNull()) continue;
                    data[i] = null;
                }
            } else {
                data = null;
            }
            return data;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't get row from result set", (Throwable)ex);
        }
    }

    public void printSQLException(SQLException ex) {
        this.log.logError(this.toString(), "==> SQLException: ", new Object[0]);
        while (ex != null) {
            this.log.logError(this.toString(), "Message:   " + ex.getMessage(), new Object[0]);
            this.log.logError(this.toString(), "SQLState:  " + ex.getSQLState(), new Object[0]);
            this.log.logError(this.toString(), "ErrorCode: " + ex.getErrorCode(), new Object[0]);
            ex = ex.getNextException();
            this.log.logError(this.toString(), "", new Object[0]);
        }
    }

    public void setLookup(String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws KettleDatabaseException {
        this.setLookup(table, codes, condition, gets, rename, orderby, false);
    }

    public void setLookup(String schema, String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws KettleDatabaseException {
        this.setLookup(schema, table, codes, condition, gets, rename, orderby, false);
    }

    public void setLookup(String tableName, String[] codes, String[] condition, String[] gets, String[] rename, String orderby, boolean checkForMultipleResults) throws KettleDatabaseException {
        this.setLookup(null, tableName, codes, condition, gets, rename, orderby, checkForMultipleResults);
    }

    public void setLookup(String schemaName, String tableName, String[] codes, String[] condition, String[] gets, String[] rename, String orderby, boolean checkForMultipleResults) throws KettleDatabaseException {
        int i;
        String table = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        String sql = "SELECT ";
        for (i = 0; i < gets.length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + this.databaseMeta.quoteField(gets[i]);
            if (rename == null || rename[i] == null || gets[i].equalsIgnoreCase(rename[i])) continue;
            sql = sql + " AS " + this.databaseMeta.quoteField(rename[i]);
        }
        sql = sql + " FROM " + table + " WHERE ";
        for (i = 0; i < codes.length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + this.databaseMeta.quoteField(codes[i]);
            sql = "BETWEEN".equalsIgnoreCase(condition[i]) ? sql + " BETWEEN ? AND ? " : ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i]) ? sql + " " + condition[i] + " " : sql + " " + condition[i] + " ? ");
        }
        if (orderby != null && orderby.length() != 0) {
            sql = sql + " ORDER BY " + orderby;
        }
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Setting preparedStatement to [" + sql + "]", new Object[0]);
            }
            this.prepStatementLookup = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            if (!checkForMultipleResults && this.databaseMeta.supportsSetMaxRows()) {
                this.prepStatementLookup.setMaxRows(1);
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for update [" + sql + "]", (Throwable)ex);
        }
    }

    public boolean prepareUpdate(String table, String[] codes, String[] condition, String[] sets) {
        return this.prepareUpdate(null, table, codes, condition, sets);
    }

    public boolean prepareUpdate(String schemaName, String tableName, String[] codes, String[] condition, String[] sets) {
        int i;
        StringBuffer sql = new StringBuffer(128);
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        sql.append("UPDATE ").append(schemaTable).append(Const.CR).append("SET ");
        for (i = 0; i < sets.length; ++i) {
            if (i != 0) {
                sql.append(",   ");
            }
            sql.append(this.databaseMeta.quoteField(sets[i]));
            sql.append(" = ?").append(Const.CR);
        }
        sql.append("WHERE ");
        for (i = 0; i < codes.length; ++i) {
            if (i != 0) {
                sql.append("AND   ");
            }
            sql.append(this.databaseMeta.quoteField(codes[i]));
            if ("BETWEEN".equalsIgnoreCase(condition[i])) {
                sql.append(" BETWEEN ? AND ? ");
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i])) {
                sql.append(' ').append(condition[i]).append(' ');
                continue;
            }
            sql.append(' ').append(condition[i]).append(" ? ");
        }
        try {
            String s = sql.toString();
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Setting update preparedStatement to [" + s + "]", new Object[0]);
            }
            this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(s));
        }
        catch (SQLException ex) {
            this.printSQLException(ex);
            return false;
        }
        return true;
    }

    public boolean prepareDelete(String table, String[] codes, String[] condition) {
        return this.prepareDelete(null, table, codes, condition);
    }

    public boolean prepareDelete(String schemaName, String tableName, String[] codes, String[] condition) {
        String table = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        String sql = "DELETE FROM " + table + Const.CR;
        sql = sql + "WHERE ";
        for (int i = 0; i < codes.length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + codes[i];
            sql = "BETWEEN".equalsIgnoreCase(condition[i]) ? sql + " BETWEEN ? AND ? " : ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i]) ? sql + " " + condition[i] + " " : sql + " " + condition[i] + " ? ");
        }
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Setting update preparedStatement to [" + sql + "]", new Object[0]);
            }
            this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            this.printSQLException(ex);
            return false;
        }
        return true;
    }

    public void setProcLookup(String proc, String[] arg, String[] argdir, int[] argtype, String returnvalue, int returntype) throws KettleDatabaseException {
        int i;
        int pos = 0;
        String sql = "{ ";
        if (returnvalue != null && returnvalue.length() != 0) {
            sql = sql + "? = ";
        }
        sql = sql + "call " + proc + " ";
        if (arg.length > 0) {
            sql = sql + "(";
        }
        for (i = 0; i < arg.length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + " ?";
        }
        if (arg.length > 0) {
            sql = sql + ")";
        }
        sql = sql + "}";
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "DBA setting callableStatement to [" + sql + "]", new Object[0]);
            }
            this.cstmt = this.connection.prepareCall(sql);
            pos = 1;
            if (!Const.isEmpty((String)returnvalue)) {
                switch (returntype) {
                    case 1: {
                        this.cstmt.registerOutParameter(pos, 8);
                        break;
                    }
                    case 6: {
                        this.cstmt.registerOutParameter(pos, 3);
                        break;
                    }
                    case 5: {
                        this.cstmt.registerOutParameter(pos, -5);
                        break;
                    }
                    case 2: {
                        this.cstmt.registerOutParameter(pos, 12);
                        break;
                    }
                    case 3: {
                        this.cstmt.registerOutParameter(pos, 93);
                        break;
                    }
                    case 4: {
                        this.cstmt.registerOutParameter(pos, 16);
                        break;
                    }
                }
                ++pos;
            }
            block19: for (i = 0; i < arg.length; ++i) {
                if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase("INOUT")) continue;
                switch (argtype[i]) {
                    case 1: {
                        this.cstmt.registerOutParameter(i + pos, 8);
                        continue block19;
                    }
                    case 6: {
                        this.cstmt.registerOutParameter(i + pos, 3);
                        continue block19;
                    }
                    case 5: {
                        this.cstmt.registerOutParameter(i + pos, -5);
                        continue block19;
                    }
                    case 2: {
                        this.cstmt.registerOutParameter(i + pos, 12);
                        continue block19;
                    }
                    case 3: {
                        this.cstmt.registerOutParameter(i + pos, 93);
                        continue block19;
                    }
                    case 4: {
                        this.cstmt.registerOutParameter(i + pos, 16);
                        continue block19;
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare database procedure call", (Throwable)ex);
        }
    }

    public Object[] getLookup() throws KettleDatabaseException {
        return this.getLookup(this.prepStatementLookup);
    }

    public Object[] getLookup(boolean failOnMultipleResults) throws KettleDatabaseException {
        return this.getLookup(this.prepStatementLookup, failOnMultipleResults);
    }

    public Object[] getLookup(PreparedStatement ps) throws KettleDatabaseException {
        return this.getLookup(ps, false);
    }

    public Object[] getLookup(PreparedStatement ps, boolean failOnMultipleResults) throws KettleDatabaseException {
        ResultSet res = null;
        try {
            res = ps.executeQuery();
            this.rowMeta = this.getRowInfo(res.getMetaData(), false, false);
            Object[] ret = this.getRow(res);
            if (failOnMultipleResults && ret != null && res.next()) {
                throw new KettleDatabaseException("Only 1 row was expected as a result of a lookup, and at least 2 were found!");
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error looking up row in database", (Throwable)ex);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Unable to close resultset after looking up data", (Throwable)e);
            }
        }
    }

    public DatabaseMetaData getDatabaseMetaData() throws KettleDatabaseException {
        try {
            if (this.dbmd == null) {
                this.dbmd = this.connection.getMetaData();
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to get database metadata from this database connection", (Throwable)e);
        }
        return this.dbmd;
    }

    public String getDDL(String tablename, RowMetaInterface fields) throws KettleDatabaseException {
        return this.getDDL(tablename, fields, null, false, null, true);
    }

    public String getDDL(String tablename, RowMetaInterface fields, String tk, boolean use_autoinc, String pk) throws KettleDatabaseException {
        return this.getDDL(tablename, fields, tk, use_autoinc, pk, true);
    }

    public String getDDL(String tableName, RowMetaInterface fields, String tk, boolean use_autoinc, String pk, boolean semicolon) throws KettleDatabaseException {
        this.databaseMeta.quoteReservedWords(fields);
        String quotedTk = tk != null ? this.databaseMeta.quoteField(tk) : null;
        String retval = this.checkTableExists(tableName) ? this.getAlterTableStatement(tableName, fields, quotedTk, use_autoinc, pk, semicolon) : this.getCreateTableStatement(tableName, fields, quotedTk, use_autoinc, pk, semicolon);
        return retval;
    }

    public String getCreateTableStatement(String tableName, RowMetaInterface fields, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        int i;
        StringBuilder retval = new StringBuilder("CREATE TABLE ");
        retval.append(tableName + Const.CR);
        retval.append("(").append(Const.CR);
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                retval.append(", ");
            } else {
                retval.append("  ");
            }
            ValueMetaInterface v = fields.getValueMeta(i);
            retval.append(this.databaseMeta.getFieldDefinition(v, tk, pk, use_autoinc));
        }
        if (tk != null && this.databaseMeta.getDatabaseType() == 8) {
            retval.append(", PRIMARY KEY (").append(tk).append(")").append(Const.CR);
        }
        if (pk != null && this.databaseMeta.getDatabaseType() == 2) {
            retval.append(", PRIMARY KEY (").append(pk).append(")").append(Const.CR);
        }
        retval.append(")").append(Const.CR);
        if (this.databaseMeta.getDatabaseType() == 2 && this.databaseMeta.getIndexTablespace() != null && this.databaseMeta.getIndexTablespace().length() > 0) {
            retval.append("TABLESPACE ").append(this.databaseMeta.getDataTablespace());
        }
        if (pk == null && tk == null && this.databaseMeta.getDatabaseType() == 35) {
            retval.append("NO PARTITION");
        }
        if (semicolon) {
            retval.append(";");
        }
        if (this.databaseMeta.getDatabaseType() == 34) {
            retval.append(Const.CR).append("CREATE PROJECTION ").append(tableName).append("_unseg_super").append(Const.CR);
            retval.append("(").append(Const.CR);
            for (i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    retval.append(", ");
                } else {
                    retval.append("  ");
                }
                retval.append(fields.getValueMeta(i).getName()).append(Const.CR);
            }
            retval.append(")").append(Const.CR);
            retval.append("AS SELECT").append(Const.CR);
            for (i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    retval.append(", ");
                } else {
                    retval.append("  ");
                }
                retval.append(fields.getValueMeta(i).getName()).append(Const.CR);
            }
            retval.append("FROM ").append(tableName).append(Const.CR);
            retval.append("-- Replace UNSEGMENTED with a hash segmentation for optimum performance").append(Const.CR);
            retval.append("--SEGMENTED BY HASH(X,Y,Z)").append(Const.CR);
            retval.append("UNSEGMENTED ALL NODES").append(Const.CR);
            retval.append(";");
        }
        return retval.toString();
    }

    public String getAlterTableStatement(String tableName, RowMetaInterface fields, String tk, boolean use_autoinc, String pk, boolean semicolon) throws KettleDatabaseException {
        int i;
        ValueMetaInterface v;
        int i2;
        ValueMetaInterface v2;
        int i3;
        String retval = "";
        RowMetaInterface tabFields = this.getTableFields(tableName);
        this.databaseMeta.quoteReservedWords(tabFields);
        RowMeta missing = new RowMeta();
        for (i3 = 0; i3 < fields.size(); ++i3) {
            v2 = fields.getValueMeta(i3);
            if (tabFields.searchValueMeta(v2.getName()) != null) continue;
            missing.addValueMeta(v2);
        }
        if (missing.size() != 0) {
            for (i3 = 0; i3 < missing.size(); ++i3) {
                v2 = missing.getValueMeta(i3);
                retval = retval + this.databaseMeta.getAddColumnStatement(tableName, v2, tk, use_autoinc, pk, true);
            }
        }
        RowMeta surplus = new RowMeta();
        for (i2 = 0; i2 < tabFields.size(); ++i2) {
            v = tabFields.getValueMeta(i2);
            if (fields.searchValueMeta(v.getName()) != null) continue;
            surplus.addValueMeta(v);
        }
        if (surplus.size() != 0) {
            for (i2 = 0; i2 < surplus.size(); ++i2) {
                v = surplus.getValueMeta(i2);
                retval = retval + this.databaseMeta.getDropColumnStatement(tableName, v, tk, use_autoinc, pk, true);
            }
        }
        RowMeta modify = new RowMeta();
        for (i = 0; i < fields.size(); ++i) {
            String currentDDL;
            boolean mod;
            ValueMetaInterface desiredField = fields.getValueMeta(i);
            ValueMetaInterface currentField = tabFields.searchValueMeta(desiredField.getName());
            if (desiredField == null || currentField == null) continue;
            String desiredDDL = this.databaseMeta.getFieldDefinition(desiredField, tk, pk, use_autoinc);
            boolean bl = mod = !desiredDDL.equalsIgnoreCase(currentDDL = this.databaseMeta.getFieldDefinition(currentField, tk, pk, use_autoinc));
            if (!mod) continue;
            modify.addValueMeta(desiredField);
        }
        if (modify.size() > 0) {
            for (i = 0; i < modify.size(); ++i) {
                ValueMetaInterface v3 = modify.getValueMeta(i);
                retval = retval + this.databaseMeta.getModifyColumnStatement(tableName, v3, tk, use_autoinc, pk, true);
            }
        }
        return retval;
    }

    public void truncateTable(String tablename) throws KettleDatabaseException {
        if (Const.isEmpty((String)this.connectionGroup)) {
            this.execStatement(this.databaseMeta.getTruncateTableStatement(null, tablename));
        } else {
            this.execStatement("DELETE FROM " + this.databaseMeta.quoteField(tablename));
        }
    }

    public void truncateTable(String schema, String tablename) throws KettleDatabaseException {
        if (Const.isEmpty((String)this.connectionGroup)) {
            this.execStatement(this.databaseMeta.getTruncateTableStatement(schema, tablename));
        } else {
            this.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(schema, tablename));
        }
    }

    public RowMetaAndData getOneRow(String sql) throws KettleDatabaseException {
        ResultSet rs = this.openQuery(sql);
        if (rs != null) {
            Object[] row = this.getRow(rs);
            try {
                rs.close();
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Unable to close resultset", (Throwable)e);
            }
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (Exception e) {
                    throw new KettleDatabaseException("Unable to close prepared statement pstmt", (Throwable)e);
                }
                this.pstmt = null;
            }
            if (this.sel_stmt != null) {
                try {
                    this.sel_stmt.close();
                }
                catch (Exception e) {
                    throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", (Throwable)e);
                }
                this.sel_stmt = null;
            }
            return new RowMetaAndData(this.rowMeta, row);
        }
        throw new KettleDatabaseException("error opening resultset for query: " + sql);
    }

    public RowMeta getMetaFromRow(Object[] row, ResultSetMetaData md) throws SQLException {
        RowMeta meta = new RowMeta();
        for (int i = 0; i < md.getColumnCount(); ++i) {
            String name = md.getColumnName(i + 1);
            ValueMetaInterface valueMeta = this.getValueFromSQLType(name, md, i + 1, true, false);
            meta.addValueMeta(valueMeta);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowMetaAndData getOneRow(String sql, RowMetaInterface param, Object[] data) throws KettleDatabaseException {
        RowMeta tmpMeta;
        Object[] row;
        block22: {
            ResultSet rs = this.openQuery(sql, param, data);
            if (rs == null) return null;
            row = this.getRow(rs);
            this.rowMeta = null;
            tmpMeta = null;
            try {
                try {
                    ResultSetMetaData md = rs.getMetaData();
                    tmpMeta = this.getMetaFromRow(row, md);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var9_10 = null;
                    try {
                        rs.close();
                    }
                    catch (Exception e2) {
                        throw new KettleDatabaseException("Unable to close resultset", (Throwable)e2);
                    }
                    if (this.pstmt != null) {
                        try {
                            this.pstmt.close();
                        }
                        catch (Exception e3) {
                            throw new KettleDatabaseException("Unable to close prepared statement pstmt", (Throwable)e3);
                        }
                        this.pstmt = null;
                    }
                    if (this.sel_stmt == null) return new RowMetaAndData((RowMetaInterface)tmpMeta, row);
                    try {
                        this.sel_stmt.close();
                    }
                    catch (Exception e4) {
                        throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", (Throwable)e4);
                    }
                    this.sel_stmt = null;
                    return new RowMetaAndData((RowMetaInterface)tmpMeta, row);
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                block21: {
                    Object var9_11 = null;
                    try {}
                    catch (Exception e2) {
                        throw new KettleDatabaseException("Unable to close resultset", (Throwable)e2);
                    }
                    rs.close();
                    if (this.pstmt == null) break block21;
                    try {}
                    catch (Exception e3) {
                        throw new KettleDatabaseException("Unable to close prepared statement pstmt", (Throwable)e3);
                    }
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.sel_stmt == null) throw throwable;
                try {}
                catch (Exception e4) {
                    throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", (Throwable)e4);
                }
                this.sel_stmt.close();
                this.sel_stmt = null;
                throw throwable;
            }
            try {}
            catch (Exception e2) {
                throw new KettleDatabaseException("Unable to close resultset", (Throwable)e2);
            }
            rs.close();
            if (this.pstmt == null) break block22;
            try {}
            catch (Exception e3) {
                throw new KettleDatabaseException("Unable to close prepared statement pstmt", (Throwable)e3);
            }
            this.pstmt.close();
            this.pstmt = null;
        }
        if (this.sel_stmt == null) return new RowMetaAndData((RowMetaInterface)tmpMeta, row);
        try {}
        catch (Exception e4) {
            throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", (Throwable)e4);
        }
        this.sel_stmt.close();
        this.sel_stmt = null;
        return new RowMetaAndData((RowMetaInterface)tmpMeta, row);
    }

    public RowMetaInterface getParameterMetaData(PreparedStatement ps) {
        RowMeta par = new RowMeta();
        try {
            ParameterMetaData pmd = ps.getParameterMetaData();
            for (int i = 1; i <= pmd.getParameterCount(); ++i) {
                ValueMeta val;
                String name = "par" + i;
                int sqltype = pmd.getParameterType(i);
                int length = pmd.getPrecision(i);
                int precision = pmd.getScale(i);
                switch (sqltype) {
                    case 1: 
                    case 12: {
                        val = new ValueMeta(name, 2);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 2: 
                    case 4: 
                    case 5: {
                        val = new ValueMeta(name, 5);
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        val = new ValueMeta(name, 1);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        val = new ValueMeta(name, 3);
                        break;
                    }
                    case -7: 
                    case 16: {
                        val = new ValueMeta(name, 4);
                        break;
                    }
                    default: {
                        val = new ValueMeta(name, 0);
                    }
                }
                if (val.isNumeric() && (length > 18 || precision > 18)) {
                    val = new ValueMeta(name, 6);
                }
                par.addValueMeta((ValueMetaInterface)val);
            }
        }
        catch (AbstractMethodError e) {
            return null;
        }
        catch (SQLException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return par;
    }

    public int countParameters(String sql) {
        int q = 0;
        boolean quote_opened = false;
        boolean dquote_opened = false;
        block5: for (int x = 0; x < sql.length(); ++x) {
            char c = sql.charAt(x);
            switch (c) {
                case '\'': {
                    quote_opened = !quote_opened;
                    continue block5;
                }
                case '\"': {
                    dquote_opened = !dquote_opened;
                    continue block5;
                }
                case '?': {
                    if (quote_opened || dquote_opened) continue block5;
                    ++q;
                }
            }
        }
        return q;
    }

    public RowMetaInterface getParameterMetaData(String sql, RowMetaInterface inform, Object[] data) {
        int q = this.countParameters(sql);
        RowMeta par = new RowMeta();
        if (inform != null && q == inform.size()) {
            for (int i = 0; i < q; ++i) {
                ValueMetaInterface inf = inform.getValueMeta(i);
                ValueMetaInterface v = inf.clone();
                par.addValueMeta(v);
            }
        } else {
            for (int i = 0; i < q; ++i) {
                ValueMeta v = new ValueMeta("name" + i, 1);
                par.addValueMeta((ValueMetaInterface)v);
            }
        }
        return par;
    }

    public static final RowMetaInterface getTransLogrecordFields(boolean update, boolean use_batchid, boolean use_logfield) {
        ValueMeta v;
        RowMeta r = new RowMeta();
        if (use_batchid && !update) {
            v = new ValueMeta("ID_BATCH", 5, 8, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!update) {
            v = new ValueMeta("TRANSNAME", 2, 255, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        v = new ValueMeta("STATUS", 2, 15, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_READ", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_WRITTEN", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_UPDATED", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_INPUT", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_OUTPUT", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("ERRORS", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("STARTDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("ENDDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LOGDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("DEPDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("REPLAYDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        if (use_logfield) {
            v = new ValueMeta("LOG_FIELD", 2, 9999999, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (use_batchid && update) {
            v = new ValueMeta("ID_BATCH", 5, 8, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        return r;
    }

    public static final RowMetaInterface getJobLogrecordFields(boolean update, boolean use_jobid, boolean use_logfield) {
        ValueMeta v;
        RowMeta r = new RowMeta();
        if (use_jobid && !update) {
            v = new ValueMeta("ID_JOB", 5, 8, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (!update) {
            v = new ValueMeta("JOBNAME", 2, 255, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        v = new ValueMeta("STATUS", 2, 15, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_READ", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_WRITTEN", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_UPDATED", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_INPUT", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_OUTPUT", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("ERRORS", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("STARTDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("ENDDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LOGDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("DEPDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("REPLAYDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        if (use_logfield) {
            v = new ValueMeta("LOG_FIELD", 2, 9999999, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (use_jobid && update) {
            v = new ValueMeta("ID_JOB", 5, 8, 0);
            r.addValueMeta((ValueMetaInterface)v);
        }
        return r;
    }

    public void writeLogRecord(String logtable, boolean use_id, long id, boolean job, String name, String status, long read, long written, long updated, long input, long output, long errors, java.util.Date startdate, java.util.Date enddate, java.util.Date logdate, java.util.Date depdate, java.util.Date replayDate, String log_string) throws KettleDatabaseException {
        boolean update;
        boolean bl = update = use_id && log_string != null && !status.equalsIgnoreCase(LOG_STATUS_START);
        RowMetaInterface rowMeta = job ? Database.getJobLogrecordFields(update, use_id, !Const.isEmpty((String)log_string)) : Database.getTransLogrecordFields(update, use_id, !Const.isEmpty((String)log_string));
        if (update) {
            String sql = "UPDATE " + logtable + " SET ";
            for (int i = 0; i < rowMeta.size() - 1; ++i) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
                if (i > 0) {
                    sql = sql + ", ";
                }
                sql = sql + this.databaseMeta.quoteField(valueMeta.getName()) + "=? ";
            }
            sql = sql + "WHERE ";
            sql = job ? sql + this.databaseMeta.quoteField("ID_JOB") + "=? " : sql + this.databaseMeta.quoteField("ID_BATCH") + "=? ";
            Object[] data = new Object[]{status, read, written, updated, input, output, errors, startdate, enddate, logdate, depdate, replayDate, log_string, id};
            this.execStatement(sql, rowMeta, data);
        } else {
            int i;
            String sql = "INSERT INTO " + logtable + " ( ";
            for (i = 0; i < rowMeta.size(); ++i) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
                if (i > 0) {
                    sql = sql + ", ";
                }
                sql = sql + this.databaseMeta.quoteField(valueMeta.getName());
            }
            sql = sql + ") VALUES(";
            for (i = 0; i < rowMeta.size(); ++i) {
                if (i > 0) {
                    sql = sql + ", ";
                }
                sql = sql + "?";
            }
            sql = sql + ")";
            try {
                this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                ArrayList<Object> data = new ArrayList<Object>();
                if (job) {
                    if (use_id) {
                        data.add(id);
                    }
                    data.add(name);
                } else {
                    if (use_id) {
                        data.add(id);
                    }
                    data.add(name);
                }
                data.add(status);
                data.add(read);
                data.add(written);
                data.add(updated);
                data.add(input);
                data.add(output);
                data.add(errors);
                data.add(startdate);
                data.add(enddate);
                data.add(logdate);
                data.add(depdate);
                data.add(replayDate);
                if (!Const.isEmpty((String)log_string)) {
                    data.add(log_string);
                }
                this.setValues(rowMeta, data.toArray(new Object[data.size()]));
                this.pstmt.executeUpdate();
                this.pstmt.close();
                this.pstmt = null;
            }
            catch (SQLException ex) {
                throw new KettleDatabaseException("Unable to write log record to log table " + logtable, (Throwable)ex);
            }
        }
    }

    public static final RowMetaInterface getStepPerformanceLogrecordFields() {
        RowMeta r = new RowMeta();
        ValueMeta v = new ValueMeta("ID_BATCH", 5, 8, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("SEQ_NR", 5, 8, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LOGDATE", 3);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("TRANSNAME", 2, 255, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("STEPNAME", 2, 255, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("STEP_COPY", 5, 3, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_READ", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_WRITTEN", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_UPDATED", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_INPUT", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_OUTPUT", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("LINES_REJECTED", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("ERRORS", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("INPUT_BUFFER_ROWS", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        v = new ValueMeta("OUTPUT_BUFFER_ROWS", 5, 10, 0);
        r.addValueMeta((ValueMetaInterface)v);
        return r;
    }

    public Object[] getLastLogDate(String logtable, String name, boolean job, String status) throws KettleDatabaseException {
        Object[] row = null;
        String jobtrans = job ? this.databaseMeta.quoteField("JOBNAME") : this.databaseMeta.quoteField("TRANSNAME");
        String sql = "";
        sql = sql + " SELECT " + this.databaseMeta.quoteField("ENDDATE") + ", " + this.databaseMeta.quoteField("DEPDATE") + ", " + this.databaseMeta.quoteField("STARTDATE");
        sql = sql + " FROM " + logtable;
        sql = sql + " WHERE  " + this.databaseMeta.quoteField("ERRORS") + "    = 0";
        sql = sql + " AND    " + this.databaseMeta.quoteField("STATUS") + "    = 'end'";
        sql = sql + " AND    " + jobtrans + " = ?";
        sql = sql + " ORDER BY " + this.databaseMeta.quoteField("LOGDATE") + " DESC, " + this.databaseMeta.quoteField("ENDDATE") + " DESC";
        try {
            this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            RowMeta r = new RowMeta();
            r.addValueMeta((ValueMetaInterface)new ValueMeta("TRANSNAME", 2));
            this.setValues((RowMetaInterface)r, new Object[]{name});
            ResultSet res = this.pstmt.executeQuery();
            if (res != null) {
                this.rowMeta = this.getRowInfo(res.getMetaData(), false, false);
                row = this.getRow(res);
                res.close();
            }
            this.pstmt.close();
            this.pstmt = null;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to obtain last logdate from table " + logtable, (Throwable)ex);
        }
        return row;
    }

    public synchronized Long getNextValue(Hashtable<String, Counter> counters, String tableName, String val_key) throws KettleDatabaseException {
        return this.getNextValue(counters, null, tableName, val_key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Long getNextValue(Hashtable<String, Counter> counters, String schemaName, String tableName, String val_key) throws KettleDatabaseException {
        long previous;
        Long nextValue = null;
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        String lookup = schemaTable + "." + this.databaseMeta.quoteField(val_key);
        Counter counter = null;
        if (counters != null) {
            counter = counters.get(lookup);
        }
        if (counter != null) return counter.next();
        RowMetaAndData rmad = this.getOneRow("SELECT MAX(" + this.databaseMeta.quoteField(val_key) + ") FROM " + schemaTable);
        if (rmad == null) throw new KettleDatabaseException("Couldn't find maximum key value from table " + schemaTable);
        try {
            Long tmp = rmad.getRowMeta().getInteger(rmad.getData(), 0);
            previous = tmp != null ? tmp : 0L;
        }
        catch (KettleValueException e) {
            throw new KettleDatabaseException("Error getting the first long value from the max value returned from table : " + schemaTable);
        }
        counter = new Counter(previous + 1L, 1L);
        nextValue = counter.next();
        if (counters == null) return nextValue;
        counters.put(lookup, counter);
        return nextValue;
    }

    public String toString() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getName();
        }
        return "-";
    }

    public boolean isSystemTable(String table_name) {
        if (this.databaseMeta.getDatabaseType() == 5) {
            if (table_name.startsWith("sys")) {
                return true;
            }
            if (table_name.equals("dtproperties")) {
                return true;
            }
        } else if (this.databaseMeta.getDatabaseType() == 11 && table_name.startsWith("SYS")) {
            return true;
        }
        return false;
    }

    public List<Object[]> getRows(String sql, int limit) throws KettleDatabaseException {
        return this.getRows(sql, limit, null);
    }

    public List<Object[]> getRows(String sql, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        if (monitor != null) {
            monitor.setTaskName("Opening query...");
        }
        ResultSet rset = this.openQuery(sql);
        return this.getRows(rset, limit, monitor);
    }

    public List<Object[]> getRows(ResultSet rset, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        try {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            boolean stop = false;
            int i = 0;
            if (rset != null) {
                if (monitor != null && limit > 0) {
                    monitor.beginTask("Reading rows...", limit);
                }
                while (!(limit > 0 && i >= limit || stop)) {
                    Object[] row = this.getRow(rset);
                    if (row != null) {
                        result.add(row);
                        ++i;
                    } else {
                        stop = true;
                    }
                    if (monitor == null || limit <= 0) continue;
                    monitor.worked(1);
                }
                this.closeQuery(rset);
                if (monitor != null) {
                    monitor.done();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to get list of rows from ResultSet : ", (Throwable)e);
        }
    }

    public List<Object[]> getFirstRows(String table_name, int limit) throws KettleDatabaseException {
        return this.getFirstRows(table_name, limit, null);
    }

    public List<Object[]> getFirstRows(String table_name, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        String sql = "SELECT";
        if (this.databaseMeta.getDatabaseType() == 35) {
            sql = sql + " [FIRST " + limit + "]";
        }
        sql = sql + " * FROM " + table_name;
        if (limit > 0) {
            sql = sql + this.databaseMeta.getLimitClause(limit);
        }
        return this.getRows(sql, limit, monitor);
    }

    public RowMetaInterface getReturnRowMeta() {
        return this.rowMeta;
    }

    public String[] getTableTypes() throws KettleDatabaseException {
        try {
            ArrayList<String> types = new ArrayList<String>();
            ResultSet rstt = this.getDatabaseMetaData().getTableTypes();
            while (rstt.next()) {
                String ttype = rstt.getString("TABLE_TYPE");
                types.add(ttype);
            }
            return types.toArray(new String[types.size()]);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to get table types from database!", (Throwable)e);
        }
    }

    public String[] getTablenames() throws KettleDatabaseException {
        return this.getTablenames(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getTablenames(boolean includeSchema) throws KettleDatabaseException {
        String schemaname = null;
        if (this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        ArrayList<String> names = new ArrayList<String>();
        ResultSet alltables = null;
        try {
            try {
                alltables = this.getDatabaseMetaData().getTables(null, schemaname, null, this.databaseMeta.getTableTypes());
                while (alltables.next()) {
                    String schema;
                    String cat;
                    block19: {
                        block18: {
                            cat = "";
                            try {
                                cat = alltables.getString("TABLE_CAT");
                            }
                            catch (Exception e) {
                                if (!this.log.isDebug()) break block18;
                                this.log.logDebug(this.toString(), "Error getting tables for field TABLE_CAT (ignored): " + e.toString(), new Object[0]);
                            }
                        }
                        schema = "";
                        try {
                            schema = alltables.getString("TABLE_SCHEM");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block19;
                            this.log.logDebug(this.toString(), "Error getting tables for field TABLE_SCHEM (ignored): " + e.toString(), new Object[0]);
                        }
                    }
                    if (Const.isEmpty((String)schema)) {
                        schema = cat;
                    }
                    String table = alltables.getString("TABLE_NAME");
                    String schemaTable = includeSchema ? this.databaseMeta.getQuotedSchemaTableCombination(schema, table) : table;
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel(this.toString(), "got table from meta-data: " + schemaTable, new Object[0]);
                    }
                    names.add(schemaTable);
                }
                Object var10_12 = null;
            }
            catch (SQLException e) {
                this.log.logError(this.toString(), "Error getting tablenames from schema [" + schemaname + "]", new Object[0]);
                Object var10_13 = null;
                try {
                    if (alltables != null) {
                        alltables.close();
                    }
                }
                catch (SQLException e2) {
                    throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            try {}
            catch (SQLException e2) {
                throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e2);
            }
            if (alltables == null) throw throwable;
            alltables.close();
            throw throwable;
        }
        try {}
        catch (SQLException e2) {
            throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e2);
        }
        if (alltables != null) {
            alltables.close();
        }
        if (!this.log.isDetailed()) return names.toArray(new String[names.size()]);
        this.log.logDetailed(this.toString(), "read :" + names.size() + " table names from db meta-data.", new Object[0]);
        return names.toArray(new String[names.size()]);
    }

    public String[] getViews() throws KettleDatabaseException {
        return this.getViews(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getViews(boolean includeSchema) throws KettleDatabaseException {
        if (!this.databaseMeta.supportsViews()) {
            return new String[0];
        }
        String schemaname = null;
        if (this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        ArrayList<String> names = new ArrayList<String>();
        ResultSet alltables = null;
        try {
            try {
                alltables = this.dbmd.getTables(null, schemaname, null, this.databaseMeta.getViewTypes());
                while (alltables.next()) {
                    String schema;
                    String cat;
                    block18: {
                        block17: {
                            cat = "";
                            try {
                                cat = alltables.getString("TABLE_CAT");
                            }
                            catch (Exception e) {
                                if (!this.log.isDebug()) break block17;
                                this.log.logDebug(this.toString(), "Error getting views for field TABLE_CAT (ignored): " + e.toString(), new Object[0]);
                            }
                        }
                        schema = "";
                        try {
                            schema = alltables.getString("TABLE_SCHEM");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block18;
                            this.log.logDebug(this.toString(), "Error getting views for field TABLE_SCHEM (ignored): " + e.toString(), new Object[0]);
                        }
                    }
                    if (Const.isEmpty((String)schema)) {
                        schema = cat;
                    }
                    String table = alltables.getString("TABLE_NAME");
                    String schemaTable = includeSchema ? this.databaseMeta.getQuotedSchemaTableCombination(schema, table) : table;
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel(this.toString(), "got view from meta-data: " + schemaTable, new Object[0]);
                    }
                    names.add(schemaTable);
                }
                Object var10_12 = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error getting views from schema [" + schemaname + "]", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (alltables == null) throw throwable;
                alltables.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e);
        }
        if (alltables != null) {
            alltables.close();
        }
        if (!this.log.isDetailed()) return names.toArray(new String[names.size()]);
        this.log.logDetailed(this.toString(), "read :" + names.size() + " views from db meta-data.", new Object[0]);
        return names.toArray(new String[names.size()]);
    }

    public String[] getSynonyms() throws KettleDatabaseException {
        return this.getSynonyms(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getSynonyms(boolean includeSchema) throws KettleDatabaseException {
        if (!this.databaseMeta.supportsSynonyms()) {
            return new String[0];
        }
        String schemaname = null;
        if (this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        ArrayList<String> names = new ArrayList<String>();
        ResultSet alltables = null;
        try {
            try {
                alltables = this.dbmd.getTables(null, schemaname, null, this.databaseMeta.getSynonymTypes());
                while (alltables.next()) {
                    String schema;
                    String cat;
                    block18: {
                        block17: {
                            cat = "";
                            try {
                                cat = alltables.getString("TABLE_CAT");
                            }
                            catch (Exception e) {
                                if (!this.log.isDebug()) break block17;
                                this.log.logDebug(this.toString(), "Error getting synonyms for field TABLE_CAT (ignored): " + e.toString(), new Object[0]);
                            }
                        }
                        schema = "";
                        try {
                            schema = alltables.getString("TABLE_SCHEM");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block18;
                            this.log.logDebug(this.toString(), "Error getting synonyms for field TABLE_SCHEM (ignored): " + e.toString(), new Object[0]);
                        }
                    }
                    if (Const.isEmpty((String)schema)) {
                        schema = cat;
                    }
                    String table = alltables.getString("TABLE_NAME");
                    String schemaTable = includeSchema ? this.databaseMeta.getQuotedSchemaTableCombination(schema, table) : table;
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel(this.toString(), "got view from meta-data: " + schemaTable, new Object[0]);
                    }
                    names.add(schemaTable);
                }
                Object var10_12 = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error getting synonyms from schema [" + schemaname + "]", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (alltables == null) throw throwable;
                alltables.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting synonyms from schema [" + schemaname + "]", (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new KettleDatabaseException("Error closing resultset after getting synonyms from schema [" + schemaname + "]", (Throwable)e);
        }
        if (alltables != null) {
            alltables.close();
        }
        if (!this.log.isDetailed()) return names.toArray(new String[names.size()]);
        this.log.logDetailed(this.toString(), "read :" + names.size() + " views from db meta-data.", new Object[0]);
        return names.toArray(new String[names.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getProcedures() throws KettleDatabaseException {
        String[] stringArray;
        String sql = this.databaseMeta.getSQLListOfProcedures();
        if (sql != null) {
            List<Object[]> procs = this.getRows(sql, 1000);
            String[] str = new String[procs.size()];
            int i = 0;
            while (i < procs.size()) {
                str[i] = procs.get(i)[0].toString();
                ++i;
            }
            return str;
        }
        ResultSet rs = null;
        try {
            try {
                DatabaseMetaData dbmd = this.getDatabaseMetaData();
                rs = dbmd.getProcedures(null, null, null);
                List<Object[]> rows = this.getRows(rs, 0, null);
                String[] result = new String[rows.size()];
                for (int i = 0; i < rows.size(); ++i) {
                    Object[] row = rows.get(i);
                    String procCatalog = this.rowMeta.getString(row, "PROCEDURE_CAT", null);
                    String procSchema = this.rowMeta.getString(row, "PROCEDURE_SCHEMA", null);
                    String procName = this.rowMeta.getString(row, "PROCEDURE_NAME", "");
                    String name = "";
                    if (procCatalog != null) {
                        name = name + procCatalog + ".";
                    } else if (procSchema != null) {
                        name = name + procSchema + ".";
                    }
                    result[i] = name = name + procName;
                }
                stringArray = result;
                Object var13_17 = null;
                if (rs == null) return stringArray;
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Unable to get list of procedures from database meta-data: ", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return stringArray;
        }
        rs.close();
        return stringArray;
    }

    public boolean isAutoCommit() {
        return this.commitsize <= 0;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void lockTables(String[] tableNames) throws KettleDatabaseException {
        if (Const.isEmpty((String[])tableNames)) {
            return;
        }
        String[] quotedTableNames = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            quotedTableNames[i] = this.databaseMeta.getQuotedSchemaTableCombination(null, tableNames[i]);
        }
        String sql = this.databaseMeta.getSQLLockTables(quotedTableNames);
        if (sql != null) {
            this.execStatements(sql);
        }
    }

    public void unlockTables(String[] tableNames) throws KettleDatabaseException {
        if (Const.isEmpty((String[])tableNames)) {
            return;
        }
        String[] quotedTableNames = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            quotedTableNames[i] = this.databaseMeta.getQuotedSchemaTableCombination(null, tableNames[i]);
        }
        String sql = this.databaseMeta.getSQLUnlockTables(quotedTableNames);
        if (sql != null) {
            this.execStatement(sql);
        }
    }

    public int getOpened() {
        return this.opened;
    }

    public void setOpened(int opened) {
        this.opened = opened;
    }

    public String getConnectionGroup() {
        return this.connectionGroup;
    }

    public void setConnectionGroup(String connectionGroup) {
        this.connectionGroup = connectionGroup;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public int getCopy() {
        return this.copy;
    }

    public void setCopy(int copy) {
        this.copy = copy;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
        if (space != this.databaseMeta) {
            this.databaseMeta.shareVariablesWith(space);
        }
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public RowMetaAndData callProcedure(String[] arg, String[] argdir, int[] argtype, String resultname, int resulttype) throws KettleDatabaseException {
        try {
            this.cstmt.execute();
            RowMetaAndData ret = new RowMetaAndData();
            int pos = 1;
            if (resultname != null && resultname.length() != 0) {
                ValueMeta vMeta = new ValueMeta(resultname, resulttype);
                Object v = null;
                switch (resulttype) {
                    case 4: {
                        v = this.cstmt.getBoolean(pos);
                        break;
                    }
                    case 1: {
                        v = new Double(this.cstmt.getDouble(pos));
                        break;
                    }
                    case 6: {
                        v = this.cstmt.getBigDecimal(pos);
                        break;
                    }
                    case 5: {
                        v = this.cstmt.getLong(pos);
                        break;
                    }
                    case 2: {
                        v = this.cstmt.getString(pos);
                        break;
                    }
                    case 8: {
                        if (this.databaseMeta.supportsGetBlob()) {
                            Blob blob = this.cstmt.getBlob(pos);
                            if (blob != null) {
                                v = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            v = null;
                            break;
                        }
                        v = this.cstmt.getBytes(pos);
                        break;
                    }
                    case 3: {
                        v = this.databaseMeta.supportsTimeStampToDateConversion() ? this.cstmt.getTimestamp(pos) : this.cstmt.getDate(pos);
                    }
                }
                ret.addValue(vMeta, v);
                ++pos;
            }
            for (int i = 0; i < arg.length; ++i) {
                if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase("INOUT")) continue;
                ValueMeta vMeta = new ValueMeta(arg[i], argtype[i]);
                Object v = null;
                switch (argtype[i]) {
                    case 4: {
                        v = this.cstmt.getBoolean(pos + i);
                        break;
                    }
                    case 1: {
                        v = new Double(this.cstmt.getDouble(pos + i));
                        break;
                    }
                    case 6: {
                        v = this.cstmt.getBigDecimal(pos + i);
                        break;
                    }
                    case 5: {
                        v = this.cstmt.getLong(pos + i);
                        break;
                    }
                    case 2: {
                        v = this.cstmt.getString(pos + i);
                        break;
                    }
                    case 8: {
                        if (this.databaseMeta.supportsGetBlob()) {
                            Blob blob = this.cstmt.getBlob(pos + i);
                            if (blob != null) {
                                v = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            v = null;
                            break;
                        }
                        v = this.cstmt.getBytes(pos + i);
                        break;
                    }
                    case 3: {
                        v = this.databaseMeta.supportsTimeStampToDateConversion() ? this.cstmt.getTimestamp(pos + i) : this.cstmt.getDate(pos + i);
                    }
                }
                ret.addValue(vMeta, v);
            }
            return ret;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to call procedure", (Throwable)ex);
        }
    }

    public String getDDLCreationTable(String tableName, RowMetaInterface fields) throws KettleDatabaseException {
        this.databaseMeta.quoteReservedWords(fields);
        String quotedTk = this.databaseMeta.quoteField(null);
        String retval = this.getCreateTableStatement(tableName, fields, quotedTk, false, null, true);
        return retval;
    }

    public String getDDLTruncateTable(String schema, String tablename) throws KettleDatabaseException {
        if (Const.isEmpty((String)this.connectionGroup)) {
            return this.databaseMeta.getTruncateTableStatement(schema, tablename);
        }
        return "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(schema, tablename);
    }

    public String getSQLOutput(String schemaName, String tableName, RowMetaInterface fields, Object[] r, String dateFormat) throws KettleDatabaseException {
        StringBuffer ins = new StringBuffer(128);
        try {
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
            ins.append("INSERT INTO ").append(schemaTable).append('(');
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    ins.append(", ");
                }
                String name = fields.getValueMeta(i).getName();
                ins.append(this.databaseMeta.quoteField(name));
            }
            ins.append(") VALUES (");
            SimpleDateFormat[] fieldDateFormatters = new SimpleDateFormat[fields.size()];
            block15: for (int i = 0; i < fields.size(); ++i) {
                ValueMetaInterface valueMeta = fields.getValueMeta(i);
                Object valueData = r[i];
                if (i > 0) {
                    ins.append(",");
                }
                if (valueMeta.isNull(valueData)) {
                    ins.append("null");
                    continue;
                }
                switch (valueMeta.getType()) {
                    case 2: 
                    case 4: {
                        String string = valueMeta.getString(valueData);
                        if (string.contains("'")) {
                            switch (this.databaseMeta.getDatabaseType()) {
                                case 1: {
                                    string = string.replace("'", "\\'");
                                    break;
                                }
                                default: {
                                    string.replace("'", "''");
                                }
                            }
                        }
                        ins.append("'" + string + "'");
                        continue block15;
                    }
                    case 3: {
                        java.util.Date date = fields.getDate(r, i);
                        if (Const.isEmpty((String)dateFormat)) {
                            switch (this.databaseMeta.getDatabaseType()) {
                                case 2: {
                                    if (fieldDateFormatters[i] == null) {
                                        fieldDateFormatters[i] = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                    }
                                    ins.append("TO_DATE('").append(fieldDateFormatters[i].format(date)).append("', 'YYYY/MM/DD HH24:MI:SS')");
                                    continue block15;
                                }
                            }
                            ins.append("'" + fields.getString(r, i) + "'");
                            continue block15;
                        }
                        try {
                            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                            ins.append("'" + formatter.format(fields.getDate(r, i)) + "'");
                            continue block15;
                        }
                        catch (Exception e) {
                            throw new KettleDatabaseException("Error : ", (Throwable)e);
                        }
                    }
                    default: {
                        ins.append(fields.getString(r, i));
                    }
                }
            }
            ins.append(')');
        }
        catch (Exception e) {
            throw new KettleDatabaseException((Throwable)e);
        }
        return ins.toString();
    }

    public Savepoint setSavepoint() throws KettleDatabaseException {
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(Messages.getString("Database.Exception.UnableToSetSavepoint"), (Throwable)e);
        }
    }

    public Savepoint setSavepoint(String savePointName) throws KettleDatabaseException {
        try {
            return this.connection.setSavepoint(savePointName);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(Messages.getString("Database.Exception.UnableToSetSavepointName", savePointName), (Throwable)e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws KettleDatabaseException {
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(Messages.getString("Database.Exception.UnableToReleaseSavepoint"), (Throwable)e);
        }
    }

    public void rollback(Savepoint savepoint) throws KettleDatabaseException {
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(Messages.getString("Database.Exception.UnableToRollbackToSavepoint"), (Throwable)e);
        }
    }
}

