/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Function;
import org.gradle.cache.FileAccess;
import org.gradle.cache.FileIntegrityViolationException;
import org.gradle.cache.FileLock;
import org.gradle.cache.MultiProcessSafeIndexedCache;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factory;

public class DefaultMultiProcessSafeIndexedCache<K, V>
implements MultiProcessSafeIndexedCache<K, V> {
    private final FileAccess fileAccess;
    private final Factory<BTreePersistentIndexedCache<K, V>> factory;
    private BTreePersistentIndexedCache<K, V> cache;

    public DefaultMultiProcessSafeIndexedCache(Factory<BTreePersistentIndexedCache<K, V>> factory, FileAccess fileAccess) {
        this.factory = factory;
        this.fileAccess = fileAccess;
    }

    public String toString() {
        return this.fileAccess.toString();
    }

    @Override
    public V getIfPresent(K key) {
        BTreePersistentIndexedCache cache = this.getCache();
        try {
            return (V)this.fileAccess.readFile(() -> cache.get(key));
        }
        catch (FileIntegrityViolationException e) {
            return null;
        }
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> producer) {
        V value = this.getIfPresent(key);
        if (value == null) {
            value = producer.apply(key);
            this.put(key, value);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        BTreePersistentIndexedCache cache = this.getCache();
        this.fileAccess.writeFile(() -> cache.put(key, value));
    }

    @Override
    public void remove(K key) {
        BTreePersistentIndexedCache cache = this.getCache();
        this.fileAccess.writeFile(() -> cache.remove(key));
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
    }

    @Override
    public void finishWork() {
        if (this.cache != null) {
            try {
                this.fileAccess.writeFile(() -> this.cache.close());
            }
            finally {
                this.cache = null;
            }
        }
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
    }

    private BTreePersistentIndexedCache<K, V> getCache() {
        if (this.cache == null) {
            this.fileAccess.writeFile(() -> {
                this.cache = (BTreePersistentIndexedCache)this.factory.create();
            });
        }
        return this.cache;
    }
}

