/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeArrayIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class TextFragmentValue
implements DocumentInfo,
FingerprintedNode,
SourceLocator {
    private CharSequence text;
    private String baseURI;
    private TextFragmentTextNode textNode = null;
    private Configuration config;
    private int documentNumber;

    public TextFragmentValue(CharSequence value, String baseURI) {
        this.text = value;
        this.baseURI = baseURI;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = -1;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        if (this.documentNumber == -1) {
            this.documentNumber = this.config.getDocumentNumberAllocator().allocateDocumentNumber();
        }
        return this.documentNumber;
    }

    public final int getNodeKind() {
        return 9;
    }

    public String getStringValue() {
        return ((Object)this.text).toString();
    }

    public CharSequence getStringValueCS() {
        return this.text;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append("tt");
        buffer.append(Integer.toString(this.getDocumentNumber()));
    }

    public void setSystemId(String systemId) {
        throw new UnsupportedOperationException("A temporary tree does not have a document URI");
    }

    public String getSystemId() {
        return null;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int compareOrder(NodeInfo other) {
        if (this == other) {
            return 0;
        }
        return -1;
    }

    public int getNameCode() {
        return -1;
    }

    public int getFingerprint() {
        return -1;
    }

    public String getPrefix() {
        return "";
    }

    public String getURI() {
        return "";
    }

    public String getDisplayName() {
        return "";
    }

    public String getLocalPart() {
        return "";
    }

    public boolean hasChildNodes() {
        return !"".equals(this.text);
    }

    public int getLineNumber() {
        return -1;
    }

    public int getTypeAnnotation() {
        return -1;
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return null;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.text));
    }

    public Value atomize() {
        return new UntypedAtomicValue(this.text);
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getAttributeValue(int fingerprint) {
        return null;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
            case 1: 
            case 12: {
                return SingleNodeIterator.makeIterator(this);
            }
            case 3: 
            case 4: {
                return SingleNodeIterator.makeIterator(this.getTextNode());
            }
            case 5: {
                NodeInfo[] nodes = new NodeInfo[]{this, this.getTextNode()};
                return new NodeArrayIterator(nodes);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
            case 1: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 3: 
            case 4: {
                return Navigator.filteredSingleton(this.getTextNode(), nodeTest);
            }
            case 5: {
                boolean b1 = nodeTest.matches(this);
                TextFragmentTextNode textNode2 = this.getTextNode();
                boolean b2 = nodeTest.matches(textNode2);
                if (b1) {
                    if (b2) {
                        NodeInfo[] pair = new NodeInfo[]{this, textNode2};
                        return new NodeArrayIterator(pair);
                    }
                    return SingleNodeIterator.makeIterator(this);
                }
                if (b2) {
                    return SingleNodeIterator.makeIterator(textNode2);
                }
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        out.characters(this.text, 0, 0);
    }

    public NodeInfo selectID(String id) {
        return null;
    }

    public Iterator getUnparsedEntityNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    public String[] getUnparsedEntity(String name) {
        return null;
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    private TextFragmentTextNode getTextNode() {
        if (this.textNode == null) {
            this.textNode = new TextFragmentTextNode();
        }
        return this.textNode;
    }

    private class TextFragmentTextNode
    implements NodeInfo,
    FingerprintedNode,
    SourceLocator {
        private TextFragmentTextNode() {
        }

        public void setSystemId(String systemId) {
        }

        public Configuration getConfiguration() {
            return TextFragmentValue.this.config;
        }

        public NamePool getNamePool() {
            return TextFragmentValue.this.config.getNamePool();
        }

        public final int getNodeKind() {
            return 3;
        }

        public String getStringValue() {
            return ((Object)TextFragmentValue.this.text).toString();
        }

        public CharSequence getStringValueCS() {
            return TextFragmentValue.this.text;
        }

        public boolean isSameNodeInfo(NodeInfo other) {
            return this == other;
        }

        public void generateId(FastStringBuffer buffer) {
            buffer.append("tt");
            buffer.append(Integer.toString(this.getDocumentNumber()));
            buffer.append("t1");
        }

        public String getSystemId() {
            return null;
        }

        public String getBaseURI() {
            return TextFragmentValue.this.baseURI;
        }

        public int compareOrder(NodeInfo other) {
            if (this == other) {
                return 0;
            }
            return 1;
        }

        public int getNameCode() {
            return -1;
        }

        public int getFingerprint() {
            return -1;
        }

        public String getPrefix() {
            return "";
        }

        public String getURI() {
            return "";
        }

        public String getDisplayName() {
            return "";
        }

        public String getLocalPart() {
            return "";
        }

        public boolean hasChildNodes() {
            return false;
        }

        public String getAttributeValue(int fingerprint) {
            return null;
        }

        public int getLineNumber() {
            return -1;
        }

        public int getTypeAnnotation() {
            return -1;
        }

        public int getDocumentNumber() {
            return this.getDocumentRoot().getDocumentNumber();
        }

        public int[] getDeclaredNamespaces(int[] buffer) {
            return null;
        }

        public SequenceIterator getTypedValue() throws XPathException {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(TextFragmentValue.this.text));
        }

        public Value atomize() throws XPathException {
            return new UntypedAtomicValue(TextFragmentValue.this.text);
        }

        public String getPublicId() {
            return null;
        }

        public int getColumnNumber() {
            return -1;
        }

        public AxisIterator iterateAxis(byte axisNumber) {
            switch (axisNumber) {
                case 0: 
                case 9: 
                case 13: {
                    return SingleNodeIterator.makeIterator(TextFragmentValue.this);
                }
                case 1: {
                    NodeInfo[] nodes = new NodeInfo[]{this, TextFragmentValue.this};
                    return new NodeArrayIterator(nodes);
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 5: 
                case 12: {
                    return SingleNodeIterator.makeIterator(this);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }

        public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
            switch (axisNumber) {
                case 0: 
                case 9: 
                case 13: {
                    return Navigator.filteredSingleton(TextFragmentValue.this, nodeTest);
                }
                case 1: {
                    boolean matchesDoc = nodeTest.matches(TextFragmentValue.this);
                    boolean matchesText = nodeTest.matches(this);
                    if (matchesDoc && matchesText) {
                        NodeInfo[] nodes = new NodeInfo[]{this, TextFragmentValue.this};
                        return new NodeArrayIterator(nodes);
                    }
                    if (matchesDoc && !matchesText) {
                        return SingleNodeIterator.makeIterator(TextFragmentValue.this);
                    }
                    if (matchesText && !matchesDoc) {
                        return SingleNodeIterator.makeIterator(this);
                    }
                    return EmptyIterator.getInstance();
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 5: 
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }

        public NodeInfo getParent() {
            return TextFragmentValue.this;
        }

        public NodeInfo getRoot() {
            return TextFragmentValue.this;
        }

        public DocumentInfo getDocumentRoot() {
            return TextFragmentValue.this;
        }

        public void copy(Receiver out, int namespaces, boolean copyAnnotations, int locationId) throws XPathException {
            out.characters(TextFragmentValue.this.text, 0, 0);
        }

        public boolean isId() {
            return false;
        }

        public boolean isIdref() {
            return false;
        }

        public boolean isNilled() {
            return false;
        }
    }
}

