/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.results.ResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.jdbc.JdbcResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryResultsSnapshot;
import org.graalvm.visualvm.lib.profiler.Bundle;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.ProfilerTopComponent;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.SaveSnapshotAction;
import org.graalvm.visualvm.lib.profiler.SnapshotInfoAction;
import org.graalvm.visualvm.lib.profiler.SnapshotsListener;
import org.graalvm.visualvm.lib.profiler.actions.CompareSnapshotsAction;
import org.graalvm.visualvm.lib.profiler.api.ActionsSupport;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerFeature;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerSession;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.cpu.SnapshotCPUView;
import org.graalvm.visualvm.lib.ui.jdbc.SnapshotJDBCView;
import org.graalvm.visualvm.lib.ui.memory.SnapshotMemoryView;
import org.graalvm.visualvm.lib.ui.swing.ExportUtils;
import org.netbeans.spi.actions.AbstractSavable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class SnapshotResultsWindow
extends ProfilerTopComponent {
    private static final byte PERSISTENCE_VERSION_MAJOR = 8;
    private static final byte PERSISTENCE_VERSION_MINOR = 1;
    private static final String HELP_CTX_KEY_CPU = "CpuSnapshot.HelpCtx";
    private static final String HELP_CTX_KEY_MEM = "MemorySnapshot.HelpCtx";
    private static final Image WINDOW_ICON_CPU = Icons.getImage((String)"ProfilerIcons.Cpu");
    private static final Image WINDOW_ICON_FRAGMENT = Icons.getImage((String)"ProfilerIcons.Fragment");
    private static final Image WINDOW_ICON_MEMORY = Icons.getImage((String)"ProfilerIcons.Memory");
    private static final Image WINDOW_ICON_JDBC = Icons.getImage((String)"ProfilerIcons.WindowSql");
    private static final HashMap windowsList = new HashMap();
    private LoadedSnapshot snapshot;
    private InstanceContent ic = new InstanceContent();
    private SavePerformer savePerformer = new SavePerformer();
    private JPanel displayedPanel;
    private String tabName = "";
    private SnapshotListener listener;
    private boolean forcedClose = false;
    private HelpCtx helpCtx = HelpCtx.DEFAULT_HELP;

    public SnapshotResultsWindow() {
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.ic));
        this.ic.add((Object)this.getActionMap());
        this.setLayout(new BorderLayout());
    }

    public SnapshotResultsWindow(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        this();
        this.initImpl(ls);
    }

    private void initImpl(LoadedSnapshot ls) {
        this.snapshot = ls;
        this.updateSaveState();
        this.setOpaque(false);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.refreshTabName();
        switch (this.snapshot.getType()) {
            case 1: {
                this.setIcon(WINDOW_ICON_CPU);
                this.helpCtx = new HelpCtx(HELP_CTX_KEY_CPU);
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_CpuSnapshotAccessDescr());
                this.setupCPUResultsView();
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                this.setIcon(WINDOW_ICON_MEMORY);
                this.helpCtx = new HelpCtx(HELP_CTX_KEY_MEM);
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_MemorySnapshotAccessDescr());
                this.setupMemoryResultsView();
                break;
            }
            case 32: {
                this.setIcon(WINDOW_ICON_JDBC);
                this.helpCtx = new HelpCtx(HELP_CTX_KEY_CPU);
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_CpuSnapshotAccessDescr());
                this.setupJDBCResultsView();
            }
        }
        if (this.displayedPanel != null) {
            this.add(this.displayedPanel, "Center");
            this.invalidate();
            this.doLayout();
            this.repaint();
        }
        this.listener = (SnapshotListener)Lookup.getDefault().lookup(SnapshotListener.class);
        this.listener.registerSnapshotResultsWindow(this);
    }

    public static synchronized void closeAllWindows() {
        Collection windows = windowsList.values();
        if (!windows.isEmpty()) {
            SnapshotResultsWindow[] toClose;
            for (SnapshotResultsWindow snapshotResultsWindow : toClose = windows.toArray(new SnapshotResultsWindow[0])) {
                snapshotResultsWindow.forcedClose();
            }
        }
    }

    public static synchronized void closeWindow(LoadedSnapshot snapshot) {
        SnapshotResultsWindow win = (SnapshotResultsWindow)((Object)windowsList.get(snapshot));
        if (win != null) {
            win.forcedClose();
        }
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot ls) {
        return SnapshotResultsWindow.get(ls, -1, false);
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        SnapshotResultsWindow win = (SnapshotResultsWindow)((Object)windowsList.get(ls));
        if (win == null) {
            win = new SnapshotResultsWindow(ls, sortingColumn, sortingOrder);
            windowsList.put(ls, win);
        }
        return win;
    }

    public static synchronized boolean hasSnapshotWindow(LoadedSnapshot ls) {
        return windowsList.get(ls) != null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(8);
        out.writeByte(1);
        out.writeUTF(Utilities.toURI((File)this.snapshot.getFile()).toString());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.add(new JLabel(Bundle.SnapshotResultsWindow_LoadingProgress(), 0), "Center");
            this.invalidate();
            this.doLayout();
            this.repaint();
            super.readExternal(in);
            in.readByte();
            in.readByte();
            URI uri = new URI(in.readUTF());
            final File file = Utilities.toFile((URI)uri);
            new RequestProcessor("NPS loader for " + this.getName()).post(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileObject fileo = FileUtil.toFileObject((File)file);
                        final LoadedSnapshot ls = ResultsManager.getDefault().loadSnapshot(fileo);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SnapshotResultsWindow.this.removeAll();
                                SnapshotResultsWindow.this.initImpl(ls);
                            }
                        });
                    }
                    catch (Throwable t) {
                        SnapshotResultsWindow.this.handleReadThrowable(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.handleReadThrowable(t);
        }
    }

    private void handleReadThrowable(Throwable t) {
        ProfilerLogger.info((String)("Restoring profiler snapshot failed: " + t.getMessage()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotResultsWindow.this.close();
            }
        });
    }

    public int getPersistenceType() {
        return ProfilerIDESettings.getInstance().getReopenSnapshots() ? 1 : 2;
    }

    public HelpCtx getHelpCtx() {
        return this.helpCtx;
    }

    public boolean canClose() {
        if (this.snapshot == null) {
            return true;
        }
        File file = this.snapshot.getFile();
        if (file != null) {
            this.putClientProperty("nb.recent.file.path", file);
        }
        if (this.forcedClose) {
            this.savePerformer.remove();
            return true;
        }
        if (this.snapshot.isSaved()) {
            return true;
        }
        Boolean ret = ProfilerDialogs.displayCancellableConfirmationDNSA((String)Bundle.SnapshotResultsWindow_SaveSnapshotDialogMsg(), null, null, (String)"org.graalvm.visualvm.lib.profiler.SnapshotResultsWindow.canClose", (boolean)false);
        if (Boolean.TRUE.equals(ret)) {
            try {
                this.savePerformer.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }
        if (Boolean.FALSE.equals(ret)) {
            this.savePerformer.remove();
            return true;
        }
        return false;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.displayedPanel == null ? this : this.displayedPanel;
    }

    public void refreshTabName() {
        this.tabName = ResultsManager.getDefault().getSnapshotDisplayName(this.snapshot);
        File snapshotFile = this.snapshot.getFile();
        if (snapshotFile != null) {
            this.setToolTipText(snapshotFile.getAbsolutePath());
        }
        this.updateTitle();
    }

    public void updateTitle() {
        if (this.snapshot.isSaved()) {
            this.setName(this.tabName);
        } else {
            this.setName(this.tabName + " *");
        }
        if (this.snapshot.getFile() != null) {
            this.setToolTipText(this.snapshot.getFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        if (this.snapshot == null) {
            return;
        }
        Class<SnapshotResultsWindow> clazz = SnapshotResultsWindow.class;
        synchronized (SnapshotResultsWindow.class) {
            windowsList.remove(this.snapshot);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ResultsManager.getDefault().closeSnapshot(this.snapshot);
            this.snapshot = null;
            this.listener.unregisterSnapshotResultsWindow(this);
            return;
        }
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    boolean setRefSnapshot(LoadedSnapshot ls) {
        ResultsSnapshot s;
        ResultsSnapshot resultsSnapshot = s = ls == null ? null : ls.getSnapshot();
        if (this.displayedPanel instanceof SnapshotCPUView && s instanceof CPUResultsSnapshot) {
            ((SnapshotCPUView)this.displayedPanel).setRefSnapshot((CPUResultsSnapshot)s);
            return true;
        }
        if (this.displayedPanel instanceof SnapshotMemoryView && s instanceof MemoryResultsSnapshot) {
            ((SnapshotMemoryView)this.displayedPanel).setRefSnapshot((MemoryResultsSnapshot)s);
            return true;
        }
        if (this.displayedPanel instanceof SnapshotJDBCView && s instanceof JdbcResultsSnapshot) {
            ((SnapshotJDBCView)this.displayedPanel).setRefSnapshot((JdbcResultsSnapshot)s);
            return true;
        }
        return false;
    }

    private void setupCPUResultsView() {
        ResultsSnapshot _snapshot = this.snapshot.getSnapshot();
        if (_snapshot instanceof CPUResultsSnapshot) {
            CPUResultsSnapshot s = (CPUResultsSnapshot)_snapshot;
            boolean sampling = this.snapshot.getSettings().getCPUProfilingType() == 2;
            SaveSnapshotAction aSave = new SaveSnapshotAction(this.snapshot);
            CompareSnapshotsAction aCompare = new CompareSnapshotsAction(this.snapshot);
            SnapshotInfoAction aInfo = new SnapshotInfoAction(this.snapshot);
            ExportUtils.Exportable exporter = ResultsManager.getDefault().createSnapshotExporter(this.snapshot);
            final SnapshotCPUView _cpuSnapshot = new SnapshotCPUView(s, sampling, aSave, aCompare, aInfo, exporter){

                protected boolean showSourceSupported() {
                    return GoToSource.isAvailable();
                }

                protected boolean profileMethodSupported() {
                    return ProfilerFeature.Registry.hasProviders();
                }

                protected boolean profileClassSupported() {
                    return ProfilerFeature.Registry.hasProviders();
                }

                protected void showSource(ClientUtils.SourceCodeSelection value) {
                    Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                    String className = value.getClassName();
                    String methodName = value.getMethodName();
                    String methodSig = value.getMethodSignature();
                    GoToSource.openSource((Lookup.Provider)project, (String)className, (String)methodName, (String)methodSig);
                }

                protected void selectForProfiling(final ClientUtils.SourceCodeSelection value) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                            String name = "*".equals(value.getMethodName()) ? Bundle.SnapshotResultsWindow_ProfileClass() : Bundle.SnapshotResultsWindow_ProfileMethod();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{value}), project, name);
                        }
                    });
                }
            };
            aCompare.setPerformer(new CompareSnapshotsAction.Performer(){

                @Override
                public void compare(LoadedSnapshot snapshot) {
                    _cpuSnapshot.setRefSnapshot((CPUResultsSnapshot)snapshot.getSnapshot());
                }
            });
            this.registerActions((JComponent)_cpuSnapshot);
            this.displayedPanel = _cpuSnapshot;
        }
    }

    private void setupMemoryResultsView() {
        ResultsSnapshot _snapshot = this.snapshot.getSnapshot();
        if (_snapshot instanceof MemoryResultsSnapshot) {
            GenericFilter filter = this.snapshot.getSettings().getInstrumentationFilter();
            if (filter != null && filter.isEmpty()) {
                filter = null;
            }
            MemoryResultsSnapshot s = (MemoryResultsSnapshot)_snapshot;
            SaveSnapshotAction aSave = new SaveSnapshotAction(this.snapshot);
            CompareSnapshotsAction aCompare = new CompareSnapshotsAction(this.snapshot);
            SnapshotInfoAction aInfo = new SnapshotInfoAction(this.snapshot);
            ExportUtils.Exportable exporter = ResultsManager.getDefault().createSnapshotExporter(this.snapshot);
            final SnapshotMemoryView _memorySnapshot = new SnapshotMemoryView(s, filter, aSave, aCompare, aInfo, exporter){

                protected boolean showSourceSupported() {
                    return GoToSource.isAvailable();
                }

                protected boolean profileMethodSupported() {
                    return ProfilerFeature.Registry.hasProviders();
                }

                protected boolean profileClassSupported() {
                    return ProfilerFeature.Registry.hasProviders();
                }

                protected void showSource(ClientUtils.SourceCodeSelection value) {
                    Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                    String className = value.getClassName();
                    String methodName = value.getMethodName();
                    String methodSig = value.getMethodSignature();
                    GoToSource.openSource((Lookup.Provider)project, (String)className, (String)methodName, (String)methodSig);
                }

                protected void selectForProfiling(final ClientUtils.SourceCodeSelection value) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{value}), project, Bundle.SnapshotResultsWindow_ProfileClass());
                        }
                    });
                }
            };
            aCompare.setPerformer(new CompareSnapshotsAction.Performer(){

                @Override
                public void compare(LoadedSnapshot snapshot) {
                    _memorySnapshot.setRefSnapshot((MemoryResultsSnapshot)snapshot.getSnapshot());
                }
            });
            this.registerActions((JComponent)_memorySnapshot);
            this.displayedPanel = _memorySnapshot;
        }
    }

    private void setupJDBCResultsView() {
        ResultsSnapshot _snapshot = this.snapshot.getSnapshot();
        if (_snapshot instanceof JdbcResultsSnapshot) {
            JdbcResultsSnapshot s = (JdbcResultsSnapshot)_snapshot;
            SaveSnapshotAction aSave = new SaveSnapshotAction(this.snapshot);
            CompareSnapshotsAction aCompare = new CompareSnapshotsAction(this.snapshot);
            SnapshotInfoAction aInfo = new SnapshotInfoAction(this.snapshot);
            ExportUtils.Exportable exporter = ResultsManager.getDefault().createSnapshotExporter(this.snapshot);
            final SnapshotJDBCView _jdbcSnapshot = new SnapshotJDBCView(s, aSave, aCompare, aInfo, exporter){

                protected boolean showSourceSupported() {
                    return GoToSource.isAvailable();
                }

                protected void showSource(ClientUtils.SourceCodeSelection value) {
                    Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                    String className = value.getClassName();
                    String methodName = value.getMethodName();
                    String methodSig = value.getMethodSignature();
                    GoToSource.openSource((Lookup.Provider)project, (String)className, (String)methodName, (String)methodSig);
                }

                protected void showSQLQuery(String query, String htmlQuery) {
                    HTMLTextArea area = new HTMLTextArea(htmlQuery);
                    JScrollPane areaScroll = new JScrollPane((Component)area);
                    areaScroll.setPreferredSize(new Dimension(500, 250));
                    JLabel label = new JLabel(Bundle.SnapshotResultsWindow_SqlQueryLabel(), 10);
                    label.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                    label.setLabelFor((Component)area);
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add((Component)label, "North");
                    panel.add((Component)areaScroll, "Center");
                    panel.setBorder(BorderFactory.createEmptyBorder(12, 10, 0, 10));
                    HelpCtx help = new HelpCtx("SqlQueryViewer.HelpCtx");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)panel, Bundle.SnapshotResultsWindow_SqlQueryCaption(), false, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, help, null));
                }

                protected void selectForProfiling(final ClientUtils.SourceCodeSelection value) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                            String name = "*".equals(value.getMethodName()) ? Bundle.SnapshotResultsWindow_ProfileClass() : Bundle.SnapshotResultsWindow_ProfileMethod();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{value}), project, name);
                        }
                    });
                }
            };
            aCompare.setPerformer(new CompareSnapshotsAction.Performer(){

                @Override
                public void compare(LoadedSnapshot snapshot) {
                    _jdbcSnapshot.setRefSnapshot((JdbcResultsSnapshot)snapshot.getSnapshot());
                }
            });
            this.registerActions((JComponent)_jdbcSnapshot);
            this.displayedPanel = _jdbcSnapshot;
        }
    }

    private void forcedClose() {
        this.forcedClose = true;
        this.close();
    }

    private void registerActions(final JComponent view) {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = view.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
        String findKey = "find-action-key";
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = view.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
    }

    private void updateSaveState() {
        if (this.snapshot != null) {
            if (this.snapshot.isSaved()) {
                this.savePerformer.remove();
            } else {
                this.savePerformer.add();
            }
        } else {
            this.savePerformer.remove();
        }
    }

    private class SavePerformer
    extends AbstractSavable {
        private SavePerformer() {
        }

        private void add() {
            this.register();
            SnapshotResultsWindow.this.ic.add((Object)this);
        }

        private void remove() {
            this.unregister();
            SnapshotResultsWindow.this.ic.remove((Object)this);
        }

        protected String findDisplayName() {
            return SnapshotResultsWindow.this.tabName;
        }

        protected void handleSave() {
            LoadedSnapshot toSave = SnapshotResultsWindow.this.snapshot;
            if (toSave == null) {
                return;
            }
            ResultsManager.getDefault().saveSnapshot(toSave);
            SnapshotResultsWindow.this.ic.remove((Object)this);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }

    public static interface FindPerformer {
        public void performFind();

        public void performFindNext();

        public void performFindPrevious();
    }

    public static class SnapshotListener
    implements SnapshotsListener {
        List<SnapshotResultsWindow> registeredWindows;

        void registerSnapshotResultsWindow(SnapshotResultsWindow w) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows == null) {
                this.registeredWindows = new ArrayList<SnapshotResultsWindow>();
            }
            this.registeredWindows.add(w);
        }

        void unregisterSnapshotResultsWindow(SnapshotResultsWindow w) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows != null) {
                this.registeredWindows.remove((Object)w);
            }
        }

        @Override
        public void snapshotLoaded(LoadedSnapshot snapshot) {
        }

        @Override
        public void snapshotRemoved(LoadedSnapshot snapshot) {
        }

        @Override
        public void snapshotSaved(LoadedSnapshot snapshot) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows != null) {
                for (SnapshotResultsWindow w : this.registeredWindows) {
                    if (w.snapshot != snapshot) continue;
                    w.updateSaveState();
                }
            }
        }

        @Override
        public void snapshotTaken(LoadedSnapshot snapshot) {
        }
    }
}

