/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class FleetGuideProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_EMPTY = 0;
    public static final int MSG_SYNC_REQ = 1;
    public static final int MSG_SYNC_ACK = 2;
    public static final int MSG_DATA_R_ACK = 3;
    public static final int MSG_DATA_N_ACK = 4;
    public static final int MSG_REP_R_ACK = 5;
    public static final int MSG_REP_N_ACK = 6;

    public FleetGuideProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Integer index;
        int type;
        DeviceSession deviceSession;
        Long deviceId;
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        int options = buf.readUnsignedShortLE();
        int length = BitUtil.to(options, 11);
        if (BitUtil.check(options, 11)) {
            deviceId = buf.readUnsignedIntLE();
            deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(deviceId));
        } else {
            deviceId = null;
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        }
        if (deviceSession == null) {
            return null;
        }
        if (BitUtil.check(options, 12)) {
            short value = buf.readUnsignedByte();
            type = BitUtil.to(value, 4);
            index = BitUtil.from(value, 4);
        } else {
            type = 0;
            index = null;
        }
        if (type != 4 && type != 6) {
            Integer responseType = type == 1 ? Integer.valueOf(2) : null;
            this.sendResponse(channel, remoteAddress, deviceId, responseType, index);
        }
        if (BitUtil.check(options, 13)) {
            buf.readUnsignedShortLE();
        }
        ByteBuf data = BitUtil.check(options, 14) ? this.decompress(buf.readSlice(length)) : buf.readRetainedSlice(length);
        LinkedList<Position> positions = new LinkedList<Position>();
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        while (data.isReadable()) {
            int recordHeader = data.readUnsignedShortLE();
            int recordLength = BitUtil.to(recordHeader, 10);
            int recordType = BitUtil.from(recordHeader, 10);
            int recordEndIndex = data.readerIndex() + recordLength;
            if (recordType == 0 && position.getDeviceTime() != null) {
                this.processPosition(positions, position);
                position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
            }
            switch (recordType) {
                case 0: {
                    position.setTime(new Date((data.readUnsignedIntLE() + 1262304000L) * 1000L));
                    break;
                }
                case 1: {
                    position.setLatitude((double)data.readUnsignedIntLE() * 90.0 / 4.294967295E9);
                    position.setLongitude((double)data.readUnsignedIntLE() * 180.0 / 4.294967295E9);
                    int speed = data.readUnsignedShortLE();
                    position.setSpeed(UnitsConverter.knotsFromKph((double)BitUtil.to(speed, 14) * 0.1));
                    if (BitUtil.check(speed, 14)) {
                        position.setLatitude(-position.getLatitude());
                    }
                    if (BitUtil.check(speed, 15)) {
                        position.setLongitude(-position.getLongitude());
                    }
                    int course = data.readUnsignedShortLE();
                    position.setSpeed(BitUtil.to(course, 9));
                    int motion = BitUtil.between(course, 9, 11);
                    if (motion > 0) {
                        position.set("motion", motion == 1);
                    }
                    position.set("sat", BitUtil.from(course, 11));
                    int altitude = data.readUnsignedShortLE();
                    position.setAltitude(BitUtil.to(altitude, 14));
                    if (!BitUtil.check(altitude, 14)) break;
                    position.setAltitude(-position.getAltitude());
                    break;
                }
                case 3: {
                    short powerLow = data.readUnsignedByte();
                    short powerFlags = data.readUnsignedByte();
                    short batteryHigh = data.readUnsignedByte();
                    position.set("power", (double)(powerLow + (BitUtil.to(powerFlags, 5) << 8)) * 0.01);
                    position.set("ignition", BitUtil.check(powerFlags, 5));
                    position.set("battery", (double)(BitUtil.from(powerFlags, 6) + (batteryHigh << 2)) * 0.01);
                    if (recordLength < 4) break;
                    short extraFlags = data.readUnsignedByte();
                    if (BitUtil.check(extraFlags, 0)) {
                        position.set("alarm", "lowPower");
                    }
                    if (!BitUtil.check(extraFlags, 1)) break;
                    position.set("alarm", "lowBattery");
                    break;
                }
                case 6: {
                    position.set("input", data.readUnsignedByte());
                    break;
                }
                case 7: {
                    position.set("output", data.readUnsignedByte());
                    break;
                }
                case 8: {
                    short adcMask = data.readUnsignedByte();
                    for (int i = 0; i < 8; ++i) {
                        if (!BitUtil.check(adcMask, i)) continue;
                        position.set("adc" + (i + 1), data.readUnsignedShortLE());
                    }
                    break;
                }
                case 11: {
                    short fuelMask = data.readUnsignedByte();
                    for (int i = 1; i < 8; ++i) {
                        if (!BitUtil.check(fuelMask, i)) continue;
                        position.set("fuel" + i, data.readUnsignedShortLE());
                    }
                    break;
                }
                case 12: {
                    short fuelTempMask = data.readUnsignedByte();
                    for (int i = 1; i < 8; ++i) {
                        if (!BitUtil.check(fuelTempMask, i)) continue;
                        position.set("fuelTemp" + i, Integer.valueOf(data.readByte()));
                    }
                    break;
                }
                case 13: {
                    short tempMask = data.readUnsignedByte();
                    for (int i = 0; i < 8; ++i) {
                        if (!BitUtil.check(tempMask, i)) continue;
                        position.set("temp" + (i + 1), (double)data.readShortLE() * 0.01);
                    }
                    break;
                }
                case 18: {
                    short sensorIndex = data.readUnsignedByte();
                    switch (recordLength - 1) {
                        case 1: {
                            position.set("sensor" + sensorIndex, data.readUnsignedByte());
                            break;
                        }
                        case 2: {
                            position.set("sensor" + sensorIndex, data.readUnsignedShortLE());
                            break;
                        }
                        case 4: {
                            position.set("sensor" + sensorIndex, data.readUnsignedIntLE());
                        }
                    }
                    break;
                }
            }
            data.readerIndex(recordEndIndex);
        }
        this.processPosition(positions, position);
        data.release();
        return positions.isEmpty() ? null : positions;
    }

    private void processPosition(List<Position> positions, Position position) {
        if (!position.getAttributes().isEmpty()) {
            if (position.getFixTime() == null) {
                position.setTime(new Date());
            }
            if (!position.getAttributes().containsKey("sat")) {
                this.getLastLocation(position, null);
            }
            positions.add(position);
        }
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, Long deviceId, Integer type, Integer index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(83);
            int options = 0;
            if (deviceId != null) {
                options |= 0x800;
            }
            if (type != null) {
                options |= 0x1000;
            }
            if (index != null) {
                options |= 0x2000;
            }
            response.writeShortLE(options);
            if (deviceId != null) {
                response.writeIntLE(deviceId.intValue());
            }
            if (type != null) {
                response.writeByte(type.intValue());
            }
            if (index != null) {
                int mask = (1 << index + 1) - 1;
                response.writeShortLE(mask);
            }
            response.writeShortLE(Checksum.crc16(Checksum.CRC16_CCITT_FALSE, response.nioBuffer(1, response.writerIndex() - 1)));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private int readVarSize(ByteBuf buf) {
        short b;
        int y = 0;
        do {
            b = buf.readUnsignedByte();
            y = y << 7 | b & 0x7F;
        } while ((b & 0x80) > 0);
        return y;
    }

    private ByteBuf decompress(ByteBuf in) {
        ByteBuf out = Unpooled.buffer();
        if (in.readableBytes() < 1) {
            return out;
        }
        short marker = in.readUnsignedByte();
        do {
            short symbol;
            if ((symbol = in.readUnsignedByte()) == marker) {
                if (in.getUnsignedByte(in.readerIndex()) == 0) {
                    out.writeByte((int)marker);
                    in.skipBytes(1);
                    continue;
                }
                int length = this.readVarSize(in);
                int offset = this.readVarSize(in);
                for (int i = 0; i < length; ++i) {
                    out.writeByte((int)out.getUnsignedByte(out.writerIndex() - offset));
                }
            } else {
                out.writeByte((int)symbol);
            }
        } while (in.isReadable());
        return out;
    }
}

