/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.BadRandom;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.constants.AuthzDataFormat;
import de.rub.nds.tlsattacker.core.constants.CertificateStatusRequestType;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EsniDnsKeyRecordVersion;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.HeartbeatMode;
import de.rub.nds.tlsattacker.core.constants.MaxFragmentLength;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.PskKeyExchangeMode;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.SrtpProtectionProfiles;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.constants.TokenBindingVersion;
import de.rub.nds.tlsattacker.core.constants.UserMappingExtensionHintType;
import de.rub.nds.tlsattacker.core.crypto.MessageDigestCollector;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.dtls.FragmentManager;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.exceptions.TransportHandlerConnectException;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.cachedinfo.CachedObject;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.SNIEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.statusrequestv2.RequestItemV2;
import de.rub.nds.tlsattacker.core.protocol.message.extension.trustedauthority.TrustedAuthority;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.layer.RecordLayer;
import de.rub.nds.tlsattacker.core.record.layer.RecordLayerFactory;
import de.rub.nds.tlsattacker.core.record.layer.RecordLayerType;
import de.rub.nds.tlsattacker.core.state.Keylogfile;
import de.rub.nds.tlsattacker.core.state.Session;
import de.rub.nds.tlsattacker.core.state.http.HttpContext;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.core.workflow.chooser.ChooserFactory;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.TransportHandlerFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.annotation.XmlTransient;
import org.bouncycastle.crypto.tls.Certificate;

public class TlsContext {
    private Config config;
    private List<Session> sessionList;
    private HttpContext httpContext;
    @XmlTransient
    private Keylogfile keylogfile;
    private AliasedConnection connection;
    private byte[] handshakeSecret;
    private byte[] clientHandshakeTrafficSecret;
    private byte[] serverHandshakeTrafficSecret;
    private byte[] clientApplicationTrafficSecret;
    private byte[] serverApplicationTrafficSecret;
    private byte[] clientEarlyTrafficSecret;
    private CipherSuite earlyDataCipherSuite;
    private byte[] earlySecret;
    private List<PskSet> pskSets;
    private byte[] psk;
    private byte[] earlyDataPsk;
    private byte[] earlyDataPSKIdentity;
    private int selectedIdentityIndex;
    private List<PskKeyExchangeMode> clientPskKeyExchangeModes;
    private long maxEarlyDataSize;
    private byte[] masterSecret;
    private byte[] clearKey;
    private byte[] preMasterSecret;
    private byte[] clientExtendedRandom;
    private byte[] serverExtendedRandom;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private CipherSuite selectedCipherSuite = null;
    private SSL2CipherSuite ssl2CipherSuite = null;
    private CompressionMethod selectedCompressionMethod;
    private byte[] serverSessionId;
    private byte[] clientSessionId;
    private byte[] ssl2Iv;
    private Certificate serverCertificate;
    private Certificate clientCertificate;
    private MessageDigestCollector digest;
    private RecordLayer recordLayer;
    private TransportHandler transportHandler;
    private ConnectionEndType talkingConnectionEndType = ConnectionEndType.CLIENT;
    private byte[] dtlsCookie;
    private ProtocolVersion selectedProtocolVersion;
    private ProtocolVersion highestClientProtocolVersion;
    private List<CipherSuite> clientSupportedCiphersuites;
    private List<CompressionMethod> clientSupportedCompressions;
    private List<SignatureAndHashAlgorithm> serverSupportedSignatureAndHashAlgorithms;
    private List<SignatureAndHashAlgorithm> clientSupportedSignatureAndHashAlgorithms;
    private HeartbeatMode heartbeatMode;
    private MaxFragmentLength maxFragmentLength;
    private SignatureAndHashAlgorithm selectedSigHashAlgorithm;
    private boolean cachedInfoExtensionClientState;
    private List<CachedObject> cachedInfoExtensionObjects;
    private List<RequestItemV2> statusRequestV2RequestList;
    private CertificateType selectedClientCertificateType;
    private CertificateType selectedServerCertificateType;
    private byte[] paddingExtensionBytes;
    private byte[] sessionTicketTLS;
    private byte[] renegotiationInfo;
    private byte[] certificateRequestContext;
    private byte[] signedCertificateTimestamp;
    private CertificateStatusRequestType certificateStatusRequestExtensionRequestType;
    private byte[] certificateStatusRequestExtensionResponderIDList;
    private byte[] certificateStatusRequestExtensionRequestExtension;
    private byte[] secureRemotePasswordExtensionIdentifier;
    private List<SrtpProtectionProfiles> secureRealTimeTransportProtocolProtectionProfiles;
    private byte[] secureRealTimeProtocolMasterKeyIdentifier;
    private UserMappingExtensionHintType userMappingExtensionHintType;
    private List<AuthzDataFormat> clientAuthzDataFormatList;
    private List<AuthzDataFormat> serverAuthzDataFormatList;
    private BigInteger serverDhGenerator;
    private BigInteger serverDhModulus;
    private BigInteger clientDhGenerator;
    private BigInteger clientDhModulus;
    private BigInteger serverDhPrivateKey;
    private BigInteger serverDhPublicKey;
    private BigInteger clientDhPrivateKey;
    private BigInteger clientDhPublicKey;
    private BigInteger srpModulus;
    private BigInteger pskModulus;
    private BigInteger serverPSKPrivateKey;
    private BigInteger serverPSKPublicKey;
    private BigInteger pskGenerator;
    private BigInteger srpGenerator;
    private BigInteger serverSRPPublicKey;
    private BigInteger serverSRPPrivateKey;
    private BigInteger clientSRPPublicKey;
    private BigInteger clientSRPPrivateKey;
    private byte[] srpServerSalt;
    private byte[] srpPassword;
    private byte[] srpIdentity;
    private byte[] pskKey;
    private byte[] pskIdentity;
    private byte[] pskIdentityHint;
    private NamedGroup selectedGroup;
    private NamedGroup ecCertificateCurve;
    private Point clientEcPublicKey;
    private Point serverEcPublicKey;
    private BigInteger serverEcPrivateKey;
    private BigInteger clientEcPrivateKey;
    private BigInteger clientRsaModulus;
    private BigInteger serverRsaModulus;
    private BigInteger serverRSAPublicKey;
    private BigInteger clientRSAPublicKey;
    private BigInteger serverRSAPrivateKey;
    private BigInteger clientRSAPrivateKey;
    private BigInteger clientDsaPrivateKey;
    private BigInteger serverDsaPrivateKey;
    private BigInteger serverDsaPrimeP;
    private BigInteger serverDsaPrimeQ;
    private BigInteger serverDsaGenerator;
    private BigInteger serverDsaPublicKey;
    private BigInteger clientDsaPublicKey;
    private BigInteger clientDsaPrimeP;
    private BigInteger clientDsaPrimeQ;
    private BigInteger clientDsaGenerator;
    private List<NamedGroup> clientNamedGroupsList;
    private List<NamedGroup> serverNamedGroupsList;
    private List<ECPointFormat> clientPointFormatsList;
    private List<ECPointFormat> serverPointFormatsList;
    private boolean receivedFatalAlert = false;
    private List<ClientCertificateType> clientCertificateTypes;
    private byte[] distinguishedNames;
    private ProtocolVersion lastRecordVersion;
    private List<SNIEntry> clientSNIEntryList;
    private List<KeyShareStoreEntry> clientKeyShareStoreEntryList;
    private KeyShareStoreEntry serverKeyShareStoreEntry;
    private GOSTCurve selectedGostCurve;
    private Tls13KeySetType activeClientKeySetType = Tls13KeySetType.NONE;
    private Tls13KeySetType activeServerKeySetType = Tls13KeySetType.NONE;
    private long writeSequenceNumber = 0L;
    private long readSequenceNumber = 0L;
    private int dtlsReadEpoch = 0;
    private int dtlsWriteEpoch = 0;
    private int dtlsReadHandshakeMessageSequence = 0;
    private int dtlsWriteHandshakeMessageSequence = 0;
    private FragmentManager globalDtlsFragmentManager;
    private List<ProtocolVersion> clientSupportedProtocolVersions;
    private TokenBindingVersion tokenBindingVersion;
    private List<TokenBindingKeyParameters> tokenBindingKeyParameters;
    private boolean tokenBindingNegotiatedSuccessfully = false;
    private byte[] AlpnAnnouncedProtocols;
    private List<CertificateType> certificateTypeClientDesiredTypes;
    private List<CertificateType> serverCertificateTypeDesiredTypes;
    private List<CertificateType> clientCertificateTypeDesiredTypes;
    private List<TrustedAuthority> trustedCaIndicationExtensionCas;
    private SignatureAndHashAlgorithm selectedSignatureAndHashAlgorithm;
    private PRFAlgorithm prfAlgorithm;
    private RecordLayerType recordLayerType;
    private ProtocolVersion highestProtocolVersion;
    private Boolean clientAuthentication;
    private String clientPWDUsername;
    private byte[] serverPWDSalt;
    private Point PWDPE;
    private BigInteger clientPWDPrivate;
    private BigInteger serverPWDPrivate;
    private BigInteger serverPWDScalar;
    private Point serverPWDElement;
    private byte[] lastHandledApplicationMessageData;
    private byte[] lastClientVerifyData;
    private byte[] lastServerVerifyData;
    private Random random;
    @XmlTransient
    private LinkedList<ProtocolMessage> messageBuffer;
    @XmlTransient
    private LinkedList<AbstractRecord> recordBuffer;
    @XmlTransient
    private Chooser chooser;
    private final EnumSet<ExtensionType> proposedExtensionSet = EnumSet.noneOf(ExtensionType.class);
    private final EnumSet<ExtensionType> negotiatedExtensionSet = EnumSet.noneOf(ExtensionType.class);
    private boolean secureRenegotiation = false;
    private boolean useExtendedMasterSecret;
    private Boolean earlyCleanShutdown = false;
    private String httpsCookieName = null;
    private String httpsCookieValue = null;
    private boolean receivedTransportHandlerException = false;
    private boolean reversePrepareAfterParse = false;
    private byte[] esniClientNonce;
    private byte[] esniServerNonce;
    private byte[] esniRecordBytes;
    private EsniDnsKeyRecordVersion esniRecordVersion;
    private byte[] esniRecordChecksum;
    private List<KeyShareStoreEntry> esniServerKeyShareEntries;
    private List<CipherSuite> esniServerCiphersuites = new LinkedList<CipherSuite>();
    private Integer esniPaddedLength;
    private Long esniNotBefore;
    private Long esniNotAfter;
    private List<ExtensionType> esniExtensions;

    public TlsContext() {
        this(Config.createConfig());
        this.httpContext = new HttpContext();
    }

    public TlsContext(Config config) {
        RunningModeType mode = config.getDefaultRunningMode();
        if (null == mode) {
            throw new ConfigurationException("Cannot create connection, running mode not set");
        }
        switch (mode) {
            case CLIENT: {
                this.init(config, config.getDefaultClientConnection());
                break;
            }
            case SERVER: {
                this.init(config, config.getDefaultServerConnection());
                break;
            }
            default: {
                throw new ConfigurationException("Cannot create connection for unknown running mode '" + (Object)((Object)mode) + "'");
            }
        }
    }

    public TlsContext(Config config, AliasedConnection connection) {
        this.init(config, connection);
    }

    private void init(Config config, AliasedConnection connection) {
        this.config = config;
        this.digest = new MessageDigestCollector();
        this.connection = connection;
        this.recordLayerType = config.getRecordLayerType();
        this.httpContext = new HttpContext();
        this.sessionList = new LinkedList<Session>();
        this.random = new Random(0L);
        this.messageBuffer = new LinkedList();
        this.recordBuffer = new LinkedList();
        this.globalDtlsFragmentManager = new FragmentManager(config);
        this.keylogfile = new Keylogfile(this);
    }

    public Chooser getChooser() {
        if (this.chooser == null) {
            this.chooser = ChooserFactory.getChooser(this.config.getChooserType(), this, this.config);
        }
        return this.chooser;
    }

    public CertificateType getSelectedClientCertificateType() {
        return this.selectedClientCertificateType;
    }

    public void setSelectedClientCertificateType(CertificateType selectedClientCertificateType) {
        this.selectedClientCertificateType = selectedClientCertificateType;
    }

    public CertificateType getSelectedServerCertificateType() {
        return this.selectedServerCertificateType;
    }

    public void setSelectedServerCertificateType(CertificateType selectedServerCertificateType) {
        this.selectedServerCertificateType = selectedServerCertificateType;
    }

    public boolean isReversePrepareAfterParse() {
        return this.reversePrepareAfterParse;
    }

    public void setReversePrepareAfterParse(boolean reversePrepareAfterParse) {
        this.reversePrepareAfterParse = reversePrepareAfterParse;
    }

    public int getDtlsReadHandshakeMessageSequence() {
        return this.dtlsReadHandshakeMessageSequence;
    }

    public void setDtlsReadHandshakeMessageSequence(int dtlsReadHandshakeMessageSequence) {
        this.dtlsReadHandshakeMessageSequence = dtlsReadHandshakeMessageSequence;
    }

    public void increaseDtlsReadHandshakeMessageSequence() {
        ++this.dtlsReadHandshakeMessageSequence;
    }

    public void increaseDtlsWriteHandshakeMessageSequence() {
        ++this.dtlsWriteHandshakeMessageSequence;
    }

    public int getDtlsWriteHandshakeMessageSequence() {
        return this.dtlsWriteHandshakeMessageSequence;
    }

    public void setDtlsWriteHandshakeMessageSequence(int dtlsWriteHandshakeMessageSequence) {
        this.dtlsWriteHandshakeMessageSequence = dtlsWriteHandshakeMessageSequence;
    }

    public LinkedList<ProtocolMessage> getMessageBuffer() {
        return this.messageBuffer;
    }

    public void setMessageBuffer(LinkedList<ProtocolMessage> messageBuffer) {
        this.messageBuffer = messageBuffer;
    }

    public LinkedList<AbstractRecord> getRecordBuffer() {
        return this.recordBuffer;
    }

    public void setRecordBuffer(LinkedList<AbstractRecord> recordBuffer) {
        this.recordBuffer = recordBuffer;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public Session getSession(byte[] sessionId) {
        for (Session session : this.sessionList) {
            if (!Arrays.equals(session.getSessionId(), sessionId)) continue;
            return session;
        }
        return null;
    }

    public boolean hasSession(byte[] sessionId) {
        return this.getSession(sessionId) != null;
    }

    public void addNewSession(Session session) {
        this.sessionList.add(session);
    }

    public List<Session> getSessionList() {
        return this.sessionList;
    }

    public void setSessionList(List<Session> sessionList) {
        this.sessionList = sessionList;
    }

    public byte[] getLastClientVerifyData() {
        return this.lastClientVerifyData;
    }

    public void setLastClientVerifyData(byte[] lastClientVerifyData) {
        this.lastClientVerifyData = lastClientVerifyData;
    }

    public byte[] getLastServerVerifyData() {
        return this.lastServerVerifyData;
    }

    public void setLastServerVerifyData(byte[] lastServerVerifyData) {
        this.lastServerVerifyData = lastServerVerifyData;
    }

    public List<CertificateType> getCertificateTypeClientDesiredTypes() {
        return this.certificateTypeClientDesiredTypes;
    }

    public void setCertificateTypeClientDesiredTypes(List<CertificateType> certificateTypeClientDesiredTypes) {
        this.certificateTypeClientDesiredTypes = certificateTypeClientDesiredTypes;
    }

    public boolean isSecureRenegotiation() {
        return this.secureRenegotiation;
    }

    public void setSecureRenegotiation(boolean secureRenegotiation) {
        this.secureRenegotiation = secureRenegotiation;
    }

    public List<ProtocolVersion> getClientSupportedProtocolVersions() {
        return this.clientSupportedProtocolVersions;
    }

    public void setClientSupportedProtocolVersions(List<ProtocolVersion> clientSupportedProtocolVersions) {
        this.clientSupportedProtocolVersions = clientSupportedProtocolVersions;
    }

    public void setClientSupportedProtocolVersions(ProtocolVersion ... clientSupportedProtocolVersions) {
        this.clientSupportedProtocolVersions = new ArrayList<ProtocolVersion>(Arrays.asList(clientSupportedProtocolVersions));
    }

    public BigInteger getClientRsaModulus() {
        return this.clientRsaModulus;
    }

    public void setClientRsaModulus(BigInteger clientRsaModulus) {
        this.clientRsaModulus = clientRsaModulus;
    }

    public BigInteger getServerRsaModulus() {
        return this.serverRsaModulus;
    }

    public void setServerRsaModulus(BigInteger serverRsaModulus) {
        this.serverRsaModulus = serverRsaModulus;
    }

    public BigInteger getServerRSAPublicKey() {
        return this.serverRSAPublicKey;
    }

    public void setServerRSAPublicKey(BigInteger serverRSAPublicKey) {
        this.serverRSAPublicKey = serverRSAPublicKey;
    }

    public BigInteger getClientRSAPublicKey() {
        return this.clientRSAPublicKey;
    }

    public void setClientRSAPublicKey(BigInteger clientRSAPublicKey) {
        this.clientRSAPublicKey = clientRSAPublicKey;
    }

    public BigInteger getServerEcPrivateKey() {
        return this.serverEcPrivateKey;
    }

    public void setServerEcPrivateKey(BigInteger serverEcPrivateKey) {
        this.serverEcPrivateKey = serverEcPrivateKey;
    }

    public BigInteger getClientEcPrivateKey() {
        return this.clientEcPrivateKey;
    }

    public void setClientEcPrivateKey(BigInteger clientEcPrivateKey) {
        this.clientEcPrivateKey = clientEcPrivateKey;
    }

    public NamedGroup getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(NamedGroup selectedCurve) {
        this.selectedGroup = selectedCurve;
    }

    public Point getClientEcPublicKey() {
        return this.clientEcPublicKey;
    }

    public void setClientEcPublicKey(Point clientEcPublicKey) {
        this.clientEcPublicKey = clientEcPublicKey;
    }

    public Point getServerEcPublicKey() {
        return this.serverEcPublicKey;
    }

    public void setServerEcPublicKey(Point serverEcPublicKey) {
        this.serverEcPublicKey = serverEcPublicKey;
    }

    public BigInteger getSRPGenerator() {
        return this.srpGenerator;
    }

    public void setSRPGenerator(BigInteger srpGenerator) {
        this.srpGenerator = srpGenerator;
    }

    public BigInteger getSRPModulus() {
        return this.srpModulus;
    }

    public void setSRPModulus(BigInteger srpModulus) {
        this.srpModulus = srpModulus;
    }

    public byte[] getPSKIdentity() {
        return this.pskIdentity;
    }

    public void setPSKIdentity(byte[] pskIdentity) {
        this.pskIdentity = pskIdentity;
    }

    public byte[] getPSKIdentityHint() {
        return this.pskIdentityHint;
    }

    public void setPSKIdentityHint(byte[] pskIdentityHint) {
        this.pskIdentityHint = pskIdentityHint;
    }

    public BigInteger getPSKModulus() {
        return this.pskModulus;
    }

    public void setPSKModulus(BigInteger pskModulus) {
        this.pskModulus = pskModulus;
    }

    public BigInteger getServerPSKPrivateKey() {
        return this.serverPSKPrivateKey;
    }

    public void setServerPSKPrivateKey(BigInteger serverPSKPrivateKey) {
        this.serverPSKPrivateKey = serverPSKPrivateKey;
    }

    public BigInteger getServerPSKPublicKey() {
        return this.serverPSKPublicKey;
    }

    public void setServerPSKPublicKey(BigInteger serverPSKPublicKey) {
        this.serverPSKPublicKey = serverPSKPublicKey;
    }

    public BigInteger getPSKGenerator() {
        return this.pskGenerator;
    }

    public void setPSKGenerator(BigInteger pskGenerator) {
        this.pskGenerator = pskGenerator;
    }

    public BigInteger getServerSRPPublicKey() {
        return this.serverSRPPublicKey;
    }

    public void setServerSRPPublicKey(BigInteger serverSRPPublicKey) {
        this.serverSRPPublicKey = serverSRPPublicKey;
    }

    public BigInteger getServerSRPPrivateKey() {
        return this.serverSRPPrivateKey;
    }

    public void setServerSRPPrivateKey(BigInteger serverSRPPrivateKey) {
        this.serverSRPPrivateKey = serverSRPPrivateKey;
    }

    public BigInteger getClientSRPPublicKey() {
        return this.clientSRPPublicKey;
    }

    public void setClientSRPPublicKey(BigInteger clientSRPPublicKey) {
        this.clientSRPPublicKey = clientSRPPublicKey;
    }

    public BigInteger getClientSRPPrivateKey() {
        return this.clientSRPPrivateKey;
    }

    public void setClientSRPPrivateKey(BigInteger clientSRPPrivateKey) {
        this.clientSRPPrivateKey = clientSRPPrivateKey;
    }

    public byte[] getSRPServerSalt() {
        return this.srpServerSalt;
    }

    public void setSRPServerSalt(byte[] srpServerSalt) {
        this.srpServerSalt = srpServerSalt;
    }

    public byte[] getPSKKey() {
        return this.pskKey;
    }

    public void setPSKKeyt(byte[] pskKey) {
        this.pskKey = pskKey;
    }

    public byte[] getSRPPassword() {
        return this.srpPassword;
    }

    public void setSRPPassword(byte[] srpPassword) {
        this.srpPassword = srpPassword;
    }

    public byte[] getSRPIdentity() {
        return this.srpIdentity;
    }

    public void setSRPIdentity(byte[] srpIdentity) {
        this.srpIdentity = srpIdentity;
    }

    public BigInteger getServerDhGenerator() {
        return this.serverDhGenerator;
    }

    public void setServerDhGenerator(BigInteger dhGenerator) {
        this.serverDhGenerator = dhGenerator;
    }

    public BigInteger getServerDhModulus() {
        return this.serverDhModulus;
    }

    public void setServerDhModulus(BigInteger serverDhModulus) {
        this.serverDhModulus = serverDhModulus;
    }

    public BigInteger getServerDhPublicKey() {
        return this.serverDhPublicKey;
    }

    public void setServerDhPublicKey(BigInteger serverDhPublicKey) {
        this.serverDhPublicKey = serverDhPublicKey;
    }

    public BigInteger getClientDhPrivateKey() {
        return this.clientDhPrivateKey;
    }

    public void setClientDhPrivateKey(BigInteger clientDhPrivateKey) {
        this.clientDhPrivateKey = clientDhPrivateKey;
    }

    public BigInteger getClientDhPublicKey() {
        return this.clientDhPublicKey;
    }

    public void setClientDhPublicKey(BigInteger clientDhPublicKey) {
        this.clientDhPublicKey = clientDhPublicKey;
    }

    public BigInteger getServerDhPrivateKey() {
        return this.serverDhPrivateKey;
    }

    public void setServerDhPrivateKey(BigInteger serverDhPrivateKey) {
        this.serverDhPrivateKey = serverDhPrivateKey;
    }

    public GOSTCurve getServerGost01Curve() {
        return this.selectedGostCurve;
    }

    public void setServerGost01Curve(GOSTCurve serverGost01Curve) {
        this.selectedGostCurve = serverGost01Curve;
    }

    public SignatureAndHashAlgorithm getSelectedSignatureAndHashAlgorithm() {
        return this.selectedSignatureAndHashAlgorithm;
    }

    public void setSelectedSignatureAndHashAlgorithm(SignatureAndHashAlgorithm selectedSignatureAndHashAlgorithm) {
        this.selectedSignatureAndHashAlgorithm = selectedSignatureAndHashAlgorithm;
    }

    public List<NamedGroup> getClientNamedGroupsList() {
        return this.clientNamedGroupsList;
    }

    public void setClientNamedGroupsList(List<NamedGroup> clientNamedGroupsList) {
        this.clientNamedGroupsList = clientNamedGroupsList;
    }

    public void setClientNamedGroupsList(NamedGroup ... clientNamedGroupsList) {
        this.clientNamedGroupsList = new ArrayList<NamedGroup>(Arrays.asList(clientNamedGroupsList));
    }

    public List<NamedGroup> getServerNamedGroupsList() {
        return this.serverNamedGroupsList;
    }

    public void setServerNamedGroupsList(List<NamedGroup> serverNamedGroupsList) {
        this.serverNamedGroupsList = serverNamedGroupsList;
    }

    public void setServerNamedGroupsList(NamedGroup ... serverNamedGroupsList) {
        this.serverNamedGroupsList = new ArrayList<NamedGroup>(Arrays.asList(serverNamedGroupsList));
    }

    public List<ECPointFormat> getServerPointFormatsList() {
        return this.serverPointFormatsList;
    }

    public void setServerPointFormatsList(List<ECPointFormat> serverPointFormatsList) {
        this.serverPointFormatsList = serverPointFormatsList;
    }

    public void setServerPointFormatsList(ECPointFormat ... serverPointFormatsList) {
        this.serverPointFormatsList = new ArrayList<ECPointFormat>(Arrays.asList(serverPointFormatsList));
    }

    public List<SignatureAndHashAlgorithm> getClientSupportedSignatureAndHashAlgorithms() {
        return this.clientSupportedSignatureAndHashAlgorithms;
    }

    public void setClientSupportedSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> clientSupportedSignatureAndHashAlgorithms) {
        this.clientSupportedSignatureAndHashAlgorithms = clientSupportedSignatureAndHashAlgorithms;
    }

    public void setClientSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm ... clientSupportedSignatureAndHashAlgorithms) {
        this.clientSupportedSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(clientSupportedSignatureAndHashAlgorithms));
    }

    public List<SNIEntry> getClientSNIEntryList() {
        return this.clientSNIEntryList;
    }

    public void setClientSNIEntryList(List<SNIEntry> clientSNIEntryList) {
        this.clientSNIEntryList = clientSNIEntryList;
    }

    public void setClientSNIEntryList(SNIEntry ... clientSNIEntryList) {
        this.clientSNIEntryList = new ArrayList<SNIEntry>(Arrays.asList(clientSNIEntryList));
    }

    public ProtocolVersion getLastRecordVersion() {
        return this.lastRecordVersion;
    }

    public void setLastRecordVersion(ProtocolVersion lastRecordVersion) {
        this.lastRecordVersion = lastRecordVersion;
    }

    public byte[] getDistinguishedNames() {
        return this.distinguishedNames;
    }

    public void setDistinguishedNames(byte[] distinguishedNames) {
        this.distinguishedNames = distinguishedNames;
    }

    public List<ClientCertificateType> getClientCertificateTypes() {
        return this.clientCertificateTypes;
    }

    public void setClientCertificateTypes(List<ClientCertificateType> clientCertificateTypes) {
        this.clientCertificateTypes = clientCertificateTypes;
    }

    public void setClientCertificateTypes(ClientCertificateType ... clientCertificateTypes) {
        this.clientCertificateTypes = new ArrayList<ClientCertificateType>(Arrays.asList(clientCertificateTypes));
    }

    public boolean isReceivedFatalAlert() {
        return this.receivedFatalAlert;
    }

    public void setReceivedFatalAlert(boolean receivedFatalAlert) {
        this.receivedFatalAlert = receivedFatalAlert;
    }

    public List<ECPointFormat> getClientPointFormatsList() {
        return this.clientPointFormatsList;
    }

    public void setClientPointFormatsList(List<ECPointFormat> clientPointFormatsList) {
        this.clientPointFormatsList = clientPointFormatsList;
    }

    public void setClientPointFormatsList(ECPointFormat ... clientPointFormatsList) {
        this.clientPointFormatsList = new ArrayList<ECPointFormat>(Arrays.asList(clientPointFormatsList));
    }

    public MaxFragmentLength getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    public void setMaxFragmentLength(MaxFragmentLength maxFragmentLength) {
        this.maxFragmentLength = maxFragmentLength;
    }

    public HeartbeatMode getHeartbeatMode() {
        return this.heartbeatMode;
    }

    public void setHeartbeatMode(HeartbeatMode heartbeatMode) {
        this.heartbeatMode = heartbeatMode;
    }

    public byte[] getPaddingExtensionBytes() {
        return this.paddingExtensionBytes;
    }

    public void setPaddingExtensionBytes(byte[] paddingExtensionBytes) {
        this.paddingExtensionBytes = paddingExtensionBytes;
    }

    public List<CompressionMethod> getClientSupportedCompressions() {
        return this.clientSupportedCompressions;
    }

    public void setClientSupportedCompressions(List<CompressionMethod> clientSupportedCompressions) {
        this.clientSupportedCompressions = clientSupportedCompressions;
    }

    public void setClientSupportedCompressions(CompressionMethod ... clientSupportedCompressions) {
        this.clientSupportedCompressions = new ArrayList<CompressionMethod>(Arrays.asList(clientSupportedCompressions));
    }

    public long getWriteSequenceNumber() {
        return this.writeSequenceNumber;
    }

    public void setWriteSequenceNumber(long writeSequenceNumber) {
        this.writeSequenceNumber = writeSequenceNumber;
    }

    public void increaseWriteSequenceNumber() {
        ++this.writeSequenceNumber;
    }

    public long getReadSequenceNumber() {
        return this.readSequenceNumber;
    }

    public void setReadSequenceNumber(long readSequenceNumber) {
        this.readSequenceNumber = readSequenceNumber;
    }

    public void increaseReadSequenceNumber() {
        ++this.readSequenceNumber;
    }

    public void increaseDtlsReadEpoch() {
        ++this.dtlsReadEpoch;
    }

    public void increaseDtlsWriteEpoch() {
        ++this.dtlsWriteEpoch;
    }

    public int getDtlsWriteEpoch() {
        return this.dtlsWriteEpoch;
    }

    public void setDtlsWriteEpoch(int dtlsWriteEpoch) {
        this.dtlsWriteEpoch = dtlsWriteEpoch;
    }

    public int getDtlsReceiveEpoch() {
        return this.dtlsReadEpoch;
    }

    public void setDtlsReceiveEpoch(int sendEpoch) {
        this.dtlsReadEpoch = sendEpoch;
    }

    public FragmentManager getDtlsFragmentManager() {
        return this.globalDtlsFragmentManager;
    }

    public List<CipherSuite> getClientSupportedCiphersuites() {
        return this.clientSupportedCiphersuites;
    }

    public void setClientSupportedCiphersuites(List<CipherSuite> clientSupportedCiphersuites) {
        this.clientSupportedCiphersuites = clientSupportedCiphersuites;
    }

    public void setClientSupportedCiphersuites(CipherSuite ... clientSupportedCiphersuites) {
        this.clientSupportedCiphersuites = new ArrayList<CipherSuite>(Arrays.asList(clientSupportedCiphersuites));
    }

    public List<SignatureAndHashAlgorithm> getServerSupportedSignatureAndHashAlgorithms() {
        return this.serverSupportedSignatureAndHashAlgorithms;
    }

    public void setServerSupportedSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> serverSupportedSignatureAndHashAlgorithms) {
        this.serverSupportedSignatureAndHashAlgorithms = serverSupportedSignatureAndHashAlgorithms;
    }

    public void setServerSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm ... serverSupportedSignatureAndHashAlgorithms) {
        this.serverSupportedSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(serverSupportedSignatureAndHashAlgorithms));
    }

    public ProtocolVersion getSelectedProtocolVersion() {
        return this.selectedProtocolVersion;
    }

    public void setSelectedProtocolVersion(ProtocolVersion selectedProtocolVersion) {
        this.selectedProtocolVersion = selectedProtocolVersion;
    }

    public ProtocolVersion getHighestClientProtocolVersion() {
        return this.highestClientProtocolVersion;
    }

    public void setHighestClientProtocolVersion(ProtocolVersion highestClientProtocolVersion) {
        this.highestClientProtocolVersion = highestClientProtocolVersion;
    }

    public ConnectionEndType getTalkingConnectionEndType() {
        return this.talkingConnectionEndType;
    }

    public void setTalkingConnectionEndType(ConnectionEndType talkingConnectionEndType) {
        this.talkingConnectionEndType = talkingConnectionEndType;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public CipherSuite getSelectedCipherSuite() {
        return this.selectedCipherSuite;
    }

    public SSL2CipherSuite getSSL2CipherSuite() {
        return this.ssl2CipherSuite;
    }

    public void setMasterSecret(byte[] masterSecret) {
        this.keylogfile.writeKey("CLIENT_RANDOM", masterSecret);
        this.masterSecret = masterSecret;
    }

    public void setSelectedCipherSuite(CipherSuite selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void setSSL2CipherSuite(SSL2CipherSuite ssl2CipherSuite) {
        this.ssl2CipherSuite = ssl2CipherSuite;
    }

    public byte[] getClientServerRandom() {
        return ArrayConverter.concatenate((byte[][])new byte[][]{this.clientRandom, this.serverRandom});
    }

    public byte[] getClearKey() {
        return this.clearKey;
    }

    public void setClearKey(byte[] clearKey) {
        this.clearKey = clearKey;
    }

    public byte[] getPreMasterSecret() {
        return this.preMasterSecret;
    }

    public void setPreMasterSecret(byte[] preMasterSecret) {
        this.keylogfile.writeKey("PMS_CLIENT_RANDOM", preMasterSecret);
        this.preMasterSecret = preMasterSecret;
    }

    public byte[] getClientExtendedRandom() {
        return this.clientExtendedRandom;
    }

    public void setClientExtendedRandom(byte[] clientExtendedRandom) {
        this.clientExtendedRandom = clientExtendedRandom;
    }

    public byte[] getServerExtendedRandom() {
        return this.serverExtendedRandom;
    }

    public void setServerExtendedRandom(byte[] serverExtendedRandom) {
        this.serverExtendedRandom = serverExtendedRandom;
    }

    public byte[] getClientRandom() {
        return this.clientRandom;
    }

    public void setClientRandom(byte[] clientRandom) {
        this.clientRandom = clientRandom;
    }

    public byte[] getServerRandom() {
        return this.serverRandom;
    }

    public void setServerRandom(byte[] serverRandom) {
        this.serverRandom = serverRandom;
    }

    public CompressionMethod getSelectedCompressionMethod() {
        return this.selectedCompressionMethod;
    }

    public void setSelectedCompressionMethod(CompressionMethod selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    public byte[] getServerSessionId() {
        return this.serverSessionId;
    }

    public void setServerSessionId(byte[] serverSessionId) {
        this.serverSessionId = serverSessionId;
    }

    public byte[] getClientSessionId() {
        return this.clientSessionId;
    }

    public void setClientSessionId(byte[] clientSessionId) {
        this.clientSessionId = clientSessionId;
    }

    public byte[] getSSL2Iv() {
        return this.ssl2Iv;
    }

    public void setSSL2Iv(byte[] ssl2Iv) {
        this.ssl2Iv = ssl2Iv;
    }

    public Certificate getServerCertificate() {
        return this.serverCertificate;
    }

    public void setServerCertificate(Certificate serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public Certificate getClientCertificate() {
        return this.clientCertificate;
    }

    public void setClientCertificate(Certificate clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    public MessageDigestCollector getDigest() {
        return this.digest;
    }

    public byte[] getDtlsCookie() {
        return this.dtlsCookie;
    }

    public void setDtlsCookie(byte[] dtlsCookie) {
        this.dtlsCookie = dtlsCookie;
    }

    public TransportHandler getTransportHandler() {
        return this.transportHandler;
    }

    public void setTransportHandler(TransportHandler transportHandler) {
        this.transportHandler = transportHandler;
    }

    public RecordLayer getRecordLayer() {
        return this.recordLayer;
    }

    public void setRecordLayer(RecordLayer recordLayer) {
        this.recordLayer = recordLayer;
    }

    public PRFAlgorithm getPrfAlgorithm() {
        return this.prfAlgorithm;
    }

    public void setPrfAlgorithm(PRFAlgorithm prfAlgorithm) {
        this.prfAlgorithm = prfAlgorithm;
    }

    public byte[] getClientHandshakeTrafficSecret() {
        return this.clientHandshakeTrafficSecret;
    }

    public void setClientHandshakeTrafficSecret(byte[] clientHandshakeTrafficSecret) {
        this.keylogfile.writeKey("CLIENT_HANDSHAKE_TRAFFIC_SECRET", clientHandshakeTrafficSecret);
        this.clientHandshakeTrafficSecret = clientHandshakeTrafficSecret;
    }

    public byte[] getServerHandshakeTrafficSecret() {
        return this.serverHandshakeTrafficSecret;
    }

    public void setServerHandshakeTrafficSecret(byte[] serverHandshakeTrafficSecret) {
        this.keylogfile.writeKey("SERVER_HANDSHAKE_TRAFFIC_SECRET", serverHandshakeTrafficSecret);
        this.serverHandshakeTrafficSecret = serverHandshakeTrafficSecret;
    }

    public byte[] getClientApplicationTrafficSecret() {
        return this.clientApplicationTrafficSecret;
    }

    public void setClientApplicationTrafficSecret(byte[] clientApplicationTrafficSecret) {
        this.keylogfile.writeKey("CLIENT_TRAFFIC_SECRET_0", clientApplicationTrafficSecret);
        this.clientApplicationTrafficSecret = clientApplicationTrafficSecret;
    }

    public byte[] getServerApplicationTrafficSecret() {
        return this.serverApplicationTrafficSecret;
    }

    public void setServerApplicationTrafficSecret(byte[] serverApplicationTrafficSecret) {
        this.keylogfile.writeKey("SERVER_TRAFFIC_SECRET_0", serverApplicationTrafficSecret);
        this.serverApplicationTrafficSecret = serverApplicationTrafficSecret;
    }

    public byte[] getHandshakeSecret() {
        return this.handshakeSecret;
    }

    public void setHandshakeSecret(byte[] handshakeSecret) {
        this.handshakeSecret = handshakeSecret;
    }

    public List<KeyShareStoreEntry> getClientKeyShareStoreEntryList() {
        return this.clientKeyShareStoreEntryList;
    }

    public void setClientKeyShareStoreEntryList(List<KeyShareStoreEntry> clientKeyShareStoreEntryList) {
        this.clientKeyShareStoreEntryList = clientKeyShareStoreEntryList;
    }

    public void setClientKSEntryList(KeyShareEntry ... clientKSEntryList) {
        this.clientKeyShareStoreEntryList = new ArrayList<KeyShareEntry>(Arrays.asList(clientKSEntryList));
    }

    public KeyShareStoreEntry getServerKeyShareStoreEntry() {
        return this.serverKeyShareStoreEntry;
    }

    public void setServerKeyShareStoreEntry(KeyShareStoreEntry serverKeyShareStoreEntry) {
        this.serverKeyShareStoreEntry = serverKeyShareStoreEntry;
    }

    public byte[] getSessionTicketTLS() {
        return this.sessionTicketTLS;
    }

    public void setSessionTicketTLS(byte[] sessionTicketTLS) {
        this.sessionTicketTLS = sessionTicketTLS;
    }

    public byte[] getSignedCertificateTimestamp() {
        return this.signedCertificateTimestamp;
    }

    public void setSignedCertificateTimestamp(byte[] signedCertificateTimestamp) {
        this.signedCertificateTimestamp = signedCertificateTimestamp;
    }

    public byte[] getRenegotiationInfo() {
        return this.renegotiationInfo;
    }

    public void setRenegotiationInfo(byte[] renegotiationInfo) {
        this.renegotiationInfo = renegotiationInfo;
    }

    public TokenBindingVersion getTokenBindingVersion() {
        return this.tokenBindingVersion;
    }

    public void setTokenBindingVersion(TokenBindingVersion tokenBindingVersion) {
        this.tokenBindingVersion = tokenBindingVersion;
    }

    public List<TokenBindingKeyParameters> getTokenBindingKeyParameters() {
        return this.tokenBindingKeyParameters;
    }

    public void setTokenBindingKeyParameters(List<TokenBindingKeyParameters> tokenBindingKeyParameters) {
        this.tokenBindingKeyParameters = tokenBindingKeyParameters;
    }

    public void setTokenBindingNegotiatedSuccessfully(boolean tokenBindingNegotiated) {
        this.tokenBindingNegotiatedSuccessfully = tokenBindingNegotiated;
    }

    public boolean isTokenBindingNegotiatedSuccessfully() {
        return this.tokenBindingNegotiatedSuccessfully;
    }

    public CertificateStatusRequestType getCertificateStatusRequestExtensionRequestType() {
        return this.certificateStatusRequestExtensionRequestType;
    }

    public void setCertificateStatusRequestExtensionRequestType(CertificateStatusRequestType certificateStatusRequestExtensionRequestType) {
        this.certificateStatusRequestExtensionRequestType = certificateStatusRequestExtensionRequestType;
    }

    public byte[] getCertificateStatusRequestExtensionResponderIDList() {
        return this.certificateStatusRequestExtensionResponderIDList;
    }

    public void setCertificateStatusRequestExtensionResponderIDList(byte[] certificateStatusRequestExtensionResponderIDList) {
        this.certificateStatusRequestExtensionResponderIDList = certificateStatusRequestExtensionResponderIDList;
    }

    public byte[] getCertificateStatusRequestExtensionRequestExtension() {
        return this.certificateStatusRequestExtensionRequestExtension;
    }

    public void setCertificateStatusRequestExtensionRequestExtension(byte[] certificateStatusRequestExtensionRequestExtension) {
        this.certificateStatusRequestExtensionRequestExtension = certificateStatusRequestExtensionRequestExtension;
    }

    public byte[] getAlpnAnnouncedProtocols() {
        return this.AlpnAnnouncedProtocols;
    }

    public void setAlpnAnnouncedProtocols(byte[] AlpnAnnouncedProtocols) {
        this.AlpnAnnouncedProtocols = AlpnAnnouncedProtocols;
    }

    public byte[] getSecureRemotePasswordExtensionIdentifier() {
        return this.secureRemotePasswordExtensionIdentifier;
    }

    public void setSecureRemotePasswordExtensionIdentifier(byte[] secureRemotePasswordExtensionIdentifier) {
        this.secureRemotePasswordExtensionIdentifier = secureRemotePasswordExtensionIdentifier;
    }

    public List<SrtpProtectionProfiles> getSecureRealTimeTransportProtocolProtectionProfiles() {
        return this.secureRealTimeTransportProtocolProtectionProfiles;
    }

    public void setSecureRealTimeTransportProtocolProtectionProfiles(List<SrtpProtectionProfiles> secureRealTimeTransportProtocolProtectionProfiles) {
        this.secureRealTimeTransportProtocolProtectionProfiles = secureRealTimeTransportProtocolProtectionProfiles;
    }

    public byte[] getSecureRealTimeProtocolMasterKeyIdentifier() {
        return this.secureRealTimeProtocolMasterKeyIdentifier;
    }

    public void setSecureRealTimeProtocolMasterKeyIdentifier(byte[] secureRealTimeProtocolMasterKeyIdentifier) {
        this.secureRealTimeProtocolMasterKeyIdentifier = secureRealTimeProtocolMasterKeyIdentifier;
    }

    public UserMappingExtensionHintType getUserMappingExtensionHintType() {
        return this.userMappingExtensionHintType;
    }

    public void setUserMappingExtensionHintType(UserMappingExtensionHintType userMappingExtensionHintType) {
        this.userMappingExtensionHintType = userMappingExtensionHintType;
    }

    public List<CertificateType> getCertificateTypeDesiredTypes() {
        return this.certificateTypeClientDesiredTypes;
    }

    public void setCertificateTypeDesiredTypes(List<CertificateType> certificateTypeDesiredTypes) {
        this.certificateTypeClientDesiredTypes = certificateTypeDesiredTypes;
    }

    public List<AuthzDataFormat> getClientAuthzDataFormatList() {
        return this.clientAuthzDataFormatList;
    }

    public void setClientAuthzDataFormatList(List<AuthzDataFormat> clientAuthzDataFormatList) {
        this.clientAuthzDataFormatList = clientAuthzDataFormatList;
    }

    public List<AuthzDataFormat> getServerAuthzDataFormatList() {
        return this.serverAuthzDataFormatList;
    }

    public void setServerAuthzDataFormatList(List<AuthzDataFormat> serverAuthzDataFormatList) {
        this.serverAuthzDataFormatList = serverAuthzDataFormatList;
    }

    public void setTokenBindingKeyParameters(TokenBindingKeyParameters ... tokenBindingKeyParameters) {
        this.tokenBindingKeyParameters = new ArrayList<TokenBindingKeyParameters>(Arrays.asList(tokenBindingKeyParameters));
    }

    public byte[] getCertificateRequestContext() {
        return this.certificateRequestContext;
    }

    public void setCertificateRequestContext(byte[] certificateRequestContext) {
        this.certificateRequestContext = certificateRequestContext;
    }

    public List<CertificateType> getClientCertificateTypeDesiredTypes() {
        return this.clientCertificateTypeDesiredTypes;
    }

    public void setClientCertificateTypeDesiredTypes(List<CertificateType> clientCertificateTypeDesiredTypes) {
        this.clientCertificateTypeDesiredTypes = clientCertificateTypeDesiredTypes;
    }

    public List<CertificateType> getServerCertificateTypeDesiredTypes() {
        return this.serverCertificateTypeDesiredTypes;
    }

    public void setServerCertificateTypeDesiredTypes(List<CertificateType> serverCertificateTypeDesiredTypes) {
        this.serverCertificateTypeDesiredTypes = serverCertificateTypeDesiredTypes;
    }

    public boolean isCachedInfoExtensionClientState() {
        return this.cachedInfoExtensionClientState;
    }

    public void setCachedInfoExtensionClientState(boolean cachedInfoExtensionClientState) {
        this.cachedInfoExtensionClientState = cachedInfoExtensionClientState;
    }

    public List<CachedObject> getCachedInfoExtensionObjects() {
        return this.cachedInfoExtensionObjects;
    }

    public void setCachedInfoExtensionObjects(List<CachedObject> cachedInfoExtensionObjects) {
        this.cachedInfoExtensionObjects = cachedInfoExtensionObjects;
    }

    public List<TrustedAuthority> getTrustedCaIndicationExtensionCas() {
        return this.trustedCaIndicationExtensionCas;
    }

    public void setTrustedCaIndicationExtensionCas(List<TrustedAuthority> trustedCaIndicationExtensionCas) {
        this.trustedCaIndicationExtensionCas = trustedCaIndicationExtensionCas;
    }

    public List<RequestItemV2> getStatusRequestV2RequestList() {
        return this.statusRequestV2RequestList;
    }

    public void setStatusRequestV2RequestList(List<RequestItemV2> statusRequestV2RequestList) {
        this.statusRequestV2RequestList = statusRequestV2RequestList;
    }

    public BigInteger getServerRSAPrivateKey() {
        return this.serverRSAPrivateKey;
    }

    public void setServerRSAPrivateKey(BigInteger serverRSAPrivateKey) {
        this.serverRSAPrivateKey = serverRSAPrivateKey;
    }

    public BigInteger getClientRSAPrivateKey() {
        return this.clientRSAPrivateKey;
    }

    public void setClientRSAPrivateKey(BigInteger clientRSAPrivateKey) {
        this.clientRSAPrivateKey = clientRSAPrivateKey;
    }

    public boolean isEarlyCleanShutdown() {
        return this.earlyCleanShutdown;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setEarlyCleanShutdown(boolean earlyCleanShutdown) {
        this.earlyCleanShutdown = earlyCleanShutdown;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public BadRandom getBadSecureRandom() {
        return new BadRandom(this.getRandom(), null);
    }

    public Config getConfig() {
        return this.config;
    }

    public AliasedConnection getConnection() {
        return this.connection;
    }

    public void setConnection(AliasedConnection connection) {
        this.connection = connection;
    }

    public RecordLayerType getRecordLayerType() {
        return this.recordLayerType;
    }

    public void setRecordLayerType(RecordLayerType recordLayerType) {
        this.recordLayerType = recordLayerType;
    }

    public ProtocolVersion getHighestProtocolVersion() {
        return this.highestProtocolVersion;
    }

    public void setHighestProtocolVersion(ProtocolVersion highestProtocolVersion) {
        this.highestProtocolVersion = highestProtocolVersion;
    }

    public Boolean isClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(Boolean clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public byte[] getLastHandledApplicationMessageData() {
        return this.lastHandledApplicationMessageData;
    }

    public void setLastHandledApplicationMessageData(byte[] lastHandledApplicationMessageData) {
        this.lastHandledApplicationMessageData = lastHandledApplicationMessageData;
    }

    public boolean isExtensionProposed(ExtensionType ext) {
        return this.proposedExtensionSet.contains((Object)ext);
    }

    public EnumSet<ExtensionType> getProposedExtensions() {
        return this.proposedExtensionSet;
    }

    public void addProposedExtension(ExtensionType ext) {
        this.proposedExtensionSet.add(ext);
    }

    public boolean isExtensionNegotiated(ExtensionType ext) {
        return this.negotiatedExtensionSet.contains((Object)ext);
    }

    public void addNegotiatedExtension(ExtensionType ext) {
        this.negotiatedExtensionSet.add(ext);
    }

    public EnumSet<ExtensionType> getNegotiatedExtensionSet() {
        return this.negotiatedExtensionSet;
    }

    public boolean isUseExtendedMasterSecret() {
        return this.useExtendedMasterSecret;
    }

    public void setUseExtendedMasterSecret(boolean useExtendedMasterSecret) {
        this.useExtendedMasterSecret = useExtendedMasterSecret;
    }

    public String getHttpsCookieName() {
        return this.httpsCookieName;
    }

    public void setHttpsCookieName(String httpsCookieName) {
        this.httpsCookieName = httpsCookieName;
    }

    public String getHttpsCookieValue() {
        return this.httpsCookieValue;
    }

    public void setHttpsCookieValue(String httpsCookieValue) {
        this.httpsCookieValue = httpsCookieValue;
    }

    public void initTransportHandler() {
        if (this.transportHandler == null) {
            if (this.connection == null) {
                throw new ConfigurationException("Connection end not set");
            }
            this.transportHandler = TransportHandlerFactory.createTransportHandler((Connection)this.connection);
        }
        try {
            this.transportHandler.initialize();
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new ConfigurationException("Invalid values in " + this.connection.toString(), ex);
        }
        catch (IOException ex) {
            throw new TransportHandlerConnectException("Unable to initialize the transport handler with: " + this.connection.toString(), ex);
        }
    }

    public void initRecordLayer() {
        if (this.recordLayerType == null) {
            throw new ConfigurationException("No record layer type defined");
        }
        this.recordLayer = RecordLayerFactory.getRecordLayer(this.recordLayerType, this);
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        if (this.connection == null) {
            info.append("TlsContext{ (no connection set) }");
        } else {
            info.append("TlsContext{'").append(this.connection.getAlias()).append("'");
            if (this.connection.getLocalConnectionEndType() == ConnectionEndType.SERVER) {
                info.append(", listening on port ").append(this.connection.getPort());
            } else {
                info.append(", connected to ").append(this.connection.getHostname()).append(":").append(this.connection.getPort());
            }
            info.append("}");
        }
        return info.toString();
    }

    public byte[] getClientEarlyTrafficSecret() {
        return this.clientEarlyTrafficSecret;
    }

    public void setClientEarlyTrafficSecret(byte[] clientEarlyTrafficSecret) {
        this.keylogfile.writeKey("CLIENT_EARLY_TRAFFIC_SECRET", clientEarlyTrafficSecret);
        this.clientEarlyTrafficSecret = clientEarlyTrafficSecret;
    }

    public long getMaxEarlyDataSize() {
        return this.maxEarlyDataSize;
    }

    public void setMaxEarlyDataSize(long maxEarlyDataSize) {
        this.maxEarlyDataSize = maxEarlyDataSize;
    }

    public byte[] getPsk() {
        return this.psk;
    }

    public void setPsk(byte[] psk) {
        this.psk = psk;
    }

    public byte[] getEarlySecret() {
        return this.earlySecret;
    }

    public void setEarlySecret(byte[] earlySecret) {
        this.earlySecret = earlySecret;
    }

    public CipherSuite getEarlyDataCipherSuite() {
        return this.earlyDataCipherSuite;
    }

    public void setEarlyDataCipherSuite(CipherSuite earlyDataCipherSuite) {
        this.earlyDataCipherSuite = earlyDataCipherSuite;
    }

    public byte[] getEarlyDataPSKIdentity() {
        return this.earlyDataPSKIdentity;
    }

    public void setEarlyDataPSKIdentity(byte[] earlyDataPSKIdentity) {
        this.earlyDataPSKIdentity = earlyDataPSKIdentity;
    }

    public int getSelectedIdentityIndex() {
        return this.selectedIdentityIndex;
    }

    public void setSelectedIdentityIndex(int selectedIdentityIndex) {
        this.selectedIdentityIndex = selectedIdentityIndex;
    }

    public List<PskKeyExchangeMode> getClientPskKeyExchangeModes() {
        return this.clientPskKeyExchangeModes;
    }

    public void setClientPskKeyExchangeModes(List<PskKeyExchangeMode> clientPskKeyExchangeModes) {
        this.clientPskKeyExchangeModes = clientPskKeyExchangeModes;
    }

    public List<PskSet> getPskSets() {
        return this.pskSets;
    }

    public void setPskSets(List<PskSet> pskSets) {
        this.pskSets = pskSets;
    }

    public Tls13KeySetType getActiveClientKeySetType() {
        return this.activeClientKeySetType;
    }

    public void setActiveClientKeySetType(Tls13KeySetType activeClientKeySetType) {
        this.activeClientKeySetType = activeClientKeySetType;
    }

    public Tls13KeySetType getActiveServerKeySetType() {
        return this.activeServerKeySetType;
    }

    public void setActiveServerKeySetType(Tls13KeySetType activeServerKeySetType) {
        this.activeServerKeySetType = activeServerKeySetType;
    }

    public Tls13KeySetType getActiveKeySetTypeRead() {
        if (this.chooser.getConnectionEndType() == ConnectionEndType.SERVER) {
            return this.activeClientKeySetType;
        }
        return this.activeServerKeySetType;
    }

    public Tls13KeySetType getActiveKeySetTypeWrite() {
        if (this.chooser.getConnectionEndType() == ConnectionEndType.SERVER) {
            return this.activeServerKeySetType;
        }
        return this.activeClientKeySetType;
    }

    public byte[] getEarlyDataPsk() {
        return this.earlyDataPsk;
    }

    public void setEarlyDataPsk(byte[] earlyDataPsk) {
        this.earlyDataPsk = earlyDataPsk;
    }

    public boolean isReceivedTransportHandlerException() {
        return this.receivedTransportHandlerException;
    }

    public void setReceivedTransportHandlerException(boolean receivedTransportHandlerException) {
        this.receivedTransportHandlerException = receivedTransportHandlerException;
    }

    public NamedGroup getEcCertificateCurve() {
        return this.ecCertificateCurve;
    }

    public void setEcCertificateCurve(NamedGroup ecCertificateCurve) {
        this.ecCertificateCurve = ecCertificateCurve;
    }

    public BigInteger getClientDhGenerator() {
        return this.clientDhGenerator;
    }

    public void setClientDhGenerator(BigInteger clientDhGenerator) {
        this.clientDhGenerator = clientDhGenerator;
    }

    public BigInteger getClientDhModulus() {
        return this.clientDhModulus;
    }

    public void setClientDhModulus(BigInteger clientDhModulus) {
        this.clientDhModulus = clientDhModulus;
    }

    public BigInteger getClientDsaPrivateKey() {
        return this.clientDsaPrivateKey;
    }

    public void setClientDsaPrivateKey(BigInteger clientDsaPrivateKey) {
        this.clientDsaPrivateKey = clientDsaPrivateKey;
    }

    public BigInteger getServerDsaPrivateKey() {
        return this.serverDsaPrivateKey;
    }

    public void setServerDsaPrivateKey(BigInteger serverDsaPrivateKey) {
        this.serverDsaPrivateKey = serverDsaPrivateKey;
    }

    public BigInteger getServerDsaPrimeP() {
        return this.serverDsaPrimeP;
    }

    public void setServerDsaPrimeP(BigInteger serverDsaPrimeP) {
        this.serverDsaPrimeP = serverDsaPrimeP;
    }

    public BigInteger getServerDsaPrimeQ() {
        return this.serverDsaPrimeQ;
    }

    public void setServerDsaPrimeQ(BigInteger serverDsaPrimeQ) {
        this.serverDsaPrimeQ = serverDsaPrimeQ;
    }

    public BigInteger getServerDsaGenerator() {
        return this.serverDsaGenerator;
    }

    public void setServerDsaGenerator(BigInteger serverDsaGenerator) {
        this.serverDsaGenerator = serverDsaGenerator;
    }

    public BigInteger getServerDsaPublicKey() {
        return this.serverDsaPublicKey;
    }

    public void setServerDsaPublicKey(BigInteger serverDsaPublicKey) {
        this.serverDsaPublicKey = serverDsaPublicKey;
    }

    public BigInteger getClientDsaPublicKey() {
        return this.clientDsaPublicKey;
    }

    public void setClientDsaPublicKey(BigInteger clientDsaPublicKey) {
        this.clientDsaPublicKey = clientDsaPublicKey;
    }

    public BigInteger getClientDsaPrimeP() {
        return this.clientDsaPrimeP;
    }

    public void setClientDsaPrimeP(BigInteger clientDsaPrimeP) {
        this.clientDsaPrimeP = clientDsaPrimeP;
    }

    public BigInteger getClientDsaPrimeQ() {
        return this.clientDsaPrimeQ;
    }

    public void setClientDsaPrimeQ(BigInteger clientDsaPrimeQ) {
        this.clientDsaPrimeQ = clientDsaPrimeQ;
    }

    public BigInteger getClientDsaGenerator() {
        return this.clientDsaGenerator;
    }

    public void setClientDsaGenerator(BigInteger clientDsaGenerator) {
        this.clientDsaGenerator = clientDsaGenerator;
    }

    public void setClientPWDUsername(String username) {
        this.clientPWDUsername = username;
    }

    public String getClientPWDUsername() {
        return this.clientPWDUsername;
    }

    public void setServerPWDSalt(byte[] salt) {
        this.serverPWDSalt = salt;
    }

    public byte[] getServerPWDSalt() {
        return this.serverPWDSalt;
    }

    public Point getPWDPE() {
        return this.PWDPE;
    }

    public void setPWDPE(Point PWDPE) {
        this.PWDPE = PWDPE;
    }

    public BigInteger getClientPWDPrivate() {
        return this.clientPWDPrivate;
    }

    public void setClientPWDPrivate(BigInteger clientPWDPrivate) {
        this.clientPWDPrivate = clientPWDPrivate;
    }

    public BigInteger getServerPWDPrivate() {
        return this.serverPWDPrivate;
    }

    public void setServerPWDPrivate(BigInteger serverPWDPrivate) {
        this.serverPWDPrivate = serverPWDPrivate;
    }

    public BigInteger getServerPWDScalar() {
        return this.serverPWDScalar;
    }

    public void setServerPWDScalar(BigInteger serverPWDScalar) {
        this.serverPWDScalar = serverPWDScalar;
    }

    public Point getServerPWDElement() {
        return this.serverPWDElement;
    }

    public void setServerPWDElement(Point serverPWDElement) {
        this.serverPWDElement = serverPWDElement;
    }

    public GOSTCurve getSelectedGostCurve() {
        return this.selectedGostCurve;
    }

    public void setSelectedGostCurve(GOSTCurve selectedGostCurve) {
        this.selectedGostCurve = selectedGostCurve;
    }

    public byte[] getEsniClientNonce() {
        return this.esniClientNonce;
    }

    public void setEsniClientNonce(byte[] esniClientNonce) {
        this.esniClientNonce = esniClientNonce;
    }

    public byte[] getEsniServerNonce() {
        return this.esniServerNonce;
    }

    public void setEsniServerNonce(byte[] esniServerNonce) {
        this.esniServerNonce = esniServerNonce;
    }

    public byte[] getEsniRecordBytes() {
        return this.esniRecordBytes;
    }

    public void setEsniRecordBytes(byte[] esniRecordBytes) {
        this.esniRecordBytes = esniRecordBytes;
    }

    public EsniDnsKeyRecordVersion getEsniRecordVersion() {
        return this.esniRecordVersion;
    }

    public void setEsniRecordVersion(EsniDnsKeyRecordVersion esniRecordVersion) {
        this.esniRecordVersion = esniRecordVersion;
    }

    public byte[] getEsniRecordChecksum() {
        return this.esniRecordChecksum;
    }

    public void setEsniRecordChecksum(byte[] esniRecordChecksum) {
        this.esniRecordChecksum = esniRecordChecksum;
    }

    public List<KeyShareStoreEntry> getEsniServerKeyShareEntries() {
        return this.esniServerKeyShareEntries;
    }

    public void setEsniServerKeyShareEntries(List<KeyShareStoreEntry> esniServerKeyShareEntries) {
        this.esniServerKeyShareEntries = esniServerKeyShareEntries;
    }

    public List<CipherSuite> getEsniServerCiphersuites() {
        return this.esniServerCiphersuites;
    }

    public void setEsniServerCiphersuites(List<CipherSuite> esniServerCiphersuites) {
        this.esniServerCiphersuites = esniServerCiphersuites;
    }

    public Integer getEsniPaddedLength() {
        return this.esniPaddedLength;
    }

    public void setEsniPaddedLength(Integer esniPaddedLength) {
        this.esniPaddedLength = esniPaddedLength;
    }

    public Long getEsniKeysNotBefore() {
        return this.esniNotBefore;
    }

    public void setEsniKeysNotBefore(Long esniKeysNotBefore) {
        this.esniNotBefore = esniKeysNotBefore;
    }

    public Long getEsniNotAfter() {
        return this.esniNotAfter;
    }

    public void setEsniKeysNotAfter(Long esniKeysNotAfter) {
        this.esniNotAfter = esniKeysNotAfter;
    }
}

