"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseCspHeader = parseCspHeader;
exports.stringifyCspHeader = stringifyCspHeader;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// parse an input CSP header string into a Map where the key of the Map is the directive name
// and the value of the key is a string array of the directive values
function parseCspHeader(cspHeader) {
  const directives = cspHeader.split(';');
  return directives.reduce((accumulator, directive) => {
    const trimmed = directive.trim().split(' ');
    accumulator.set(trimmed[0], trimmed.slice(1));
    return accumulator;
  }, new Map());
}

// stringify a CSP header Map to a string
function stringifyCspHeader(parsedCspHeader) {
  const directives = [];
  parsedCspHeader.forEach((values, directive) => {
    directives.push(directive + ' ' + values.join(' '));
  });
  return directives.join('; ');
}