/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.events.AutomationEventFactory;
import org.openhab.core.automation.events.TimerEvent;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TimeBasedTriggerHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.scheduler.CronAdjuster;
import org.openhab.core.scheduler.CronScheduler;
import org.openhab.core.scheduler.ScheduledCompletableFuture;
import org.openhab.core.scheduler.SchedulerRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GenericCronTriggerHandler
extends BaseTriggerModuleHandler
implements SchedulerRunnable,
TimeBasedTriggerHandler {
    public static final String MODULE_TYPE_ID = "timer.GenericCronTrigger";
    public static final String CALLBACK_CONTEXT_NAME = "CALLBACK";
    public static final String MODULE_CONTEXT_NAME = "MODULE";
    public static final String CFG_CRON_EXPRESSION = "cronExpression";
    private final Logger logger = LoggerFactory.getLogger(GenericCronTriggerHandler.class);
    private final CronScheduler scheduler;
    private final String expression;
    private @Nullable ScheduledCompletableFuture<?> schedule;

    public GenericCronTriggerHandler(Trigger module, CronScheduler scheduler) {
        super(module);
        this.scheduler = scheduler;
        this.expression = (String)module.getConfiguration().get(CFG_CRON_EXPRESSION);
    }

    @Override
    public synchronized void setCallback(ModuleHandlerCallback callback) {
        super.setCallback(callback);
        this.scheduleJob();
    }

    private void scheduleJob() {
        this.schedule = this.scheduler.schedule((SchedulerRunnable)this, this.expression);
        this.logger.debug("Scheduled cron job '{}' for trigger '{}'.", ((Trigger)this.module).getConfiguration().get(CFG_CRON_EXPRESSION), (Object)((Trigger)this.module).getId());
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.schedule != null) {
            this.schedule.cancel(true);
            this.logger.debug("cancelled job for trigger '{}'.", (Object)((Trigger)this.module).getId());
        }
    }

    public void run() {
        if (this.callback != null) {
            TimerEvent event = AutomationEventFactory.createTimerEvent(((Trigger)this.module).getTypeUID(), Objects.requireNonNullElse(((Trigger)this.module).getLabel(), ((Trigger)this.module).getId()), Map.of(CFG_CRON_EXPRESSION, this.expression));
            ((TriggerHandlerCallback)this.callback).triggered((Trigger)this.module, Map.of("event", event));
        } else {
            this.logger.debug("Tried to trigger, but callback isn't available!");
        }
    }

    public CronAdjuster getTemporalAdjuster() {
        return new CronAdjuster(this.expression);
    }
}

