/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.TransformRestoreEdit;
import org.jhotdraw.geom.Geom;

public class BezierScaleHandle
extends AbstractHandle {
    private Point location;
    private Object restoreData;
    private AffineTransform transform;
    private Point2D.Double center;
    private double startTheta;
    private double startLength;

    public BezierScaleHandle(BezierFigure bezierFigure) {
        super(bezierFigure);
    }

    @Override
    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.drawCircle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.SCALE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.SCALE_HANDLE_STROKE_COLOR));
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        int n = this.getHandlesize();
        rectangle.x -= n / 2;
        rectangle.y -= n / 2;
        rectangle.width = rectangle.height = n;
        return rectangle;
    }

    public Point getLocation() {
        if (this.location == null) {
            return this.view.drawingToView(this.getOrigin());
        }
        return this.location;
    }

    private BezierFigure getBezierFigure() {
        return (BezierFigure)this.getOwner();
    }

    private Point2D.Double getOrigin() {
        int n = this.getHandlesize();
        Point2D.Double double_ = this.getBezierFigure().getOutermostPoint();
        Point2D.Double double_2 = this.getBezierFigure().getCenter();
        double d = Geom.length(double_.x, double_.y, double_2.x, double_2.y);
        if (d == 0.0) {
            return new Point2D.Double(double_.x - (double)(n / 2), double_.y + (double)(n / 2));
        }
        double d2 = (double)n / d;
        if (d2 > 1.0) {
            return new Point2D.Double((double_.x * 3.0 + double_2.x) / 4.0, (double_.y * 3.0 + double_2.y) / 4.0);
        }
        return new Point2D.Double(double_.x * (1.0 - d2) + double_2.x * d2, double_.y * (1.0 - d2) + double_2.y * d2);
    }

    @Override
    public void trackStart(Point point, int n) {
        this.location = new Point(point.x, point.y);
        this.restoreData = this.getBezierFigure().getTransformRestoreData();
        this.transform = new AffineTransform();
        this.center = this.getBezierFigure().getCenter();
        Point2D.Double double_ = this.view.viewToDrawing(point);
        this.startTheta = Geom.angle(this.center.x, this.center.y, double_.x, double_.y);
        this.startLength = Geom.length(this.center.x, this.center.y, double_.x, double_.y);
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        this.location = new Point(point2.x, point2.y);
        Point2D.Double double_ = this.view.viewToDrawing(point2);
        double d = Geom.angle(this.center.x, this.center.y, double_.x, double_.y);
        double d2 = Geom.length(this.center.x, this.center.y, double_.x, double_.y);
        double d3 = (n & 0x240) != 0 ? 1.0 : d2 / this.startLength;
        this.transform.setToIdentity();
        this.transform.translate(this.center.x, this.center.y);
        this.transform.scale(d3, d3);
        this.transform.rotate(d - this.startTheta);
        this.transform.translate(-this.center.x, -this.center.y);
        this.getOwner().willChange();
        this.getOwner().restoreTransformTo(this.restoreData);
        this.getOwner().transform(this.transform);
        this.getOwner().changed();
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        this.view.getDrawing().fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), this.restoreData, this.getOwner().getTransformRestoreData()));
        this.location = null;
    }
}

