/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.LiquibaseJpaUpdaterProvider;
import org.keycloak.connections.jpa.updater.liquibase.ThreadLocalSessionContext;
import org.keycloak.models.KeycloakSession;

public abstract class CustomKeycloakTask
implements CustomSqlChange {
    protected KeycloakSession kcSession;
    protected Database database;
    protected JdbcConnection jdbcConnection;
    protected Connection connection;
    protected StringBuilder confirmationMessage = new StringBuilder();
    protected List<SqlStatement> statements = new ArrayList<SqlStatement>();

    public ValidationErrors validate(Database database) {
        return null;
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public String getConfirmationMessage() {
        return this.confirmationMessage.toString();
    }

    public void setUp() throws SetupException {
        this.kcSession = ThreadLocalSessionContext.getCurrentSession();
        if (this.kcSession == null) {
            throw new SetupException("Thread bound session is null");
        }
    }

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        this.database = database;
        this.jdbcConnection = (JdbcConnection)database.getConnection();
        this.connection = this.jdbcConnection.getWrappedConnection();
        if (this.isApplicable()) {
            this.confirmationMessage.append(this.getTaskId() + ": ");
            this.generateStatementsImpl();
        } else {
            this.confirmationMessage.append(this.getTaskId() + ": no update applicable for this task");
        }
        return this.statements.toArray(new SqlStatement[this.statements.size()]);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean isApplicable() throws CustomChangeException {
        try {
            String correctedTableName = this.database.correctObjectName("REALM", Table.class);
            if (SnapshotGeneratorFactory.getInstance().has((DatabaseObject)new Table().setName(correctedTableName), this.database)) {
                try (Statement st = this.connection.createStatement();){
                    boolean bl;
                    block15: {
                        ResultSet resultSet = st.executeQuery("SELECT ID FROM " + this.getTableName(correctedTableName));
                        try {
                            bl = resultSet.next();
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return bl;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new CustomChangeException("Failed to check database availability", (Throwable)e);
        }
    }

    protected abstract void generateStatementsImpl() throws CustomChangeException;

    protected abstract String getTaskId();

    protected String getTableName(String tableName) {
        String correctedSchemaName = this.database.escapeObjectName(this.database.getDefaultSchemaName(), Schema.class);
        return LiquibaseJpaUpdaterProvider.getTable(tableName, correctedSchemaName);
    }
}

