/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.protocol.oid4vc.model.DisplayObject;
import org.keycloak.protocol.oid4vc.model.Format;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SupportedCredentialConfiguration {
    private static final String DOT_SEPARATOR = ".";
    @JsonIgnore
    private static final String FORMAT_KEY = "format";
    @JsonIgnore
    private static final String SCOPE_KEY = "scope";
    @JsonIgnore
    private static final String CRYPTOGRAPHIC_BINDING_METHODS_SUPPORTED_KEY = " credential_signing_alg_values_supported";
    @JsonIgnore
    private static final String CRYPTOGRAPHIC_SUITES_SUPPORTED_KEY = "cryptographic_suites_supported";
    @JsonIgnore
    private static final String CREDENTIAL_SIGNING_ALG_VALUES_SUPPORTED_KEY = "credential_signing_alg_values_supported";
    @JsonIgnore
    private static final String DISPLAY_KEY = "display";
    private String id;
    @JsonProperty(value="format")
    private Format format;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value=" credential_signing_alg_values_supported")
    private List<String> cryptographicBindingMethodsSupported;
    @JsonProperty(value="cryptographic_suites_supported")
    private List<String> cryptographicSuitesSupported;
    @JsonProperty(value="credential_signing_alg_values_supported")
    private List<String> credentialSigningAlgValuesSupported;
    @JsonProperty(value="display")
    private DisplayObject display;

    public Format getFormat() {
        return this.format;
    }

    public SupportedCredentialConfiguration setFormat(Format format) {
        this.format = format;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public SupportedCredentialConfiguration setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<String> getCryptographicBindingMethodsSupported() {
        return this.cryptographicBindingMethodsSupported;
    }

    public SupportedCredentialConfiguration setCryptographicBindingMethodsSupported(List<String> cryptographicBindingMethodsSupported) {
        this.cryptographicBindingMethodsSupported = Collections.unmodifiableList(cryptographicBindingMethodsSupported);
        return this;
    }

    public List<String> getCryptographicSuitesSupported() {
        return this.cryptographicSuitesSupported;
    }

    public SupportedCredentialConfiguration setCryptographicSuitesSupported(List<String> cryptographicSuitesSupported) {
        this.cryptographicSuitesSupported = Collections.unmodifiableList(cryptographicSuitesSupported);
        return this;
    }

    public DisplayObject getDisplay() {
        return this.display;
    }

    public SupportedCredentialConfiguration setDisplay(DisplayObject display) {
        this.display = display;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SupportedCredentialConfiguration setId(String id) {
        if (id.contains(DOT_SEPARATOR)) {
            throw new IllegalArgumentException("dots are not supported as part of the supported credentials id.");
        }
        this.id = id;
        return this;
    }

    public List<String> getCredentialSigningAlgValuesSupported() {
        return this.credentialSigningAlgValuesSupported;
    }

    public SupportedCredentialConfiguration setCredentialSigningAlgValuesSupported(List<String> credentialSigningAlgValuesSupported) {
        this.credentialSigningAlgValuesSupported = Collections.unmodifiableList(credentialSigningAlgValuesSupported);
        return this;
    }

    public Map<String, String> toDotNotation() {
        HashMap<String, String> dotNotation = new HashMap<String, String>();
        Optional.ofNullable(this.format).ifPresent(format -> dotNotation.put(this.id + ".format", format.toString()));
        Optional.ofNullable(this.scope).ifPresent(scope -> dotNotation.put(this.id + ".scope", (String)scope));
        Optional.ofNullable(this.cryptographicBindingMethodsSupported).ifPresent(types -> dotNotation.put(this.id + ". credential_signing_alg_values_supported", String.join((CharSequence)",", this.cryptographicBindingMethodsSupported)));
        Optional.ofNullable(this.cryptographicSuitesSupported).ifPresent(types -> dotNotation.put(this.id + ".cryptographic_suites_supported", String.join((CharSequence)",", this.cryptographicSuitesSupported)));
        Optional.ofNullable(this.cryptographicSuitesSupported).ifPresent(types -> dotNotation.put(this.id + ".credential_signing_alg_values_supported", String.join((CharSequence)",", this.credentialSigningAlgValuesSupported)));
        Map dotNotatedDisplay = Optional.ofNullable(this.display).map(DisplayObject::toDotNotation).orElse(Map.of());
        dotNotatedDisplay.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> dotNotation.put(this.id + ".display." + (String)entry.getKey(), (String)entry.getValue()));
        return dotNotation;
    }

    public static SupportedCredentialConfiguration fromDotNotation(String credentialId, Map<String, String> dotNotated) {
        SupportedCredentialConfiguration supportedCredentialConfiguration = new SupportedCredentialConfiguration().setId(credentialId);
        Optional.ofNullable(dotNotated.get(credentialId + ".format")).map(Format::fromString).ifPresent(supportedCredentialConfiguration::setFormat);
        Optional.ofNullable(dotNotated.get(credentialId + ".scope")).ifPresent(supportedCredentialConfiguration::setScope);
        Optional.ofNullable(dotNotated.get(credentialId + ". credential_signing_alg_values_supported")).map(cbms -> cbms.split(",")).map(Arrays::asList).ifPresent(supportedCredentialConfiguration::setCryptographicBindingMethodsSupported);
        Optional.ofNullable(dotNotated.get(credentialId + ".cryptographic_suites_supported")).map(css -> css.split(",")).map(Arrays::asList).ifPresent(supportedCredentialConfiguration::setCryptographicSuitesSupported);
        Optional.ofNullable(dotNotated.get(credentialId + ".credential_signing_alg_values_supported")).map(css -> css.split(",")).map(Arrays::asList).ifPresent(supportedCredentialConfiguration::setCredentialSigningAlgValuesSupported);
        HashMap<String, String> displayMap = new HashMap<String, String>();
        dotNotated.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            if (key.startsWith(credentialId + ".display")) {
                displayMap.put(key.substring((credentialId + ".display").length() + 1), (String)entry.getValue());
            }
        });
        if (!displayMap.isEmpty()) {
            supportedCredentialConfiguration.setDisplay(DisplayObject.fromDotNotation(displayMap));
        }
        return supportedCredentialConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SupportedCredentialConfiguration)) {
            return false;
        }
        SupportedCredentialConfiguration that = (SupportedCredentialConfiguration)o;
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getFormat() != that.getFormat()) {
            return false;
        }
        if (this.getScope() != null ? !this.getScope().equals(that.getScope()) : that.getScope() != null) {
            return false;
        }
        if (this.getCryptographicBindingMethodsSupported() != null ? !this.getCryptographicBindingMethodsSupported().equals(that.getCryptographicBindingMethodsSupported()) : that.getCryptographicBindingMethodsSupported() != null) {
            return false;
        }
        if (this.getCryptographicSuitesSupported() != null ? !this.getCryptographicSuitesSupported().equals(that.getCryptographicSuitesSupported()) : that.getCryptographicSuitesSupported() != null) {
            return false;
        }
        if (this.getCredentialSigningAlgValuesSupported() != null ? !this.getCredentialSigningAlgValuesSupported().equals(that.getCredentialSigningAlgValuesSupported()) : that.getCredentialSigningAlgValuesSupported() != null) {
            return false;
        }
        return this.getDisplay() != null ? this.getDisplay().equals(that.getDisplay()) : that.getDisplay() == null;
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getFormat() != null ? this.getFormat().hashCode() : 0);
        result = 31 * result + (this.getScope() != null ? this.getScope().hashCode() : 0);
        result = 31 * result + (this.getCryptographicBindingMethodsSupported() != null ? this.getCryptographicBindingMethodsSupported().hashCode() : 0);
        result = 31 * result + (this.getCryptographicSuitesSupported() != null ? this.getCryptographicSuitesSupported().hashCode() : 0);
        result = 31 * result + (this.getCredentialSigningAlgValuesSupported() != null ? this.getCredentialSigningAlgValuesSupported().hashCode() : 0);
        result = 31 * result + (this.getDisplay() != null ? this.getDisplay().hashCode() : 0);
        return result;
    }
}

