/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jruby.dirgra.Edge;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LoadLocalVarPlacementProblem;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;

public class LoadLocalVarPlacementNode
extends FlowGraphNode<LoadLocalVarPlacementProblem, LoadLocalVarPlacementNode> {
    Set<LocalVariable> inRequiredLoads;
    Set<LocalVariable> outRequiredLoads;
    Set<LocalVariable> reqdLoads;

    public LoadLocalVarPlacementNode(LoadLocalVarPlacementProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.inRequiredLoads = new HashSet<LocalVariable>();
        this.outRequiredLoads = new HashSet<LocalVariable>();
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
    }

    @Override
    public void applyPreMeetHandler() {
        if (this.basicBlock.isExitBB()) {
            this.inRequiredLoads = ((LoadLocalVarPlacementProblem)this.problem).getLoadsOnScopeExit();
        }
    }

    @Override
    public void compute_MEET(Edge e, LoadLocalVarPlacementNode pred2) {
        this.inRequiredLoads.addAll(pred2.outRequiredLoads);
    }

    @Override
    public void initSolution() {
        this.reqdLoads = new HashSet<LocalVariable>(this.inRequiredLoads);
    }

    @Override
    public void applyTransferFunction(Instr i2) {
        FullInterpreterContext fic = ((LoadLocalVarPlacementProblem)this.problem).getFIC();
        boolean scopeBindingHasEscaped = fic.bindingHasEscaped();
        if (i2 instanceof ResultInstr) {
            this.reqdLoads.remove(((ResultInstr)((Object)i2)).getResult());
        }
        if (i2 instanceof ClosureAcceptingInstr) {
            Operand o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg();
            if (o != null && o instanceof WrappedIRClosure) {
                FullInterpreterContext clfic = ((WrappedIRClosure)o).getClosure().getFullInterpreterContext();
                HashSet<LocalVariable> newReqdLoads = new HashSet<LocalVariable>(this.reqdLoads);
                for (LocalVariable v : this.reqdLoads) {
                    if (!clfic.definesLocalVariable(v)) continue;
                    newReqdLoads.remove(v);
                }
                this.reqdLoads = newReqdLoads;
            }
            if (scopeBindingHasEscaped) {
                this.reqdLoads.clear();
            } else {
                HashSet<LocalVariable> newReqdLoads = new HashSet<LocalVariable>(this.reqdLoads);
                for (LocalVariable v : this.reqdLoads) {
                    if (fic.definesLocalVariable(v)) continue;
                    newReqdLoads.remove(v);
                }
                this.reqdLoads = newReqdLoads;
            }
        } else if (scopeBindingHasEscaped && i2.getOperation() == Operation.PUT_GLOBAL_VAR) {
            this.reqdLoads.clear();
        }
        if (i2.getOperation() == Operation.BINDING_STORE) {
            LocalVariable lv = ((StoreLocalVarInstr)i2).getLocalVar();
            if (!lv.isSelf()) {
                this.reqdLoads.add(lv);
            }
        } else {
            for (Variable x : i2.getUsedVariables()) {
                if (!(x instanceof LocalVariable) || x.isSelf()) continue;
                this.reqdLoads.add((LocalVariable)x);
            }
        }
    }

    @Override
    public boolean solutionChanged() {
        if (this.basicBlock.isEntryBB() || this.basicBlock.isRescueEntry()) {
            this.reqdLoads.clear();
        }
        return !this.outRequiredLoads.equals(this.reqdLoads);
    }

    @Override
    public void finalizeSolution() {
        this.outRequiredLoads = this.reqdLoads;
    }

    public String toString() {
        return "";
    }

    private TemporaryLocalVariable getLocalVarReplacement(LocalVariable v, FullInterpreterContext fic, Map<Operand, Operand> varRenameMap) {
        TemporaryLocalVariable value2 = (TemporaryLocalVariable)varRenameMap.get(v);
        if (value2 == null) {
            value2 = fic.getNewTemporaryVariableFor(v);
            varRenameMap.put(v, value2);
        }
        return value2;
    }

    public void addLoads(Map<Operand, Operand> varRenameMap) {
        FullInterpreterContext fic = ((LoadLocalVarPlacementProblem)this.problem).getFIC();
        IRScope scope = ((LoadLocalVarPlacementProblem)this.problem).getFIC().getScope();
        boolean isEvalScript = ((LoadLocalVarPlacementProblem)this.problem).getFIC().getScope() instanceof IREvalScript;
        boolean scopeBindingHasEscaped = fic.bindingHasEscaped();
        List<Instr> instrs = this.basicBlock.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        this.initSolution();
        while (it.hasPrevious()) {
            Instr i2 = it.previous();
            if (i2 instanceof ResultInstr) {
                this.reqdLoads.remove(((ResultInstr)((Object)i2)).getResult());
            }
            if (i2 instanceof ClosureAcceptingInstr) {
                Operand o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg();
                if (o != null && o instanceof WrappedIRClosure) {
                    FullInterpreterContext fullInterpreterContext = ((WrappedIRClosure)o).getClosure().getFullInterpreterContext();
                    it.next();
                    Iterator<LocalVariable> iter = this.reqdLoads.iterator();
                    while (iter.hasNext()) {
                        LocalVariable v = iter.next();
                        if (!fullInterpreterContext.definesLocalVariable(v)) continue;
                        it.add(new LoadLocalVarInstr(this.getLocalVarReplacement(v, fic, varRenameMap), v, scope));
                        it.previous();
                        iter.remove();
                    }
                    it.previous();
                }
                if (scopeBindingHasEscaped) {
                    it.next();
                    for (LocalVariable v : this.reqdLoads) {
                        it.add(new LoadLocalVarInstr(this.getLocalVarReplacement(v, fic, varRenameMap), v, scope));
                        it.previous();
                    }
                    it.previous();
                    this.reqdLoads.clear();
                } else {
                    it.next();
                    Iterator<LocalVariable> iterator = this.reqdLoads.iterator();
                    while (iterator.hasNext()) {
                        LocalVariable v;
                        v = iterator.next();
                        if (fic.definesLocalVariable(v)) continue;
                        it.add(new LoadLocalVarInstr(this.getLocalVarReplacement(v, fic, varRenameMap), v, scope));
                        it.previous();
                        iterator.remove();
                    }
                    it.previous();
                }
            } else if (scopeBindingHasEscaped && i2.getOperation() == Operation.PUT_GLOBAL_VAR || i2.getOperation() == Operation.THREAD_POLL) {
                it.next();
                for (LocalVariable localVariable : this.reqdLoads) {
                    it.add(new LoadLocalVarInstr(this.getLocalVarReplacement(localVariable, fic, varRenameMap), localVariable, scope));
                    it.previous();
                }
                it.previous();
                this.reqdLoads.clear();
            }
            if (i2.getOperation() == Operation.BINDING_STORE) {
                LocalVariable lv = ((StoreLocalVarInstr)i2).getLocalVar();
                if (lv.isSelf()) continue;
                this.reqdLoads.add(lv);
                this.getLocalVarReplacement(lv, fic, varRenameMap);
                continue;
            }
            for (Variable variable : i2.getUsedVariables()) {
                LocalVariable lv;
                if (!(variable instanceof LocalVariable) || (lv = (LocalVariable)variable).isSelf()) continue;
                this.reqdLoads.add(lv);
                this.getLocalVarReplacement(lv, fic, varRenameMap);
            }
        }
        if (this.basicBlock.isRescueEntry()) {
            for (LocalVariable v : this.reqdLoads) {
                it.add(new LoadLocalVarInstr(this.getLocalVarReplacement(v, fic, varRenameMap), v, scope));
            }
        }
        if (fic.getScope() instanceof IRClosure && this.basicBlock.isEntryBB()) {
            for (LocalVariable v : this.reqdLoads) {
                if (!fic.usesLocalVariable(v) && !fic.definesLocalVariable(v) || !isEvalScript && v instanceof ClosureLocalVariable && !((ClosureLocalVariable)v).isOuterScopeVar()) continue;
                it.add(new LoadLocalVarInstr(this.getLocalVarReplacement(v, fic, varRenameMap), v, scope));
            }
        }
    }
}

