/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jruby.ir.IRScope;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;

public class SexpMaker {
    public static String sha1(IRScope scope) {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
        DigestBuilder builder = new DigestBuilder(sha1);
        builder.append(scope.getId()).append('\n').append(scope.getScopeId());
        byte[] digest2 = builder.digest.digest();
        return new String(ConvertBytes.twosComplementToHexBytes(digest2, false));
    }

    private static class DigestBuilder {
        final MessageDigest digest;

        DigestBuilder(MessageDigest digest2) {
            this.digest = digest2;
        }

        public DigestBuilder append(Object o) {
            this.append(o.toString());
            return this;
        }

        public DigestBuilder append(ByteList str) {
            this.digest.update(str.unsafeBytes(), str.getBegin(), str.getRealSize());
            return this;
        }

        public DigestBuilder append(String str) {
            this.digest.update(str.getBytes());
            return this;
        }

        public DigestBuilder append(boolean b2) {
            this.append((byte)(b2 ? 1 : 0));
            return this;
        }

        public DigestBuilder append(char ch) {
            this.digest.update((byte)(ch >> 8));
            this.digest.update((byte)ch);
            return this;
        }

        public DigestBuilder append(int i2) {
            this.append((char)(i2 >> 16));
            this.append((char)i2);
            return this;
        }

        public DigestBuilder append(long l) {
            this.append((int)(l >> 32));
            this.append((int)l);
            return this;
        }

        public DigestBuilder append(double d) {
            this.append(Double.doubleToLongBits(d));
            return this;
        }
    }
}

