/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import com.southernstorm.noise.protocol.CipherState;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;

public final class Noise {
    public static final int MAX_PACKET_LEN = 65535;

    public static CipherState createCipher(String name) throws NoSuchAlgorithmException {
        if (name.equals("ChaChaPoly")) {
            return new ChaChaPolyCipherState();
        }
        throw new NoSuchAlgorithmException("Unknown Noise cipher algorithm name: " + name);
    }

    public static MessageDigest createHash(String name) throws NoSuchAlgorithmException {
        if (name.equals("SHA256")) {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException("Unknown Noise hash algorithm name: " + name);
    }

    static void destroy(byte[] array) {
        Arrays.fill(array, (byte)0);
    }

    static byte[] copySubArray(byte[] data, int offset, int length) {
        byte[] copy = new byte[length];
        System.arraycopy(data, offset, copy, 0, length);
        return copy;
    }

    static void throwBadTagException() throws BadPaddingException {
        try {
            Class<?> c = Class.forName("javax.crypto.AEADBadTagException");
            throw (BadPaddingException)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new BadPaddingException();
    }
}

