/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class SQLServerDataSource
implements DataSource,
Referenceable,
Serializable {
    static Logger dsLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerDataSource");
    private Properties connectionProps = new Properties();
    private String dataSourceURL;
    private String dataSourceDescription;
    private static int baseDataSourceID = 0;
    int dataSourceID = SQLServerDataSource.nextDataSourceID();
    private PrintWriter logWriter;

    public Connection getConnection() throws SQLException {
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine("dsID:" + this.dataSourceID + " user:(default)");
        }
        return this.getConnectionInternal(null, null, null);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine("dsID:" + this.dataSourceID + " user:" + string);
        }
        return this.getConnectionInternal(string, string2, null);
    }

    public void setLoginTimeout(int n) {
        this.setIntProperty(this.connectionProps, "loginTimeout", n);
    }

    public int getLoginTimeout() {
        return this.getIntProperty(this.connectionProps, "loginTimeout", 0);
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setApplicationName(String string) {
        this.setStringProperty(this.connectionProps, "applicationName", string);
    }

    public String getApplicationName() {
        return this.getStringProperty(this.connectionProps, "applicationName", "Microsoft SQL Server 2005 JDBC Driver");
    }

    public void setDatabaseName(String string) {
        this.setStringProperty(this.connectionProps, "databaseName", string);
    }

    public String getDatabaseName() {
        return this.getStringProperty(this.connectionProps, "databaseName", null);
    }

    public void setInstanceName(String string) {
        this.setStringProperty(this.connectionProps, "instanceName", string);
    }

    public String getInstanceName() {
        return this.getStringProperty(this.connectionProps, "instanceName", null);
    }

    public void setIntegratedSecurity(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "integratedSecurity", bl);
    }

    public void setLastUpdateCount(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "lastUpdateCount", bl);
    }

    public boolean getLastUpdateCount() {
        return this.getBooleanProperty(this.connectionProps, "lastUpdateCount", true);
    }

    public void setLockTimeout(int n) {
        this.setIntProperty(this.connectionProps, "lockTimeout", n);
    }

    public int getLockTimeout() {
        return this.getIntProperty(this.connectionProps, "lockTimeout", -1);
    }

    public void setPassword(String string) {
        this.setStringProperty(this.connectionProps, "password", string);
    }

    String getPassword() {
        return this.getStringProperty(this.connectionProps, "password", null);
    }

    public void setPortNumber(int n) {
        this.setIntProperty(this.connectionProps, "portNumber", n);
    }

    public int getPortNumber() {
        return this.getIntProperty(this.connectionProps, "portNumber", 1433);
    }

    public void setSelectMethod(String string) {
        this.setStringProperty(this.connectionProps, "selectMethod", string);
    }

    public String getSelectMethod() {
        return this.getStringProperty(this.connectionProps, "selectMethod", "direct");
    }

    public void setSendStringParametersAsUnicode(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "sendStringParametersAsUnicode", bl);
    }

    public boolean getSendStringParametersAsUnicode() {
        return this.getBooleanProperty(this.connectionProps, "sendStringParametersAsUnicode", true);
    }

    public void setServerName(String string) {
        this.setStringProperty(this.connectionProps, "serverName", string);
    }

    public String getServerName() {
        return this.getStringProperty(this.connectionProps, "serverName", null);
    }

    public void setFailoverPartner(String string) {
        this.setStringProperty(this.connectionProps, "failoverPartner", string);
    }

    public String getFailoverPartner() {
        return this.getStringProperty(this.connectionProps, "failoverPartner", null);
    }

    public void setUser(String string) {
        this.setStringProperty(this.connectionProps, "user", string);
    }

    public String getUser() {
        return this.getStringProperty(this.connectionProps, "user", null);
    }

    public void setWorkstationID(String string) {
        this.setStringProperty(this.connectionProps, "workstationID", string);
    }

    public String getWorkstationID() {
        String string = this.getStringProperty(this.connectionProps, "workstationID", null);
        if (null == string) {
            try {
                string = Util.lookupHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "WSID Not Available";
            }
        }
        return string;
    }

    public void setXopenStates(boolean bl) {
        this.setBooleanProperty(this.connectionProps, "xopenStates", bl);
    }

    public boolean getXopenStates() {
        return this.getBooleanProperty(this.connectionProps, "xopenStates", false);
    }

    public void setURL(String string) {
        this.dataSourceURL = string;
    }

    public String getURL() {
        if (null == this.dataSourceURL) {
            return "jdbc:sqlserver://";
        }
        return this.dataSourceURL;
    }

    public void setDescription(String string) {
        this.dataSourceDescription = string;
    }

    public String getDescription() {
        return this.dataSourceDescription;
    }

    public void setPacketSize(int n) {
        this.setIntProperty(this.connectionProps, "packetSize", n);
    }

    public int getPacketSize() {
        return this.getIntProperty(this.connectionProps, "packetSize", 4096);
    }

    private void setStringProperty(Properties properties, String string, String string2) {
        if (null == string2) {
            return;
        }
        properties.setProperty(string, string2);
    }

    private String getStringProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (null == string3) {
            return string2;
        }
        return string3;
    }

    private void setIntProperty(Properties properties, String string, int n) {
        properties.setProperty(string, new Integer(n).toString());
    }

    private int getIntProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (null == string2) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private void setBooleanProperty(Properties properties, String string, boolean bl) {
        properties.setProperty(string, bl ? "true" : "false");
    }

    private boolean getBooleanProperty(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string);
        if (null == string2) {
            return bl;
        }
        return Boolean.getBoolean(string2);
    }

    SQLServerConnection getConnectionInternal(String string, String string2, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Serializable serializable;
        Properties properties = null;
        Properties properties2 = null;
        if (null != string || null != string2) {
            properties = (Properties)this.connectionProps.clone();
            properties.remove("user");
            properties.remove("password");
            if (null != string) {
                properties.put("user", string);
            }
            if (null != string2) {
                properties.put("password", string2);
            }
        } else {
            properties = this.connectionProps;
        }
        if (null != this.dataSourceURL) {
            serializable = Util.parseUrl(this.dataSourceURL);
            properties2 = SQLServerDriver.mergeURLAndSuppliedProperties((Properties)serializable, properties);
        } else {
            properties2 = properties;
        }
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine("dsID:" + this.dataSourceID + " Begin create new connection.");
        }
        serializable = new SQLServerConnection();
        ((SQLServerConnection)serializable).sConnectURL = this.dataSourceURL;
        ((SQLServerConnection)serializable).connect(properties2, sQLServerPooledConnection);
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine("dsID:" + this.dataSourceID + " End create new connection -> cID:" + ((SQLServerConnection)serializable).connectionID);
        }
        return serializable;
    }

    public Reference getReference() {
        return this.getReferenceInternal("com.microsoft.sqlserver.jdbc.SQLServerDataSource");
    }

    Reference getReferenceInternal(String string) {
        if (dsLogger.isLoggable(Level.FINE)) {
            dsLogger.fine("dsID:" + this.dataSourceID + " creating reference for " + string + ".");
        }
        Reference reference = new Reference(this.getClass().getName(), "com.microsoft.sqlserver.jdbc.SQLServerDataSourceObjectFactory", null);
        reference.add(new StringRefAddr("class", string));
        Enumeration<Object> enumeration = this.connectionProps.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            reference.add(new StringRefAddr(string2, this.connectionProps.getProperty(string2)));
        }
        if (null != this.dataSourceURL) {
            reference.add(new StringRefAddr("dataSourceURL", this.dataSourceURL));
        }
        if (null != this.dataSourceDescription) {
            reference.add(new StringRefAddr("dataSourceDescription", this.dataSourceDescription));
        }
        return reference;
    }

    void initializeFromReference(Reference reference) {
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            StringRefAddr stringRefAddr = (StringRefAddr)enumeration.nextElement();
            String string = stringRefAddr.getType();
            String string2 = (String)stringRefAddr.getContent();
            if (string.equals("dataSourceURL")) {
                this.dataSourceURL = string2;
                continue;
            }
            if (string.equals("dataSourceDescription")) {
                this.dataSourceDescription = string2;
                continue;
            }
            if (string.equals("class")) continue;
            this.connectionProps.setProperty(string, string2);
        }
    }

    SQLServerDataSource cloneInternal() {
        SQLServerDataSource sQLServerDataSource = new SQLServerDataSource();
        sQLServerDataSource.connectionProps = (Properties)this.connectionProps.clone();
        sQLServerDataSource.dataSourceDescription = this.dataSourceDescription;
        sQLServerDataSource.dataSourceURL = this.dataSourceURL;
        return sQLServerDataSource;
    }

    private static synchronized int nextDataSourceID() {
        return ++baseDataSourceID;
    }
}

