/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextSpanLayout;

public class TextNode
extends AbstractGraphicsNode
implements Selectable {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    protected Point2D location = new Point2D.Float(0.0f, 0.0f);
    protected AttributedCharacterIterator aci;
    protected String text;
    protected Mark beginMark = null;
    protected Mark endMark = null;
    protected List textRuns;
    protected TextPainter textPainter = StrokingTextPainter.getInstance();
    private Rectangle2D geometryBounds;
    private Rectangle2D primitiveBounds;
    private Shape outline;

    public void setTextPainter(TextPainter textPainter) {
        this.textPainter = textPainter == null ? StrokingTextPainter.getInstance() : textPainter;
    }

    public TextPainter getTextPainter() {
        return this.textPainter;
    }

    public List getTextRuns() {
        return this.textRuns;
    }

    public void setTextRuns(List list) {
        this.textRuns = list;
    }

    public String getText() {
        if (this.text == null) {
            StringBuffer stringBuffer = new StringBuffer(this.aci.getEndIndex());
            char c = this.aci.first();
            while (c != '\uffff') {
                stringBuffer.append(c);
                c = this.aci.next();
            }
            this.text = stringBuffer.toString();
        }
        return this.text;
    }

    public void setLocation(Point2D point2D) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.location = point2D;
        this.fireGraphicsNodeChangeCompleted();
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void swapTextPaintInfo(TextPaintInfo textPaintInfo, TextPaintInfo textPaintInfo2) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        textPaintInfo2.set(textPaintInfo);
        this.fireGraphicsNodeChangeCompleted();
    }

    public void setAttributedCharacterIterator(AttributedCharacterIterator attributedCharacterIterator) {
        this.fireGraphicsNodeChangeStarted();
        this.invalidateGeometryCache();
        this.aci = attributedCharacterIterator;
        this.text = null;
        this.textRuns = null;
        this.fireGraphicsNodeChangeCompleted();
    }

    public AttributedCharacterIterator getAttributedCharacterIterator() {
        return this.aci;
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.primitiveBounds = null;
        this.geometryBounds = null;
        this.outline = null;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds == null && this.aci != null) {
            this.primitiveBounds = this.textPainter.getBounds2D(this);
        }
        return this.primitiveBounds;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null && this.aci != null) {
            this.geometryBounds = this.textPainter.getGeometryBounds(this);
        }
        return this.geometryBounds;
    }

    public Rectangle2D getSensitiveBounds() {
        return this.getGeometryBounds();
    }

    public Shape getOutline() {
        if (this.outline == null && this.aci != null) {
            this.outline = this.textPainter.getOutline(this);
        }
        return this.outline;
    }

    public Mark getMarkerForChar(int n, boolean bl) {
        return this.textPainter.getMark(this, n, bl);
    }

    public void setSelection(Mark mark, Mark mark2) {
        if (mark.getTextNode() != this || mark2.getTextNode() != this) {
            throw new Error("Markers not from this TextNode");
        }
        this.beginMark = mark;
        this.endMark = mark2;
    }

    public boolean selectAt(double d, double d2) {
        this.beginMark = this.textPainter.selectAt(d, d2, this);
        return true;
    }

    public boolean selectTo(double d, double d2) {
        Mark mark = this.textPainter.selectTo(d, d2, this.beginMark);
        if (mark == null) {
            return false;
        }
        if (mark != this.endMark) {
            this.endMark = mark;
            return true;
        }
        return false;
    }

    public boolean selectAll(double d, double d2) {
        this.beginMark = this.textPainter.selectFirst(this);
        this.endMark = this.textPainter.selectLast(this);
        return true;
    }

    public Object getSelection() {
        int[] nArray = this.textPainter.getSelected(this.beginMark, this.endMark);
        AttributedCharacterSpanIterator attributedCharacterSpanIterator = null;
        if (nArray != null && nArray.length > 1) {
            if (nArray[0] > nArray[1]) {
                int n = nArray[1];
                nArray[1] = nArray[0];
                nArray[0] = n;
            }
            attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(this.aci, nArray[0], nArray[1] + 1);
        }
        return attributedCharacterSpanIterator;
    }

    public Shape getHighlightShape() {
        Shape shape = this.textPainter.getHighlightShape(this.beginMark, this.endMark);
        AffineTransform affineTransform = this.getGlobalTransform();
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public void primitivePaint(Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        if (shape != null && !(shape instanceof GeneralPath)) {
            graphics2D.setClip(new GeneralPath(shape));
        }
        this.textPainter.paint(this, graphics2D);
    }

    public boolean contains(Point2D point2D) {
        if (!super.contains(point2D)) {
            return false;
        }
        List list = this.getTextRuns();
        int n = 0;
        while (n < list.size()) {
            float f;
            float f2;
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            TextHit textHit = textSpanLayout.hitTestChar(f2 = (float)point2D.getX(), f = (float)point2D.getY());
            if (textHit != null && this.contains(point2D, textSpanLayout.getBounds2D())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean contains(Point2D point2D, Rectangle2D rectangle2D) {
        if (rectangle2D == null || !rectangle2D.contains(point2D)) {
            return false;
        }
        switch (this.pointerEventType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.isVisible;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
            case 8: {
                return false;
            }
        }
        return false;
    }

    public static final class Anchor
    implements Serializable {
        public static final int ANCHOR_START = 0;
        public static final int ANCHOR_MIDDLE = 1;
        public static final int ANCHOR_END = 2;
        public static final Anchor START = new Anchor(0);
        public static final Anchor MIDDLE = new Anchor(1);
        public static final Anchor END = new Anchor(2);
        private int type;

        private Anchor(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.type) {
                case 0: {
                    return START;
                }
                case 1: {
                    return MIDDLE;
                }
                case 2: {
                    return END;
                }
            }
            throw new Error("Unknown Anchor type");
        }
    }
}

