/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.persistence;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.OpenClosedType;
import org.openhab.core.persistence.FilterCriteria;
import org.openhab.core.persistence.HistoricItem;
import org.openhab.core.persistence.ModifiablePersistenceService;
import org.openhab.core.persistence.PersistenceItemConfiguration;
import org.openhab.core.persistence.PersistenceItemInfo;
import org.openhab.core.persistence.PersistenceManager;
import org.openhab.core.persistence.PersistenceService;
import org.openhab.core.persistence.PersistenceServiceRegistry;
import org.openhab.core.persistence.QueryablePersistenceService;
import org.openhab.core.persistence.config.PersistenceAllConfig;
import org.openhab.core.persistence.dto.ItemHistoryDTO;
import org.openhab.core.persistence.dto.PersistenceServiceConfigurationDTO;
import org.openhab.core.persistence.dto.PersistenceServiceDTO;
import org.openhab.core.persistence.registry.ManagedPersistenceServiceConfigurationProvider;
import org.openhab.core.persistence.registry.PersistenceServiceConfiguration;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationDTOMapper;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationRegistry;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="persistence")
@Tag(name="persistence")
@Component
@JaxrsResource
@JaxrsName(value="persistence")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class PersistenceResource
implements RESTResource {
    public static final String PATH_PERSISTENCE = "persistence";
    private final Logger logger = LoggerFactory.getLogger(PersistenceResource.class);
    private static final String MODIFYABLE = "Modifiable";
    private static final String QUERYABLE = "Queryable";
    private static final String STANDARD = "Standard";
    private final ItemRegistry itemRegistry;
    private final LocaleService localeService;
    private final PersistenceServiceRegistry persistenceServiceRegistry;
    private final PersistenceManager persistenceManager;
    private final PersistenceServiceConfigurationRegistry persistenceServiceConfigurationRegistry;
    private final ManagedPersistenceServiceConfigurationProvider managedPersistenceServiceConfigurationProvider;
    private final TimeZoneProvider timeZoneProvider;

    @Activate
    public PersistenceResource(@Reference ItemRegistry itemRegistry, @Reference LocaleService localeService, @Reference PersistenceServiceRegistry persistenceServiceRegistry, @Reference PersistenceManager persistenceManager, @Reference PersistenceServiceConfigurationRegistry persistenceServiceConfigurationRegistry, @Reference ManagedPersistenceServiceConfigurationProvider managedPersistenceServiceConfigurationProvider, @Reference TimeZoneProvider timeZoneProvider) {
        this.itemRegistry = itemRegistry;
        this.localeService = localeService;
        this.persistenceServiceRegistry = persistenceServiceRegistry;
        this.persistenceManager = persistenceManager;
        this.persistenceServiceConfigurationRegistry = persistenceServiceConfigurationRegistry;
        this.managedPersistenceServiceConfigurationProvider = managedPersistenceServiceConfigurationProvider;
        this.timeZoneProvider = timeZoneProvider;
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Produces(value={"application/json"})
    @Operation(operationId="getPersistenceServices", summary="Gets a list of persistence services.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=PersistenceServiceDTO.class)))})})
    public Response httpGetPersistenceServices(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        List<PersistenceServiceDTO> responseObject = this.getPersistenceServiceList(locale);
        return Response.ok(responseObject).build();
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Produces(value={"application/json"})
    @Path(value="{serviceId: [a-zA-Z0-9]+}")
    @Operation(operationId="getPersistenceServiceConfiguration", summary="Gets a persistence service configuration.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=PersistenceServiceConfigurationDTO.class))}), @ApiResponse(responseCode="404", description="Service configuration not found.")})
    public Response httpGetPersistenceServiceConfiguration(@Context HttpHeaders headers, @Parameter(description="Id of the persistence service.") @PathParam(value="serviceId") String serviceId) {
        PersistenceService service;
        boolean editable;
        PersistenceServiceConfiguration configuration = (PersistenceServiceConfiguration)this.persistenceServiceConfigurationRegistry.get((Object)serviceId);
        boolean bl = editable = this.managedPersistenceServiceConfigurationProvider.get((Object)serviceId) != null;
        if (configuration == null && (service = this.persistenceServiceRegistry.get(serviceId)) != null) {
            List strategies = service.getDefaultStrategies();
            List<PersistenceItemConfiguration> configs = List.of(new PersistenceItemConfiguration(List.of(new PersistenceAllConfig()), null, strategies, null));
            configuration = new PersistenceServiceConfiguration(serviceId, configs, (Collection)strategies, (Collection)strategies, List.of());
            editable = true;
        }
        if (configuration != null) {
            PersistenceServiceConfigurationDTO configurationDTO = PersistenceServiceConfigurationDTOMapper.map((PersistenceServiceConfiguration)configuration);
            configurationDTO.editable = editable;
            return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)configurationDTO, null);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{serviceId: [a-zA-Z0-9]+}")
    @Operation(operationId="putPersistenceServiceConfiguration", summary="Sets a persistence service configuration.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=PersistenceServiceConfigurationDTO.class))}), @ApiResponse(responseCode="201", description="PersistenceServiceConfiguration created."), @ApiResponse(responseCode="400", description="Payload invalid."), @ApiResponse(responseCode="405", description="PersistenceServiceConfiguration not editable.")})
    public Response httpPutPersistenceServiceConfiguration(@Context UriInfo uriInfo, @Context HttpHeaders headers, @Parameter(description="Id of the persistence service.") @PathParam(value="serviceId") String serviceId, @Parameter(description="service configuration", required=true) @Nullable PersistenceServiceConfigurationDTO serviceConfigurationDTO) {
        PersistenceServiceConfiguration persistenceServiceConfiguration;
        if (serviceConfigurationDTO == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Payload must not be null.");
        }
        if (!serviceId.equals(serviceConfigurationDTO.serviceId)) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("serviceId in payload '" + serviceConfigurationDTO.serviceId + "' differs from serviceId in URL '" + serviceId + "'"));
        }
        try {
            persistenceServiceConfiguration = PersistenceServiceConfigurationDTOMapper.map((PersistenceServiceConfigurationDTO)serviceConfigurationDTO);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Received HTTP PUT request at '{}' with an invalid payload: '{}'.", (Object)uriInfo.getPath(), (Object)e.getMessage());
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
        }
        if (this.persistenceServiceConfigurationRegistry.get((Object)serviceId) == null) {
            this.managedPersistenceServiceConfigurationProvider.add((Identifiable)persistenceServiceConfiguration);
            return JSONResponse.createResponse((Response.StatusType)Response.Status.CREATED, (Object)serviceConfigurationDTO, null);
        }
        if (this.managedPersistenceServiceConfigurationProvider.get((Object)serviceId) != null) {
            this.managedPersistenceServiceConfigurationProvider.update((Identifiable)persistenceServiceConfiguration);
            return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)serviceConfigurationDTO, null);
        }
        this.logger.warn("Cannot update existing persistence service configuration '{}', because is not managed.", (Object)serviceId);
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.METHOD_NOT_ALLOWED, (String)("Cannot update non-managed persistence service configuration " + serviceId));
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="{serviceId: [a-zA-Z0-9]+}")
    @Operation(operationId="deletePersistenceServiceConfiguration", summary="Deletes a persistence service configuration.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Persistence service configuration not found."), @ApiResponse(responseCode="405", description="Persistence service configuration not editable.")})
    public Response httpDeletePersistenceServiceConfiguration(@Context UriInfo uriInfo, @Context HttpHeaders headers, @Parameter(description="Id of the persistence service.") @PathParam(value="serviceId") String serviceId) {
        if (this.persistenceServiceConfigurationRegistry.get((Object)serviceId) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (this.managedPersistenceServiceConfigurationProvider.remove((Object)serviceId) == null) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"administrator"})
    @Path(value="/items")
    @Produces(value={"application/json"})
    @Operation(operationId="getItemsForPersistenceService", summary="Gets a list of items available via a specific persistence service.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=PersistenceItemInfo.class), uniqueItems=true))})})
    public Response httpGetPersistenceServiceItems(@Context HttpHeaders headers, @Parameter(description="Id of the persistence service. If not provided the default service will be used") @QueryParam(value="serviceId") @Nullable String serviceId) {
        return this.getServiceItemList(serviceId);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/items/{itemname: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="getItemDataFromPersistenceService", summary="Gets item persistence data from the persistence service.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ItemHistoryDTO.class))}), @ApiResponse(responseCode="404", description="Unknown Item or persistence service")})
    public Response httpGetPersistenceItemData(@Context HttpHeaders headers, @Parameter(description="Id of the persistence service. If not provided the default service will be used") @QueryParam(value="serviceId") @Nullable String serviceId, @Parameter(description="The item name") @PathParam(value="itemname") String itemName, @Parameter(description="Start time of the data to return. Will default to 1 day before endtime. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]") @QueryParam(value="starttime") @Nullable String startTime, @Parameter(description="End time of the data to return. Will default to current time. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]") @QueryParam(value="endtime") @Nullable String endTime, @Parameter(description="Page number of data to return. This parameter will enable paging.") @QueryParam(value="page") int pageNumber, @Parameter(description="The length of each page.") @QueryParam(value="pagelength") int pageLength, @Parameter(description="Gets one value before and after the requested period.") @QueryParam(value="boundary") boolean boundary) {
        return this.getItemHistoryDTO(serviceId, itemName, startTime, endTime, pageNumber, pageLength, boundary);
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/items/{itemname: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="deleteItemFromPersistenceService", summary="Deletes item persistence data from a specific persistence service in a given time range.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))}), @ApiResponse(responseCode="400", description="Invalid filter parameters"), @ApiResponse(responseCode="404", description="Unknown persistence service")})
    public Response httpDeletePersistenceServiceItem(@Context HttpHeaders headers, @Parameter(description="Id of the persistence service.", required=true) @QueryParam(value="serviceId") String serviceId, @Parameter(description="The item name.") @PathParam(value="itemname") String itemName, @Parameter(description="Start of the time range to be deleted. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]", required=true) @QueryParam(value="starttime") String startTime, @Parameter(description="End of the time range to be deleted. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]", required=true) @QueryParam(value="endtime") String endTime) {
        return this.deletePersistenceItemData(serviceId, itemName, startTime, endTime);
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/items/{itemname: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="storeItemDataInPersistenceService", summary="Stores item persistence data into the persistence service.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Unknown Item or persistence service")})
    public Response httpPutPersistenceItemData(@Context HttpHeaders headers, @Parameter(description="Id of the persistence service. If not provided the default service will be used") @QueryParam(value="serviceId") @Nullable String serviceId, @Parameter(description="The item name.") @PathParam(value="itemname") String itemName, @Parameter(description="Time of the data to be stored. Will default to current time. [yyyy-MM-dd'T'HH:mm:ss.SSSZ]", required=true) @QueryParam(value="time") String time, @Parameter(description="The state to store.", required=true) @QueryParam(value="state") String value) {
        return this.putItemState(serviceId, itemName, value, time);
    }

    private ZonedDateTime convertTime(String sTime) {
        DateTimeType dateTime = new DateTimeType(sTime);
        return dateTime.getZonedDateTime();
    }

    private Response getItemHistoryDTO(@Nullable String serviceId, String itemName, @Nullable String timeBegin, @Nullable String timeEnd, int pageNumber, int pageLength, boolean boundary) {
        long timerStart = System.currentTimeMillis();
        @Nullable ItemHistoryDTO dto = this.createDTO(serviceId, itemName, timeBegin, timeEnd, pageNumber, pageLength, boundary);
        if (dto == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Persistence service not queryable: " + serviceId));
        }
        this.logger.debug("Persistence returned {} rows in {}ms", (Object)dto.datapoints, (Object)(System.currentTimeMillis() - timerStart));
        return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)dto, (String)"");
    }

    protected @Nullable ItemHistoryDTO createDTO(@Nullable String serviceId, String itemName, @Nullable String timeBegin, @Nullable String timeEnd, int pageNumber, int pageLength, boolean boundary) {
        Iterable result;
        ZonedDateTime dateTimeBegin;
        String effectiveServiceId = serviceId != null ? serviceId : this.persistenceServiceRegistry.getDefaultId();
        PersistenceService service = this.persistenceServiceRegistry.get(effectiveServiceId);
        if (service == null) {
            this.logger.debug("Persistence service not found '{}'.", (Object)effectiveServiceId);
            return null;
        }
        if (!(service instanceof QueryablePersistenceService)) {
            this.logger.debug("Persistence service not queryable '{}'.", (Object)effectiveServiceId);
            return null;
        }
        QueryablePersistenceService qService = (QueryablePersistenceService)service;
        ZonedDateTime dateTimeEnd = dateTimeBegin = ZonedDateTime.now();
        if (timeBegin != null) {
            dateTimeBegin = this.convertTime(timeBegin);
        }
        if (timeEnd != null) {
            dateTimeEnd = this.convertTime(timeEnd);
        }
        if (dateTimeEnd.toEpochSecond() == 0L) {
            dateTimeEnd = ZonedDateTime.of(LocalDateTime.now(), this.timeZoneProvider.getTimeZone());
        }
        if (dateTimeBegin.toEpochSecond() == 0L) {
            dateTimeBegin = ZonedDateTime.of(dateTimeEnd.toLocalDateTime().plusDays(-1L), this.timeZoneProvider.getTimeZone());
        }
        if (dateTimeBegin.isAfter(dateTimeEnd) || dateTimeBegin.isEqual(dateTimeEnd)) {
            dateTimeBegin = ZonedDateTime.of(dateTimeEnd.toLocalDateTime().plusDays(-1L), this.timeZoneProvider.getTimeZone());
        }
        long quantity = 0L;
        ItemHistoryDTO dto = new ItemHistoryDTO();
        dto.name = itemName;
        if (boundary) {
            FilterCriteria filterBeforeStart = new FilterCriteria();
            filterBeforeStart.setItemName(itemName);
            filterBeforeStart.setEndDate(dateTimeBegin);
            filterBeforeStart.setPageSize(1);
            filterBeforeStart.setOrdering(FilterCriteria.Ordering.DESCENDING);
            result = qService.query(filterBeforeStart);
            if (result.iterator().hasNext()) {
                dto.addData(dateTimeBegin.toInstant().toEpochMilli(), ((HistoricItem)result.iterator().next()).getState());
                ++quantity;
            }
        }
        FilterCriteria filter = new FilterCriteria();
        filter.setItemName(itemName);
        if (pageLength == 0) {
            filter.setPageNumber(0);
            filter.setPageSize(Integer.MAX_VALUE);
        } else {
            filter.setPageNumber(pageNumber);
            filter.setPageSize(pageLength);
        }
        filter.setBeginDate(dateTimeBegin);
        filter.setEndDate(dateTimeEnd);
        filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
        result = qService.query(filter);
        Iterator it = result.iterator();
        Object lastState = null;
        while (it.hasNext()) {
            HistoricItem historicItem = (HistoricItem)it.next();
            State state = historicItem.getState();
            long timestamp = historicItem.getTimestamp().toInstant().toEpochMilli();
            if ((state instanceof OnOffType || state instanceof OpenClosedType) && lastState != null && !lastState.equals(state)) {
                dto.addData(timestamp, (State)lastState);
                ++quantity;
            }
            dto.addData(timestamp, state);
            ++quantity;
            lastState = state;
        }
        if (boundary) {
            FilterCriteria filterAfterEnd = new FilterCriteria();
            filterAfterEnd.setItemName(itemName);
            filterAfterEnd.setBeginDate(dateTimeEnd);
            filterAfterEnd.setPageSize(1);
            filterAfterEnd.setOrdering(FilterCriteria.Ordering.ASCENDING);
            result = qService.query(filterAfterEnd);
            if (result.iterator().hasNext()) {
                dto.addData(dateTimeEnd.toInstant().toEpochMilli(), ((HistoricItem)result.iterator().next()).getState());
                ++quantity;
            }
        }
        dto.datapoints = Long.toString(quantity);
        return dto;
    }

    private List<PersistenceServiceDTO> getPersistenceServiceList(Locale locale) {
        ArrayList<PersistenceServiceDTO> dtoList = new ArrayList<PersistenceServiceDTO>();
        for (PersistenceService service : this.persistenceServiceRegistry.getAll()) {
            PersistenceServiceDTO serviceDTO = new PersistenceServiceDTO();
            serviceDTO.id = service.getId();
            serviceDTO.label = service.getLabel(locale);
            serviceDTO.type = service instanceof ModifiablePersistenceService ? MODIFYABLE : (service instanceof QueryablePersistenceService ? QUERYABLE : STANDARD);
            dtoList.add(serviceDTO);
        }
        return dtoList;
    }

    private Response getServiceItemList(@Nullable String serviceId) {
        PersistenceService service = serviceId == null ? this.persistenceServiceRegistry.getDefault() : this.persistenceServiceRegistry.get(serviceId);
        if (service == null) {
            this.logger.debug("Persistence service not found '{}'.", (Object)serviceId);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Persistence service not found: " + serviceId));
        }
        if (!(service instanceof QueryablePersistenceService)) {
            this.logger.debug("Persistence service not queryable '{}'.", (Object)serviceId);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Persistence service not queryable: " + serviceId));
        }
        QueryablePersistenceService qService = (QueryablePersistenceService)service;
        return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)qService.getItemInfo(), (String)"");
    }

    private Response deletePersistenceItemData(@Nullable String serviceId, String itemName, @Nullable String timeBegin, @Nullable String timeEnd) {
        if (serviceId == null || serviceId.isEmpty()) {
            this.logger.debug("Persistence service must be specified for delete operations.");
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Persistence service must be specified for delete operations.");
        }
        PersistenceService service = this.persistenceServiceRegistry.get(serviceId);
        if (service == null) {
            this.logger.debug("Persistence service not found '{}'.", (Object)serviceId);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Persistence service not found: " + serviceId));
        }
        if (!(service instanceof ModifiablePersistenceService)) {
            this.logger.warn("Persistence service not modifiable '{}'.", (Object)serviceId);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Persistence service not modifiable: " + serviceId));
        }
        if (timeBegin == null || timeEnd == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"The start and end time must be set");
        }
        ZonedDateTime dateTimeBegin = this.convertTime(timeBegin);
        ZonedDateTime dateTimeEnd = this.convertTime(timeEnd);
        if (dateTimeEnd.isBefore(dateTimeBegin)) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Start time must be earlier than end time");
        }
        FilterCriteria filter = new FilterCriteria();
        filter.setItemName(itemName);
        filter.setBeginDate(dateTimeBegin);
        filter.setEndDate(dateTimeEnd);
        ModifiablePersistenceService mService = (ModifiablePersistenceService)service;
        try {
            mService.remove(filter);
        }
        catch (IllegalArgumentException e) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Invalid filter parameters.");
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private Response putItemState(@Nullable String serviceId, String itemName, String value, @Nullable String time) {
        Item item;
        String effectiveServiceId = serviceId != null ? serviceId : this.persistenceServiceRegistry.getDefaultId();
        PersistenceService service = this.persistenceServiceRegistry.get(effectiveServiceId);
        if (service == null) {
            this.logger.warn("Persistence service not found '{}'.", (Object)effectiveServiceId);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Persistence service not found: " + effectiveServiceId));
        }
        if (!(service instanceof ModifiablePersistenceService)) {
            this.logger.warn("Persistence service not modifiable '{}'.", (Object)effectiveServiceId);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Persistence service not modifiable: " + effectiveServiceId));
        }
        try {
            item = this.itemRegistry.getItem(itemName);
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Item not found '{}'.", (Object)itemName);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("Item not found: " + itemName));
        }
        State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)value);
        if (state == null) {
            this.logger.warn("Can't persist item {} with invalid state '{}'.", (Object)itemName, (Object)value);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("State could not be parsed: " + value));
        }
        ChronoZonedDateTime dateTime = null;
        if (time != null && !time.isEmpty()) {
            dateTime = this.convertTime(time);
        }
        if (dateTime == null || dateTime.toEpochSecond() == 0L) {
            this.logger.warn("Error with persistence store to {}. Time badly formatted {}.", (Object)itemName, (Object)time);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Time badly formatted.");
        }
        ModifiablePersistenceService mService = (ModifiablePersistenceService)service;
        mService.store(item, (ZonedDateTime)dateTime, state);
        this.persistenceManager.handleExternalPersistenceDataChange((PersistenceService)mService, item);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

