/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.hierarchy;

import aQute.lib.hierarchy.FolderNode;
import aQute.lib.hierarchy.LeafNode;
import aQute.lib.hierarchy.NamedNode;
import aQute.libg.ints.IntCounter;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Hierarchy
implements Iterable<NamedNode> {
    final RootNode root;

    public Hierarchy(Map<String, Object> map) {
        this.root = new RootNode(map);
    }

    public Optional<FolderNode> findFolder(String path) {
        return this.find(path).filter(NamedNode::isFolder).map(FolderNode.class::cast);
    }

    public Optional<FolderNode> findFolder(String[] parts) {
        return this.find(parts).filter(NamedNode::isFolder).map(FolderNode.class::cast);
    }

    public Optional<NamedNode> find(String path) {
        return this.root.find(path);
    }

    @Override
    public Iterator<NamedNode> iterator() {
        return new Iterator<NamedNode>(){
            Node node;
            {
                this.node = Hierarchy.this.root;
            }

            @Override
            public boolean hasNext() {
                return this.node != null;
            }

            @Override
            public Node next() {
                int n;
                if (this.node == null) {
                    throw new NoSuchElementException();
                }
                Node ret = this.node;
                if (this.node instanceof Folder) {
                    Folder folder = (Folder)this.node;
                    if (folder.children.length > 0) {
                        this.node = folder.children[0];
                        return ret;
                    }
                }
                Folder rover = this.node.parent.orElse(null);
                while (true) {
                    if (rover == null) {
                        this.node = null;
                        return ret;
                    }
                    n = this.node.parent.get().indexOf(this.node);
                    assert (n >= 0) : "we are its child!";
                    if (++n < rover.children.length) break;
                    this.node = rover;
                    rover = rover.parent.orElse(null);
                }
                this.node = rover.children[n];
                return ret;
            }
        };
    }

    protected Object payload(LeafNode node) {
        return ((Leaf)node).payload;
    }

    protected Map<String, ?> asMap() {
        return new AbstractMap<String, Object>(){

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        final Iterator<NamedNode> i = Hierarchy.this.iterator();
                        return new Iterator<Map.Entry<String, Object>>(){

                            @Override
                            public boolean hasNext() {
                                return i.hasNext();
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                final NamedNode next = (NamedNode)i.next();
                                return new Map.Entry<String, Object>(){

                                    @Override
                                    public String getKey() {
                                        return next.path();
                                    }

                                    @Override
                                    public Object getValue() {
                                        if (next instanceof Leaf) {
                                            return ((Leaf)next).payload;
                                        }
                                        return null;
                                    }

                                    @Override
                                    public NamedNode setValue(Object value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return Hierarchy.this.root.size;
                    }
                };
            }

            @Override
            public Object get(Object key) {
                if (!(key instanceof String)) {
                    return null;
                }
                String path = (String)key;
                return Hierarchy.this.find(path).filter(n -> n instanceof Leaf).map(Leaf.class::cast).map(Leaf::payload).orElse(null);
            }

            @Override
            public int size() {
                return Hierarchy.this.root.size;
            }
        };
    }

    public int size() {
        return this.root.size;
    }

    public Stream<NamedNode> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Optional<NamedNode> find(String[] parts) {
        return Optional.ofNullable(this.root.find(parts, 0));
    }

    static class RootNode
    extends Folder {
        final int size;

        public RootNode(Map<String, Object> map) {
            this(map, new IntCounter(1));
        }

        private RootNode(Map<String, Object> map, IntCounter size) {
            super(Optional.empty(), "", map, size);
            this.size = size.get();
        }

        @Override
        void getPath(StringBuilder app) {
        }

        @Override
        public FolderNode root() {
            return this;
        }

        @Override
        public Optional<? extends Folder> parent() {
            return Optional.empty();
        }
    }

    static class Leaf
    extends Node
    implements LeafNode {
        final Object payload;

        Leaf(Folder parent, String name, Object payload) {
            super(Optional.of(parent), name);
            this.payload = payload;
        }

        @Override
        void getPath(StringBuilder app) {
            ((Folder)this.parent.get()).getPath(app);
            app.append(this.name);
        }

        public String toString() {
            return this.name;
        }

        Object payload() {
            return this.payload;
        }
    }

    static abstract class Node
    implements NamedNode {
        final Optional<Folder> parent;
        final String name;

        Node(Optional<Folder> parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String path() {
            StringBuilder sb = new StringBuilder();
            this.getPath(sb);
            return sb.toString();
        }

        @Override
        public int compareTo(NamedNode b) {
            return this.name.compareTo(b.name());
        }

        abstract void getPath(StringBuilder var1);

        public Optional<? extends Folder> parent() {
            return this.parent;
        }

        @Override
        public FolderNode root() {
            return this.parent.get().root();
        }

        @Override
        public Optional<NamedNode> find(String path) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            String[] parts = path.isEmpty() ? new String[]{} : path.split("/");
            Node node = this.find(parts, 0);
            return Optional.ofNullable(node);
        }

        Node find(String[] parts, int i) {
            if (i == parts.length || ".".equals(parts[i])) {
                return this;
            }
            if ("..".equals(parts[i])) {
                if (this.isRoot()) {
                    throw new IllegalArgumentException(".. attempts to go beyond root");
                }
                return this.parent.get();
            }
            return null;
        }
    }

    static class OrphanNode
    extends Node {
        OrphanNode(String name) {
            super(null, name);
        }

        @Override
        Node find(String[] parts, int i) {
            assert (false) : "May not be called";
            return null;
        }

        @Override
        void getPath(StringBuilder app) {
            assert (false) : "May not be called";
        }
    }

    static class Folder
    extends Node
    implements FolderNode {
        final Node[] children;

        Folder(Optional<Folder> parent, String name, Map<String, Object> map, IntCounter size) {
            super(parent, name);
            this.children = new Node[map.size()];
            int n = 0;
            for (Map.Entry<String, Object> e : map.entrySet()) {
                Object value = e.getValue();
                if (value instanceof Map) {
                    Map sub = (Map)value;
                    Folder folder = new Folder(Optional.of(this), e.getKey(), sub, size);
                    this.children[n] = folder;
                } else {
                    this.children[n] = new Leaf(this, e.getKey(), value);
                }
                ++n;
                size.inc();
            }
            Arrays.sort(this.children);
        }

        @Override
        void getPath(StringBuilder app) {
            ((Folder)this.parent.get()).getPath(app);
            app.append(this.name).append("/");
        }

        @Override
        public Node find(String[] parts, int i) {
            Node find = super.find(parts, i);
            if (find != null) {
                return find;
            }
            String p = parts[i];
            int index = this.indexOf(p);
            if (index < 0) {
                return null;
            }
            return this.children[index].find(parts, i + 1);
        }

        public String toString() {
            return this.name + "/";
        }

        @Override
        public NamedNode[] children() {
            NamedNode[] cs = new NamedNode[this.children.length];
            System.arraycopy(this.children, 0, cs, 0, cs.length);
            return cs;
        }

        @Override
        public int size() {
            return this.children.length;
        }

        @Override
        public Iterator<NamedNode> iterator() {
            return new Iterator<NamedNode>(){
                int n = 0;

                @Override
                public boolean hasNext() {
                    return this.n < children.length;
                }

                @Override
                public NamedNode next() {
                    assert (this.hasNext());
                    return children[this.n++];
                }
            };
        }

        int indexOf(String name) {
            int low = 0;
            int high = this.children.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int cmp = this.children[mid].name.compareTo(name);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        @Override
        public Optional<NamedNode> get(String name) {
            int n = this.indexOf(name);
            if (n < 0) {
                return Optional.empty();
            }
            return Optional.of(this.children[n]);
        }

        public int indexOf(Node node) {
            return Arrays.binarySearch(this.children, node);
        }
    }
}

